#!/bin/sh

# OMPi OpenMP Compiler
# == Copyright since 2001 the OMPi Team
# == Dept. of Computer Science & Engineering, University of Ioannina
# 
# This file is part of OMPi.
# 
# OMPi is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# OMPi is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with OMPi; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
#

# remote_offload_create_config.sh -- creates a default configuration file for 
#                                    remote offloading.

OMPI_REMOTE_DEVICES_FILE="${HOME}/.ompi_remote_devices"

create_default_nodefile () {
cat >> "${1}" << __EOF__
# Remote node configuration is performed in this file.
# Comments can be placed before host declarations and at the end of lines using the '#' character.
# Duplicate host names are ignored, even if the devices listed are different from the first occurence.
# Hostname declaration format is as follows:
#   hostname {
#     module_name: device_count
#   }
#
# Example:
#   # This is a comment, before declarations start.
#   # You can have as many comment lines as you want.
#   node1.mycluster.org {
#     cpu: 4, # Here is a valid place for a comment, too!
#     cuda: 2,
#   },
#   node2.mycluster.org {
#     cpu: 1 # Commas between modules can be omitted!
#     cuda: 1
#   },
#   195.251.100.230 { # IPs can be used instead of hostnames.
#     cpu: 1
#   } 
__EOF__
}

if [ ! -f "${OMPI_REMOTE_DEVICES_FILE}" ]; then
	create_default_nodefile "${OMPI_REMOTE_DEVICES_FILE}"
	exit 0
fi

exit 1