#!/bin/sh
#
# Autocomplete utility for ompicc

_ompicc()
{
    local cur prev prev2 words cword argument prefix prefix_length
    _init_completion || return

    # extract also for situations like: --devs=pr<tab>
    if ((cword > 2)); then
        prev2="${COMP_WORDS[cword - 2]}"
    fi

    # --devs<tab>
    if [[ $cur == --* || $cur == -* ]]; then
        argument=$cur
        prefix=""
    # --devs=<tab>
    elif [[ $cur == "=" && $prev == --* ]]; then
        argument=$prev$cur
        prefix=$prev$cur
    # --devs=pr<tab>
    elif [[ $prev == "=" && $prev2 == --* ]]; then
        argument=$prev2$prev$cur
        prefix=$prev2$prev
    fi
    
    if [[ ! -v argument ]]; then
        _filedir
    else
        prefix_length=$((${#prefix} + 1))
        local flags=$($1 --complete="$argument" 2>&1 | cut -c $prefix_length-)

        case $flags in
            *=) compopt -o nospace 2>/dev/null
        esac

        COMPREPLY=($(compgen -W "$flags" -- ""))
    fi
} 
complete -F _ompicc ompicc 