/*
  OMPi OpenMP Compiler
  == Copyright since 2001, the OMPi Team
  == Dept. of Computer Science & Engineering, University of Ioannina

  This file is part of OMPi.

  OMPi is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  OMPi is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with OMPi; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* KERNELS.H
 * Module and kernels support for ompicc
 */

#ifndef __KERNELS_H__
#define __KERNELS_H__

extern int nmodules;
extern char **modulenames;

extern void modules_employ(char *modstr);   /* Find requested modules/devices */
extern char *modules_argfor_ompi();         /* Make a string to pass to _ompi */
extern int kernel_makefiles(char *fname, int nkernels);   /* Produce kernels */
extern int kernel_makefile_single(char *fname);

#if 0
extern char *kernel_bubins_file_compile(char *fname, int nkernels);
#endif
extern void kernel_binaries_remove(char *fname, int nkernels);
extern void kernel_sources_remove(char *fname, int nkernels);

#ifdef OMPI_REMOTE_OFFLOADING
	extern void remote_modules_employ(void); /* Find requested remote modules/devices */
	extern void remote_modules_finalize(void);
#endif

#endif /* __KERNELS_H__ */
