/*
  OMPi OpenMP Compiler
  == Copyright since 2001 the OMPi Team
  == Dept. of Computer Science & Engineering, University of Ioannina

  This file is part of OMPi.

  OMPi is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  OMPi is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with OMPi; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* remote/workercmds.h 
 * 
 * All worker (remote; with rank != 0) MPI processes execute
 * these functions. Their purpose is to respond to the
 * primary node's requests. Note that the primary and the worker nodes do
 * **NOT** run in a shared memory environment. Communication is
 * achieved with MPI.
 */


#ifndef __ROFF_WORKERCMDS_H__
#define __ROFF_WORKERCMDS_H__

#include "stddefs.h"

#ifdef OMPI_REMOTE_OFFLOADING

#include "roff_prive.h"
#include "roff.h"
#include "workers.h"

#define __DEVICE(device_id) &(ort->ort_devices[device_id])
#define DEVICE_ALLOC(d,size,map,haddr,map_type) \
	d->module->dev_alloc(d->device_info,size,map,haddr,map_type)
#define DEVICE_INIT_ALLOC_GLOBAL(d,initfrom,size,glid,haddr) \
	d->module->dev_init_alloc_global(d->device_info,initfrom,size,glid,haddr)
#define DEVICE_FREE(d,da,unmap) \
	d->module->dev_free(d->device_info,da,unmap)
#define DEVICE_FREE_GLOBAL(d,da,glid) \
	d->module->dev_free_global(d->device_info,da,glid)
#define DEVICE_WRITE(d,ha,hoff,da,doff,s) \
	d->module->todev(d->device_info,ha,hoff,da,doff,s)
#define DEVICE_READ(d,ha,hoff,da,doff,s) \
	d->module->fromdev(d->device_info,ha,hoff,da,doff,s)
#define DEVICE_OFFLOAD(d,hf,devdata,decldata,kfname,nt,nthr,thrl,td,thrd,nargs,args) \
	d->module->offload(d->device_info,hf,devdata,decldata,kfname,\
	                                  nt,nthr,thrl,td,thrd,nargs,args)
#define DEVICE_IMED2UMED_ADDR(d,i) \
	d->module->imed2umed_addr(d->device_info, i)
#define DEVICE_UMED2IMED_ADDR(d,u) \
	d->module->umed2imed_addr(d->device_info, u)
#define DEVICE_FINALIZE(d) \
	d->module->dev_end(d->device_info)

#define NO_HOSTADDR NULL

#define WORKER_COMMANDS(WORKER_COMMAND)   \
	WORKER_COMMAND(initialize)            \
	WORKER_COMMAND(finalize)              \
	WORKER_COMMAND(fromdev)               \
	WORKER_COMMAND(todev)                 \
	WORKER_COMMAND(dev_alloc)             \
	WORKER_COMMAND(dev_init_alloc_global) \
	WORKER_COMMAND(dev_free)              \
	WORKER_COMMAND(dev_free_global)       \
	WORKER_COMMAND(offload)               \
	WORKER_COMMAND(imed2umed_addr)        \
	WORKER_COMMAND(umed2imed_addr)        \
	WORKER_COMMAND(shutdown)
/* new-hostpart-func.sh:workercmds */

#define _WORKER_PROTO(cmd) static void cmd(int, roff_datatype_t*);
#define WORKER_PROTO_LIST WORKER_COMMANDS(_WORKER_PROTO)
#define _WORKER_ELEM(cmd) cmd,
#define WORKER_COMMAND_ELEMS WORKER_COMMANDS(_WORKER_ELEM)

/* Commands the device can understand */
#define CMD(x) ROFF_CMD_ ## x
#define _WORKER_ENUM(cmd) CMD(cmd),
#define WORKER_COMMAND_ENUMS WORKER_COMMANDS(_WORKER_ENUM)
typedef enum workercmd_ {
	CMD(unknown) = -1,
	WORKER_COMMAND_ENUMS
	CMD(last)
} workercmd_e;

extern void (*worker_commands[])();

#endif  /* OMPI_REMOTE_OFFLOADING */
#endif  /* __ROFF_WORKERCMDS_H__ */
