/*
  OMPi OpenMP Compiler
  == Copyright since 2001 the OMPi Team
  == Dept. of Computer Science & Engineering, University of Ioannina

  This file is part of OMPi.

  OMPi is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  OMPi is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with OMPi; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* remote/roff.h -- remote offloading runtime interface
 */

#ifndef __ROFF_H__
#define __ROFF_H__

#include "stddefs.h"

#ifdef OMPI_REMOTE_OFFLOADING

#include <stdlib.h>
#include "ort.h"
#include "rt_common.h"

#define CMD_MAX_NUM_ARGS 6

enum noderoletype
{
	ROLE_PRIMARY = 0, 
	ROLE_WORKER = 1
};

extern int  num_primary_devs;
extern enum noderoletype node_role;

extern int    roff_man_get_my_id(void);
extern void   roff_man_prepare_node(int *argc, char ***argv);
extern void   roff_worker_loop(void);
extern char **roff_worker_get_modules(int *nModules);

/* Interface between the primary node and a worker node */
extern int    roff_initialize(char *modname, int global_id_of_first_device,
                                      void (*init_lock_in_ignore)(void **lock, int type),
                                      void (*lock_in_ignore)(void **lock),
                                      void (*unlock_in_ignore)(void **lock),
                                      int  (*hyield_in_ignore)(void), int *argc, char ***argv);
extern void   roff_finalize(void);
extern void  *roff_dev_init(int dev_num, ort_icvs_t *ort_env, int *sharedspace);
extern void   roff_dev_end(void *device_info);
extern int    roff_offload(void *device_info, void *(*host_func)(void *), void *dev_data,
                           void *decl_data, char *kernel_filename_prefix, int num_teams,
                           int num_threads, int thread_limit, 
                           unsigned long long teamdims, unsigned long long thrdims, 
                           int *num_args, void **args);
extern void  *roff_dev_alloc(void *device_info, size_t size, int map_memory, void *hostaddr, int map_type);
extern void  *roff_dev_init_alloc_global(void *device_info, void *initfrom, size_t size, int global_id,
                                     void *hostaddr);
extern void   roff_dev_free(void *device_info, void *iaddr, int unmap_memory);
extern void   roff_dev_free_global(void *device_info, void *iaddr, int global_id);
extern void   roff_todev(void *device_info, void *hostaddr, size_t hostoffset,
                         void *imedaddr, size_t devoffset, size_t size);
extern void   roff_fromdev(void *device_info, void *hostaddr, size_t hostoffset,
                           void *imedaddr, size_t devoffset, size_t size);
extern void  *roff_imed2umed_addr(void *device_info, void *imedaddr);
extern void  *roff_umed2imed_addr(void *device_info, void *umedaddr);
/* new-hostpart-func.sh:externroff */

#endif /* OMPI_REMOTE_OFFLOADING */
#endif /* __ROFF_H__ */
