/*
  OMPi OpenMP Compiler
  == Copyright since 2001 the OMPi Team
  == Dept. of Computer Science & Engineering, University of Ioannina

  This file is part of OMPi.

  OMPi is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  OMPi is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with OMPi; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* This file provides an API for easy identification of supported devices
 * based on a configuration file. It also provides a way to start such devices.
 */


#ifndef __ROFF_NODE_MANAGER_H__
#define __ROFF_NODE_MANAGER_H__

#include "stddefs.h"

#ifdef OMPI_REMOTE_OFFLOADING

extern int   roff_man_create_workers(void);
extern int   roff_man_get_num_nodes();
extern char *roff_man_get_nodename(int node_id);
extern void  roff_man_finalize();
extern int   roff_man_get_device_chunk(int num_devices, int num_siblings, int ee_id, 
                                       int *first_device_id, int *last_device_id);
extern void    *comminfo;

#endif /* OMPI_REMOTE_OFFLOADING */
#endif /* __ROFF_NODE_MANAGER_H__ */

