/*
  OMPi OpenMP Compiler
  == Copyright since 2001 the OMPi Team
  == Dept. of Computer Science & Engineering, University of Ioannina

  This file is part of OMPi.

  OMPi is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  OMPi is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with OMPi; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* This is the MPI comm library for remote offloading
 */

#ifndef __COMM_H__
#define __COMM_H__

#define COMM_TYPE_MPI

#include "config.h"

#ifdef OMPI_REMOTE_OFFLOADING

#include <unistd.h>
#include <mpi.h>
#include "../sysdeps.h"
#include "../roff_prive.h"

typedef struct MPI_info_
{
	MPI_Comm communicator;
	int initialized;
	int provided;
	int *argc;
	char ***argv;
	int role;
	int parent_worker_node_id;
} MPI_info_t;

#define DECL_MPITYPE(X) \
    case TYPE(X): return MPI_##X

static inline MPI_Datatype get_MPI_type(Comm_Datatype origtype)
{
	switch (origtype)
	{
		DECL_MPITYPE(CHAR);
		DECL_MPITYPE(SIGNED_CHAR);
		DECL_MPITYPE(UNSIGNED_CHAR);
		DECL_MPITYPE(BYTE);
		DECL_MPITYPE(WCHAR);
		DECL_MPITYPE(SHORT);
		DECL_MPITYPE(UNSIGNED_SHORT);
		DECL_MPITYPE(INT);
		DECL_MPITYPE(UNSIGNED);
		DECL_MPITYPE(LONG);
		DECL_MPITYPE(UNSIGNED_LONG);
		DECL_MPITYPE(FLOAT);
		DECL_MPITYPE(DOUBLE);
		DECL_MPITYPE(LONG_DOUBLE);
		DECL_MPITYPE(LONG_LONG);
		DECL_MPITYPE(UNSIGNED_LONG_LONG);
		DECL_MPITYPE(PACKED);
		DECL_MPITYPE(LB);
		DECL_MPITYPE(UB);
		DECL_MPITYPE(FLOAT_INT);
		DECL_MPITYPE(DOUBLE_INT);
		DECL_MPITYPE(LONG_INT);
		DECL_MPITYPE(SHORT_INT);
		DECL_MPITYPE(2INT);
		DECL_MPITYPE(LONG_DOUBLE_INT);
		DECL_MPITYPE(COMPLEX);
		DECL_MPITYPE(DOUBLE_COMPLEX);
		DECL_MPITYPE(LOGICAL);
		DECL_MPITYPE(REAL);
		DECL_MPITYPE(DOUBLE_PRECISION);
		DECL_MPITYPE(INTEGER);
		DECL_MPITYPE(2INTEGER);
		DECL_MPITYPE(2REAL);
		DECL_MPITYPE(2DOUBLE_PRECISION);
		DECL_MPITYPE(CHARACTER);
#ifdef MPI_REAL4
		DECL_MPITYPE(REAL4);
#endif
#ifdef MPI_REAL8
		DECL_MPITYPE(REAL8);
#endif
#ifdef MPI_REAL16
		DECL_MPITYPE(REAL16);
#endif
#ifdef MPI_COMPLEX8
		DECL_MPITYPE(COMPLEX8);
#endif
#ifdef MPI_COMPLEX16
		DECL_MPITYPE(COMPLEX16);
#endif
#ifdef MPI_COMPLEX32
		DECL_MPITYPE(COMPLEX32);
#endif
#ifdef MPI_INTEGER1
		DECL_MPITYPE(INTEGER1);
#endif
#ifdef MPI_INTEGER2
		DECL_MPITYPE(INTEGER2);
#endif
#ifdef MPI_INTEGER4
		DECL_MPITYPE(INTEGER4);
#endif
#ifdef MPI_INTEGER8
		DECL_MPITYPE(INTEGER8);
#endif
#ifdef MPI_INTEGER16
		DECL_MPITYPE(INTEGER16);
#endif
		default:
			return MPI_DATATYPE_NULL;
	}

	return MPI_DATATYPE_NULL;
}

#endif /* OMPI_REMOTE_OFFLOADING */

#endif /* __COMM_H__ */