/*
  OMPi OpenMP Compiler
  == Copyright since 2001 the OMPi Team
  == Dept. of Computer Science & Engineering, University of Ioannina

  This file is part of OMPi.

  OMPi is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  OMPi is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with OMPi; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* oclutils -- handy OpenCL utilities */

#ifndef __OCLUTILS_H__
#define __OCLUTILS_H__

/* Max version we target; maybe we should rethink it */
#define CL_TARGET_OPENCL_VERSION 300

#include <CL/opencl.h>
#include "rt_common.h"

#define MAX_OPENCL_C_VERSIONS 20         // Supported versions (v3.0) limit
#define OCL_QUERY_SIZE        2048       // Space for info queries

/* Define some handy OpenCL 3.x stuff */
/* Available macros from the standard: 
 * CL_VERSION_1_0, _1_1, _1_2 and 2_0; nothing after that
 */
#ifndef CL_VERSION_MAJOR /* defined in v3.0 */
  #define VERMAJ(v) ((v) >> 22)           /* 10 MSBs */
  #define VERMIN(v) (((v) >> 12) & 1023)  /* Next 10 bits */
  #define VERPAT(v) ((v) & 4095)          /* 12 LSBs is the patch number */
  #define MAKEVER(maj,min,pat) (((maj)<<22) | (((min)&1023)<<12) | ((pat)&4095))
#else
  #define VERMAJ  CL_VERSION_MAJOR
  #define VERMIN  CL_VERSION_MINOR
  #define VERPAT  CL_VERSION_PATCH
  #define MAKEVER CL_MAKE_VERSION
#endif

#define ocl_discover_num_gpus(pid) ocl_iterate_gpus((pid),NULL)
int     ocl_iterate_gpus(int platformid,
                         int (*callback)(int, cl_device_id, cl_platform_id));
int     ocl_discover_ith_gpu(int gpuid, cl_device_id *, cl_platform_id *);
cl_uint ocl_openclc_versions(cl_device_id dev, cl_uint *vers, int *nver);
cl_uint ocl_version_from_string(char *str);
char   *ocl_read_src(char *path);
void    ocl_show_clprogram_info(cl_program, cl_device_id, char *);
void    ocl_show_clkernel_info(cl_kernel, cl_device_id, char *);
char   *ocl_errstr(cl_int err);

#endif /* __OCLUITLS_H__ */
