#
#    OMPi OpenMP Compiler
#    == Copyright since 2001 the OMPi Team
#    == Dept. of Computer Science & Engineering, University of Ioannina
#
#    This file is part of OMPi.
#
#    OMPi is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    OMPi is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with OMPi; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
#

#  MODULE: opencl
#    PART: Makefile recipe for compiling kernels for this module devices;
#          it should discover all produced kernels (*_d??.c);
#          all @OMPI_XXX@ variables get substituted by ompicc at compile time.

KERNEL_ID   = @@OMPI_KERNELID@@
KERNEL_FILE = @@OMPI_KERNELFILE@@
KERNEL_SRC  = $(patsubst %.c, %, $(KERNEL_FILE))_d$(KERNEL_ID)-opencl.cl
KERNEL_BIN  = $(patsubst %.cl, %.out, $(KERNEL_SRC))

all: ${KERNEL_BIN}

# Just copy the kernel file
%.out: %.cl
#	@cp -f $< $@
	@echo "/* MALflavor: nored */" > $@
	@cat $< >> $@

clean-src:
	@rm -rf $(KERNEL_SRC)

clean-bins: 
	@rm -rf $(KERNEL_BIN)

clean:
	@rm -rf $(KERNEL_SRC) $(KERNEL_BIN)