/*
  OMPi OpenMP Compiler
  == Copyright since 2001 the OMPi Team
  == Dept. of Computer Science & Engineering, University of Ioannina

  This file is part of OMPi.

  OMPi is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  OMPi is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with OMPi; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* tasks.c
 * This file implements tasking
 */

#include <stdlib.h>
#include <stdio.h>
#include <stdbool.h>
#include "globals.h"
#include "locks.h"
#include "tasks.h"
#include "barrier.h"
#include "parallel.h"
#include "worksharing.h"


__device__ 
void *_ort_taskenv_alloc(int size, void *(*task_func)(void *))
{
}

__device__ 
void _ort_taskenv_free(void *ptr, void *(*task_func)(void *))
{
}


__device__
void _ort_new_task(void *(*func)(void *arg), void *arg,
                  int now, int final, int untied, int priority,
                  void **deparray, int noutdeps, int nindeps, int ninoutdeps)
{
	thread_cb_t *cb = __MYCB;
	if (!cb) return;

	cb->intask = true;
	(*func)(arg);
	cb->intask = false;
}

__device__
int _ort_task_throttling(void)
{
	return 1;
}

__device__
void *_ort_task_immediate_start(int final)
{
	return NULL;
}

__device__
void _ort_task_immediate_end(void *tn)
{
}

__device__
void tasking_init()
{
}

__device__
void tasking_finish()
{
}


__device__
bool _cuda_dev_is_executing_task()
{
	return false;
}


__device__
void _ort_taskwait(int how)
{
	switch (how)
	{
		case 0:
			__threadfence();
			break;
		case 2:
#if PARALLEL_SCHEME == SCHEME_MASTERWORKER
			if (shdata.inmasterworker)
				__threadfence_block();
			else
				dev_barrier_wait(BARRIER_SLOT_2, dev_get_parallel_active_threads());
#else
			__syncthreads();
#endif
			break;
		case 1:
		default:
			// No-op / legacy semantics
			break;
	}
}
