/*
  OMPi OpenMP Compiler
  == Copyright since 2001 the OMPi Team
  == Dept. of Computer Science & Engineering, University of Ioannina

  This file is part of OMPi.

  OMPi is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  OMPi is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with OMPi; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#include "globals.h"
#include "locks.h"

#ifndef __PARALLEL_H__
#define __PARALLEL_H__

#define SCHEME_IFMASTER     0
#define SCHEME_MASTERWORKER 1

#define MEMTYPE_GLOBAL 0
#define MEMTYPE_SHARED 1

/*
 * Parallel configuration 
 */

/* Available values: SCHEME_IFMASTER, SCHEME_MASTERWORKER */
#define PARALLEL_SCHEME SCHEME_MASTERWORKER

/* Available values: MEMTYPE_GLOBAL, MEMTYPE_SHARED */
#define PARALLEL_MEMTYPE MEMTYPE_SHARED 

typedef struct ort_parallel_
{
	bool combined;
	int activelevel;
	int execthr;
	void *(*func)(void*);
	void *shvars;
} ort_parallel_t;

#if PARALLEL_MEMTYPE == MEMTYPE_SHARED
	#define __PARBLOCK block_parallel_cb
	#define __MYPARBLOCK &(__PARBLOCK)
	#define __CHECKPARBLOCK(p)
	extern __shared__ ort_parallel_t block_parallel_cb;
#else
	#define MAX_PARALLEL_BLOCKS 512
	#define __PARBLOCK block_parallel_cbs[omp_get_team_num()]
	#define __MYPARBLOCK \
		((omp_get_team_num() < MAX_PARALLEL_BLOCKS) \
		? __PARBLOCK \
		: NULL)
	#define __CHECKPARBLOCK(p) \
		if (p == NULL) \
		{ \
			printf("error: could not retrieve parallel control block."); \
			return; \
		}
	extern __device__ ort_parallel_t block_parallel_cbs[MAX_PARALLEL_BLOCKS];
#endif

extern __device__ void dev_init_block_parallel_cb(void);
extern __device__ void dev_set_active_level(int level);
extern __device__ int  dev_get_parallel_active_threads(void);
extern __device__ void _cuda_dev_worker_loop(int thrid);

#endif
