/*
  OMPi OpenMP Compiler
  == Copyright since 2001 the OMPi Team
  == Dept. of Computer Science & Engineering, University of Ioannina

  This file is part of OMPi.

  OMPi is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  OMPi is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with OMPi; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#include "globals.h"

#define BARRIER_SLOT_0   0
#define BARRIER_SLOT_1   1
#define BARRIER_SLOT_2   2
#define BARRIER_SLOT_3   3
#define BARRIER_SLOT_4   4
#define BARRIER_SLOT_5   5
#define BARRIER_SLOT_6   6
#define BARRIER_SLOT_7   7
#define BARRIER_SLOT_8   8
#define BARRIER_SLOT_9   9
#define BARRIER_SLOT_10 10
#define BARRIER_SLOT_11 11
#define BARRIER_SLOT_12 12
#define BARRIER_SLOT_13 13
#define BARRIER_SLOT_14 14
#define BARRIER_SLOT_15 15
#define BARRIER_SLOT_DEFAULT BARRIER_SLOT_0

static inline __device__
int numtowarpsize(int n)
{
	return (int) ceilf(((float) n) / warpSize) * warpSize;
}

#define dev_barrier_wait(SLOT,NTHR) \
	do { \
		thread_cb_t *cb = __MYCB; \
		if (!cb) return; \
		if (((NTHR) == 1) || (cb->in_nested_parallel)) return; \
		int count = numtowarpsize(NTHR); \
	    asm volatile("bar.sync %0, %1;" :: "n"(SLOT), "r"(count) : "memory"); \
	} while(0)

