/* A Bison parser, made by GNU Bison 3.7.4.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2020 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
   especially those whose name start with YY_ or yy_.  They are
   private implementation details that can be changed or removed.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output, and Bison version.  */
#define YYBISON 30704

/* Bison version string.  */
#define YYBISON_VERSION "3.7.4"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1




/* First part of user prologue.  */
#line 1 "../compiler/parser.y"

/*
  OMPi OpenMP Compiler
  == Copyright since 2001 the OMPi Team
  == Dept. of Computer Science & Engineering, University of Ioannina

  This file is part of OMPi.

  OMPi is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  OMPi is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with OMPi; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* parser.y */

/*
 * 2010/11/10:
 *   dropped OpenMP-specific for parsing; fewer rules, less code
 * 2009/05/11:
 *   added AUTO schedule type
 * 2009/05/03:
 *   added ATNODE ompix clause
 */

#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/time.h>
#include <stdarg.h>
#include <ctype.h>
#include <assert.h>
#include "scanner.h"
#include "ompi.h"
#include "ast.h"
#include "symtab.h"
#include "codetargs.h"
#include "ast_free.h"
#include "ast_copy.h"
#include "ast_vars.h"
#include "ast_print.h"
#include "ast_arith.h"
#include "x_clauses.h"
#include "str.h"

void    check_for_unknown_identifier(astexpr e);
void    check_uknown_var(char *name);
void    parse_error(int exitvalue, char *format, ...);
void    parse_warning(char *format, ...);
void    yyerror(const char *s);
void    check_for_main_and_declare(astspec s, astdecl d);
void    add_declaration_links(astspec s, astdecl d);
astdecl fix_known_typename(astspec s);
void    check_schedule(ompclsubt_e sched, intvec_t mods);
char    *strdupcat(char *first, char *second, int freethem);
int     mk_dirname_modifier(char *dirname);
int     check_data_reduction_modifiers(intvec_t v);
int     check_map_clause_modifiers(intvec_t);

aststmt pastree = NULL;       /* The generated AST */
aststmt pastree_stmt = NULL;  /* For when parsing statment strings */
astexpr pastree_expr = NULL;  /* For when parsing expression strings */
int     checkDecls = 1;       /* 0 when scanning strings (no context check) */
int     tempsave;
int     isTypedef  = 0;       /* To keep track of typedefs */
int     suDepth = 0;   /* To tell appart struct/union decls from their fields */

char    *parsingstring;       /* For error reporting when parsing string */

int     __has_target = 0;

//TODO this is not 100% correct (e.g. if returns lies in a dead code area).
/* Return and goto statements that lead outside the outlined region constitute
 * programmer errors and so we should stop the compilation. When simply 
 * analyzing vars (and not outlining) we ignore this rule.
 */
int     errorOnReturn = 0;

#line 160 "compiler/parser.c"

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

#include "parser.h"
/* Symbol kind.  */
enum yysymbol_kind_t
{
  YYSYMBOL_YYEMPTY = -2,
  YYSYMBOL_YYEOF = 0,                      /* "end of file"  */
  YYSYMBOL_YYerror = 1,                    /* error  */
  YYSYMBOL_YYUNDEF = 2,                    /* "invalid token"  */
  YYSYMBOL_START_SYMBOL_EXPRESSION = 3,    /* START_SYMBOL_EXPRESSION  */
  YYSYMBOL_START_SYMBOL_BLOCKLIST = 4,     /* START_SYMBOL_BLOCKLIST  */
  YYSYMBOL_START_SYMBOL_TRANSUNIT = 5,     /* START_SYMBOL_TRANSUNIT  */
  YYSYMBOL_IDENTIFIER = 6,                 /* IDENTIFIER  */
  YYSYMBOL_TYPE_NAME = 7,                  /* TYPE_NAME  */
  YYSYMBOL_CONSTANT = 8,                   /* CONSTANT  */
  YYSYMBOL_STRING_LITERAL = 9,             /* STRING_LITERAL  */
  YYSYMBOL_PTR_OP = 10,                    /* PTR_OP  */
  YYSYMBOL_INC_OP = 11,                    /* INC_OP  */
  YYSYMBOL_DEC_OP = 12,                    /* DEC_OP  */
  YYSYMBOL_LEFT_OP = 13,                   /* LEFT_OP  */
  YYSYMBOL_RIGHT_OP = 14,                  /* RIGHT_OP  */
  YYSYMBOL_LE_OP = 15,                     /* LE_OP  */
  YYSYMBOL_GE_OP = 16,                     /* GE_OP  */
  YYSYMBOL_EQ_OP = 17,                     /* EQ_OP  */
  YYSYMBOL_NE_OP = 18,                     /* NE_OP  */
  YYSYMBOL_AND_OP = 19,                    /* AND_OP  */
  YYSYMBOL_OR_OP = 20,                     /* OR_OP  */
  YYSYMBOL_MUL_ASSIGN = 21,                /* MUL_ASSIGN  */
  YYSYMBOL_DIV_ASSIGN = 22,                /* DIV_ASSIGN  */
  YYSYMBOL_MOD_ASSIGN = 23,                /* MOD_ASSIGN  */
  YYSYMBOL_ADD_ASSIGN = 24,                /* ADD_ASSIGN  */
  YYSYMBOL_SUB_ASSIGN = 25,                /* SUB_ASSIGN  */
  YYSYMBOL_LEFT_ASSIGN = 26,               /* LEFT_ASSIGN  */
  YYSYMBOL_RIGHT_ASSIGN = 27,              /* RIGHT_ASSIGN  */
  YYSYMBOL_AND_ASSIGN = 28,                /* AND_ASSIGN  */
  YYSYMBOL_XOR_ASSIGN = 29,                /* XOR_ASSIGN  */
  YYSYMBOL_OR_ASSIGN = 30,                 /* OR_ASSIGN  */
  YYSYMBOL_SIZEOF = 31,                    /* SIZEOF  */
  YYSYMBOL_ALIGNOF = 32,                   /* ALIGNOF  */
  YYSYMBOL_TYPEOF = 33,                    /* TYPEOF  */
  YYSYMBOL_TYPEDEF = 34,                   /* TYPEDEF  */
  YYSYMBOL_EXTERN = 35,                    /* EXTERN  */
  YYSYMBOL_STATIC = 36,                    /* STATIC  */
  YYSYMBOL_AUTO = 37,                      /* AUTO  */
  YYSYMBOL_REGISTER = 38,                  /* REGISTER  */
  YYSYMBOL_RESTRICT = 39,                  /* RESTRICT  */
  YYSYMBOL_CHAR = 40,                      /* CHAR  */
  YYSYMBOL_SHORT = 41,                     /* SHORT  */
  YYSYMBOL_INT = 42,                       /* INT  */
  YYSYMBOL_LONG = 43,                      /* LONG  */
  YYSYMBOL_SIGNED = 44,                    /* SIGNED  */
  YYSYMBOL_UNSIGNED = 45,                  /* UNSIGNED  */
  YYSYMBOL_FLOAT = 46,                     /* FLOAT  */
  YYSYMBOL_DOUBLE = 47,                    /* DOUBLE  */
  YYSYMBOL_CONST = 48,                     /* CONST  */
  YYSYMBOL_VOLATILE = 49,                  /* VOLATILE  */
  YYSYMBOL_VOID = 50,                      /* VOID  */
  YYSYMBOL_INLINE = 51,                    /* INLINE  */
  YYSYMBOL_UBOOL = 52,                     /* UBOOL  */
  YYSYMBOL_UCOMPLEX = 53,                  /* UCOMPLEX  */
  YYSYMBOL_UIMAGINARY = 54,                /* UIMAGINARY  */
  YYSYMBOL_STRUCT = 55,                    /* STRUCT  */
  YYSYMBOL_UNION = 56,                     /* UNION  */
  YYSYMBOL_ENUM = 57,                      /* ENUM  */
  YYSYMBOL_ELLIPSIS = 58,                  /* ELLIPSIS  */
  YYSYMBOL_CASE = 59,                      /* CASE  */
  YYSYMBOL_DEFAULT = 60,                   /* DEFAULT  */
  YYSYMBOL_IF = 61,                        /* IF  */
  YYSYMBOL_ELSE = 62,                      /* ELSE  */
  YYSYMBOL_SWITCH = 63,                    /* SWITCH  */
  YYSYMBOL_WHILE = 64,                     /* WHILE  */
  YYSYMBOL_DO = 65,                        /* DO  */
  YYSYMBOL_FOR = 66,                       /* FOR  */
  YYSYMBOL_GOTO = 67,                      /* GOTO  */
  YYSYMBOL_CONTINUE = 68,                  /* CONTINUE  */
  YYSYMBOL_BREAK = 69,                     /* BREAK  */
  YYSYMBOL_RETURN = 70,                    /* RETURN  */
  YYSYMBOL___BUILTIN_VA_ARG = 71,          /* __BUILTIN_VA_ARG  */
  YYSYMBOL___BUILTIN_OFFSETOF = 72,        /* __BUILTIN_OFFSETOF  */
  YYSYMBOL___BUILTIN_TYPES_COMPATIBLE_P = 73, /* __BUILTIN_TYPES_COMPATIBLE_P  */
  YYSYMBOL___ATTRIBUTE__ = 74,             /* __ATTRIBUTE__  */
  YYSYMBOL___ASM__ = 75,                   /* __ASM__  */
  YYSYMBOL_PRAGMA_OTHER = 76,              /* PRAGMA_OTHER  */
  YYSYMBOL_PRAGMA_OMP = 77,                /* PRAGMA_OMP  */
  YYSYMBOL_OMP_THREADPRIVATE = 78,         /* OMP_THREADPRIVATE  */
  YYSYMBOL_OMP_PARALLEL = 79,              /* OMP_PARALLEL  */
  YYSYMBOL_OMP_SECTIONS = 80,              /* OMP_SECTIONS  */
  YYSYMBOL_OMP_NOWAIT = 81,                /* OMP_NOWAIT  */
  YYSYMBOL_OMP_ORDERED = 82,               /* OMP_ORDERED  */
  YYSYMBOL_OMP_SCHEDULE = 83,              /* OMP_SCHEDULE  */
  YYSYMBOL_OMP_STATIC = 84,                /* OMP_STATIC  */
  YYSYMBOL_OMP_DYNAMIC = 85,               /* OMP_DYNAMIC  */
  YYSYMBOL_OMP_GUIDED = 86,                /* OMP_GUIDED  */
  YYSYMBOL_OMP_RUNTIME = 87,               /* OMP_RUNTIME  */
  YYSYMBOL_OMP_AUTO = 88,                  /* OMP_AUTO  */
  YYSYMBOL_OMP_SECTION = 89,               /* OMP_SECTION  */
  YYSYMBOL_OMP_AFFINITY = 90,              /* OMP_AFFINITY  */
  YYSYMBOL_OMP_SINGLE = 91,                /* OMP_SINGLE  */
  YYSYMBOL_OMP_MASTER = 92,                /* OMP_MASTER  */
  YYSYMBOL_OMP_CRITICAL = 93,              /* OMP_CRITICAL  */
  YYSYMBOL_OMP_BARRIER = 94,               /* OMP_BARRIER  */
  YYSYMBOL_OMP_ATOMIC = 95,                /* OMP_ATOMIC  */
  YYSYMBOL_OMP_FLUSH = 96,                 /* OMP_FLUSH  */
  YYSYMBOL_OMP_PRIVATE = 97,               /* OMP_PRIVATE  */
  YYSYMBOL_OMP_FIRSTPRIVATE = 98,          /* OMP_FIRSTPRIVATE  */
  YYSYMBOL_OMP_LASTPRIVATE = 99,           /* OMP_LASTPRIVATE  */
  YYSYMBOL_OMP_SHARED = 100,               /* OMP_SHARED  */
  YYSYMBOL_OMP_DEFAULT = 101,              /* OMP_DEFAULT  */
  YYSYMBOL_OMP_NONE = 102,                 /* OMP_NONE  */
  YYSYMBOL_OMP_REDUCTION = 103,            /* OMP_REDUCTION  */
  YYSYMBOL_OMP_COPYIN = 104,               /* OMP_COPYIN  */
  YYSYMBOL_OMP_NUMTHREADS = 105,           /* OMP_NUMTHREADS  */
  YYSYMBOL_OMP_COPYPRIVATE = 106,          /* OMP_COPYPRIVATE  */
  YYSYMBOL_OMP_FOR = 107,                  /* OMP_FOR  */
  YYSYMBOL_OMP_IF = 108,                   /* OMP_IF  */
  YYSYMBOL_OMP_TASK = 109,                 /* OMP_TASK  */
  YYSYMBOL_OMP_UNTIED = 110,               /* OMP_UNTIED  */
  YYSYMBOL_OMP_TASKWAIT = 111,             /* OMP_TASKWAIT  */
  YYSYMBOL_OMP_COLLAPSE = 112,             /* OMP_COLLAPSE  */
  YYSYMBOL_OMP_FINAL = 113,                /* OMP_FINAL  */
  YYSYMBOL_OMP_MERGEABLE = 114,            /* OMP_MERGEABLE  */
  YYSYMBOL_OMP_TASKYIELD = 115,            /* OMP_TASKYIELD  */
  YYSYMBOL_OMP_READ = 116,                 /* OMP_READ  */
  YYSYMBOL_OMP_WRITE = 117,                /* OMP_WRITE  */
  YYSYMBOL_OMP_CAPTURE = 118,              /* OMP_CAPTURE  */
  YYSYMBOL_OMP_UPDATE = 119,               /* OMP_UPDATE  */
  YYSYMBOL_OMP_MIN = 120,                  /* OMP_MIN  */
  YYSYMBOL_OMP_MAX = 121,                  /* OMP_MAX  */
  YYSYMBOL_OMP_PROCBIND = 122,             /* OMP_PROCBIND  */
  YYSYMBOL_OMP_CLOSE = 123,                /* OMP_CLOSE  */
  YYSYMBOL_OMP_SPREAD = 124,               /* OMP_SPREAD  */
  YYSYMBOL_OMP_SIMD = 125,                 /* OMP_SIMD  */
  YYSYMBOL_OMP_INBRANCH = 126,             /* OMP_INBRANCH  */
  YYSYMBOL_OMP_NOTINBRANCH = 127,          /* OMP_NOTINBRANCH  */
  YYSYMBOL_OMP_UNIFORM = 128,              /* OMP_UNIFORM  */
  YYSYMBOL_OMP_LINEAR = 129,               /* OMP_LINEAR  */
  YYSYMBOL_OMP_ALIGNED = 130,              /* OMP_ALIGNED  */
  YYSYMBOL_OMP_SIMDLEN = 131,              /* OMP_SIMDLEN  */
  YYSYMBOL_OMP_SAFELEN = 132,              /* OMP_SAFELEN  */
  YYSYMBOL_OMP_DECLARE = 133,              /* OMP_DECLARE  */
  YYSYMBOL_OMP_TARGET = 134,               /* OMP_TARGET  */
  YYSYMBOL_OMP_TARGETDATA = 135,           /* OMP_TARGETDATA  */
  YYSYMBOL_OMP_TARGETUPDATE = 136,         /* OMP_TARGETUPDATE  */
  YYSYMBOL_OMP_DEVICE = 137,               /* OMP_DEVICE  */
  YYSYMBOL_OMP_MAP = 138,                  /* OMP_MAP  */
  YYSYMBOL_OMP_ALLOC = 139,                /* OMP_ALLOC  */
  YYSYMBOL_OMP_TO = 140,                   /* OMP_TO  */
  YYSYMBOL_OMP_FROM = 141,                 /* OMP_FROM  */
  YYSYMBOL_OMP_TOFROM = 142,               /* OMP_TOFROM  */
  YYSYMBOL_OMP_END = 143,                  /* OMP_END  */
  YYSYMBOL_OMP_TEAMS = 144,                /* OMP_TEAMS  */
  YYSYMBOL_OMP_DISTRIBUTE = 145,           /* OMP_DISTRIBUTE  */
  YYSYMBOL_OMP_NUMTEAMS = 146,             /* OMP_NUMTEAMS  */
  YYSYMBOL_OMP_THREADLIMIT = 147,          /* OMP_THREADLIMIT  */
  YYSYMBOL_OMP_DISTSCHEDULE = 148,         /* OMP_DISTSCHEDULE  */
  YYSYMBOL_OMP_DEPEND = 149,               /* OMP_DEPEND  */
  YYSYMBOL_OMP_IN = 150,                   /* OMP_IN  */
  YYSYMBOL_OMP_OUT = 151,                  /* OMP_OUT  */
  YYSYMBOL_OMP_INOUT = 152,                /* OMP_INOUT  */
  YYSYMBOL_OMP_TASKGROUP = 153,            /* OMP_TASKGROUP  */
  YYSYMBOL_OMP_SEQ_CST = 154,              /* OMP_SEQ_CST  */
  YYSYMBOL_OMP_CANCEL = 155,               /* OMP_CANCEL  */
  YYSYMBOL_OMP_INITIALIZER = 156,          /* OMP_INITIALIZER  */
  YYSYMBOL_OMP_CANCELLATIONPOINT = 157,    /* OMP_CANCELLATIONPOINT  */
  YYSYMBOL_OMP_DECLARETARGET = 158,        /* OMP_DECLARETARGET  */
  YYSYMBOL_OMP_ENDDECLARETARGET = 159,     /* OMP_ENDDECLARETARGET  */
  YYSYMBOL_OMP_HINT = 160,                 /* OMP_HINT  */
  YYSYMBOL_OMP_SOURCE = 161,               /* OMP_SOURCE  */
  YYSYMBOL_OMP_SINK = 162,                 /* OMP_SINK  */
  YYSYMBOL_OMP_RELEASE = 163,              /* OMP_RELEASE  */
  YYSYMBOL_OMP_DELETE = 164,               /* OMP_DELETE  */
  YYSYMBOL_OMP_ALWAYS = 165,               /* OMP_ALWAYS  */
  YYSYMBOL_OMP_IS_DEVICE_PTR = 166,        /* OMP_IS_DEVICE_PTR  */
  YYSYMBOL_OMP_USE_DEVICE_PTR = 167,       /* OMP_USE_DEVICE_PTR  */
  YYSYMBOL_OMP_TARGETENTERDATA = 168,      /* OMP_TARGETENTERDATA  */
  YYSYMBOL_OMP_TARGETEXITDATA = 169,       /* OMP_TARGETEXITDATA  */
  YYSYMBOL_OMP_PRIORITY = 170,             /* OMP_PRIORITY  */
  YYSYMBOL_OMP_TASKLOOP = 171,             /* OMP_TASKLOOP  */
  YYSYMBOL_OMP_THREADS = 172,              /* OMP_THREADS  */
  YYSYMBOL_OMP_LINK = 173,                 /* OMP_LINK  */
  YYSYMBOL_OMP_DEFAULTMAP = 174,           /* OMP_DEFAULTMAP  */
  YYSYMBOL_OMP_SCALAR = 175,               /* OMP_SCALAR  */
  YYSYMBOL_OMP_MONOTONIC = 176,            /* OMP_MONOTONIC  */
  YYSYMBOL_OMP_NONMONOTONIC = 177,         /* OMP_NONMONOTONIC  */
  YYSYMBOL_OMP_INREDUCTION = 178,          /* OMP_INREDUCTION  */
  YYSYMBOL_OMP_TASKREDUCTION = 179,        /* OMP_TASKREDUCTION  */
  YYSYMBOL_OMP_INSCAN = 180,               /* OMP_INSCAN  */
  YYSYMBOL_OMP_REQUIRES = 181,             /* OMP_REQUIRES  */
  YYSYMBOL_OMP_REVERSE_OFFLOAD = 182,      /* OMP_REVERSE_OFFLOAD  */
  YYSYMBOL_OMP_UNIFIED_ADDRESS = 183,      /* OMP_UNIFIED_ADDRESS  */
  YYSYMBOL_OMP_UNIFIED_SHARED_MEMORY = 184, /* OMP_UNIFIED_SHARED_MEMORY  */
  YYSYMBOL_OMP_ATOMIC_DEFAULT_MEM_ORDER = 185, /* OMP_ATOMIC_DEFAULT_MEM_ORDER  */
  YYSYMBOL_OMP_ACQ_REL = 186,              /* OMP_ACQ_REL  */
  YYSYMBOL_OMP_ACQUIRE = 187,              /* OMP_ACQUIRE  */
  YYSYMBOL_OMP_RELAXED = 188,              /* OMP_RELAXED  */
  YYSYMBOL_OMP_DYNAMIC_ALLOCATORS = 189,   /* OMP_DYNAMIC_ALLOCATORS  */
  YYSYMBOL_OMP_PRIMARY = 190,              /* OMP_PRIMARY  */
  YYSYMBOL_OMP_MASKED = 191,               /* OMP_MASKED  */
  YYSYMBOL_OMP_FILTER = 192,               /* OMP_FILTER  */
  YYSYMBOL_OMP_COMPARE = 193,              /* OMP_COMPARE  */
  YYSYMBOL_OMP_WEAK = 194,                 /* OMP_WEAK  */
  YYSYMBOL_OMP_FAIL = 195,                 /* OMP_FAIL  */
  YYSYMBOL_OMP_ERROR = 196,                /* OMP_ERROR  */
  YYSYMBOL_OMP_COMPILATION = 197,          /* OMP_COMPILATION  */
  YYSYMBOL_OMP_EXECUTION = 198,            /* OMP_EXECUTION  */
  YYSYMBOL_OMP_SEVERITY = 199,             /* OMP_SEVERITY  */
  YYSYMBOL_OMP_FATAL = 200,                /* OMP_FATAL  */
  YYSYMBOL_OMP_WARNING = 201,              /* OMP_WARNING  */
  YYSYMBOL_OMP_MESSAGE = 202,              /* OMP_MESSAGE  */
  YYSYMBOL_OMP_AT = 203,                   /* OMP_AT  */
  YYSYMBOL_PRAGMA_OMPIX = 204,             /* PRAGMA_OMPIX  */
  YYSYMBOL_OMPIX_TASKDEF = 205,            /* OMPIX_TASKDEF  */
  YYSYMBOL_OMPIX_TASKSYNC = 206,           /* OMPIX_TASKSYNC  */
  YYSYMBOL_OMPIX_UPONRETURN = 207,         /* OMPIX_UPONRETURN  */
  YYSYMBOL_OMPIX_ATNODE = 208,             /* OMPIX_ATNODE  */
  YYSYMBOL_OMPIX_DETACHED = 209,           /* OMPIX_DETACHED  */
  YYSYMBOL_OMPIX_ATWORKER = 210,           /* OMPIX_ATWORKER  */
  YYSYMBOL_OMPIX_TASKSCHEDULE = 211,       /* OMPIX_TASKSCHEDULE  */
  YYSYMBOL_OMPIX_STRIDE = 212,             /* OMPIX_STRIDE  */
  YYSYMBOL_OMPIX_START = 213,              /* OMPIX_START  */
  YYSYMBOL_OMPIX_SCOPE = 214,              /* OMPIX_SCOPE  */
  YYSYMBOL_OMPIX_NODES = 215,              /* OMPIX_NODES  */
  YYSYMBOL_OMPIX_WORKERS = 216,            /* OMPIX_WORKERS  */
  YYSYMBOL_OMPIX_LOCAL = 217,              /* OMPIX_LOCAL  */
  YYSYMBOL_OMPIX_GLOBAL = 218,             /* OMPIX_GLOBAL  */
  YYSYMBOL_OMPIX_HERE = 219,               /* OMPIX_HERE  */
  YYSYMBOL_OMPIX_REMOTE = 220,             /* OMPIX_REMOTE  */
  YYSYMBOL_OMPIX_HINTS = 221,              /* OMPIX_HINTS  */
  YYSYMBOL_OMPIX_TIED = 222,               /* OMPIX_TIED  */
  YYSYMBOL_OMPIX_PROCEXTERN = 223,         /* OMPIX_PROCEXTERN  */
  YYSYMBOL_OMPIX_TAG = 224,                /* OMPIX_TAG  */
  YYSYMBOL_NOELSE = 225,                   /* NOELSE  */
  YYSYMBOL_MULTIATTR = 226,                /* MULTIATTR  */
  YYSYMBOL_227_ = 227,                     /* '('  */
  YYSYMBOL_228_ = 228,                     /* ')'  */
  YYSYMBOL_229_ = 229,                     /* '['  */
  YYSYMBOL_230_ = 230,                     /* ']'  */
  YYSYMBOL_231_ = 231,                     /* '.'  */
  YYSYMBOL_232_ = 232,                     /* '{'  */
  YYSYMBOL_233_ = 233,                     /* '}'  */
  YYSYMBOL_234_ = 234,                     /* ','  */
  YYSYMBOL_235_ = 235,                     /* '&'  */
  YYSYMBOL_236_ = 236,                     /* '*'  */
  YYSYMBOL_237_ = 237,                     /* '+'  */
  YYSYMBOL_238_ = 238,                     /* '-'  */
  YYSYMBOL_239_ = 239,                     /* '~'  */
  YYSYMBOL_240_ = 240,                     /* '!'  */
  YYSYMBOL_241_ = 241,                     /* '/'  */
  YYSYMBOL_242_ = 242,                     /* '%'  */
  YYSYMBOL_243_ = 243,                     /* '<'  */
  YYSYMBOL_244_ = 244,                     /* '>'  */
  YYSYMBOL_245_ = 245,                     /* '^'  */
  YYSYMBOL_246_ = 246,                     /* '|'  */
  YYSYMBOL_247_ = 247,                     /* '?'  */
  YYSYMBOL_248_ = 248,                     /* ':'  */
  YYSYMBOL_249_ = 249,                     /* '='  */
  YYSYMBOL_250_ = 250,                     /* ';'  */
  YYSYMBOL_251_n_ = 251,                   /* '\n'  */
  YYSYMBOL_YYACCEPT = 252,                 /* $accept  */
  YYSYMBOL_start_trick = 253,              /* start_trick  */
  YYSYMBOL_enumeration_constant = 254,     /* enumeration_constant  */
  YYSYMBOL_string_literal = 255,           /* string_literal  */
  YYSYMBOL_primary_expression = 256,       /* primary_expression  */
  YYSYMBOL_postfix_expression = 257,       /* postfix_expression  */
  YYSYMBOL_argument_expression_list = 258, /* argument_expression_list  */
  YYSYMBOL_unary_expression = 259,         /* unary_expression  */
  YYSYMBOL_unary_operator = 260,           /* unary_operator  */
  YYSYMBOL_cast_expression = 261,          /* cast_expression  */
  YYSYMBOL_multiplicative_expression = 262, /* multiplicative_expression  */
  YYSYMBOL_additive_expression = 263,      /* additive_expression  */
  YYSYMBOL_shift_expression = 264,         /* shift_expression  */
  YYSYMBOL_relational_expression = 265,    /* relational_expression  */
  YYSYMBOL_equality_expression = 266,      /* equality_expression  */
  YYSYMBOL_AND_expression = 267,           /* AND_expression  */
  YYSYMBOL_exclusive_OR_expression = 268,  /* exclusive_OR_expression  */
  YYSYMBOL_inclusive_OR_expression = 269,  /* inclusive_OR_expression  */
  YYSYMBOL_logical_AND_expression = 270,   /* logical_AND_expression  */
  YYSYMBOL_logical_OR_expression = 271,    /* logical_OR_expression  */
  YYSYMBOL_conditional_expression = 272,   /* conditional_expression  */
  YYSYMBOL_assignment_expression = 273,    /* assignment_expression  */
  YYSYMBOL_assignment_operator = 274,      /* assignment_operator  */
  YYSYMBOL_expression = 275,               /* expression  */
  YYSYMBOL_constant_expression = 276,      /* constant_expression  */
  YYSYMBOL_declaration = 277,              /* declaration  */
  YYSYMBOL_declaration_specifiers = 278,   /* declaration_specifiers  */
  YYSYMBOL_init_declarator_list = 279,     /* init_declarator_list  */
  YYSYMBOL_init_declarator = 280,          /* init_declarator  */
  YYSYMBOL_281_1 = 281,                    /* $@1  */
  YYSYMBOL_declarator_and_maybe_attributes = 282, /* declarator_and_maybe_attributes  */
  YYSYMBOL_declarator_and_maybe_attributes_asm = 283, /* declarator_and_maybe_attributes_asm  */
  YYSYMBOL_storage_class_specifier = 284,  /* storage_class_specifier  */
  YYSYMBOL_type_specifier = 285,           /* type_specifier  */
  YYSYMBOL_struct_or_union_specifier = 286, /* struct_or_union_specifier  */
  YYSYMBOL_287_2 = 287,                    /* $@2  */
  YYSYMBOL_288_3 = 288,                    /* $@3  */
  YYSYMBOL_289_4 = 289,                    /* $@4  */
  YYSYMBOL_290_5 = 290,                    /* $@5  */
  YYSYMBOL_291_6 = 291,                    /* $@6  */
  YYSYMBOL_292_7 = 292,                    /* $@7  */
  YYSYMBOL_struct_or_union = 293,          /* struct_or_union  */
  YYSYMBOL_struct_declaration_list = 294,  /* struct_declaration_list  */
  YYSYMBOL_struct_declaration = 295,       /* struct_declaration  */
  YYSYMBOL_specifier_qualifier_list = 296, /* specifier_qualifier_list  */
  YYSYMBOL_struct_declarator_list = 297,   /* struct_declarator_list  */
  YYSYMBOL_struct_declarator = 298,        /* struct_declarator  */
  YYSYMBOL_enum_specifier = 299,           /* enum_specifier  */
  YYSYMBOL_enumerator_list = 300,          /* enumerator_list  */
  YYSYMBOL_enumerator = 301,               /* enumerator  */
  YYSYMBOL_type_qualifier = 302,           /* type_qualifier  */
  YYSYMBOL_function_specifier = 303,       /* function_specifier  */
  YYSYMBOL_declarator = 304,               /* declarator  */
  YYSYMBOL_direct_declarator = 305,        /* direct_declarator  */
  YYSYMBOL_pointer = 306,                  /* pointer  */
  YYSYMBOL_type_qualifier_list = 307,      /* type_qualifier_list  */
  YYSYMBOL_parameter_type_list = 308,      /* parameter_type_list  */
  YYSYMBOL_parameter_list = 309,           /* parameter_list  */
  YYSYMBOL_parameter_declaration = 310,    /* parameter_declaration  */
  YYSYMBOL_identifier_list = 311,          /* identifier_list  */
  YYSYMBOL_type_name = 312,                /* type_name  */
  YYSYMBOL_abstract_declarator = 313,      /* abstract_declarator  */
  YYSYMBOL_direct_abstract_declarator = 314, /* direct_abstract_declarator  */
  YYSYMBOL_typedef_name = 315,             /* typedef_name  */
  YYSYMBOL_initializer = 316,              /* initializer  */
  YYSYMBOL_initializer_list = 317,         /* initializer_list  */
  YYSYMBOL_designation = 318,              /* designation  */
  YYSYMBOL_designator_list = 319,          /* designator_list  */
  YYSYMBOL_designator = 320,               /* designator  */
  YYSYMBOL_statement = 321,                /* statement  */
  YYSYMBOL_statement_for_labeled = 322,    /* statement_for_labeled  */
  YYSYMBOL_labeled_statement = 323,        /* labeled_statement  */
  YYSYMBOL_compound_statement = 324,       /* compound_statement  */
  YYSYMBOL_325_8 = 325,                    /* @8  */
  YYSYMBOL_block_item_list = 326,          /* block_item_list  */
  YYSYMBOL_block_item = 327,               /* block_item  */
  YYSYMBOL_expression_statement = 328,     /* expression_statement  */
  YYSYMBOL_selection_statement = 329,      /* selection_statement  */
  YYSYMBOL_iteration_statement = 330,      /* iteration_statement  */
  YYSYMBOL_iteration_statement_for = 331,  /* iteration_statement_for  */
  YYSYMBOL_jump_statement = 332,           /* jump_statement  */
  YYSYMBOL_translation_unit = 333,         /* translation_unit  */
  YYSYMBOL_external_declaration = 334,     /* external_declaration  */
  YYSYMBOL_function_definition = 335,      /* function_definition  */
  YYSYMBOL_normal_function_definition = 336, /* normal_function_definition  */
  YYSYMBOL_337_9 = 337,                    /* $@9  */
  YYSYMBOL_338_10 = 338,                   /* $@10  */
  YYSYMBOL_oldstyle_function_definition = 339, /* oldstyle_function_definition  */
  YYSYMBOL_340_11 = 340,                   /* $@11  */
  YYSYMBOL_341_12 = 341,                   /* $@12  */
  YYSYMBOL_declaration_list = 342,         /* declaration_list  */
  YYSYMBOL_asm_statement = 343,            /* asm_statement  */
  YYSYMBOL_asm_stmtrest = 344,             /* asm_stmtrest  */
  YYSYMBOL_asm_qualifiers = 345,           /* asm_qualifiers  */
  YYSYMBOL_asm_qualifier = 346,            /* asm_qualifier  */
  YYSYMBOL_asm_output = 347,               /* asm_output  */
  YYSYMBOL_asm_outoperand = 348,           /* asm_outoperand  */
  YYSYMBOL_asm_input = 349,                /* asm_input  */
  YYSYMBOL_asm_inoperand = 350,            /* asm_inoperand  */
  YYSYMBOL_asm_clobbers = 351,             /* asm_clobbers  */
  YYSYMBOL_labellist = 352,                /* labellist  */
  YYSYMBOL_asm_asmname = 353,              /* asm_asmname  */
  YYSYMBOL_attribute_optseq = 354,         /* attribute_optseq  */
  YYSYMBOL_attribute_seq = 355,            /* attribute_seq  */
  YYSYMBOL_attribute = 356,                /* attribute  */
  YYSYMBOL_declaration_definition = 357,   /* declaration_definition  */
  YYSYMBOL_function_statement = 358,       /* function_statement  */
  YYSYMBOL_declarations_definitions_seq = 359, /* declarations_definitions_seq  */
  YYSYMBOL_openmp_construct = 360,         /* openmp_construct  */
  YYSYMBOL_openmp_directive = 361,         /* openmp_directive  */
  YYSYMBOL_structured_block = 362,         /* structured_block  */
  YYSYMBOL_parallel_construct = 363,       /* parallel_construct  */
  YYSYMBOL_parallel_directive = 364,       /* parallel_directive  */
  YYSYMBOL_parallel_clause_optseq = 365,   /* parallel_clause_optseq  */
  YYSYMBOL_parallel_clause = 366,          /* parallel_clause  */
  YYSYMBOL_paren_dirnamemod_and_expr = 367, /* paren_dirnamemod_and_expr  */
  YYSYMBOL_paren_dirnamemod_and_optexpr = 368, /* paren_dirnamemod_and_optexpr  */
  YYSYMBOL_paren_dirnamemod_and_varlist = 369, /* paren_dirnamemod_and_varlist  */
  YYSYMBOL_paren_dirnamemod_and_xlist = 370, /* paren_dirnamemod_and_xlist  */
  YYSYMBOL_dirname_modifier = 371,         /* dirname_modifier  */
  YYSYMBOL_dirname_modifier_opt = 372,     /* dirname_modifier_opt  */
  YYSYMBOL_paren_dirnamemod_maybe = 373,   /* paren_dirnamemod_maybe  */
  YYSYMBOL_num_threads_clause = 374,       /* num_threads_clause  */
  YYSYMBOL_375_13 = 375,                   /* $@13  */
  YYSYMBOL_copyin_clause = 376,            /* copyin_clause  */
  YYSYMBOL_377_14 = 377,                   /* $@14  */
  YYSYMBOL_unique_parallel_clause = 378,   /* unique_parallel_clause  */
  YYSYMBOL_379_15 = 379,                   /* $@15  */
  YYSYMBOL_for_construct = 380,            /* for_construct  */
  YYSYMBOL_for_directive = 381,            /* for_directive  */
  YYSYMBOL_for_clause_optseq = 382,        /* for_clause_optseq  */
  YYSYMBOL_for_clause = 383,               /* for_clause  */
  YYSYMBOL_nowait_clause = 384,            /* nowait_clause  */
  YYSYMBOL_unique_for_clause = 385,        /* unique_for_clause  */
  YYSYMBOL_ordered_clause = 386,           /* ordered_clause  */
  YYSYMBOL_387_16 = 387,                   /* $@16  */
  YYSYMBOL_schedule_clause = 388,          /* schedule_clause  */
  YYSYMBOL_389_17 = 389,                   /* $@17  */
  YYSYMBOL_390_18 = 390,                   /* $@18  */
  YYSYMBOL_schedule_kind = 391,            /* schedule_kind  */
  YYSYMBOL_schedule_mod_seq = 392,         /* schedule_mod_seq  */
  YYSYMBOL_schedule_mod = 393,             /* schedule_mod  */
  YYSYMBOL_sections_construct = 394,       /* sections_construct  */
  YYSYMBOL_sections_directive = 395,       /* sections_directive  */
  YYSYMBOL_sections_clause_optseq = 396,   /* sections_clause_optseq  */
  YYSYMBOL_sections_clause = 397,          /* sections_clause  */
  YYSYMBOL_section_scope = 398,            /* section_scope  */
  YYSYMBOL_section_sequence = 399,         /* section_sequence  */
  YYSYMBOL_section_directive = 400,        /* section_directive  */
  YYSYMBOL_single_construct = 401,         /* single_construct  */
  YYSYMBOL_single_directive = 402,         /* single_directive  */
  YYSYMBOL_single_clause_optseq = 403,     /* single_clause_optseq  */
  YYSYMBOL_single_clause = 404,            /* single_clause  */
  YYSYMBOL_unique_single_clause = 405,     /* unique_single_clause  */
  YYSYMBOL_406_19 = 406,                   /* $@19  */
  YYSYMBOL_simd_construct = 407,           /* simd_construct  */
  YYSYMBOL_simd_directive = 408,           /* simd_directive  */
  YYSYMBOL_simd_clause_optseq = 409,       /* simd_clause_optseq  */
  YYSYMBOL_simd_clause = 410,              /* simd_clause  */
  YYSYMBOL_unique_simd_clause = 411,       /* unique_simd_clause  */
  YYSYMBOL_safelen_clause = 412,           /* safelen_clause  */
  YYSYMBOL_413_20 = 413,                   /* $@20  */
  YYSYMBOL_inbranch_clause = 414,          /* inbranch_clause  */
  YYSYMBOL_uniform_clause = 415,           /* uniform_clause  */
  YYSYMBOL_416_21 = 416,                   /* $@21  */
  YYSYMBOL_linear_clause = 417,            /* linear_clause  */
  YYSYMBOL_418_22 = 418,                   /* $@22  */
  YYSYMBOL_aligned_clause = 419,           /* aligned_clause  */
  YYSYMBOL_420_23 = 420,                   /* $@23  */
  YYSYMBOL_optional_expression = 421,      /* optional_expression  */
  YYSYMBOL_declare_simd_construct = 422,   /* declare_simd_construct  */
  YYSYMBOL_declare_simd_directive_seq = 423, /* declare_simd_directive_seq  */
  YYSYMBOL_declare_simd_directive = 424,   /* declare_simd_directive  */
  YYSYMBOL_declare_simd_clause_optseq = 425, /* declare_simd_clause_optseq  */
  YYSYMBOL_declare_simd_clause = 426,      /* declare_simd_clause  */
  YYSYMBOL_for_simd_construct = 427,       /* for_simd_construct  */
  YYSYMBOL_for_simd_directive = 428,       /* for_simd_directive  */
  YYSYMBOL_for_simd_clause_optseq = 429,   /* for_simd_clause_optseq  */
  YYSYMBOL_for_simd_clause = 430,          /* for_simd_clause  */
  YYSYMBOL_parallel_for_simd_construct = 431, /* parallel_for_simd_construct  */
  YYSYMBOL_parallel_for_simd_directive = 432, /* parallel_for_simd_directive  */
  YYSYMBOL_parallel_for_simd_clause_optseq = 433, /* parallel_for_simd_clause_optseq  */
  YYSYMBOL_parallel_for_simd_clause = 434, /* parallel_for_simd_clause  */
  YYSYMBOL_target_data_construct = 435,    /* target_data_construct  */
  YYSYMBOL_target_data_directive = 436,    /* target_data_directive  */
  YYSYMBOL_target_data_clause_optseq = 437, /* target_data_clause_optseq  */
  YYSYMBOL_target_data_clause = 438,       /* target_data_clause  */
  YYSYMBOL_device_clause = 439,            /* device_clause  */
  YYSYMBOL_440_24 = 440,                   /* $@24  */
  YYSYMBOL_map_clause = 441,               /* map_clause  */
  YYSYMBOL_442_25 = 442,                   /* $@25  */
  YYSYMBOL_443_26 = 443,                   /* $@26  */
  YYSYMBOL_map_modifier_seq = 444,         /* map_modifier_seq  */
  YYSYMBOL_map_modifier = 445,             /* map_modifier  */
  YYSYMBOL_map_type = 446,                 /* map_type  */
  YYSYMBOL_use_device_ptr_clause = 447,    /* use_device_ptr_clause  */
  YYSYMBOL_448_27 = 448,                   /* $@27  */
  YYSYMBOL_defaultmap_clause = 449,        /* defaultmap_clause  */
  YYSYMBOL_is_device_ptr_clause = 450,     /* is_device_ptr_clause  */
  YYSYMBOL_451_28 = 451,                   /* $@28  */
  YYSYMBOL_target_construct = 452,         /* target_construct  */
  YYSYMBOL_453_29 = 453,                   /* @29  */
  YYSYMBOL_target_directive = 454,         /* target_directive  */
  YYSYMBOL_target_clause_optseq = 455,     /* target_clause_optseq  */
  YYSYMBOL_target_clause = 456,            /* target_clause  */
  YYSYMBOL_unique_target_clause = 457,     /* unique_target_clause  */
  YYSYMBOL_target_enter_data_directive = 458, /* target_enter_data_directive  */
  YYSYMBOL_target_enter_data_clause_seq = 459, /* target_enter_data_clause_seq  */
  YYSYMBOL_target_enter_data_clause = 460, /* target_enter_data_clause  */
  YYSYMBOL_target_exit_data_directive = 461, /* target_exit_data_directive  */
  YYSYMBOL_target_exit_data_clause_seq = 462, /* target_exit_data_clause_seq  */
  YYSYMBOL_target_exit_data_clause = 463,  /* target_exit_data_clause  */
  YYSYMBOL_target_update_directive = 464,  /* target_update_directive  */
  YYSYMBOL_target_update_clause_seq = 465, /* target_update_clause_seq  */
  YYSYMBOL_target_update_clause = 466,     /* target_update_clause  */
  YYSYMBOL_error_directive = 467,          /* error_directive  */
  YYSYMBOL_error_clause_seq = 468,         /* error_clause_seq  */
  YYSYMBOL_error_clause = 469,             /* error_clause  */
  YYSYMBOL_at_clause = 470,                /* at_clause  */
  YYSYMBOL_at_action = 471,                /* at_action  */
  YYSYMBOL_severity_clause = 472,          /* severity_clause  */
  YYSYMBOL_severity_level = 473,           /* severity_level  */
  YYSYMBOL_message_clause = 474,           /* message_clause  */
  YYSYMBOL_filter_clause = 475,            /* filter_clause  */
  YYSYMBOL_476_30 = 476,                   /* $@30  */
  YYSYMBOL_fail_memmodel = 477,            /* fail_memmodel  */
  YYSYMBOL_motion_clause = 478,            /* motion_clause  */
  YYSYMBOL_to_clause = 479,                /* to_clause  */
  YYSYMBOL_480_31 = 480,                   /* $@31  */
  YYSYMBOL_from_clause = 481,              /* from_clause  */
  YYSYMBOL_482_32 = 482,                   /* $@32  */
  YYSYMBOL_declare_target_construct = 483, /* declare_target_construct  */
  YYSYMBOL_declare_target_directive = 484, /* declare_target_directive  */
  YYSYMBOL_end_declare_target_directive = 485, /* end_declare_target_directive  */
  YYSYMBOL_declare_target_directive_v45 = 486, /* declare_target_directive_v45  */
  YYSYMBOL_declare_target_clause_optseq = 487, /* declare_target_clause_optseq  */
  YYSYMBOL_unique_declare_target_clause = 488, /* unique_declare_target_clause  */
  YYSYMBOL_489_33 = 489,                   /* $@33  */
  YYSYMBOL_490_34 = 490,                   /* $@34  */
  YYSYMBOL_decltarg_to_clause_args = 491,  /* decltarg_to_clause_args  */
  YYSYMBOL_link_clause_args = 492,         /* link_clause_args  */
  YYSYMBOL_teams_construct = 493,          /* teams_construct  */
  YYSYMBOL_teams_directive = 494,          /* teams_directive  */
  YYSYMBOL_teams_clause_optseq = 495,      /* teams_clause_optseq  */
  YYSYMBOL_teams_clause = 496,             /* teams_clause  */
  YYSYMBOL_thread_limit_clause = 497,      /* thread_limit_clause  */
  YYSYMBOL_498_35 = 498,                   /* $@35  */
  YYSYMBOL_numteams_args = 499,            /* numteams_args  */
  YYSYMBOL_unique_teams_clause = 500,      /* unique_teams_clause  */
  YYSYMBOL_501_36 = 501,                   /* $@36  */
  YYSYMBOL_distribute_construct = 502,     /* distribute_construct  */
  YYSYMBOL_distribute_directive = 503,     /* distribute_directive  */
  YYSYMBOL_distribute_clause_optseq = 504, /* distribute_clause_optseq  */
  YYSYMBOL_distribute_clause = 505,        /* distribute_clause  */
  YYSYMBOL_unique_distribute_clause = 506, /* unique_distribute_clause  */
  YYSYMBOL_507_37 = 507,                   /* $@37  */
  YYSYMBOL_distribute_simd_construct = 508, /* distribute_simd_construct  */
  YYSYMBOL_distribute_simd_directive = 509, /* distribute_simd_directive  */
  YYSYMBOL_distribute_simd_clause_optseq = 510, /* distribute_simd_clause_optseq  */
  YYSYMBOL_distribute_simd_clause = 511,   /* distribute_simd_clause  */
  YYSYMBOL_distribute_parallel_for_construct = 512, /* distribute_parallel_for_construct  */
  YYSYMBOL_distribute_parallel_for_directive = 513, /* distribute_parallel_for_directive  */
  YYSYMBOL_distribute_parallel_for_clause_optseq = 514, /* distribute_parallel_for_clause_optseq  */
  YYSYMBOL_distribute_parallel_for_clause = 515, /* distribute_parallel_for_clause  */
  YYSYMBOL_distribute_parallel_for_simd_construct = 516, /* distribute_parallel_for_simd_construct  */
  YYSYMBOL_distribute_parallel_for_simd_directive = 517, /* distribute_parallel_for_simd_directive  */
  YYSYMBOL_distribute_parallel_for_simd_clause_optseq = 518, /* distribute_parallel_for_simd_clause_optseq  */
  YYSYMBOL_distribute_parallel_for_simd_clause = 519, /* distribute_parallel_for_simd_clause  */
  YYSYMBOL_target_teams_construct = 520,   /* target_teams_construct  */
  YYSYMBOL_target_teams_directive = 521,   /* target_teams_directive  */
  YYSYMBOL_target_teams_clause_optseq = 522, /* target_teams_clause_optseq  */
  YYSYMBOL_target_teams_clause = 523,      /* target_teams_clause  */
  YYSYMBOL_target_parallel_construct = 524, /* target_parallel_construct  */
  YYSYMBOL_target_parallel_directive = 525, /* target_parallel_directive  */
  YYSYMBOL_target_parallel_clause_optseq = 526, /* target_parallel_clause_optseq  */
  YYSYMBOL_target_parallel_clause = 527,   /* target_parallel_clause  */
  YYSYMBOL_teams_distribute_construct = 528, /* teams_distribute_construct  */
  YYSYMBOL_teams_distribute_directive = 529, /* teams_distribute_directive  */
  YYSYMBOL_teams_distribute_clause_optseq = 530, /* teams_distribute_clause_optseq  */
  YYSYMBOL_teams_distribute_clause = 531,  /* teams_distribute_clause  */
  YYSYMBOL_teams_distribute_simd_construct = 532, /* teams_distribute_simd_construct  */
  YYSYMBOL_teams_distribute_simd_directive = 533, /* teams_distribute_simd_directive  */
  YYSYMBOL_teams_distribute_simd_clause_optseq = 534, /* teams_distribute_simd_clause_optseq  */
  YYSYMBOL_teams_distribute_simd_clause = 535, /* teams_distribute_simd_clause  */
  YYSYMBOL_target_teams_distribute_construct = 536, /* target_teams_distribute_construct  */
  YYSYMBOL_target_teams_distribute_directive = 537, /* target_teams_distribute_directive  */
  YYSYMBOL_target_teams_distribute_clause_optseq = 538, /* target_teams_distribute_clause_optseq  */
  YYSYMBOL_target_teams_distribute_clause = 539, /* target_teams_distribute_clause  */
  YYSYMBOL_target_teams_distribute_simd_construct = 540, /* target_teams_distribute_simd_construct  */
  YYSYMBOL_target_teams_distribute_simd_directive = 541, /* target_teams_distribute_simd_directive  */
  YYSYMBOL_target_teams_distribute_simd_clause_optseq = 542, /* target_teams_distribute_simd_clause_optseq  */
  YYSYMBOL_target_teams_distribute_simd_clause = 543, /* target_teams_distribute_simd_clause  */
  YYSYMBOL_teams_distribute_parallel_for_construct = 544, /* teams_distribute_parallel_for_construct  */
  YYSYMBOL_teams_distribute_parallel_for_directive = 545, /* teams_distribute_parallel_for_directive  */
  YYSYMBOL_teams_distribute_parallel_for_clause_optseq = 546, /* teams_distribute_parallel_for_clause_optseq  */
  YYSYMBOL_teams_distribute_parallel_for_clause = 547, /* teams_distribute_parallel_for_clause  */
  YYSYMBOL_target_teams_distribute_parallel_for_construct = 548, /* target_teams_distribute_parallel_for_construct  */
  YYSYMBOL_target_teams_distribute_parallel_for_directive = 549, /* target_teams_distribute_parallel_for_directive  */
  YYSYMBOL_target_teams_distribute_parallel_for_clause_optseq = 550, /* target_teams_distribute_parallel_for_clause_optseq  */
  YYSYMBOL_target_teams_distribute_parallel_for_clause = 551, /* target_teams_distribute_parallel_for_clause  */
  YYSYMBOL_teams_distribute_parallel_for_simd_construct = 552, /* teams_distribute_parallel_for_simd_construct  */
  YYSYMBOL_teams_distribute_parallel_for_simd_directive = 553, /* teams_distribute_parallel_for_simd_directive  */
  YYSYMBOL_teams_distribute_parallel_for_simd_clause_optseq = 554, /* teams_distribute_parallel_for_simd_clause_optseq  */
  YYSYMBOL_teams_distribute_parallel_for_simd_clause = 555, /* teams_distribute_parallel_for_simd_clause  */
  YYSYMBOL_target_teams_distribute_parallel_for_simd_construct = 556, /* target_teams_distribute_parallel_for_simd_construct  */
  YYSYMBOL_target_teams_distribute_parallel_for_simd_directive = 557, /* target_teams_distribute_parallel_for_simd_directive  */
  YYSYMBOL_target_teams_distribute_parallel_for_simd_clause_optseq = 558, /* target_teams_distribute_parallel_for_simd_clause_optseq  */
  YYSYMBOL_target_teams_distribute_parallel_for_simd_clause = 559, /* target_teams_distribute_parallel_for_simd_clause  */
  YYSYMBOL_target_parallel_for_construct = 560, /* target_parallel_for_construct  */
  YYSYMBOL_target_parallel_for_directive = 561, /* target_parallel_for_directive  */
  YYSYMBOL_target_parallel_for_clause_optseq = 562, /* target_parallel_for_clause_optseq  */
  YYSYMBOL_target_parallel_for_clause = 563, /* target_parallel_for_clause  */
  YYSYMBOL_task_construct = 564,           /* task_construct  */
  YYSYMBOL_task_directive = 565,           /* task_directive  */
  YYSYMBOL_task_clause_optseq = 566,       /* task_clause_optseq  */
  YYSYMBOL_task_clause = 567,              /* task_clause  */
  YYSYMBOL_unique_task_clause = 568,       /* unique_task_clause  */
  YYSYMBOL_569_38 = 569,                   /* $@38  */
  YYSYMBOL_570_39 = 570,                   /* $@39  */
  YYSYMBOL_depend_clause = 571,            /* depend_clause  */
  YYSYMBOL_572_40 = 572,                   /* $@40  */
  YYSYMBOL_573_41 = 573,                   /* $@41  */
  YYSYMBOL_574_42 = 574,                   /* $@42  */
  YYSYMBOL_dependence_type = 575,          /* dependence_type  */
  YYSYMBOL_inreduction_clause = 576,       /* inreduction_clause  */
  YYSYMBOL_577_43 = 577,                   /* $@43  */
  YYSYMBOL_578_44 = 578,                   /* $@44  */
  YYSYMBOL_579_45 = 579,                   /* $@45  */
  YYSYMBOL_parallel_for_construct = 580,   /* parallel_for_construct  */
  YYSYMBOL_parallel_for_directive = 581,   /* parallel_for_directive  */
  YYSYMBOL_parallel_for_clause_optseq = 582, /* parallel_for_clause_optseq  */
  YYSYMBOL_parallel_for_clause = 583,      /* parallel_for_clause  */
  YYSYMBOL_parallel_sections_construct = 584, /* parallel_sections_construct  */
  YYSYMBOL_parallel_sections_directive = 585, /* parallel_sections_directive  */
  YYSYMBOL_parallel_sections_clause_optseq = 586, /* parallel_sections_clause_optseq  */
  YYSYMBOL_parallel_sections_clause = 587, /* parallel_sections_clause  */
  YYSYMBOL_master_construct = 588,         /* master_construct  */
  YYSYMBOL_master_directive = 589,         /* master_directive  */
  YYSYMBOL_critical_construct = 590,       /* critical_construct  */
  YYSYMBOL_critical_directive = 591,       /* critical_directive  */
  YYSYMBOL_region_phrase = 592,            /* region_phrase  */
  YYSYMBOL_hint_clause = 593,              /* hint_clause  */
  YYSYMBOL_594_46 = 594,                   /* $@46  */
  YYSYMBOL_barrier_directive = 595,        /* barrier_directive  */
  YYSYMBOL_taskwait_directive = 596,       /* taskwait_directive  */
  YYSYMBOL_taskgroup_construct = 597,      /* taskgroup_construct  */
  YYSYMBOL_taskgroup_directive = 598,      /* taskgroup_directive  */
  YYSYMBOL_taskgroup_clause_optseq = 599,  /* taskgroup_clause_optseq  */
  YYSYMBOL_taskreduction_clause = 600,     /* taskreduction_clause  */
  YYSYMBOL_601_47 = 601,                   /* $@47  */
  YYSYMBOL_602_48 = 602,                   /* $@48  */
  YYSYMBOL_603_49 = 603,                   /* $@49  */
  YYSYMBOL_taskyield_directive = 604,      /* taskyield_directive  */
  YYSYMBOL_atomic_construct = 605,         /* atomic_construct  */
  YYSYMBOL_atomic_directive = 606,         /* atomic_directive  */
  YYSYMBOL_atomic_clause_optseq = 607,     /* atomic_clause_optseq  */
  YYSYMBOL_atomic_clause = 608,            /* atomic_clause  */
  YYSYMBOL_memory_order_clause = 609,      /* memory_order_clause  */
  YYSYMBOL_seq_cst_clause = 610,           /* seq_cst_clause  */
  YYSYMBOL_acq_rel_clause = 611,           /* acq_rel_clause  */
  YYSYMBOL_acquire_clause = 612,           /* acquire_clause  */
  YYSYMBOL_release_clause = 613,           /* release_clause  */
  YYSYMBOL_relaxed_clause = 614,           /* relaxed_clause  */
  YYSYMBOL_masked_construct = 615,         /* masked_construct  */
  YYSYMBOL_masked_directive = 616,         /* masked_directive  */
  YYSYMBOL_masked_clause_opt = 617,        /* masked_clause_opt  */
  YYSYMBOL_requires_directive = 618,       /* requires_directive  */
  YYSYMBOL_requires_clause_optseq = 619,   /* requires_clause_optseq  */
  YYSYMBOL_unique_requires_clause = 620,   /* unique_requires_clause  */
  YYSYMBOL_reverse_offload_clause = 621,   /* reverse_offload_clause  */
  YYSYMBOL_unified_address_clause = 622,   /* unified_address_clause  */
  YYSYMBOL_unified_shared_memory_clause = 623, /* unified_shared_memory_clause  */
  YYSYMBOL_dynamic_allocators_clause = 624, /* dynamic_allocators_clause  */
  YYSYMBOL_defmemorder_type = 625,         /* defmemorder_type  */
  YYSYMBOL_atomic_default_mem_order_clause = 626, /* atomic_default_mem_order_clause  */
  YYSYMBOL_flush_directive = 627,          /* flush_directive  */
  YYSYMBOL_flush_vars = 628,               /* flush_vars  */
  YYSYMBOL_629_50 = 629,                   /* $@50  */
  YYSYMBOL_ordered_construct = 630,        /* ordered_construct  */
  YYSYMBOL_ordered_directive_full = 631,   /* ordered_directive_full  */
  YYSYMBOL_ordered_directive_standalone = 632, /* ordered_directive_standalone  */
  YYSYMBOL_ordered_clause_optseq_full = 633, /* ordered_clause_optseq_full  */
  YYSYMBOL_ordered_clause_type_full = 634, /* ordered_clause_type_full  */
  YYSYMBOL_ordered_clause_optseq_standalone = 635, /* ordered_clause_optseq_standalone  */
  YYSYMBOL_ordered_clause_depend_sink = 636, /* ordered_clause_depend_sink  */
  YYSYMBOL_sink_vec = 637,                 /* sink_vec  */
  YYSYMBOL_sink_vec_elem = 638,            /* sink_vec_elem  */
  YYSYMBOL_cancel_directive = 639,         /* cancel_directive  */
  YYSYMBOL_construct_type_clause = 640,    /* construct_type_clause  */
  YYSYMBOL_cancellation_point_directive = 641, /* cancellation_point_directive  */
  YYSYMBOL_threadprivate_directive = 642,  /* threadprivate_directive  */
  YYSYMBOL_643_51 = 643,                   /* $@51  */
  YYSYMBOL_644_52 = 644,                   /* $@52  */
  YYSYMBOL_thrprv_variable_list = 645,     /* thrprv_variable_list  */
  YYSYMBOL_declare_reduction_directive = 646, /* declare_reduction_directive  */
  YYSYMBOL_647_53 = 647,                   /* $@53  */
  YYSYMBOL_648_54 = 648,                   /* $@54  */
  YYSYMBOL_reduction_identifier = 649,     /* reduction_identifier  */
  YYSYMBOL_reduction_type_list = 650,      /* reduction_type_list  */
  YYSYMBOL_initializer_clause_opt = 651,   /* initializer_clause_opt  */
  YYSYMBOL_data_default_clause = 652,      /* data_default_clause  */
  YYSYMBOL_data_privatization_clause = 653, /* data_privatization_clause  */
  YYSYMBOL_654_55 = 654,                   /* $@55  */
  YYSYMBOL_data_privatization_in_clause = 655, /* data_privatization_in_clause  */
  YYSYMBOL_656_56 = 656,                   /* $@56  */
  YYSYMBOL_data_privatization_out_clause = 657, /* data_privatization_out_clause  */
  YYSYMBOL_658_57 = 658,                   /* $@57  */
  YYSYMBOL_data_sharing_clause = 659,      /* data_sharing_clause  */
  YYSYMBOL_660_58 = 660,                   /* $@58  */
  YYSYMBOL_data_reduction_clause = 661,    /* data_reduction_clause  */
  YYSYMBOL_662_59 = 662,                   /* $@59  */
  YYSYMBOL_data_reduction_modifier_seq = 663, /* data_reduction_modifier_seq  */
  YYSYMBOL_data_reduction_modifier = 664,  /* data_reduction_modifier  */
  YYSYMBOL_if_clause = 665,                /* if_clause  */
  YYSYMBOL_666_60 = 666,                   /* $@60  */
  YYSYMBOL_667_61 = 667,                   /* $@61  */
  YYSYMBOL_collapse_clause = 668,          /* collapse_clause  */
  YYSYMBOL_669_62 = 669,                   /* $@62  */
  YYSYMBOL_variable_list = 670,            /* variable_list  */
  YYSYMBOL_variable_array_section_list = 671, /* variable_array_section_list  */
  YYSYMBOL_varid_or_array_section = 672,   /* varid_or_array_section  */
  YYSYMBOL_funcname_variable_array_section_list = 673, /* funcname_variable_array_section_list  */
  YYSYMBOL_funcvarid_or_array_section = 674, /* funcvarid_or_array_section  */
  YYSYMBOL_array_section_slice_list = 675, /* array_section_slice_list  */
  YYSYMBOL_676_63 = 676,                   /* $@63  */
  YYSYMBOL_677_64 = 677,                   /* $@64  */
  YYSYMBOL_array_section_slice = 678,      /* array_section_slice  */
  YYSYMBOL_procbind_clause = 679,          /* procbind_clause  */
  YYSYMBOL_procbind_policy = 680,          /* procbind_policy  */
  YYSYMBOL_ompix_directive = 681,          /* ompix_directive  */
  YYSYMBOL_ox_tasksync_directive = 682,    /* ox_tasksync_directive  */
  YYSYMBOL_ox_taskschedule_directive = 683, /* ox_taskschedule_directive  */
  YYSYMBOL_684_65 = 684,                   /* $@65  */
  YYSYMBOL_ox_taskschedule_clause_optseq = 685, /* ox_taskschedule_clause_optseq  */
  YYSYMBOL_ox_taskschedule_clause = 686,   /* ox_taskschedule_clause  */
  YYSYMBOL_ox_scope_spec = 687,            /* ox_scope_spec  */
  YYSYMBOL_ompix_construct = 688,          /* ompix_construct  */
  YYSYMBOL_ox_taskdef_construct = 689,     /* ox_taskdef_construct  */
  YYSYMBOL_690_66 = 690,                   /* $@66  */
  YYSYMBOL_ox_taskdef_directive = 691,     /* ox_taskdef_directive  */
  YYSYMBOL_692_67 = 692,                   /* $@67  */
  YYSYMBOL_ox_taskdef_clause_optseq = 693, /* ox_taskdef_clause_optseq  */
  YYSYMBOL_ox_taskdef_clause = 694,        /* ox_taskdef_clause  */
  YYSYMBOL_ox_variable_size_list = 695,    /* ox_variable_size_list  */
  YYSYMBOL_ox_variable_size_elem = 696,    /* ox_variable_size_elem  */
  YYSYMBOL_ox_task_construct = 697,        /* ox_task_construct  */
  YYSYMBOL_ox_task_directive = 698,        /* ox_task_directive  */
  YYSYMBOL_ox_task_clause_optseq = 699,    /* ox_task_clause_optseq  */
  YYSYMBOL_ox_task_clause = 700,           /* ox_task_clause  */
  YYSYMBOL_ox_procextern_construct = 701,  /* ox_procextern_construct  */
  YYSYMBOL_ox_procextern_directive = 702,  /* ox_procextern_directive  */
  YYSYMBOL_703_68 = 703,                   /* $@68  */
  YYSYMBOL_704_69 = 704,                   /* $@69  */
  YYSYMBOL_extern_variable_list = 705,     /* extern_variable_list  */
  YYSYMBOL_ox_tag_construct = 706,         /* ox_tag_construct  */
  YYSYMBOL_ox_tag_directive = 707,         /* ox_tag_directive  */
  YYSYMBOL_ox_tag_clause = 708,            /* ox_tag_clause  */
  YYSYMBOL_709_70 = 709,                   /* $@70  */
  YYSYMBOL_tag_clause = 710,               /* tag_clause  */
  YYSYMBOL_711_71 = 711                    /* $@71  */
};
typedef enum yysymbol_kind_t yysymbol_kind_t;




#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))


/* Stored state numbers (used for stacks). */
typedef yytype_int16 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif


#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(E) ((void) (E))
#else
# define YYUSE(E) /* empty */
#endif

#if defined __GNUC__ && ! defined __ICC && 407 <= __GNUC__ * 100 + __GNUC_MINOR__
/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                            \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if !defined yyoverflow

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* !defined yyoverflow */

#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  245
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   6506

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  252
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  460
/* YYNRULES -- Number of rules.  */
#define YYNRULES  1159
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  1944

/* YYMAXUTOK -- Last valid token kind.  */
#define YYMAXUTOK   481


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK                     \
   ? YY_CAST (yysymbol_kind_t, yytranslate[YYX])        \
   : YYSYMBOL_YYUNDEF)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_uint8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     251,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   240,     2,     2,     2,   242,   235,     2,
     227,   228,   236,   237,   234,   238,   231,   241,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   248,   250,
     243,   249,   244,   247,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   229,     2,   230,   245,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   232,   246,   233,   239,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226
};

#if YYDEBUG
  /* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,   633,   633,   634,   635,   636,   653,   674,   678,   701,
     720,   724,   728,   754,   759,   764,   769,   774,   784,   789,
     794,   799,   804,   808,   817,   820,   821,   829,   834,   838,
     842,   849,   853,   857,   866,   871,   876,   885,   889,   893,
     897,   901,   905,   913,   914,   922,   923,   927,   931,   939,
     940,   944,   952,   953,   957,   965,   966,   970,   974,   978,
     986,   987,   991,   999,  1000,  1008,  1009,  1017,  1018,  1026,
    1027,  1035,  1036,  1044,  1045,  1053,  1054,  1062,  1066,  1070,
    1074,  1078,  1082,  1086,  1090,  1094,  1098,  1102,  1110,  1111,
    1119,  1130,  1145,  1152,  1157,  1161,  1165,  1170,  1178,  1179,
    1183,  1184,  1188,  1189,  1193,  1194,  1202,  1203,  1217,  1234,
    1233,  1256,  1257,  1262,  1263,  1264,  1265,  1274,  1279,  1283,
    1287,  1291,  1299,  1303,  1307,  1311,  1315,  1319,  1323,  1327,
    1331,  1335,  1339,  1343,  1347,  1348,  1349,  1353,  1357,  1366,
    1367,  1366,  1371,  1375,  1376,  1375,  1391,  1392,  1391,  1399,
    1406,  1417,  1421,  1429,  1430,  1438,  1442,  1450,  1451,  1455,
    1456,  1464,  1465,  1473,  1474,  1478,  1486,  1490,  1503,  1515,
    1519,  1531,  1543,  1551,  1563,  1564,  1573,  1577,  1585,  1589,
    1593,  1597,  1602,  1610,  1614,  1623,  1627,  1635,  1639,  1643,
    1647,  1651,  1655,  1659,  1663,  1667,  1671,  1675,  1679,  1687,
    1691,  1695,  1699,  1707,  1708,  1716,  1717,  1725,  1726,  1734,
    1738,  1742,  1750,  1754,  1762,  1766,  1774,  1778,  1782,  1790,
    1794,  1798,  1802,  1806,  1810,  1814,  1818,  1822,  1826,  1830,
    1838,  1846,  1847,  1851,  1859,  1860,  1864,  1868,  1876,  1881,
    1882,  1890,  1894,  1898,  1912,  1913,  1914,  1915,  1916,  1917,
    1918,  1919,  1924,  1940,  1948,  1952,  1962,  1966,  1970,  1978,
    1982,  1982,  1993,  1994,  2003,  2004,  2005,  2010,  2019,  2023,
    2032,  2036,  2040,  2049,  2053,  2057,  2061,  2065,  2069,  2073,
    2077,  2081,  2085,  2089,  2093,  2097,  2101,  2105,  2113,  2118,
    2122,  2126,  2133,  2150,  2154,  2162,  2163,  2167,  2171,  2175,
    2187,  2188,  2193,  2192,  2219,  2218,  2254,  2253,  2282,  2281,
    2319,  2320,  2340,  2344,  2351,  2355,  2359,  2363,  2367,  2374,
    2375,  2382,  2383,  2387,  2390,  2391,  2398,  2402,  2409,  2412,
    2413,  2420,  2424,  2431,  2435,  2442,  2446,  2453,  2465,  2468,
    2475,  2479,  2486,  2509,  2510,  2515,  2521,  2522,  2529,  2530,
    2531,  2532,  2533,  2534,  2535,  2536,  2537,  2538,  2540,  2542,
    2543,  2544,  2545,  2546,  2547,  2548,  2549,  2550,  2551,  2552,
    2553,  2554,  2555,  2556,  2557,  2558,  2559,  2560,  2561,  2562,
    2564,  2566,  2577,  2581,  2586,  2591,  2596,  2601,  2606,  2611,
    2616,  2621,  2628,  2632,  2640,  2648,  2651,  2655,  2662,  2663,
    2664,  2665,  2666,  2667,  2668,  2691,  2695,  2705,  2709,  2713,
    2721,  2725,  2734,  2738,  2747,  2748,  2749,  2750,  2751,  2752,
    2753,  2754,  2755,  2756,  2757,  2758,  2759,  2760,  2761,  2762,
    2763,  2764,  2765,  2766,  2767,  2768,  2769,  2770,  2771,  2772,
    2773,  2774,  2782,  2783,  2788,  2789,  2790,  2794,  2794,  2803,
    2803,  2812,  2813,  2814,  2816,  2816,  2824,  2831,  2839,  2842,
    2855,  2871,  2872,  2873,  2874,  2875,  2876,  2880,  2881,  2888,
    2889,  2890,  2891,  2895,  2899,  2899,  2921,  2928,  2928,  2940,
    2939,  2954,  2955,  2956,  2957,  2958,  2959,  2963,  2964,  2968,
    2981,  2982,  2983,  2987,  2994,  3002,  3005,  3009,  3016,  3017,
    3018,  3019,  3020,  3024,  3031,  3036,  3040,  3047,  3054,  3061,
    3069,  3072,  3076,  3083,  3084,  3085,  3086,  3090,  3090,  3100,
    3108,  3116,  3119,  3123,  3131,  3132,  3133,  3134,  3135,  3136,
    3140,  3141,  3142,  3147,  3147,  3164,  3168,  3176,  3176,  3185,
    3185,  3194,  3194,  3203,  3206,  3214,  3222,  3226,  3234,  3242,
    3245,  3249,  3258,  3270,  3271,  3272,  3273,  3278,  3286,  3294,
    3297,  3301,  3308,  3309,  3314,  3322,  3330,  3333,  3337,  3344,
    3345,  3350,  3359,  3367,  3370,  3374,  3381,  3382,  3390,  3391,
    3396,  3396,  3407,  3407,  3412,  3412,  3422,  3423,  3429,  3430,
    3431,  3437,  3438,  3439,  3440,  3441,  3442,  3447,  3447,  3457,
    3465,  3465,  3475,  3475,  3487,  3494,  3495,  3496,  3500,  3501,
    3502,  3503,  3504,  3505,  3506,  3510,  3511,  3519,  3520,  3525,
    3536,  3537,  3541,  3548,  3555,  3556,  3557,  3558,  3563,  3574,
    3575,  3579,  3586,  3594,  3595,  3596,  3597,  3602,  3610,  3611,
    3615,  3622,  3623,  3624,  3625,  3626,  3631,  3638,  3639,  3640,
    3644,  3645,  3646,  3650,  3657,  3658,  3662,  3669,  3670,  3674,
    3682,  3682,  3691,  3692,  3693,  3698,  3699,  3704,  3704,  3713,
    3713,  3724,  3729,  3736,  3743,  3751,  3756,  3764,  3765,  3769,
    3777,  3777,  3783,  3782,  3797,  3801,  3808,  3812,  3822,  3832,
    3839,  3840,  3841,  3845,  3846,  3847,  3848,  3849,  3850,  3851,
    3857,  3857,  3866,  3870,  3877,  3892,  3892,  3901,  3909,  3917,
    3920,  3924,  3931,  3932,  3933,  3934,  3935,  3939,  3944,  3943,
    3953,  3962,  3970,  3973,  3977,  3984,  3985,  3986,  3991,  4000,
    4008,  4011,  4024,  4040,  4041,  4046,  4055,  4064,  4067,  4071,
    4078,  4079,  4084,  4094,  4102,  4105,  4109,  4116,  4117,  4118,
    4119,  4120,  4125,  4135,  4143,  4146,  4150,  4157,  4158,  4159,
    4160,  4161,  4162,  4163,  4164,  4165,  4166,  4167,  4172,  4180,
    4188,  4191,  4195,  4202,  4203,  4204,  4205,  4206,  4211,  4219,
    4227,  4230,  4234,  4241,  4242,  4243,  4244,  4245,  4250,  4260,
    4268,  4271,  4275,  4282,  4283,  4284,  4285,  4286,  4291,  4301,
    4310,  4313,  4318,  4326,  4327,  4328,  4329,  4334,  4343,  4352,
    4355,  4369,  4386,  4387,  4388,  4393,  4404,  4413,  4416,  4430,
    4447,  4448,  4449,  4450,  4455,  4464,  4473,  4476,  4481,  4489,
    4490,  4491,  4496,  4507,  4516,  4519,  4524,  4532,  4533,  4534,
    4535,  4540,  4550,  4558,  4561,  4574,  4590,  4591,  4592,  4593,
    4598,  4607,  4615,  4616,  4617,  4622,  4623,  4624,  4625,  4626,
    4627,  4628,  4629,  4635,  4635,  4641,  4645,  4650,  4650,  4665,
    4664,  4671,  4670,  4677,  4676,  4686,  4687,  4688,  4698,  4697,
    4704,  4703,  4710,  4709,  4718,  4726,  4734,  4737,  4750,  4766,
    4767,  4768,  4769,  4770,  4771,  4772,  4773,  4774,  4778,  4786,
    4794,  4797,  4801,  4808,  4809,  4810,  4811,  4812,  4813,  4814,
    4815,  4819,  4826,  4833,  4840,  4844,  4849,  4856,  4864,  4864,
    4873,  4881,  4889,  4898,  4906,  4909,  4913,  4926,  4925,  4932,
    4931,  4938,  4937,  4947,  4954,  4961,  4969,  4972,  4976,  4980,
    4984,  4991,  4992,  4993,  4994,  4995,  4996,  4997,  5001,  5005,
    5006,  5007,  5008,  5009,  5013,  5017,  5021,  5025,  5029,  5034,
    5041,  5049,  5052,  5057,  5066,  5067,  5071,  5078,  5079,  5080,
    5081,  5082,  5083,  5092,  5099,  5106,  5113,  5120,  5124,  5128,
    5132,  5140,  5147,  5151,  5158,  5162,  5175,  5179,  5179,  5187,
    5191,  5198,  5206,  5210,  5219,  5222,  5226,  5234,  5238,  5243,
    5244,  5248,  5257,  5262,  5267,  5275,  5276,  5283,  5289,  5295,
    5305,  5309,  5313,  5320,  5324,  5328,  5332,  5340,  5347,  5348,
    5347,  5360,  5378,  5401,  5402,  5400,  5409,  5415,  5416,  5417,
    5418,  5419,  5420,  5421,  5422,  5423,  5424,  5428,  5432,  5440,
    5443,  5448,  5461,  5465,  5470,  5477,  5477,  5486,  5486,  5495,
    5495,  5504,  5504,  5514,  5514,  5527,  5531,  5538,  5539,  5543,
    5545,  5550,  5550,  5556,  5556,  5567,  5567,  5584,  5591,  5601,
    5602,  5613,  5620,  5634,  5635,  5646,  5651,  5659,  5659,  5668,
    5668,  5676,  5677,  5678,  5679,  5680,  5684,  5691,  5692,  5693,
    5694,  5696,  5716,  5720,  5727,  5735,  5734,  5747,  5750,  5754,
    5761,  5765,  5769,  5773,  5777,  5784,  5788,  5792,  5796,  5803,
    5804,  5805,  5806,  5813,  5812,  5829,  5838,  5837,  5850,  5853,
    5857,  5864,  5868,  5872,  5876,  5883,  5884,  5891,  5896,  5904,
    5912,  5921,  5929,  5932,  5936,  5943,  5947,  5951,  5955,  5959,
    5963,  5967,  5971,  5975,  5979,  5987,  5995,  5995,  5994,  6003,
    6016,  6032,  6036,  6043,  6050,  6054,  6054,  6062,  6066,  6066
};
#endif

/** Accessing symbol of state STATE.  */
#define YY_ACCESSING_SYMBOL(State) YY_CAST (yysymbol_kind_t, yystos[State])

#if YYDEBUG || 0
/* The user-facing name of the symbol whose (internal) number is
   YYSYMBOL.  No bounds checking.  */
static const char *yysymbol_name (yysymbol_kind_t yysymbol) YY_ATTRIBUTE_UNUSED;

/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "\"end of file\"", "error", "\"invalid token\"",
  "START_SYMBOL_EXPRESSION", "START_SYMBOL_BLOCKLIST",
  "START_SYMBOL_TRANSUNIT", "IDENTIFIER", "TYPE_NAME", "CONSTANT",
  "STRING_LITERAL", "PTR_OP", "INC_OP", "DEC_OP", "LEFT_OP", "RIGHT_OP",
  "LE_OP", "GE_OP", "EQ_OP", "NE_OP", "AND_OP", "OR_OP", "MUL_ASSIGN",
  "DIV_ASSIGN", "MOD_ASSIGN", "ADD_ASSIGN", "SUB_ASSIGN", "LEFT_ASSIGN",
  "RIGHT_ASSIGN", "AND_ASSIGN", "XOR_ASSIGN", "OR_ASSIGN", "SIZEOF",
  "ALIGNOF", "TYPEOF", "TYPEDEF", "EXTERN", "STATIC", "AUTO", "REGISTER",
  "RESTRICT", "CHAR", "SHORT", "INT", "LONG", "SIGNED", "UNSIGNED",
  "FLOAT", "DOUBLE", "CONST", "VOLATILE", "VOID", "INLINE", "UBOOL",
  "UCOMPLEX", "UIMAGINARY", "STRUCT", "UNION", "ENUM", "ELLIPSIS", "CASE",
  "DEFAULT", "IF", "ELSE", "SWITCH", "WHILE", "DO", "FOR", "GOTO",
  "CONTINUE", "BREAK", "RETURN", "__BUILTIN_VA_ARG", "__BUILTIN_OFFSETOF",
  "__BUILTIN_TYPES_COMPATIBLE_P", "__ATTRIBUTE__", "__ASM__",
  "PRAGMA_OTHER", "PRAGMA_OMP", "OMP_THREADPRIVATE", "OMP_PARALLEL",
  "OMP_SECTIONS", "OMP_NOWAIT", "OMP_ORDERED", "OMP_SCHEDULE",
  "OMP_STATIC", "OMP_DYNAMIC", "OMP_GUIDED", "OMP_RUNTIME", "OMP_AUTO",
  "OMP_SECTION", "OMP_AFFINITY", "OMP_SINGLE", "OMP_MASTER",
  "OMP_CRITICAL", "OMP_BARRIER", "OMP_ATOMIC", "OMP_FLUSH", "OMP_PRIVATE",
  "OMP_FIRSTPRIVATE", "OMP_LASTPRIVATE", "OMP_SHARED", "OMP_DEFAULT",
  "OMP_NONE", "OMP_REDUCTION", "OMP_COPYIN", "OMP_NUMTHREADS",
  "OMP_COPYPRIVATE", "OMP_FOR", "OMP_IF", "OMP_TASK", "OMP_UNTIED",
  "OMP_TASKWAIT", "OMP_COLLAPSE", "OMP_FINAL", "OMP_MERGEABLE",
  "OMP_TASKYIELD", "OMP_READ", "OMP_WRITE", "OMP_CAPTURE", "OMP_UPDATE",
  "OMP_MIN", "OMP_MAX", "OMP_PROCBIND", "OMP_CLOSE", "OMP_SPREAD",
  "OMP_SIMD", "OMP_INBRANCH", "OMP_NOTINBRANCH", "OMP_UNIFORM",
  "OMP_LINEAR", "OMP_ALIGNED", "OMP_SIMDLEN", "OMP_SAFELEN", "OMP_DECLARE",
  "OMP_TARGET", "OMP_TARGETDATA", "OMP_TARGETUPDATE", "OMP_DEVICE",
  "OMP_MAP", "OMP_ALLOC", "OMP_TO", "OMP_FROM", "OMP_TOFROM", "OMP_END",
  "OMP_TEAMS", "OMP_DISTRIBUTE", "OMP_NUMTEAMS", "OMP_THREADLIMIT",
  "OMP_DISTSCHEDULE", "OMP_DEPEND", "OMP_IN", "OMP_OUT", "OMP_INOUT",
  "OMP_TASKGROUP", "OMP_SEQ_CST", "OMP_CANCEL", "OMP_INITIALIZER",
  "OMP_CANCELLATIONPOINT", "OMP_DECLARETARGET", "OMP_ENDDECLARETARGET",
  "OMP_HINT", "OMP_SOURCE", "OMP_SINK", "OMP_RELEASE", "OMP_DELETE",
  "OMP_ALWAYS", "OMP_IS_DEVICE_PTR", "OMP_USE_DEVICE_PTR",
  "OMP_TARGETENTERDATA", "OMP_TARGETEXITDATA", "OMP_PRIORITY",
  "OMP_TASKLOOP", "OMP_THREADS", "OMP_LINK", "OMP_DEFAULTMAP",
  "OMP_SCALAR", "OMP_MONOTONIC", "OMP_NONMONOTONIC", "OMP_INREDUCTION",
  "OMP_TASKREDUCTION", "OMP_INSCAN", "OMP_REQUIRES", "OMP_REVERSE_OFFLOAD",
  "OMP_UNIFIED_ADDRESS", "OMP_UNIFIED_SHARED_MEMORY",
  "OMP_ATOMIC_DEFAULT_MEM_ORDER", "OMP_ACQ_REL", "OMP_ACQUIRE",
  "OMP_RELAXED", "OMP_DYNAMIC_ALLOCATORS", "OMP_PRIMARY", "OMP_MASKED",
  "OMP_FILTER", "OMP_COMPARE", "OMP_WEAK", "OMP_FAIL", "OMP_ERROR",
  "OMP_COMPILATION", "OMP_EXECUTION", "OMP_SEVERITY", "OMP_FATAL",
  "OMP_WARNING", "OMP_MESSAGE", "OMP_AT", "PRAGMA_OMPIX", "OMPIX_TASKDEF",
  "OMPIX_TASKSYNC", "OMPIX_UPONRETURN", "OMPIX_ATNODE", "OMPIX_DETACHED",
  "OMPIX_ATWORKER", "OMPIX_TASKSCHEDULE", "OMPIX_STRIDE", "OMPIX_START",
  "OMPIX_SCOPE", "OMPIX_NODES", "OMPIX_WORKERS", "OMPIX_LOCAL",
  "OMPIX_GLOBAL", "OMPIX_HERE", "OMPIX_REMOTE", "OMPIX_HINTS",
  "OMPIX_TIED", "OMPIX_PROCEXTERN", "OMPIX_TAG", "NOELSE", "MULTIATTR",
  "'('", "')'", "'['", "']'", "'.'", "'{'", "'}'", "','", "'&'", "'*'",
  "'+'", "'-'", "'~'", "'!'", "'/'", "'%'", "'<'", "'>'", "'^'", "'|'",
  "'?'", "':'", "'='", "';'", "'\\n'", "$accept", "start_trick",
  "enumeration_constant", "string_literal", "primary_expression",
  "postfix_expression", "argument_expression_list", "unary_expression",
  "unary_operator", "cast_expression", "multiplicative_expression",
  "additive_expression", "shift_expression", "relational_expression",
  "equality_expression", "AND_expression", "exclusive_OR_expression",
  "inclusive_OR_expression", "logical_AND_expression",
  "logical_OR_expression", "conditional_expression",
  "assignment_expression", "assignment_operator", "expression",
  "constant_expression", "declaration", "declaration_specifiers",
  "init_declarator_list", "init_declarator", "$@1",
  "declarator_and_maybe_attributes", "declarator_and_maybe_attributes_asm",
  "storage_class_specifier", "type_specifier", "struct_or_union_specifier",
  "$@2", "$@3", "$@4", "$@5", "$@6", "$@7", "struct_or_union",
  "struct_declaration_list", "struct_declaration",
  "specifier_qualifier_list", "struct_declarator_list",
  "struct_declarator", "enum_specifier", "enumerator_list", "enumerator",
  "type_qualifier", "function_specifier", "declarator",
  "direct_declarator", "pointer", "type_qualifier_list",
  "parameter_type_list", "parameter_list", "parameter_declaration",
  "identifier_list", "type_name", "abstract_declarator",
  "direct_abstract_declarator", "typedef_name", "initializer",
  "initializer_list", "designation", "designator_list", "designator",
  "statement", "statement_for_labeled", "labeled_statement",
  "compound_statement", "@8", "block_item_list", "block_item",
  "expression_statement", "selection_statement", "iteration_statement",
  "iteration_statement_for", "jump_statement", "translation_unit",
  "external_declaration", "function_definition",
  "normal_function_definition", "$@9", "$@10",
  "oldstyle_function_definition", "$@11", "$@12", "declaration_list",
  "asm_statement", "asm_stmtrest", "asm_qualifiers", "asm_qualifier",
  "asm_output", "asm_outoperand", "asm_input", "asm_inoperand",
  "asm_clobbers", "labellist", "asm_asmname", "attribute_optseq",
  "attribute_seq", "attribute", "declaration_definition",
  "function_statement", "declarations_definitions_seq", "openmp_construct",
  "openmp_directive", "structured_block", "parallel_construct",
  "parallel_directive", "parallel_clause_optseq", "parallel_clause",
  "paren_dirnamemod_and_expr", "paren_dirnamemod_and_optexpr",
  "paren_dirnamemod_and_varlist", "paren_dirnamemod_and_xlist",
  "dirname_modifier", "dirname_modifier_opt", "paren_dirnamemod_maybe",
  "num_threads_clause", "$@13", "copyin_clause", "$@14",
  "unique_parallel_clause", "$@15", "for_construct", "for_directive",
  "for_clause_optseq", "for_clause", "nowait_clause", "unique_for_clause",
  "ordered_clause", "$@16", "schedule_clause", "$@17", "$@18",
  "schedule_kind", "schedule_mod_seq", "schedule_mod",
  "sections_construct", "sections_directive", "sections_clause_optseq",
  "sections_clause", "section_scope", "section_sequence",
  "section_directive", "single_construct", "single_directive",
  "single_clause_optseq", "single_clause", "unique_single_clause", "$@19",
  "simd_construct", "simd_directive", "simd_clause_optseq", "simd_clause",
  "unique_simd_clause", "safelen_clause", "$@20", "inbranch_clause",
  "uniform_clause", "$@21", "linear_clause", "$@22", "aligned_clause",
  "$@23", "optional_expression", "declare_simd_construct",
  "declare_simd_directive_seq", "declare_simd_directive",
  "declare_simd_clause_optseq", "declare_simd_clause",
  "for_simd_construct", "for_simd_directive", "for_simd_clause_optseq",
  "for_simd_clause", "parallel_for_simd_construct",
  "parallel_for_simd_directive", "parallel_for_simd_clause_optseq",
  "parallel_for_simd_clause", "target_data_construct",
  "target_data_directive", "target_data_clause_optseq",
  "target_data_clause", "device_clause", "$@24", "map_clause", "$@25",
  "$@26", "map_modifier_seq", "map_modifier", "map_type",
  "use_device_ptr_clause", "$@27", "defaultmap_clause",
  "is_device_ptr_clause", "$@28", "target_construct", "@29",
  "target_directive", "target_clause_optseq", "target_clause",
  "unique_target_clause", "target_enter_data_directive",
  "target_enter_data_clause_seq", "target_enter_data_clause",
  "target_exit_data_directive", "target_exit_data_clause_seq",
  "target_exit_data_clause", "target_update_directive",
  "target_update_clause_seq", "target_update_clause", "error_directive",
  "error_clause_seq", "error_clause", "at_clause", "at_action",
  "severity_clause", "severity_level", "message_clause", "filter_clause",
  "$@30", "fail_memmodel", "motion_clause", "to_clause", "$@31",
  "from_clause", "$@32", "declare_target_construct",
  "declare_target_directive", "end_declare_target_directive",
  "declare_target_directive_v45", "declare_target_clause_optseq",
  "unique_declare_target_clause", "$@33", "$@34",
  "decltarg_to_clause_args", "link_clause_args", "teams_construct",
  "teams_directive", "teams_clause_optseq", "teams_clause",
  "thread_limit_clause", "$@35", "numteams_args", "unique_teams_clause",
  "$@36", "distribute_construct", "distribute_directive",
  "distribute_clause_optseq", "distribute_clause",
  "unique_distribute_clause", "$@37", "distribute_simd_construct",
  "distribute_simd_directive", "distribute_simd_clause_optseq",
  "distribute_simd_clause", "distribute_parallel_for_construct",
  "distribute_parallel_for_directive",
  "distribute_parallel_for_clause_optseq",
  "distribute_parallel_for_clause",
  "distribute_parallel_for_simd_construct",
  "distribute_parallel_for_simd_directive",
  "distribute_parallel_for_simd_clause_optseq",
  "distribute_parallel_for_simd_clause", "target_teams_construct",
  "target_teams_directive", "target_teams_clause_optseq",
  "target_teams_clause", "target_parallel_construct",
  "target_parallel_directive", "target_parallel_clause_optseq",
  "target_parallel_clause", "teams_distribute_construct",
  "teams_distribute_directive", "teams_distribute_clause_optseq",
  "teams_distribute_clause", "teams_distribute_simd_construct",
  "teams_distribute_simd_directive", "teams_distribute_simd_clause_optseq",
  "teams_distribute_simd_clause", "target_teams_distribute_construct",
  "target_teams_distribute_directive",
  "target_teams_distribute_clause_optseq",
  "target_teams_distribute_clause",
  "target_teams_distribute_simd_construct",
  "target_teams_distribute_simd_directive",
  "target_teams_distribute_simd_clause_optseq",
  "target_teams_distribute_simd_clause",
  "teams_distribute_parallel_for_construct",
  "teams_distribute_parallel_for_directive",
  "teams_distribute_parallel_for_clause_optseq",
  "teams_distribute_parallel_for_clause",
  "target_teams_distribute_parallel_for_construct",
  "target_teams_distribute_parallel_for_directive",
  "target_teams_distribute_parallel_for_clause_optseq",
  "target_teams_distribute_parallel_for_clause",
  "teams_distribute_parallel_for_simd_construct",
  "teams_distribute_parallel_for_simd_directive",
  "teams_distribute_parallel_for_simd_clause_optseq",
  "teams_distribute_parallel_for_simd_clause",
  "target_teams_distribute_parallel_for_simd_construct",
  "target_teams_distribute_parallel_for_simd_directive",
  "target_teams_distribute_parallel_for_simd_clause_optseq",
  "target_teams_distribute_parallel_for_simd_clause",
  "target_parallel_for_construct", "target_parallel_for_directive",
  "target_parallel_for_clause_optseq", "target_parallel_for_clause",
  "task_construct", "task_directive", "task_clause_optseq", "task_clause",
  "unique_task_clause", "$@38", "$@39", "depend_clause", "$@40", "$@41",
  "$@42", "dependence_type", "inreduction_clause", "$@43", "$@44", "$@45",
  "parallel_for_construct", "parallel_for_directive",
  "parallel_for_clause_optseq", "parallel_for_clause",
  "parallel_sections_construct", "parallel_sections_directive",
  "parallel_sections_clause_optseq", "parallel_sections_clause",
  "master_construct", "master_directive", "critical_construct",
  "critical_directive", "region_phrase", "hint_clause", "$@46",
  "barrier_directive", "taskwait_directive", "taskgroup_construct",
  "taskgroup_directive", "taskgroup_clause_optseq", "taskreduction_clause",
  "$@47", "$@48", "$@49", "taskyield_directive", "atomic_construct",
  "atomic_directive", "atomic_clause_optseq", "atomic_clause",
  "memory_order_clause", "seq_cst_clause", "acq_rel_clause",
  "acquire_clause", "release_clause", "relaxed_clause", "masked_construct",
  "masked_directive", "masked_clause_opt", "requires_directive",
  "requires_clause_optseq", "unique_requires_clause",
  "reverse_offload_clause", "unified_address_clause",
  "unified_shared_memory_clause", "dynamic_allocators_clause",
  "defmemorder_type", "atomic_default_mem_order_clause", "flush_directive",
  "flush_vars", "$@50", "ordered_construct", "ordered_directive_full",
  "ordered_directive_standalone", "ordered_clause_optseq_full",
  "ordered_clause_type_full", "ordered_clause_optseq_standalone",
  "ordered_clause_depend_sink", "sink_vec", "sink_vec_elem",
  "cancel_directive", "construct_type_clause",
  "cancellation_point_directive", "threadprivate_directive", "$@51",
  "$@52", "thrprv_variable_list", "declare_reduction_directive", "$@53",
  "$@54", "reduction_identifier", "reduction_type_list",
  "initializer_clause_opt", "data_default_clause",
  "data_privatization_clause", "$@55", "data_privatization_in_clause",
  "$@56", "data_privatization_out_clause", "$@57", "data_sharing_clause",
  "$@58", "data_reduction_clause", "$@59", "data_reduction_modifier_seq",
  "data_reduction_modifier", "if_clause", "$@60", "$@61",
  "collapse_clause", "$@62", "variable_list",
  "variable_array_section_list", "varid_or_array_section",
  "funcname_variable_array_section_list", "funcvarid_or_array_section",
  "array_section_slice_list", "$@63", "$@64", "array_section_slice",
  "procbind_clause", "procbind_policy", "ompix_directive",
  "ox_tasksync_directive", "ox_taskschedule_directive", "$@65",
  "ox_taskschedule_clause_optseq", "ox_taskschedule_clause",
  "ox_scope_spec", "ompix_construct", "ox_taskdef_construct", "$@66",
  "ox_taskdef_directive", "$@67", "ox_taskdef_clause_optseq",
  "ox_taskdef_clause", "ox_variable_size_list", "ox_variable_size_elem",
  "ox_task_construct", "ox_task_directive", "ox_task_clause_optseq",
  "ox_task_clause", "ox_procextern_construct", "ox_procextern_directive",
  "$@68", "$@69", "extern_variable_list", "ox_tag_construct",
  "ox_tag_directive", "ox_tag_clause", "$@70", "tag_clause", "$@71", YY_NULLPTR
};

static const char *
yysymbol_name (yysymbol_kind_t yysymbol)
{
  return yytname[yysymbol];
}
#endif

#ifdef YYPRINT
/* YYTOKNUM[NUM] -- (External) token number corresponding to the
   (internal) symbol number NUM (which must be that of a token).  */
static const yytype_int16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,    40,    41,    91,
      93,    46,   123,   125,    44,    38,    42,    43,    45,   126,
      33,    47,    37,    60,    62,    94,   124,    63,    58,    61,
      59,    10
};
#endif

#define YYPACT_NINF (-1555)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-1114)

#define yytable_value_is_error(Yyn) \
  0

  /* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
     STATE-NUM.  */
static const yytype_int16 yypact[] =
{
    3656,  2612,  2078,  3710, -1555, -1555,  -130, -1555, -1555, -1555,
   -1555, -1555, -1555, -1555, -1555, -1555, -1555, -1555, -1555, -1555,
   -1555, -1555, -1555, -1555, -1555, -1555, -1555, -1555, -1555, -1555,
      68, -1555, -1555,   889,   546,   167,   441,   157, -1555,   179,
      32,  6343,  6343, -1555,    68, -1555,  6343,  6343,    68,   324,
      90, -1555,  3710, -1555, -1555, -1555, -1555, -1555, -1555,  3918,
   -1555, -1555,  3970, -1555, -1555, -1555, -1555, -1555,  4074, -1555,
   -1555, -1555, -1555, -1555,  3402,  3402,  3431,   -14,   245,   267,
     303,  2855, -1555, -1555, -1555, -1555, -1555, -1555,   183, -1555,
     559,   830,  2612, -1555,   555,   361,   706,   152,   813,    -9,
     309,   333,   606,    54, -1555, -1555,   427,   438,  2612,   443,
     442,   474,   498,  2266,   545,   770,   539,   557,  1593,    81,
   -1555,  5619,   491,   561, -1555,    23, -1555,   179, -1555, -1555,
   -1555,  2078, -1555, -1555, -1555, -1555, -1555, -1555, -1555, -1555,
   -1555, -1555,  2266, -1555,   777, -1555,   639, -1555,  2266, -1555,
     777, -1555,   777, -1555,   777, -1555,  2266, -1555, -1555, -1555,
   -1555, -1555, -1555, -1555,  2266, -1555,   777, -1555,   777, -1555,
     777, -1555,  2266, -1555,  2266, -1555,  2266, -1555,   777, -1555,
     777, -1555,   777, -1555,   777, -1555,   777, -1555,   777, -1555,
     777, -1555,   777, -1555,   777, -1555,  2266, -1555,   777, -1555,
     639, -1555,  2266, -1555,  2266, -1555, -1555, -1555,  2266, -1555,
   -1555,  2266, -1555,  2266, -1555, -1555,  2266, -1555, -1555, -1555,
   -1555, -1555, -1555, -1555, -1555, -1555,   941, -1555, -1555,    57,
    3710,  2855,   100,    68, -1555, -1555,    36,   476,   430, -1555,
   -1555,   741, -1555, -1555,   441, -1555, -1555,   288, -1555,   744,
     760,   390,   794,  6240, -1555, -1555,   165, -1555, -1555,    68,
    4281,  2907,   324, -1555,   909,   167, -1555, -1555, -1555, -1555,
   -1555, -1555,  4022,   167, -1555,   797,  2855, -1555, -1555,  2855,
   -1555,  6394,  2612,  6394,  6394,    34,  6394,   662,  6394,   817,
   -1555,   886, -1555, -1555,  2612,  2612,   907, -1555, -1555, -1555,
   -1555, -1555, -1555, -1555, -1555, -1555, -1555, -1555,  2612, -1555,
   -1555,  2612,  2612,  2612,  2612,  2612,  2612,  2612,  2612,  2612,
    2612,  2612,  2612,  2612,  2612,  2612,  2612,  2612,  2612,  2612,
    2612,    68, -1555,   816,  2338,  2612,  2612,  2612,  5864,   319,
     997,  2193,   833, -1555, -1555, -1555,   307, -1555, -1555,   853,
    1076, -1555,    81, -1555,    53, -1555,   950, -1555,   851,   -40,
     865, -1555,   934,  1015, -1555,   884,   899, -1555,    61, -1555,
    1028,  1033,    50, -1555,    84,    84,   963,   963,  1005,  1410,
   -1555,   904, -1555,   933,   923, -1555,  2078, -1555,   848, -1555,
   -1555, -1555, -1555,  2413, -1555, -1555, -1555, -1555, -1555, -1555,
    2266, -1555, -1555, -1555, -1555, -1555, -1555, -1555, -1555, -1555,
   -1555, -1555, -1555, -1555, -1555, -1555, -1555, -1555, -1555, -1555,
   -1555, -1555, -1555, -1555, -1555, -1555,   974, -1555, -1555,   985,
     999,   993,  1233,  1023, -1555,  1038,  1085, -1555, -1555, -1555,
    1236, -1555,   508, -1555, -1555,  1119,  1119,  1119,  1124,  1119,
     343, -1555, -1555, -1555, -1555, -1555, -1555, -1555,  1152, -1555,
   -1555, -1555,   167, -1555,   794,  6240, -1555,  1179,    68,   417,
   -1555, -1555,  4228,  1051,  1061,  1109, -1555, -1555,   164,  1135,
    1193, -1555,   418,  2951, -1555,  1183,  1222,  2936,  1389,   975,
   -1555, -1555, -1555,  1286,  1305,  1308,  1316,  1315,  1320,  1322,
   -1555, -1555,  4125,  3052,   591, -1555,   675, -1555,  2518, -1555,
   -1555,   594, -1555,   506, -1555, -1555, -1555, -1555, -1555, -1555,
     555,   555,   361,   361,   706,   706,   706,   706,   152,   152,
     813,    -9,   309,   333,   606,   259, -1555,  2266,  2338,  5939,
   -1555, -1555, -1555,   642,   721,   746,  1348,  1662,   356,  1705,
   -1555, -1555,  1076,    75, -1555, -1555, -1555,  1453,  1960,   859,
    1368,   334,   -35, -1555,   478, -1555,  1594, -1555,   -23, -1555,
    4976,  1119,  1119,  1119,  1119,  1119,  1375, -1555,  1363, -1555,
   -1555, -1555, -1555, -1555,  1276, -1555,  1412,  1208, -1555, -1555,
    3745,  1508,  1471,  4591,   920,  1393,  1396, -1555, -1555, -1555,
    1399, -1555, -1555,   838, -1555, -1555, -1555, -1555, -1555, -1555,
      70,  1026,  1520, -1555,   595,   283, -1555, -1555, -1555, -1555,
     346,  1381,  1407, -1555, -1555, -1555,   968, -1555, -1555, -1555,
   -1555, -1555, -1555,  1010, -1555, -1555, -1555, -1555, -1555,  1384,
    1415,  1417,  1418,   676, -1555, -1555, -1555, -1555,   677, -1555,
   -1555,  1076, -1555,  1953,    68,  4482, -1555,     1,  2266, -1555,
    2612, -1555, -1555,  1233, -1555,    68,   711, -1555,  1233,  1631,
     603,   862,  1427,  1429,  1430,   749, -1555,   326, -1555, -1555,
    5871, -1555, -1555, -1555,  5871, -1555,   430, -1555, -1555,   809,
    1652, -1555, -1555,  4228,  3108,  1076,    68, -1555, -1555, -1555,
   -1555,  6394, -1555,  3762, -1555,   172, -1555, -1555,  6291, -1555,
    1654,  1431,  2951, -1555, -1555,  2612, -1555,  1432,  1437,  1424,
     794,  1444,  1444, -1555,  6394,  1663,  6394, -1555,  1451,  1452,
   -1555,  1454,  1455,   675,  4332,  3153,  3008, -1555, -1555,  2612,
   -1555,  2612, -1555, -1555,  2266,  2266,  2266,  2612,  3252,   395,
    1806,  3287,   440,    64, -1555,    62,  1702, -1555,  4890, -1555,
   -1555, -1555, -1555,  1460,  1461, -1555, -1555,  1462,  3768, -1555,
   -1555, -1555, -1555, -1555, -1555, -1555, -1555, -1555, -1555, -1555,
   -1555, -1555,   922, -1555, -1555, -1555, -1555, -1555, -1555, -1555,
    5779,  1119,  1119,    -6, -1555, -1555,  1463,  1532, -1555, -1555,
   -1555,  1060, -1555, -1555, -1555, -1555, -1555, -1555,  1464, -1555,
   -1555,  1440,  1119,  1119,  1119,  1119,  1119,  1119,  1468,  5398,
   -1555, -1555, -1555, -1555, -1555, -1555, -1555, -1555, -1555, -1555,
    1690, -1555, -1555,  1447,  4581,  1472,  1473, -1555,  1475,  1246,
   -1555, -1555, -1555, -1555, -1555, -1555, -1555, -1555, -1555, -1555,
   -1555, -1555,  1119, -1555,  1119, -1555,  1476,  2350, -1555, -1555,
   -1555, -1555, -1555, -1555, -1555, -1555, -1555, -1555, -1555, -1555,
    1478,  1150, -1555, -1555, -1555, -1555, -1555, -1555, -1555, -1555,
   -1555, -1555, -1555, -1555,  4553,   107,  2460, -1555, -1555,  1479,
    1423, -1555, -1555, -1555, -1555, -1555, -1555, -1555, -1555, -1555,
   -1555, -1555, -1555, -1555, -1555,   450, -1555, -1555, -1555, -1555,
   -1555, -1555,  5871,  5871,  1480,  1481,  1481,  5444,  1028, -1555,
   -1555,  1605, -1555,  2061, -1555,  1311, -1555, -1555, -1555, -1555,
   -1555, -1555, -1555, -1555, -1555,  1590,  2161,  1491,   636, -1555,
   -1555, -1555, -1555, -1555, -1555, -1555,  1492,  1543, -1555, -1555,
    1615, -1555,  1474, -1555,  5340,   963, -1555, -1555,   963, -1555,
   -1555,  1480, -1555,  5871,  5871,  5871,  1410, -1555, -1555,  1497,
   -1555,  1499,  1500, -1555,  1501, -1555,   544, -1555, -1555,   717,
     126, -1555,  1489,  1640, -1555,  2266, -1555,   783,   804,  1482,
   -1555,   105,   898, -1555,   784, -1555, -1555, -1555, -1555, -1555,
   -1555, -1555, -1555, -1555, -1555, -1555,  1493, -1555, -1555, -1555,
    1503,  1521, -1555, -1555, -1555, -1555, -1555, -1555,  1738, -1555,
    1739, -1555, -1555,  1517,  1496,  1236, -1555, -1555, -1555, -1555,
   -1555, -1555, -1555, -1555, -1555, -1555, -1555, -1555, -1555, -1555,
   -1555, -1555, -1555, -1555, -1555, -1555, -1555, -1555, -1555, -1555,
   -1555, -1555, -1555, -1555, -1555,   228,  1504,   456, -1555,  1522,
    1526,  1530,  1533,   785, -1555, -1555, -1555,   795, -1555,  3008,
   -1555, -1555,   138,  6394,  1874, -1555,   225,  6394, -1555, -1555,
   -1555, -1555,  1518,  1529, -1555, -1555, -1555,  1519,  1536,  1537,
    1539, -1555, -1555, -1555, -1555, -1555,  1540, -1555,  1531,  1544,
    2612,  1146, -1555,   982,  3108,   255, -1555, -1555, -1555,  1707,
   -1555, -1555,   828,  2266,   831,  3301,  3330,   445,  2266,   841,
    3344,  1525,  1764,   112,   373, -1555,  1378, -1555, -1555, -1555,
   -1555, -1555, -1555, -1555, -1555, -1555, -1555,  4784,  4396, -1555,
   -1555, -1555, -1555, -1555, -1555, -1555, -1555, -1555, -1555, -1555,
    1548,  1552,  1552,  1552,  5871,  2580,  1552,  1480,  5871, -1555,
    1552, -1555,   330,   355,  1619, -1555, -1555, -1555,  5779, -1555,
    1552, -1555, -1555,  1480, -1555, -1555, -1555, -1555, -1555, -1555,
   -1555,  5871, -1555, -1555, -1555,   856, -1555,  2084, -1555, -1555,
   -1555, -1555,  1554,  5527,  1480,  1076, -1555, -1555,  1480, -1555,
    1480,  2687, -1555,  1555,  1556, -1555, -1555,  4447,  6043, -1555,
   -1555, -1555, -1555, -1555, -1555, -1555, -1555, -1555, -1555, -1555,
   -1555, -1555,  1677, -1555,  4606,  6097, -1555, -1555, -1555, -1555,
   -1555, -1555, -1555,  1480,  1552,  5871, -1555,  1552, -1555,  1538,
    1541,  2612,  3445, -1555,  1779, -1555, -1555, -1555, -1555, -1555,
    1553,  1557, -1555,  1667,  4922,  1747, -1555, -1555, -1555, -1555,
   -1555, -1555, -1555,  1561, -1555, -1555,  4857,  1509, -1555, -1555,
   -1555, -1555, -1555,  5871, -1555,  2687, -1555,  1542, -1555, -1555,
   -1555, -1555, -1555, -1555, -1555, -1555, -1555,  1788,  1562, -1555,
   -1555, -1555, -1555, -1555,  1067,  1076,  1195, -1555,  2612,  2612,
    3035,  2612, -1555, -1555,  1568,  1571,  1581, -1555,   360, -1555,
   -1555, -1555,  1577, -1555, -1555,  1563, -1555,   110,  2612, -1555,
   -1555, -1555,   125, -1555,  1813,  6212,  1595,  2612, -1555,  -103,
     911,   -74,   954, -1555,  1344, -1555, -1555, -1555, -1555,  1598,
   -1555, -1555, -1555, -1555, -1555,  1599,   603,  1815,  1815,  1815,
   -1555, -1555,  1817,  1070, -1555,  3854, -1555, -1555,  2612, -1555,
   -1555,   455, -1555,   408,  4176, -1555, -1555, -1555, -1555, -1555,
   -1555, -1555, -1555, -1555,  1606, -1555, -1555, -1555,  2965, -1555,
   -1555, -1555,  2266,  1585, -1555,  2266,  2266,   958,  2266,   959,
    3373, -1555,  2266,  2266,   961,    67,  1610,  3402, -1555,    62,
      67, -1555,  5240, -1555, -1555, -1555, -1555, -1555,  1690,  1842,
   -1555, -1555, -1555,   762, -1555, -1555, -1555, -1555,  1617, -1555,
   -1555, -1555,   421, -1555,  5871,  1843,  1691,  1624,  1620, -1555,
   -1555,    -8, -1555,  1849, -1555,  3488, -1555,  1622, -1555, -1555,
   -1555,   715,   416, -1555,   150, -1555, -1555,  1623,  1626,  1690,
    1690,  2612,  5118, -1555, -1555, -1555, -1555, -1555, -1555, -1555,
    1733,  4500,  6074, -1555, -1555, -1555, -1555, -1555, -1555, -1555,
   -1555, -1555, -1555,  1719, -1555,  1634, -1555,   971,  1616,   978,
     273,   983,   834,  5871,  1621, -1555,  4829,  5546, -1555, -1555,
   -1555, -1555, -1555, -1555, -1555, -1555,  2612, -1555,  4746,  5304,
   -1555, -1555, -1555, -1555, -1555,  1783,  1629,  1636, -1555,  1430,
     990,  5340,  1625, -1555, -1555,  1646,   185, -1555, -1555,  1647,
     992,   995,  1648,  1655,  1657,  1658,  1659,  2612,  2612,  1245,
   -1555,  2612, -1555, -1555, -1555, -1555,  1637, -1555, -1555,   507,
    1690,  1002,  1236, -1555,  1788,  1517, -1555,  1788,  2612,   633,
    1638,  1344, -1555, -1555,  1632,  1653,  1004, -1555,  1009,  1029,
    1639, -1555, -1555,  2980, -1555,    68, -1555,   287, -1555,  2612,
   -1555, -1555, -1555, -1555,  3108, -1555, -1555, -1555, -1555,  2266,
   -1555,  2266,  2266,  1056, -1555, -1555,  2266,  1885,   115,   661,
   -1555,  1076,  1664, -1555,   564, -1555,  1065,  1656,  1068,  1668,
    1675,  1680,  2580,  1661, -1555, -1555, -1555, -1555, -1555,  1682,
    1685,  1185,  1683,  1671,  1686,  1674, -1555, -1555, -1555,  1709,
   -1555,  1687,  1089, -1555, -1555, -1555, -1555, -1555, -1555, -1555,
    1710,  5687, -1555, -1555,  1712,   603,  5871,  1699,   716,   716,
    1097, -1555, -1555,  4368,  5990, -1555, -1555, -1555, -1555, -1555,
   -1555, -1555,  1701, -1555,  2612, -1555,  2612, -1555,  1788, -1555,
   -1555, -1555,  1788,  4691,  5277, -1555, -1555, -1555, -1555, -1555,
   -1555,   587,  5203, -1555, -1555, -1555, -1555, -1555,  1711,   603,
    5871,  1703, -1555, -1555,  1788, -1555, -1555, -1555, -1555, -1555,
   -1555, -1555, -1555, -1555, -1555,  1722,  1724, -1555,  1729,  1728,
    1104, -1555,  6212, -1555,  1106, -1555,  1114,  1126, -1555,   427,
    2612, -1555,  1736,  1815,  2345, -1555,  1815, -1555, -1555, -1555,
   -1555,    68, -1555, -1555, -1555,    68, -1555, -1555, -1555, -1555,
    2266, -1555,  1737,  2612,    67,  1076,   191, -1555, -1555,  1076,
   -1555,  1690, -1555, -1555, -1555, -1555, -1555,  1788, -1555,  1843,
    2612,  2612, -1555,  1843,  1843, -1555, -1555,  3388, -1555,  2612,
   -1555,  1734,  1721,  2612, -1555, -1555,  1788,  2612,  1742,  1743,
   -1555,  4315,  5046, -1555, -1555, -1555, -1555, -1555, -1555, -1555,
    1797,  1136,  1137,  1138,  1725,  1726,  1140,  5149, -1555, -1555,
   -1555, -1555, -1555, -1555, -1555,  2612,  2612, -1555, -1555,  1741,
   -1555, -1555,  1788,  1149, -1555, -1555,  1251, -1555, -1555, -1555,
    2612, -1555, -1555, -1555,   427, -1555,  1153,  1970,  1748, -1555,
   -1555, -1555, -1555,  1076,  1162, -1555,   183,   718,  3402,  1167,
    1192,  1197,  1749,   555,   555, -1555,  1751, -1555,  1204,  1207,
    2612, -1555,  1209,  1732,  1763,  1212,   427, -1555, -1555,  4974,
   -1555, -1555, -1555, -1555, -1555, -1555, -1555,  1753, -1555, -1555,
   -1555,  1788,  1788, -1555, -1555,  1767,  1754,  2612,  1784,  1786,
    1221, -1555, -1555, -1555,  1271, -1555,  1801, -1555,   197, -1555,
    1076,  2029,  1808, -1555, -1555, -1555, -1555, -1555, -1555, -1555,
    1274, -1555,  1788,  1788, -1555, -1555, -1555,  1278,  1285,  2612,
   -1555,  1288,  1788,  1788, -1555, -1555, -1555,  2612,   183, -1555,
    1289, -1555, -1555,  1304,  1309, -1555, -1555,  1809, -1555,  1317,
    1318,  1882,  1329, -1555,  2033, -1555, -1555, -1555, -1555, -1555,
    1820,  1789, -1555, -1555,  2043, -1555,   -19,  2612,  2612,  1362,
    1822,  1823, -1555, -1555
};

  /* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
     Performed when YYTABLE does not specify something else to do.  Zero
     means the default is an error.  */
static const yytype_int16 yydefact[] =
{
       0,     0,     0,     0,   185,   230,     0,   117,   118,   119,
     120,   121,   179,   123,   124,   125,   126,   129,   130,   127,
     128,   178,   180,   122,   182,   131,   132,   133,   151,   152,
     338,   342,   299,     0,     0,     0,   199,     0,   296,     0,
     308,    98,   100,   134,   338,   135,   102,   104,   111,   183,
       0,   136,     2,   293,   295,   300,   301,   181,    94,     0,
     546,    95,     0,   672,    97,    93,    96,   297,     0,   298,
    1145,     9,    10,     7,     0,     0,     0,     0,     0,     0,
       0,     0,    37,    38,    39,    40,    41,    42,    11,    13,
      27,    43,     0,    45,    49,    52,    55,    60,    63,    65,
      67,    69,    71,    73,    75,    88,     3,     9,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     253,     0,     0,   260,   268,     0,   264,     0,   265,   244,
     245,     4,   262,   246,   247,   248,   275,   249,   250,   251,
     266,   348,     0,   349,     0,   350,     0,   351,     0,   359,
       0,   360,     0,   361,     0,   362,     0,   363,   602,   389,
     390,   388,   391,   364,     0,   365,     0,   366,     0,   367,
       0,   368,     0,   369,     0,   370,     0,   372,     0,   373,
       0,   374,     0,   375,     0,   376,     0,   377,     0,   378,
       0,   379,     0,   371,     0,   358,     0,   352,     0,   353,
       0,   354,     0,   355,     0,   382,   384,   380,     0,   385,
     356,     0,   381,     0,   383,   357,     0,   990,   386,   387,
     267,  1092,  1093,   252,  1109,  1110,     0,  1111,  1112,     0,
       5,     0,     0,   339,   340,  1018,     0,     0,     0,  1116,
    1146,     0,   203,   201,   200,     1,    91,     0,   106,   306,
     108,   111,     0,     0,    99,   101,     0,   103,   105,   112,
       0,     0,   184,   294,     0,     0,   345,   545,   547,   344,
     343,   346,     0,     0,   304,  1115,     0,    28,    29,     0,
      31,     0,     0,     0,     0,     0,   157,   214,   159,     0,
       8,     0,    20,    21,    24,     0,     0,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    77,     0,    43,
      30,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   338,    90,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   289,   290,   291,     0,   321,   322,     0,
       0,   312,     0,   319,   395,   495,   994,   510,     0,     0,
       0,   936,     0,   458,   852,     0,     0,   521,   605,   573,
       0,   690,   709,   924,     0,     0,     0,     0,   961,     0,
    1132,     0,  1095,     0,     0,   259,     0,   269,   113,   263,
     392,   393,   456,     0,   493,   508,   519,   557,   564,   571,
       0,   688,   707,   720,   728,   735,   742,   752,   768,   778,
     788,   798,   807,   815,   824,   832,   841,   850,   884,   898,
     911,   913,   922,   934,   959,   989,     0,  1151,  1152,     0,
       0,   172,     0,   173,   341,     0,     0,   549,   680,   682,
       0,   673,     0,   677,   972,   444,   444,   444,     0,   444,
       0,   964,   967,   968,   969,   971,   970,  1118,     0,   186,
     204,   202,     0,    92,     0,     0,   109,     0,   115,   112,
     305,   310,     0,   149,   139,   150,   212,   197,   210,     0,
     205,   207,     0,     0,   187,    38,     0,     0,     0,     0,
     347,   671,   302,     0,     0,     0,     0,     0,     0,     0,
      12,   158,     0,     0,   216,   215,   217,   160,     0,    17,
      19,     0,    25,     0,    16,    18,    76,    46,    47,    48,
      50,    51,    53,    54,    58,    59,    56,    57,    61,    62,
      64,    66,    68,    70,    72,     0,    89,     0,     0,     0,
     254,   258,   255,     0,     0,     0,     0,     0,     0,     0,
     288,   292,     0,     0,   313,   320,   900,   886,     0,     0,
       0,     0,     0,   999,     0,   912,     0,   914,     0,   920,
       0,   444,   444,   444,   444,   444,   987,   982,     0,   949,
     950,   951,   952,   953,     0,   559,     0,     0,   921,   933,
       0,   754,   744,     0,     0,   467,     0,   580,   667,   669,
       0,   645,   642,     0,   638,   641,   665,   666,   644,   643,
     770,     0,     0,   722,     0,     0,  1013,  1014,  1015,  1016,
       0,     0,     0,   627,   624,   623,     0,   620,   626,   625,
     636,   633,   632,     0,   629,   635,   634,   660,   962,     0,
       0,     0,     0,     0,   647,   650,   651,   652,     0,  1094,
    1097,     0,  1153,     0,   114,     0,   504,     0,     0,   603,
      24,   137,   138,     0,     6,   338,     0,   174,     0,     0,
       0,     0,     0,     0,  1075,     0,  1073,     0,   676,   678,
       0,   973,   974,   975,   442,   976,     0,   963,   965,     0,
       0,   107,   303,     0,     0,     0,   116,   311,   309,   143,
     142,     0,   146,     0,   209,   216,   211,   196,     0,   198,
       0,     0,     0,   194,   189,     0,   188,    38,     0,     0,
       0,     0,    32,    33,     0,     0,     0,   226,     0,     0,
     220,    38,     0,   218,     0,     0,     0,    44,    15,     0,
      14,     0,   256,   257,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   314,   323,     0,   566,     0,   454,
    1045,  1047,  1051,     0,     0,   449,   447,     0,     0,   394,
     396,   451,   452,   398,   400,   401,   402,   403,   404,   399,
     453,  1049,     0,   494,   502,   496,   498,   499,   500,   501,
     442,   444,   444,     0,   991,   995,     0,     0,   993,  1000,
     517,     0,   509,   516,   511,   513,   514,   515,     0,   918,
     915,     0,   444,   444,   444,   444,   444,   444,     0,     0,
     935,   948,   937,   939,   954,   957,   955,   956,   958,   986,
       0,   983,   984,     0,     0,   473,     0,  1065,     0,     0,
     457,   459,   466,   461,   469,   470,   462,   463,   464,   465,
     471,   472,   444,   863,   444,   867,     0,     0,   851,   853,
     855,   861,   862,   857,   858,   859,   860,   856,   539,   541,
       0,     0,   520,   522,   524,   530,   531,   532,   526,   527,
     528,   525,   529,   843,     0,   790,     0,   700,   600,     0,
       0,   604,   611,   615,   616,   617,   618,   606,   608,   614,
     610,   612,   613,   609,   597,     0,   572,   574,   576,   577,
     579,   578,     0,  1061,     0,     0,     0,     0,     0,   637,
     639,     0,   780,     0,   705,     0,   689,   691,   699,   693,
     694,   695,   696,   697,   698,   730,     0,     0,     0,   708,
     710,   716,   712,   713,   714,   715,     0,     0,   923,   925,
       0,  1010,     0,  1017,   582,     0,   619,   621,     0,   628,
     630,     0,   960,   442,   442,   442,     0,   646,   648,     0,
    1141,     0,     0,  1142,     0,  1140,     0,  1131,  1133,     0,
    1155,   261,     0,     0,   503,     0,   505,     0,     0,   176,
     166,     0,     0,  1021,     0,  1026,  1033,  1034,  1035,  1036,
    1030,  1028,  1027,  1029,  1031,  1032,     0,   535,   536,   537,
       0,     0,   548,   556,   555,   553,   554,   550,     0,   681,
       0,   683,  1079,  1076,     0,     0,   679,   423,   414,   416,
     420,   417,   418,   421,   419,   422,   415,   424,   425,   426,
     427,   429,   430,   431,   436,   428,   435,   433,   434,   432,
     437,   438,   439,   440,   441,     0,     0,     0,   966,     0,
       0,     0,     0,     0,  1117,  1119,  1149,     0,   307,     0,
     231,   110,     0,     0,     0,   153,     0,     0,   206,   208,
     213,   191,     0,     0,   195,   190,   674,     0,     0,     0,
       0,   228,   219,   224,   222,   227,     0,   221,    38,     0,
       0,     0,   234,     0,     0,     0,   239,    26,    74,   270,
     272,   273,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   324,     0,   899,   903,   901,
     905,   906,   907,   908,   909,   910,   904,     0,     0,   885,
     889,   890,   887,   892,   893,   894,   895,   896,   897,   891,
       0,     0,     0,     0,   442,     0,     0,     0,   442,   397,
       0,   497,     0,     0,     0,   998,   997,   996,     0,  1001,
       0,   512,   917,     0,   916,   941,   942,   944,   943,   945,
     946,   442,   938,   940,  1067,     0,   985,     0,   558,   562,
     563,   560,     0,   487,     0,     0,   460,   865,     0,   866,
       0,     0,   854,     0,     0,   533,   523,     0,     0,   753,
     757,   766,   758,   767,   755,   765,   760,   761,   762,   763,
     764,   759,     0,   800,     0,     0,   743,   751,   748,   747,
     745,   750,   749,     0,     0,   442,   607,     0,   575,     0,
       0,     0,     0,   581,     0,   668,   670,   875,   876,   877,
       0,   869,   640,   809,     0,     0,   769,   777,   773,   776,
     771,   774,   775,     0,   692,   737,     0,     0,   721,   726,
     725,   723,   727,   442,   711,     0,   926,     0,  1011,   591,
     592,   593,   594,   595,   596,   588,   590,     0,   584,   586,
     589,   622,   631,   661,     0,     0,     0,   649,     0,     0,
       0,     0,  1134,  1104,     0,     0,     0,  1103,     0,  1096,
    1098,  1154,     0,   507,   506,     0,   167,     0,     0,   169,
     175,   168,     0,  1019,     0,     0,     0,     0,   551,  1075,
       0,  1071,     0,  1069,     0,  1077,   675,  1074,   445,     0,
     443,   980,   977,   978,   979,     0,     0,     0,     0,     0,
    1120,  1147,     0,     0,   337,     0,   140,   154,     0,   156,
     163,     0,   161,   113,     0,   192,   193,  1114,    34,    35,
      36,   229,   225,   223,     0,   242,   243,    22,     0,   235,
     238,   240,     0,     0,   276,     0,     0,     0,     0,     0,
       0,   284,     0,     0,     0,   328,     0,     0,   315,     0,
     328,   902,     0,   565,   570,   567,   569,   888,     0,     0,
    1046,  1048,  1052,     0,  1059,  1060,  1058,  1057,  1053,  1055,
     450,   448,     0,  1050,     0,     0,     0,     0,     0,   518,
     919,     0,   988,     0,   561,     0,   475,     0,   490,   491,
     492,     0,     0,  1066,  1158,   864,   868,     0,   878,     0,
       0,     0,     0,   842,   849,   846,   844,   848,   847,   756,
     817,     0,     0,   789,   797,   794,   793,   791,   796,   795,
     746,   701,   601,     0,   598,     0,  1063,     0,     9,     0,
    1071,     0,     0,     0,     0,   826,     0,     0,   779,   787,
     783,   786,   781,   784,   785,   772,     0,   706,     0,     0,
     729,   733,   731,   734,   724,     0,     0,   927,  1012,  1071,
       0,     0,     0,   657,   658,     0,     0,   654,   655,     0,
       0,     0,     0,     0,    38,     0,     0,     0,     0,     0,
    1099,     0,  1130,   170,   177,   171,     0,  1022,  1037,     0,
       0,     0,     0,   684,     0,  1072,   686,     0,  1085,  1083,
       0,     0,   446,   981,     0,  1127,     0,  1125,     0,     0,
       0,  1150,   232,     0,   144,   338,   165,     0,   155,     0,
     147,   241,    23,   236,     0,   271,   274,   279,   278,     0,
     277,     0,     0,     0,   286,   285,     0,     0,     0,     0,
     329,     0,     0,   325,     0,   568,     0,  1067,     0,     0,
       0,     0,     0,     0,  1091,  1088,  1089,  1090,  1087,     0,
       0,  1007,     0,  1005,     0,     0,   662,   663,   664,     0,
    1068,     9,     0,   479,   486,   481,   482,   483,   484,   485,
     477,     0,   488,  1157,     0,     0,     0,     0,   543,   543,
       0,   845,   834,     0,     0,   799,   806,   804,   803,   801,
     805,   792,     0,   468,     0,  1062,     0,   405,     0,   412,
     871,   873,     0,     0,     0,   808,   814,   812,   813,   810,
     782,     0,     0,   736,   741,   740,   738,   732,   718,     0,
       0,     0,   583,   587,     0,   656,   659,   653,  1144,  1143,
    1137,  1138,  1135,  1136,  1139,     0,     0,  1105,  1106,     0,
       0,  1020,     0,  1023,     0,   552,     0,     0,  1070,  1084,
    1082,  1080,     0,     0,     0,  1121,     0,  1122,  1123,  1148,
     233,   338,   141,   162,   164,   338,   237,   282,   281,   280,
       0,   287,     0,     0,     0,     0,     0,   327,   316,     0,
     455,     0,   410,  1044,  1042,  1043,  1056,     0,  1086,     0,
       0,     0,  1002,     0,     0,   992,   947,     0,   407,     0,
     476,     0,     0,     0,   880,   882,     0,     0,     0,     0,
     534,     0,     0,   816,   823,   820,   821,   818,   822,   802,
       0,     0,     0,     0,     0,     0,     0,     0,   825,   831,
     829,   830,   827,   811,   702,     0,     0,   739,   717,     0,
     929,   931,     0,     0,  1100,  1101,     0,  1102,  1156,  1038,
       0,   538,   685,   687,  1081,  1078,     0,     0,     0,  1126,
     145,   148,   283,     0,     0,   330,   333,     0,     0,     0,
       0,     0,     0,  1008,  1009,  1006,     0,   408,     0,     0,
       0,   489,     0,     0,     0,     0,   544,   540,   542,     0,
     833,   839,   837,   838,   835,   840,   819,     0,  1064,   406,
     413,     0,     0,   870,   828,     0,     0,     0,     0,     0,
       0,   585,  1108,  1107,     0,  1124,     0,  1129,     0,   332,
       0,     0,     0,   317,   411,  1054,  1004,  1003,   409,   480,
       0,  1159,     0,     0,   879,   836,   599,     0,     0,     0,
     703,     0,     0,     0,   928,  1024,  1128,     0,   334,   335,
       0,   326,   478,     0,     0,   872,   874,     0,   719,     0,
       0,  1039,     0,   318,     0,   881,   883,   704,   930,   932,
       0,     0,   331,   336,     0,  1025,     0,    24,     0,     0,
       0,     0,  1040,  1041
};

  /* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
   -1555, -1555, -1555,  -332, -1555, -1555,  -650,   -73, -1555,    59,
    -306,  1257,   679,  1263,  1730,  1727,  1740,  1735,  1731, -1555,
    -104,  -227, -1555,    -1, -1053,    46,   764, -1555,  1591, -1555,
      15, -1047, -1555,   -69, -1555, -1555, -1555, -1555, -1555, -1555,
   -1555, -1555,  -312, -1008,  -260, -1555,   488, -1555,   198,  -933,
      69, -1555,   -28,   -34,   -15,  -163,  -229, -1555,  1359, -1555,
    -161,  -212,  -268,  -219,  -656,  1000, -1276, -1555,   965,    12,
    1534, -1555,  -183, -1555,  1688,  -106, -1555, -1555, -1555,  6308,
   -1555,  2068,   219,   159,  2005, -1555, -1555, -1555, -1555, -1555,
    1611, -1555,  1723, -1555,  1744, -1555,   678,   680,   347,   344,
   -1555, -1555,   -39,   -26,   -24,  1816, -1555, -1555,  1862,  -252,
     -20, -1555, -1555, -1555,  1324,  -702, -1555,   406,  1177,  -321,
    -680,   459, -1555, -1555, -1555, -1555,  -498, -1555, -1555, -1555,
   -1555,  -524,  -282,  -544, -1555, -1555, -1555, -1555, -1555, -1555,
   -1555,   463, -1555, -1555, -1555,  1313,  1897, -1555,  1441, -1555,
   -1555, -1555,  1298, -1555, -1555, -1555, -1555, -1555,  1229,  -567,
   -1555, -1555, -1555, -1555, -1555,  -635, -1555,  -628, -1555,   462,
   -1555, -1555,  2044, -1555,  1091, -1555, -1555, -1555,   918, -1555,
   -1555, -1555, -1078, -1555, -1555, -1555,  1201,  -187, -1555,  -175,
   -1555, -1555, -1555,   597, -1555, -1555, -1555, -1555, -1555, -1555,
   -1555, -1555, -1555, -1555,  1266,  -799, -1555, -1555,  -587, -1555,
   -1555,  -577, -1555, -1555,  -558, -1555, -1555,  -592, -1555, -1555,
   -1555, -1555, -1555, -1555, -1555, -1555, -1555, -1555, -1555, -1555,
   -1555, -1555, -1555, -1555, -1555, -1555,  -379, -1555, -1555, -1555,
   -1555, -1555, -1555, -1555,  -550,  -480, -1555, -1555,   -33, -1555,
   -1555, -1555, -1555,  -597,  -839, -1555, -1555, -1555, -1555,  -879,
   -1555, -1555, -1555, -1220, -1555, -1555, -1555, -1398, -1555, -1555,
   -1555,   937, -1555, -1555, -1555,   928, -1555, -1555, -1555,  -890,
   -1555, -1555, -1555, -1190, -1555, -1555, -1555,   701, -1555, -1555,
   -1555,   524, -1555, -1555, -1555, -1262, -1555, -1555, -1555,   397,
   -1555, -1555, -1555, -1554, -1555, -1555, -1555,   321, -1555, -1555,
   -1555,   719, -1555, -1555, -1555,  1319, -1555, -1555, -1555,  -324,
   -1555, -1555, -1555,   690, -1555, -1555, -1555, -1555, -1555, -1555,
   -1555,  -726, -1555, -1555, -1555,  1048, -1555, -1555, -1555, -1555,
   -1555,  1607, -1555, -1555, -1555, -1555, -1555, -1555,  1230, -1555,
   -1555, -1555, -1555, -1555, -1555, -1555,  1360,  -505, -1555, -1555,
   -1555, -1555, -1555, -1555, -1555, -1555, -1555, -1555,  -357, -1555,
   -1555, -1555, -1555, -1555, -1555, -1555, -1555, -1555, -1555, -1555,
   -1555, -1555,  1385, -1555,  -470,  -269, -1555, -1555,  1831, -1555,
   -1555, -1555, -1555, -1555, -1555, -1555, -1555,  -640, -1555, -1555,
    -389,   617, -1555,   310, -1555,  -253, -1555,  -446, -1555,   496,
   -1555, -1555,   582,  -173, -1555, -1555,  -546, -1555, -1359,  -274,
     648, -1003,  1172,  -647, -1555, -1555,   647, -1555, -1555, -1555,
   -1555, -1555, -1555, -1555,   902, -1555,  1983,    86, -1555, -1555,
   -1555, -1555,  1154, -1308,   499, -1555, -1555, -1555,  1242,   101,
   -1555, -1555, -1555, -1555, -1555, -1555, -1555, -1555, -1555, -1555
};

  /* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,    37,   665,    88,    89,    90,   511,    91,    92,    93,
      94,    95,    96,    97,    98,    99,   100,   101,   102,   103,
     104,   105,   308,   125,   333,    38,   127,   247,   248,   694,
      40,   250,    41,    42,    43,   701,  1565,  1073,  1721,  1077,
    1725,    44,  1074,  1075,   287,  1361,  1362,    45,   666,   667,
      46,    47,    48,    49,    50,   244,   728,   480,   481,   482,
     289,   729,   506,    51,  1102,  1103,  1104,  1105,  1106,   390,
     541,   129,   130,   386,   131,   132,   133,   134,   135,   136,
     137,    52,    53,    54,    55,   464,   252,    56,   465,   253,
     472,   138,   351,   352,   353,  1124,  1125,  1589,  1590,  1827,
    1910,   468,   232,   233,    57,   271,   267,   272,   139,   140,
     391,   141,   142,   558,   770,  1243,  1436,  1410,  1245,  1056,
    1057,   681,   771,  1157,   772,  1156,  1140,  1150,   143,   144,
     586,  1189,   842,  1141,   844,  1192,   845,  1761,  1759,  1630,
    1441,  1442,   145,   146,   559,   785,   394,   657,   658,   147,
     148,   564,   804,   805,  1170,   149,   150,   590,   873,  1404,
     875,  1451,  1013,  1014,  1326,   876,  1203,   877,  1204,  1768,
      58,    59,    60,   671,  1017,   151,   152,   834,  1191,   153,
     154,  1137,  1674,   155,   156,   594,   907,   893,   914,   894,
    1287,  1512,  1288,  1289,  1290,   910,  1237,   895,   896,  1234,
     157,   400,   158,   593,   897,   898,   159,   626,   627,   160,
     633,   634,   161,   603,   604,   162,   643,   644,   645,  1519,
     646,  1515,   647,   638,   961,  1619,   605,   606,   915,   607,
     916,    61,    62,   491,    63,   442,   443,   672,   673,  1019,
    1021,   163,   164,   611,  1229,   928,  1233,  1497,   929,  1263,
     165,   166,   614,  1270,   941,  1799,   167,   168,   936,  1491,
     169,   170,  1266,  1668,   171,   172,  1498,  1791,   173,   174,
     886,  1230,   175,   176,   884,  1214,   177,   178,   923,  1466,
     179,   180,  1254,  1648,   181,   182,  1224,  1467,   183,   184,
    1461,  1649,   185,   186,  1486,  1776,   187,   188,  1643,  1777,
     189,   190,  1663,  1853,   191,   192,  1771,  1854,   193,   194,
    1207,  1456,   195,   196,   587,   859,   860,  1198,  1200,   608,
    1484,  1784,  1785,  1251,   862,  1637,  1843,  1844,   197,   198,
     758,  1406,   199,   200,   756,  1129,   201,   202,   203,   204,
     568,   821,  1173,   205,   206,   207,   208,   615,   949,  1681,
    1868,  1869,   209,   210,   211,   570,   822,   578,   579,   580,
     581,   582,   583,   212,   213,   639,    64,   450,   451,   452,
     453,   454,   455,  1345,   456,   214,   584,   830,   215,   216,
     217,   561,   795,   562,   563,  1612,  1613,   218,   620,   219,
      65,   435,  1536,   994,    66,  1810,  1921,  1417,  1539,  1931,
    1143,  1144,  1151,  1145,  1152,  1146,  1160,  1147,  1153,  1148,
    1603,  1418,  1419,  1149,  1241,  1654,   850,  1194,  1185,  1332,
    1333,   675,   676,  1545,  1551,  1334,  1550,   780,  1609,   220,
     221,   222,   650,   979,  1310,  1699,   223,   224,   493,    68,
     457,   689,  1065,  1556,  1557,   225,   226,   648,   978,   227,
      70,   458,  1560,  1067,   228,   229,   384,  1312,   851,  1634
};

  /* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
     positive, shift that token.  If negative, reduce the rule whose
     number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
     106,   277,   278,   280,   332,   256,   234,   241,   520,   521,
     987,   251,   286,   433,   128,  1330,   262,   940,   553,   309,
     234,   243,   259,   874,   234,   389,   501,  1023,   507,  1360,
    1006,   479,  1142,  1260,   486,   309,  1015,   475,  1071,   957,
    1558,  1559,   843,  1016,   882,   920,  1502,  1374,   126,  1596,
    1598,   968,   628,   635,   249,   497,   960,  1271,  1320,  1405,
     773,   927,   841,   679,  1492,   823,  1357,   512,   945,   470,
     430,    73,   510,   290,   328,   505,    73,   515,   983,   833,
     285,   516,   542,   274,   290,  1212,    67,  1228,   601,    67,
    1638,  1639,   799,   688,   623,   630,     4,   231,   487,   388,
    1676,    69,  1574,   536,    69,   242,   431,     5,   269,  1792,
    1164,   664,   777,   899,   796,   494,   664,   346,   495,   791,
     496,   290,   498,   499,   290,   340,  1022,   429,   395,   612,
     347,   664,   348,   556,   338,   290,   399,   809,    67,   436,
     591,   866,    31,   128,   401,  1542,  1616,   290,   349,   921,
     288,   310,   405,    69,   406,  1022,   407,   245,   309,   290,
     557,   437,   286,   616,   617,   933,   792,   318,   319,   774,
       4,   473,     5,     4,  1544,   613,   417,   126,     4,  1617,
    1618,  1704,   420,   602,   421,     4,  1222,   566,   422,   624,
     631,   618,   290,   424,   290,   922,   425,   609,   863,   797,
     290,   625,   632,   629,   636,   592,   290,   286,  1937,   434,
     286,   567,   286,   281,   286,   286,   798,   286,   266,   286,
     753,   270,   930,   423,  1669,   469,   324,   234,   810,   461,
    1938,     4,  1223,  1864,   984,   434,   733,   619,   309,   309,
     309,   309,   309,   309,   309,   309,   309,   309,   309,   309,
     309,   309,   309,   309,   309,   309,   711,   330,  1128,  1293,
     718,   339,   500,   861,  -304,  1534,   706,  1190,   330,   900,
     773,   263,   504,   387,  1797,   285,   732,   784,   285,  1677,
     249,   692,   803,  1294,  1295,  1296,   542,  1574,   492,   698,
     843,  1122,   537,     4,   513,   843,  1587,  1670,  1026,   471,
     288,   329,   628,   754,   874,  1566,   788,   234,   350,   635,
    1134,   892,  1121,   460,  1183,  1196,    67,    35,   269,   980,
     712,   601,   777,   755,  1595,   882,  1259,  1169,   535,  1058,
     242,    69,   432,   848,   543,   544,   545,   879,  1319,  1397,
     548,  1274,  1733,  1533,   623,   288,   540,  1357,   288,   444,
     288,   630,   288,   288,  1311,   288,  1357,   288,  1535,  1055,
    1252,   944,   654,  1072,   234,  1495,  1354,  1130,  1291,  1269,
     517,   518,   519,   656,  1297,  1264,  1015,   945,  1633,   774,
     659,  1292,  1830,  1016,  1320,   779,  1210,   549,  1504,  1320,
     945,   703,   945,   503,    35,   320,   321,   474,   128,   703,
      36,   503,  1793,    36,  1213,  1816,    35,   908,  1455,  1212,
     899,   866,  1407,  1686,   867,    36,   602,   881,  1828,   909,
     903,   911,  1604,  1123,  1907,  1465,  1228,  1501,   380,   246,
     609,   270,   126,   512,   388,   309,   444,   733,  1219,   624,
     933,  1076,   696,  1257,   234,   434,   631,   952,  1379,   263,
     704,   625,    35,   629,   596,  1421,  1338,  1341,   632,   791,
     636,    36,   946,   705,    31,   467,   438,  1070,   863,  1163,
    1303,  1430,   282,  1358,  1413,  1359,  1339,  1261,  1422,   933,
      12,  1458,    31,   467,  1100,  1082,  1101,   504,  1083,    21,
      22,    31,  1443,   330,   283,  1216,  1445,   930,  1446,   439,
     784,  1431,  1022,  1133,  1380,  1096,   792,   741,  1099,  1070,
    1068,   471,  1107,  1605,    35,    31,  1724,   947,   697,   803,
    1360,  1658,   462,    36,   239,   445,   446,   447,   448,   788,
     284,  1471,   449,   861,   948,  1358,   930,  1087,   463,  1706,
    1503,   330,   240,   383,  1606,  1607,   749,   389,   752,   742,
     540,   260,   242,   261,   325,  1473,   460,   551,   596,   595,
    1215,  1448,  1231,  1088,  1424,  1090,   900,   737,   793,   291,
     292,   293,  1304,  1305,  1306,   760,   761,   686,  1425,   326,
     950,   848,  1307,  1136,   800,   794,   848,   597,   622,  1426,
     330,  1239,  1240,  1505,   687,   779,  1250,   951,   314,   315,
     380,  1398,  1211,  1340,  1227,   969,   750,  1399,   892,   995,
    1342,  1608,   445,   446,   447,   448,   438,   904,   879,   449,
    1190,  1400,   996,   997,  -113,   327,   989,  1259,  1128,   330,
     434,   628,   286,  1286,   635,  1507,   601,  1108,   986,  -113,
    -113,   234,  1343,   843,  1344,  1115,   709,  1501,   438,   439,
    1631,  -114,   710,  1455,   970,   286,  1569,   286,  1259,  1675,
    1501,   330,  1647,  1465,  1632,   128,  -114,  -114,   309,   335,
     944,   262,   434,   623,   330,   241,   630,    36,   945,   330,
    1134,   439,  1023,   944,   867,   944,   331,  1269,   705,  1567,
    1120,   334,   760,   761,   781,  1390,   239,   381,   881,   126,
    1269,   336,   382,   440,   971,  1568,  1554,   837,   945,   945,
    1210,  1221,   801,  1232,   240,   383,  1624,   903,   908,   316,
     317,   945,  1573,   998,   999,   337,  1458,   441,  1213,   802,
     909,   602,   911,   760,   761,   781,   740,  1130,   969,   697,
     330,  1702,   677,   937,  1257,   609,  1112,  1114,   837,  1117,
    1119,   239,   972,   973,   974,  1703,  1109,  1110,  1111,   678,
    1503,  1355,  1219,  1272,    39,  1364,   975,    39,   624,   240,
     288,   631,   341,  1503,  1489,  1257,   342,  1277,  1261,   933,
     625,   460,   629,   632,   937,   636,   294,   970,   295,   343,
     296,   311,  1738,   288,   385,   288,   312,   313,  1734,  1625,
    1626,  1627,  1628,  1629,  1501,   254,   255,   344,  1493,  1261,
     257,   258,  1739,  1076,  1076,  1794,    39,  1076,   502,  1216,
     503,  1795,   738,   265,  1675,  1501,    39,  1303,   739,   938,
     322,   323,   273,  1675,  1416,  1796,   930,   971,  1000,  1001,
    1002,  1003,  1070,   114,  1775,  1647,   939,  1428,  1004,  1005,
    1599,   297,   298,   299,   300,   301,   302,   303,   304,   305,
     306,   988,  1600,  1444,  1601,  1259,   992,   330,   776,   787,
     744,   393,  1440,  1133,   807,   640,   330,  1070,   641,   642,
    1447,  1710,  1376,  1457,  1215,   972,   973,   974,  1059,   502,
    1258,   503,   509,     5,  1269,  1734,   847,   865,    36,   975,
    1468,  1231,   734,   902,   735,   682,   683,  1573,   685,  1735,
     966,   976,  1059,   514,     5,   945,   945,  1503,  1726,   595,
    1269,   932,    31,   467,   943,  1454,  1211,   967,   977,  1304,
    1305,  1306,  1675,  1501,   848,  1060,  1061,  1062,  1503,  1307,
     595,   945,  1464,  1227,   990,   991,   596,   426,  1675,   745,
    1433,  1308,  1880,  1136,  1506,   330,   760,   761,   781,  1060,
    1061,  1062,   764,  1516,  1767,  1314,  1881,   235,  1309,   459,
    1481,   944,  1852,  1775,   746,   597,  -302,  1024,   598,   599,
     330,  1489,  1257,  1025,  1247,  1248,  1249,   600,  1007,  1008,
    1009,   868,   869,  1010,    39,  1764,   332,   524,   525,   526,
     527,   944,   944,   595,   286,   286,  1666,  1489,   286,   466,
    1675,  1315,  1323,  1510,   944,  1493,  1261,   739,  1324,   760,
     761,   781,   236,  1351,   478,   764,   123,   309,   596,  1352,
     824,   825,   826,   827,   828,  1221,    39,  1316,  1317,  1800,
   -1113,  1493,   488,  1063,   595,   508,  1503,   237,  1363,   595,
    1852,  1469,  1232,   235,   778,   789,  1383,   597,   622,  1385,
    1064,   546,   330,  1588,   538,   330,  1132,  1123,  1588,  1392,
     238,   596,   918,  1525,  1526,   330,   596,  1269,   776,   307,
     552,  1272,   849,   550,  1432,    73,   880,   904,   571,   919,
    1433,   595,   787,   782,  1272,  1076,  1011,   572,   945,   560,
     597,   622,   565,  1610,  1076,   597,   622,   934,   236,   595,
     783,   807,   600,  1012,  1387,  1389,   569,   600,   596,  1394,
     573,   574,   575,   760,   761,  1384,   762,   763,  1457,   764,
    1391,  1321,  1322,   237,   719,   588,   596,  1650,  1468,  1543,
     585,   595,   288,   288,   847,  1025,   288,   597,   622,   847,
     589,  1070,  1375,     5,   905,   649,   238,   760,   761,   600,
     651,   576,  1661,  1666,  1489,   597,   800,   865,   598,   599,
    1454,   906,   924,   887,   652,   775,   786,   600,   610,  1646,
    1464,   806,  1546,  1789,  1666,   577,  1579,  1581,  1547,  1586,
    1286,  1258,   330,   330,  1218,   330,   932,   637,  1493,  1655,
     902,   660,   955,   846,   864,   330,  1657,   878,   944,   944,
     901,  1659,   330,   661,   332,  1377,  1378,  1547,  1682,   956,
    1688,  1490,  1258,  1689,  1547,   663,   330,   662,   931,   330,
    1705,   942,  1715,   943,   944,   932,   330,  1717,  1716,   664,
    1477,  1479,   674,  1716,   958,   309,   943,   760,   943,   781,
    1165,  1166,  1135,   764,   332,   668,  1538,  1718,   596,  1736,
     925,   959,   837,  1716,   778,   669,   478,  1513,  1514,  1671,
    1707,  1175,  1176,  1177,  1178,  1179,  1180,   926,   789,   868,
     869,  1416,   870,   699,  1730,   309,   286,  1939,  1272,  1469,
     330,  1789,  1666,  1740,   700,   286,  1742,  1520,  1521,  1433,
    1695,  1696,  1433,  1562,  1563,   760,   761,  1789,   762,   763,
    1440,  1197,   670,  1199,  1272,  1765,   596,  1758,   852,  1778,
    1650,   853,   854,   330,  1592,  1770,  1541,   595,   835,   836,
     849,   330,  1808,  1549,  1811,   849,  1070,   654,   330,   234,
    1433,   702,  1812,   760,   761,   781,   680,  1070,  1025,   764,
      71,   684,    72,    73,  1813,    74,    75,   600,   837,  1801,
    1547,  1774,  1646,   707,  1858,  1859,  1860,   880,  1863,  1789,
     330,   330,  1547,  1131,  1547,    76,    77,  1871,   855,   690,
    1220,  1875,   934,  1547,  1783,   775,   856,  1716,  1786,  1583,
    1879,   944,  1517,  1518,  1575,  1883,   330,  1577,  1578,   786,
    1580,  1880,  1588,  1826,  1584,  1585,   695,  1826,   760,   761,
    1803,   762,   763,   713,   764,    78,    79,    80,   806,  1262,
    1884,   934,  1750,  1751,   288,  1885,  1433,   708,  1490,  1258,
     571,  1547,  1888,   288,  1622,  1889,  1132,  1891,   330,   572,
    1894,   330,   857,   330,  1833,  1834,  1547,  1855,  1778,  1904,
    1640,   846,   714,  1667,  1490,  1547,   846,   924,   887,   858,
    1697,  1698,   573,   574,   575,   332,   759,   478,  1872,  1873,
     838,  1272,   478,  1831,   864,   760,   761,   781,   762,   763,
    1832,   764,   765,   766,  1835,  1836,   596,  1818,   878,  1851,
    1774,  1878,  1845,   595,   835,   836,   309,   847,   478,  1905,
     767,  1217,  1912,   931,   595,   330,  1915,   901,   330,   760,
     761,   781,  1547,  1916,   437,   764,  1918,  1923,  1218,  1547,
     760,   761,   330,  1924,   837,  1855,  1722,   832,  1870,   720,
    1700,   596,  1925,   721,   943,   932,   722,  1926,  1547,  1363,
     942,   234,   931,  1547,   723,  1928,  1929,  1709,  1908,   724,
    1549,  1547,  1547,   942,   725,   942,   726,  1932,  1411,  1412,
     597,   622,  1420,   330,   943,   943,  1423,  1851,  1865,  1866,
     887,    81,   600,   522,   523,   747,  1429,   943,   757,    82,
      83,    84,    85,    86,    87,   528,   529,  1897,  1898,   888,
    1941,  1727,  1548,  1728,  1729,   790,   739,   889,  1731,    71,
     808,    72,    73,   829,    74,    75,   760,   761,   781,   640,
    1667,  1490,   641,   642,   831,   883,   885,   596,  1913,  1914,
     912,   837,  1135,   913,    76,    77,   917,   935,  1919,  1920,
    1790,  1667,   953,  1809,   954,   962,   838,   993,   868,   869,
    1472,   870,   963,  1474,   964,   965,   839,  1007,  1008,  1009,
     868,   869,  1010,  1781,  1018,  1782,  1020,   937,  1066,  1022,
    1080,  1081,  1084,   840,    78,    79,    80,  1085,    71,  1089,
      72,    73,  1917,    74,    75,  1086,   736,   309,   309,  1091,
    1092,   796,  1820,   849,  1093,  1094,  1821,  1154,  1155,  1158,
    1168,  1174,  1172,    76,    77,  1181,  1184,   234,  1186,  -474,
    1193,   234,  1195,  1201,  1220,  1205,  1235,  1242,  1244,  1814,
     512,    71,  1253,    72,    73,  1265,    74,    75,  1273,  1275,
    1262,   934,   946,   596,  1298,  1278,  1299,  1300,  1301,   982,
    1327,  1318,  1824,    78,    79,    80,    76,    77,  1790,  1667,
    1313,  1325,  1822,  1131,  1329,  1331,  1335,  1336,  1365,  1346,
    1494,  1262,  1340,  1347,  1790,  1882,  1838,  1348,  1839,  1366,
    1349,  1372,  1842,  1367,  1368,  1369,  1846,  1370,  1371,  1382,
    1396,   943,   943,  1395,  1373,  1408,    78,    79,    80,  1409,
    1427,  1435,  1449,  1450,  1460,  1480,  1475,  1482,  1496,  1476,
     759,  1483,  1485,  1508,  1509,  1527,  1511,   943,  1528,   760,
     761,   781,   762,   763,   846,   764,   765,   766,  1529,  1874,
     596,  1531,    71,  1532,    72,    73,  1790,    74,    75,  1537,
      81,  1555,  1540,  1561,   767,  1217,  1552,  1553,    82,    83,
      84,    85,    86,    87,  1940,  1576,  1571,    76,    77,  1890,
    1591,   942,   931,   345,   760,   761,   781,   762,  1597,  1611,
     764,  1602,  1615,  1614,  1426,  1620,  1623,  1635,  1642,   837,
    1636,  1652,  1653,  1679,  1656,   309,  1901,  1678,  1711,  1662,
    1680,   942,   942,  1684,  1685,  1687,  1690,    78,    79,    80,
    1713,     5,  1714,  1691,   942,  1692,  1693,  1694,  1701,    81,
    1719,  1732,  1737,   924,   887,   937,  1743,    82,    83,    84,
      85,    86,    87,  1744,  1741,  1753,  1922,     6,  1745,  1747,
    1748,  1752,   748,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    21,    22,    23,  1755,    25,    26,    27,    28,
      29,    30,    81,  1749,  1754,  1757,  1126,  1756,  1760,  1798,
      82,    83,    84,    85,    86,    87,  1763,  1766,    31,  1780,
    1804,  1802,  1805,  1127,   943,   751,  1807,  1494,  1262,   107,
       5,    72,    73,  1806,    74,    75,  1815,  1823,  1840,  1841,
    1847,  1848,  1857,  1861,  1862,  1867,  1876,  1886,  1877,  1887,
    1892,  1896,  1900,  1494,    76,    77,     6,     7,     8,     9,
      10,    11,    12,    13,    14,    15,    16,    17,    18,    19,
      20,    21,    22,    23,    24,    25,    26,    27,    28,    29,
      30,  1893,   108,   109,   110,  1899,   111,   112,   113,   114,
     115,   116,   117,   118,    78,    79,    80,    31,   119,   120,
     121,  1906,  1902,    81,  1903,  1909,  1911,  1927,  1930,  1933,
    1935,    82,    83,    84,    85,    86,    87,  1934,   759,  1936,
    1942,  1943,   531,   691,   530,  1723,  1116,   760,   761,   534,
     762,   763,   533,   764,   765,   766,   532,  1079,   596,  1353,
    1381,   230,   743,   275,   653,   554,   693,  1593,   942,   942,
    1594,  1825,   767,  1829,   107,     5,    72,    73,   490,    74,
      75,   427,  1159,  1246,  1762,  1161,   555,   419,   985,  1171,
    1206,  1769,  1328,   268,   942,  1434,  1238,  1356,  1683,    76,
      77,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,  1459,   108,   109,   110,
    1494,   111,   112,   113,   114,   115,   116,   117,   118,    78,
      79,    80,    31,   119,   120,   121,  1236,   122,   760,   761,
     781,   762,  1470,  1651,   764,   595,   835,   836,  1779,  1856,
    1895,  1641,  1660,   837,  1401,   811,  1202,  1276,  1167,  1182,
      81,   760,   761,   781,  1746,   123,   981,   764,    82,    83,
      84,    85,    86,    87,   768,  1708,   837,  1337,  1712,    71,
       5,    72,    73,   124,    74,    75,   621,   924,   887,   937,
    1530,   769,   428,   868,   869,  1819,   870,  1350,  1302,     0,
       0,     0,     0,     0,    76,    77,     6,     7,     8,     9,
      10,    11,    12,    13,    14,    15,    16,    17,    18,    19,
      20,    21,    22,    23,    24,    25,    26,    27,    28,    29,
      30,     0,     0,     0,     0,     0,     0,     0,   760,   761,
     781,   942,     0,     0,    78,    79,    80,    31,     0,   596,
      33,     0,   107,   837,    72,    73,     0,    74,    75,     0,
       0,     0,   122,     0,     0,     0,     0,     0,     0,     0,
     868,   869,     0,   870,     0,  1255,     0,    76,    77,     0,
       0,     0,     0,     0,     0,    81,     0,     0,   838,   937,
     123,     0,  1256,    82,    83,    84,    85,    86,    87,     0,
       0,     0,     0,     0,     0,   108,   109,   110,   124,   111,
     112,   113,   114,   115,   116,   117,   118,    78,    79,    80,
       0,   119,   120,   338,   107,     0,    72,    73,     0,    74,
      75,    71,     0,    72,    73,     0,    74,    75,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    76,
      77,     0,     0,     0,     0,     0,    76,    77,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1267,     0,   108,   109,   110,
       0,   111,   112,   113,   114,   115,   116,   117,   118,    78,
      79,    80,  1268,   119,   120,   539,    78,    79,    80,   107,
      81,    72,    73,     0,    74,    75,     0,     0,    82,    83,
      84,    85,    86,    87,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   547,    76,    77,     0,   760,   761,     0,
     762,   763,     0,     0,     0,     0,     0,     0,   596,     0,
     852,     0,     0,   853,   854,     0,     0,     0,     0,     0,
     339,     0,   108,   109,   110,     0,   111,   112,   113,   114,
     115,   116,   117,   118,    78,    79,    80,     0,   119,   120,
     655,     0,     0,    81,     0,     0,     0,     0,   123,   600,
       0,    82,    83,    84,    85,    86,    87,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   124,     0,     0,     0,
     855,     0,     0,     0,    71,     0,    72,    73,   856,    74,
      75,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   595,   339,     0,     0,     0,     0,     0,     0,    76,
      77,     0,     0,     0,     0,     0,     0,   760,   761,     0,
     762,   763,     0,   764,     0,    81,     0,     0,   596,     0,
     123,     0,    81,    82,    83,    84,    85,    86,    87,     0,
      82,    83,    84,    85,    86,    87,   995,     0,   124,    78,
      79,    80,  1817,     0,     0,     0,     0,   597,   622,   996,
     997,     0,     0,     0,     0,     0,   924,   887,     0,   600,
       0,     0,     0,     0,     0,     0,     0,   339,    71,     0,
      72,    73,     0,    74,    75,     0,   888,     0,     0,     0,
       0,     0,     0,     0,   889,     0,     0,     0,     0,     0,
      81,     0,     0,    76,    77,   123,     0,     0,    82,    83,
      84,    85,    86,    87,     0,     0,     0,     0,  1027,  1028,
    1029,     0,  1030,   124,     0,     0,     0,     0,     0,     0,
       0,  1031,     0,  1032,  1033,  1034,  1035,     0,     0,     0,
       0,  1414,     0,    78,    79,    80,     0,  1036,     0,  1037,
       0,  1038,     0,   995,  1225,  1039,     0,     0,     0,     0,
     998,   999,     0,     0,     0,  1040,   996,   997,     0,     0,
       0,  1226,     0,     0,  1041,  1042,  1043,     0,     0,     0,
       0,     0,     0,     0,  1044,  1045,     0,     0,     0,     0,
       0,     0,     0,  1046,     0,  1047,     0,  1048,  1049,     0,
       0,     0,     0,     0,     0,    81,     0,     0,  1050,  1051,
     736,     0,     0,    82,    83,    84,    85,    86,    87,     0,
    1415,  1052,     0,     0,     0,  1027,  1028,  1029,     0,  1030,
       0,  1053,     0,     0,     0,     0,  1054,     0,  1031,     0,
    1032,  1033,  1034,  1035,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1036,     0,  1037,     0,  1038,     0,
       0,     0,  1039,     0,     0,     0,     0,   998,   999,     0,
       0,     0,  1040,     0,     0,  1000,  1001,  1002,  1003,     0,
       0,  1041,  1042,  1043,     0,  1004,  1005,     0,     0,     0,
       0,  1044,  1045,     0,     0,     0,     0,     0,     0,    81,
    1046,     0,  1047,     0,  1048,  1049,     0,    82,    83,    84,
      85,    86,    87,     0,     0,  1050,  1051,     0,     0,     0,
       0,    71,     5,    72,    73,     0,    74,    75,  1052,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1053,     0,
       0,     0,     0,  1054,     0,     0,    76,    77,     6,     0,
       0,     0,     0,     0,    12,    13,    14,    15,    16,    17,
      18,    19,    20,    21,    22,    23,     0,    25,    26,    27,
      28,    29,    30,    71,     0,    72,    73,     0,    74,    75,
       0,     0,  1000,  1001,  1002,  1003,    78,    79,    80,    31,
       0,     0,  1004,  1005,     0,     0,     0,     0,    76,    77,
       0,     0,    71,   483,    72,    73,    12,    74,    75,     0,
       0,     0,     0,     0,     0,    21,    22,    71,     0,    72,
      73,     0,    74,    75,     0,     0,     0,    76,    77,     0,
       0,    71,   715,    72,    73,    12,    74,    75,    78,    79,
      80,    31,    76,    77,    21,    22,    71,     0,    72,    73,
      12,    74,    75,     0,     0,     0,    76,    77,     0,    21,
      22,     0,     0,     0,     0,     0,     0,    78,    79,    80,
      31,    76,    77,     0,    71,     0,    72,    73,     0,    74,
      75,     0,    78,    79,    80,    31,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    78,    79,    80,    76,
      77,    71,     0,    72,    73,     0,    74,    75,     0,     0,
       0,    78,    79,    80,     0,     0,     0,     0,    71,     0,
      72,    73,     0,    74,    75,     0,    76,    77,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    78,
      79,    80,    81,    76,    77,     0,     0,     0,     0,     0,
      82,    83,    84,    85,    86,    87,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    78,    79,    80,     0,
       0,     0,     0,     0,    71,     0,    72,    73,     0,    74,
      75,     0,     0,    78,    79,    80,     0,     0,     0,     0,
       0,     0,     0,     0,    81,     0,     0,   484,     0,    76,
      77,     0,    82,   485,    84,    85,    86,    87,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    71,
       0,    72,    73,    81,    74,    75,   716,     0,     0,     0,
       0,    82,   717,    84,    85,    86,    87,     0,    81,    78,
      79,    80,     0,     0,    76,    77,    82,    83,    84,    85,
      86,    87,    81,     0,  1100,     0,  1101,  1069,  1572,     0,
      82,    83,    84,    85,    86,    87,     0,    81,     0,  1100,
       0,  1101,  1069,  1720,     0,    82,    83,    84,    85,    86,
      87,     0,     0,     0,    78,    79,    80,     0,     0,     0,
       0,     0,     0,     0,     0,    81,     0,  1100,     0,  1101,
    1069,     0,     0,    82,    83,    84,    85,    86,    87,     0,
       0,     0,     0,     0,  1522,  1523,     0,     0,    71,     0,
      72,    73,    81,    74,    75,     0,     0,     0,     0,     0,
      82,  1524,    84,    85,    86,    87,     0,     0,     0,    81,
       0,     0,   730,    76,    77,     0,     0,    82,   731,    84,
      85,    86,    87,    71,     0,    72,    73,     0,    74,    75,
       0,     0,     0,     0,     0,     0,     0,    71,     0,    72,
      73,     0,    74,    75,     0,     0,     0,     0,    76,    77,
       0,     0,     0,    78,    79,    80,     0,     0,     0,     0,
       0,     0,    76,    77,     0,    81,    71,     0,    72,    73,
    1069,    74,    75,    82,    83,    84,    85,    86,    87,     0,
      71,     0,    72,    73,     0,    74,    75,     0,    78,    79,
      80,    76,    77,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    78,    79,    80,    76,    77,     0,     0,    71,
      81,    72,    73,  1097,    74,    75,     0,     0,    82,  1098,
      84,    85,    86,    87,    71,     0,    72,    73,     0,    74,
      75,    78,    79,    80,    76,    77,     0,     0,    71,     0,
      72,    73,     0,    74,    75,    78,    79,    80,     0,    76,
      77,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    76,    77,     0,     0,    71,     0,    72,
      73,     0,    74,    75,    78,    79,    80,     0,     0,     0,
       0,  1478,     0,    72,    73,     0,    74,    75,     0,    78,
      79,    80,    76,    77,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    78,    79,    80,    76,    77,     0,    81,
    1113,     0,     0,     0,     0,     0,     0,    82,    83,    84,
      85,    86,    87,     0,  1621,     0,    72,    73,     0,    74,
      75,     0,    78,    79,    80,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    81,  1118,    78,    79,    80,    76,
      77,     0,    82,    83,    84,    85,    86,    87,    81,  1386,
       0,     0,     0,     0,     0,     0,    82,    83,    84,    85,
      86,    87,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    81,  1388,    78,
      79,    80,     0,     0,     0,    82,    83,    84,    85,    86,
      87,    81,  1393,     0,     0,     0,     0,     0,     0,    82,
      83,    84,    85,    86,    87,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      81,  1582,     0,     0,     0,     0,     0,     0,    82,    83,
      84,    85,    86,    87,     0,    81,  1837,     0,     0,     0,
       0,     0,     0,    82,    83,    84,    85,    86,    87,   276,
       0,     0,     0,     0,     0,     0,     0,    82,    83,    84,
      85,    86,    87,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   279,     1,
       2,     3,     4,     5,     0,     0,    82,    83,    84,    85,
      86,    87,    81,     0,     0,     0,     0,     0,     0,     0,
      82,    83,    84,    85,    86,    87,     0,     0,     0,     6,
       7,     8,     9,    10,    11,    12,    13,    14,    15,    16,
      17,    18,    19,    20,    21,    22,    23,    24,    25,    26,
      27,    28,    29,    30,     0,    81,     4,     5,     0,     0,
       0,     0,     0,    82,    83,    84,    85,    86,    87,     0,
      31,     0,    32,    33,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     6,     7,     8,     9,    10,    11,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,    30,     4,     5,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    31,     0,    32,    33,     0,     0,
       0,     0,     0,     0,     0,     6,     7,     8,     9,    10,
      11,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    31,     0,     0,     0,
       0,     0,   760,     0,   781,     0,     0,     0,   764,     0,
       0,     0,     0,   596,     0,     0,   759,   837,     0,     0,
      34,     5,     0,     0,     0,   760,   761,     0,   762,   763,
       0,   764,   765,   766,   868,   869,   596,   870,     0,     0,
       0,     0,     0,    35,     0,     0,     0,     6,     0,     0,
     767,     0,    36,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    21,    22,    23,     0,    25,    26,    27,    28,
      29,    30,     0,     0,    34,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     4,     5,     0,     0,    31,     0,
       0,     0,     0,     0,     0,     0,     0,    35,     0,     0,
       0,     0,     0,     0,     0,     0,    36,     0,     0,     0,
       0,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,     4,     5,     0,   871,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   703,
     727,   503,    31,     0,     0,   264,   872,     0,    36,     0,
       0,     0,     0,     6,     7,     8,     9,    10,    11,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,    30,     4,     5,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    31,     0,     0,    33,     0,     0,
       0,     0,     0,     0,     0,     6,     7,     8,     9,    10,
      11,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
       4,     5,     0,     0,     0,     0,     0,  1564,     0,     0,
       0,     0,     0,     0,     0,     0,    31,     0,     0,   489,
       0,     0,     0,     0,     0,     0,     0,     6,     7,     8,
       9,    10,    11,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    21,    22,    23,    24,    25,    26,    27,    28,
      29,    30,     5,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    35,     0,     0,    31,     0,
       0,     0,     0,     0,    36,     0,     0,     0,     6,     7,
       8,     9,    10,    11,    12,    13,    14,    15,    16,    17,
      18,    19,    20,    21,    22,    23,    24,    25,    26,    27,
      28,    29,    30,     5,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    35,     0,    31,
       0,     0,     0,     0,     0,     0,    36,     0,     0,     6,
       0,     0,     0,     0,     0,    12,    13,    14,    15,    16,
      17,    18,    19,    20,    21,    22,    23,     0,    25,    26,
      27,    28,    29,    30,     0,     5,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    35,
      31,     0,     0,     0,     0,     0,     0,     0,    36,     0,
       0,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,     0,   476,     5,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    35,    31,     0,     0,    33,     0,     0,     0,     0,
      36,     0,     0,     0,     6,     7,     8,     9,    10,    11,
      12,    13,    14,    15,    16,    17,    18,    19,    20,    21,
      22,    23,    24,    25,    26,    27,    28,    29,    30,     5,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   502,   727,   503,    31,     0,     0,     0,     0,
       0,    36,     0,     0,     0,     6,     7,     8,     9,    10,
      11,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
       0,     0,     0,     0,     0,     0,   595,   835,   836,     0,
       0,     0,     0,   759,     0,     0,    31,     0,     0,  1570,
       0,     0,   760,   761,   781,   762,   763,     0,   764,   765,
     766,     0,     0,   596,     0,     0,     0,   837,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   767,     0,     0,
       0,     0,     0,     0,   868,   869,     0,   870,     0,   595,
     835,   836,   597,   622,     0,     0,   759,     0,     0,     0,
     123,   924,   887,   937,   600,   760,   761,   781,   762,   763,
       0,   764,   765,   766,     0,     0,   596,     0,   835,   836,
     837,   888,     0,     0,   759,     0,     0,     0,     0,   889,
     767,     0,     0,   760,   761,   781,   762,   763,     0,   764,
     765,   766,     0,     0,   596,   597,   622,     0,   837,   477,
       0,     0,     0,     0,   924,   887,   937,   600,   767,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   595,   835,
     836,     0,     0,     0,   888,   759,     0,     0,     0,   838,
       0,     0,   889,     0,   760,   761,   781,   762,   763,  1849,
     764,   765,   766,     0,     0,   596,     0,     0,     0,   837,
    1095,   354,   355,     0,   356,     0,  1850,     0,     0,   767,
       0,   982,     0,   357,   358,   359,     0,   361,     0,     0,
       0,   595,     0,     0,   597,   622,     0,     0,     0,   363,
       0,   364,   838,     0,     0,     0,   600,   760,   761,   781,
     762,     0,  1772,   764,     0,     0,     0,   367,   596,     0,
       0,     0,   837,   888,     0,     0,   368,   369,     0,  1773,
     838,   889,     0,     0,     0,     0,   371,   372,     0,   868,
     869,     0,   870,     0,   595,   373,     0,   597,   622,     0,
       0,   759,     0,     0,     0,     0,   924,   887,   937,   600,
     760,   761,     0,   762,   763,     0,   764,   765,   766,     0,
       0,   596,   595,   835,   836,     0,   888,     0,     0,     0,
       0,   838,   595,   378,   889,   767,     0,     0,   760,   761,
     781,  1452,     0,     0,   764,     0,     0,   595,   760,   761,
     597,   622,     0,   837,     0,     0,     0,     0,  1453,   596,
     887,     0,   600,   760,   761,   781,   762,     0,     0,   764,
     868,   869,     0,   870,   596,     0,     0,     0,   837,   888,
       0,     0,     0,     0,     0,     0,     0,   889,   597,   622,
       0,     0,     0,     0,  1644,     0,     0,     0,   887,     0,
     600,     0,     0,   597,   622,     0,     0,     0,     0,     0,
       0,  1645,   924,   887,   937,   600,     0,   888,     0,     0,
       0,     0,     0,     0,     0,   889,     0,     0,     0,     0,
       0,     0,   888,   835,   836,     0,     0,     0,     0,   759,
     889,     0,     0,     0,     0,     0,     0,  1208,   760,   761,
     781,   762,   763,     0,   764,   765,   766,     0,     0,   596,
       0,     0,     0,   837,  1209,   838,     0,     0,     0,     0,
       0,     0,     0,   767,     0,  1187,     0,     0,     0,     0,
     868,   869,     0,   870,     0,   890,     0,     0,   835,   836,
       0,     0,  1188,     0,   759,     0,     0,   924,   887,   937,
    1462,     0,   891,   760,   761,   781,   762,   763,     0,   764,
     765,   766,     0,     0,   596,     0,     0,  1463,   837,     0,
       0,     0,     0,     0,     0,     0,   835,   836,   767,     0,
       0,     0,   759,     0,     0,   868,   869,     0,   870,     0,
       0,   760,   761,   781,   762,   763,     0,   764,   765,   766,
       0,     0,   596,     0,   937,     0,   837,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   767,     0,     0,     0,
       0,   835,   836,   868,   869,   838,   870,   759,     0,     0,
       0,     0,     0,     0,     0,  1787,   760,   761,   781,   762,
     763,     0,   764,   765,   766,     0,     0,   596,     0,   835,
     836,   837,  1788,     0,     0,   759,     0,     0,     0,     0,
       0,   767,     0,     0,   760,   761,   781,   762,   763,     0,
     764,   765,   766,     0,     0,   596,     0,     0,     0,   837,
     838,     0,   835,   836,     0,   924,   887,   937,   759,   767,
    1672,     0,     0,     0,     0,     0,     0,   760,   761,   781,
     762,   763,     0,   764,   765,   766,     0,  1673,   596,     0,
       0,     0,   837,     0,     0,   937,     0,     0,   838,     0,
       0,     0,   767,     0,     0,     0,     0,     0,  1402,   760,
     761,   781,   762,     0,     0,   764,     0,     0,     0,     0,
     596,     0,     0,     0,   837,  1403,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   868,   869,   838,   870,   595,   835,   836,     0,     0,
       0,     0,   759,  1664,     0,     0,     0,     0,   924,   887,
     937,   760,   761,   781,   762,   763,     0,   764,   765,   766,
    1665,   838,   596,     0,     0,     0,   837,     0,     0,     0,
       0,  1499,   812,   813,   814,   815,   767,     0,     0,     0,
       0,     0,     0,   868,   869,     0,   870,     0,  1500,     0,
       0,   597,   622,     0,   838,     0,     0,     0,     0,     0,
     924,   887,   937,   600,  1138,     0,     0,   595,   835,   836,
     571,     0,     0,     0,   759,     0,   809,     0,     0,   572,
     888,  1139,     0,   760,   761,   781,   762,   763,   889,   764,
     765,   766,     0,     0,   596,     0,  1487,     0,   837,     0,
       0,     0,   573,   574,   575,     0,     0,     0,   767,   816,
     817,   818,     0,  1488,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   597,   622,     0,     0,     0,     0,     0,
       0,     0,   924,   887,   937,   600,     0,     0,   838,   595,
     835,   836,     0,     0,     0,     0,   759,     0,     0,     0,
     819,     0,   888,     0,     0,   760,   761,   781,   762,   763,
     889,   764,   765,   766,     0,     0,   596,   820,     0,     0,
     837,   835,   836,     0,     0,     0,     0,   759,     0,     0,
     767,     0,     0,     0,     0,     0,   760,   761,   781,   762,
     763,     0,   764,   765,   766,   597,   622,   596,     0,     0,
       0,   837,     0,     0,     0,     0,     0,   600,     0,     0,
     838,   767,     0,     0,     0,     0,     0,     0,   868,   869,
       0,   870,     0,     0,   888,   835,   836,     0,     0,     0,
       0,   759,   889,     0,     0,   924,   887,   937,     0,     0,
     760,   761,   781,   762,   763,     0,   764,   765,   766,     0,
       0,   596,     0,     0,     0,   837,     0,     0,     0,     0,
       0,     0,   835,   836,     0,   767,     0,     0,   759,     0,
       0,     0,   868,   869,     0,   870,     0,   760,   761,   781,
     762,   763,   838,   764,   765,   766,     0,     0,   596,     0,
       0,   937,   837,     0,     0,     0,     0,     0,     0,   835,
     836,     0,   767,     0,     0,   759,     0,     0,     0,   868,
     869,     0,   870,   838,   760,   761,   781,   762,   763,     0,
     764,   765,   766,     0,     0,   596,   835,   836,     0,   837,
       0,     0,   759,     0,     0,     0,     0,     0,     0,   767,
       0,   760,   761,   781,   762,   763,     0,   764,   765,   766,
       0,     0,   596,     0,     0,     0,   837,     0,  1027,  1028,
    1029,     0,  1030,   924,   887,   937,   767,   838,     0,     0,
       0,  1031,     0,  1032,  1033,  1034,  1035,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1036,     0,  1037,
       0,  1038,   937,     0,     0,  1039,     0,     0,     0,     0,
       0,     0,     0,     0,   838,  1040,     0,     0,     0,     0,
       0,     0,     0,     0,  1041,  1042,  1043,     0,     0,  1279,
    1280,  1281,  1282,     0,  1044,  1045,     0,     0,     0,     0,
       0,     0,     0,  1046,     0,  1047,     0,  1048,  1049,     0,
       0,   838,     0,  1283,  1284,  1285,     0,     0,  1050,  1051,
       0,     0,     0,     0,   812,   813,   814,   815,     0,     0,
       0,  1052,  1027,  1028,  1029,     0,  1030,     0,   838,     0,
       0,  1053,     0,     0,     0,  1031,  1054,  1032,  1033,  1034,
    1035,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1036,   571,  1037,     0,  1038,     0,     0,   809,  1039,
       0,   572,     0,     0,     0,     0,     0,     0,     0,  1040,
       0,     0,     0,     0,     0,     0,     0,     0,  1041,  1042,
    1043,     0,     0,     0,   573,   574,   575,     0,  1044,  1045,
       0,   816,   817,   818,  1247,  1248,  1249,  1046,     0,  1047,
       0,  1048,  1049,     0,     0,  1027,  1028,  1029,     0,  1030,
       0,     0,  1050,  1051,     0,     0,     0,  1437,  1031,     0,
    1032,  1033,  1034,  1035,     0,  1052,     0,     0,     0,     0,
       0,     0,     0,     0,  1036,  1053,  1037,     0,  1038,     0,
    1054,     0,  1039,   760,   761,   781,   762,     0,     0,   764,
       0,     0,  1040,     0,   596,     0,     0,     0,   837,     0,
       0,  1041,  1042,  1043,     0,     0,     0,     0,     0,     0,
       0,  1044,  1045,     0,     0,   868,   869,     0,   870,     0,
    1046,     0,  1047,     0,  1048,  1049,     0,     0,     0,     0,
       0,     0,   924,   887,   937,  1050,  1051,   235,   354,   355,
       0,   356,     0,  1438,  1439,     0,     0,     0,  1052,     0,
     357,   358,   359,   360,   361,   362,     0,     0,  1053,     0,
       0,     0,     0,  1054,     0,     0,   363,     0,   364,     0,
     365,     0,     0,     0,   366,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   367,     0,     0,     0,     0,     0,
       0,     0,   236,   368,   369,   370,     0,     0,     0,     0,
       0,     0,     0,   371,   372,  1027,  1028,  1029,     0,  1030,
       0,     0,   373,     0,   374,     0,   375,   237,  1031,     0,
    1032,  1033,  1034,  1035,     0,     0,     0,   376,   377,     0,
       0,     0,     0,     0,  1036,     0,  1037,     0,  1038,     0,
     238,     0,  1039,     0,     0,     0,     0,     0,     0,     0,
     378,     0,  1040,     0,     0,   379,     0,     0,     0,     0,
       0,  1041,  1042,  1043,     0,     0,     0,     0,     0,     0,
       0,  1044,  1045,     0,     0,     0,     0,     0,     0,     0,
    1046,     0,  1047,     0,  1048,  1049,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1050,  1051,  1027,  1028,  1029,
       0,  1030,     0,  1438,  1439,     0,     0,     0,  1052,     0,
    1031,     0,  1032,  1033,  1034,  1035,     0,     0,  1053,     0,
       0,     0,     0,  1054,     0,     0,  1036,     0,  1037,     0,
    1038,     0,     0,     0,  1039,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1040,     0,     0,     0,     0,     0,
       0,     0,     0,  1041,  1042,  1043,     0,     0,     0,     0,
       0,     0,     0,  1044,  1045,     0,     0,     0,     0,     0,
       0,     0,  1046,     0,  1047,     0,  1048,  1049,     0,     0,
       0,  1162,     0,   354,   355,     0,   356,  1050,  1051,  1027,
    1028,  1029,     0,  1030,     0,   357,   358,   359,     0,   361,
    1052,     0,  1031,     0,  1032,  1033,  1034,  1035,     0,     0,
    1053,   363,     0,   364,     0,  1054,     0,     0,  1036,     0,
    1037,     0,  1038,     0,     0,     0,  1039,     0,     0,   367,
       0,     0,     0,     0,     0,     0,  1040,     0,   368,   369,
       0,     0,     0,     0,     0,  1041,  1042,  1043,   371,   372,
       0,     0,     0,     0,     0,  1044,  1045,   373,   354,   355,
       0,   356,     0,     0,  1046,     0,  1047,     0,  1048,  1049,
     357,   358,   359,   360,   361,   362,     0,     0,     0,  1050,
    1051,     0,     0,     0,     0,     0,   363,     0,   364,     0,
     365,     0,  1052,     0,   366,   378,     0,     0,     0,     0,
       0,     0,  1053,     0,   367,     0,     0,  1054,     0,     0,
       0,   595,     0,   368,   369,   370,     0,     0,     0,     0,
       0,     0,     0,   371,   372,     0,     0,   760,   761,   781,
     762,     0,   373,   764,   374,     0,   375,     0,   596,     0,
       0,     0,   837,     0,     0,     0,     0,   376,   377,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   868,
     869,     0,   870,     0,   595,     0,     0,   597,   622,     0,
     378,   759,     0,     0,     0,   379,   924,   887,   937,   600,
     760,   761,     0,   762,   763,     0,   764,   765,   766,     0,
       0,   596,     0,     0,     0,   595,   888,     0,     0,     0,
       0,     0,     0,     0,   889,   767,     0,     0,     0,     0,
       0,   760,   761,   781,   762,     0,     0,   764,   595,     0,
     597,   622,   596,     0,     0,     0,   837,     0,     0,     0,
     887,     0,   600,     0,   760,   761,     0,   762,   763,     0,
     764,     0,     0,     0,     0,   596,     0,     0,     0,   888,
       0,   597,   622,     0,     0,     0,     0,   889,     0,     5,
     924,   887,   937,   600,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   597,   622,     0,     0,     0,     0,
     888,     0,     0,   924,   887,     6,   600,     5,   889,     0,
       0,     0,    13,    14,    15,    16,    17,    18,    19,    20,
       0,     0,    23,   888,    25,    26,    27,    28,    29,    30,
       0,   889,     0,     6,     7,     8,     9,    10,    11,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,    30,     5,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    31,     0,     0,    33,     0,     0,
       0,     0,     0,     0,     6,     7,     8,     9,    10,    11,
      12,    13,    14,    15,    16,    17,    18,    19,    20,    21,
      22,    23,    24,    25,    26,    27,    28,    29,    30,  1078,
       5,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    31,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     6,     7,     8,     9,
      10,    11,    12,    13,    14,    15,    16,    17,    18,    19,
      20,    21,    22,    23,    24,    25,    26,    27,    28,    29,
      30,     5,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    31,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     6,     0,     0,
       0,     0,     0,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    21,    22,    23,     0,    25,    26,    27,    28,
      29,    30,   392,     0,     0,     0,     0,     0,   396,     0,
     397,     0,   398,     0,     0,     0,     0,     0,    31,     0,
       0,     0,     0,     0,   402,     0,   403,     0,   404,     0,
       0,     0,     0,     0,     0,     0,   408,     0,   409,     0,
     410,     0,   411,     0,   412,     0,   413,     0,   414,     0,
     415,     0,   416,     0,     0,     0,   418
};

static const yytype_int16 yycheck[] =
{
       1,    74,    75,    76,   108,    44,    30,    35,   314,   315,
     660,    39,    81,   232,     2,  1018,    50,   614,   350,    92,
      44,    36,    48,   590,    48,   131,   286,   674,   288,  1076,
     670,   260,   758,   923,   261,   108,   671,   256,   694,   626,
    1348,  1349,   586,   671,   590,   603,  1266,  1100,     2,  1408,
    1409,   643,   376,   377,    39,   282,   633,   936,   991,  1137,
     558,   611,   586,   442,  1254,   570,  1074,   294,   614,   252,
     231,     9,   291,     9,    20,   287,     9,   296,    77,   584,
      81,   308,   334,    68,     9,   884,     0,   886,   370,     3,
    1449,  1450,   562,   450,   376,   377,     6,   227,   261,   127,
    1498,     0,  1378,   330,     3,    36,     6,     7,    62,  1663,
     790,     6,   558,   593,   149,   276,     6,   118,   279,   125,
     281,     9,   283,   284,     9,   113,   229,   231,   148,    79,
      49,     6,    51,    80,    77,     9,   156,   160,    52,   103,
      79,   587,    74,   131,   164,   248,   154,     9,    67,    79,
      81,    92,   172,    52,   174,   229,   176,     0,   231,     9,
     107,   125,   231,    79,    80,   611,   172,    15,    16,   558,
       6,     6,     7,     6,   248,   125,   196,   131,     6,   187,
     188,  1540,   202,   370,   204,     6,    79,   227,   208,   376,
     377,   107,     9,   213,     9,   125,   216,   370,   587,   234,
       9,   376,   377,   376,   377,   144,     9,   276,   227,   233,
     279,   251,   281,   227,   283,   284,   251,   286,    59,   288,
     552,    62,   611,   211,  1486,   251,   235,   251,   251,   244,
     249,     6,   125,  1787,   233,   259,   504,   153,   311,   312,
     313,   314,   315,   316,   317,   318,   319,   320,   321,   322,
     323,   324,   325,   326,   327,   328,   483,   234,   756,   961,
     487,   204,   228,   587,   232,  1318,   478,   834,   234,   593,
     768,    52,   287,   250,  1672,   276,   503,   559,   279,  1499,
     265,   464,   564,   963,   964,   965,   538,  1563,   273,   472,
     834,   229,   331,     6,   295,   839,   229,  1487,   677,   253,
     231,   247,   626,   228,   871,  1358,   559,   331,   227,   633,
     756,   593,   248,   244,   819,   839,   230,   227,   272,   651,
     483,   603,   768,   248,  1402,   871,   923,   797,   329,   686,
     261,   230,   232,   586,   335,   336,   337,   590,   233,   227,
     341,   938,   227,   233,   626,   276,   334,  1355,   279,     6,
     281,   633,   283,   284,   228,   286,  1364,   288,   233,   680,
     918,   614,   388,   695,   388,  1255,   228,   756,   955,   936,
     311,   312,   313,   393,   966,   925,  1011,   923,   228,   768,
     400,   958,  1741,  1011,  1317,   558,   884,   341,  1267,  1322,
     936,   227,   938,   229,   227,   243,   244,   232,   386,   227,
     236,   229,  1664,   236,   884,  1713,   227,   594,  1207,  1208,
     890,   857,  1138,   228,   587,   236,   603,   590,   227,   594,
     593,   594,     1,   755,   227,  1224,  1225,  1266,   109,   250,
     603,   272,   386,   660,   462,   508,     6,   705,   884,   626,
     886,   701,   468,   923,   468,   469,   633,   620,  1104,   230,
     478,   626,   227,   626,   108,  1157,   228,     1,   633,   125,
     633,   236,   179,   478,    74,    75,   140,   694,   857,   790,
     110,  1173,   227,   248,  1154,   250,   248,   923,  1158,   925,
      39,  1207,    74,    75,   229,   712,   231,   502,   715,    48,
      49,    74,  1194,   234,   227,   884,  1198,   886,  1200,   173,
     782,  1181,   229,   756,   249,   734,   172,   248,   735,   736,
     693,   465,   739,    92,   227,    74,  1569,   234,   472,   801,
    1567,   248,   234,   236,   205,   182,   183,   184,   185,   782,
     227,  1233,   189,   857,   251,   248,   925,   720,   250,  1542,
    1266,   234,   223,   224,   123,   124,   547,   653,   549,   537,
     538,   227,   483,   229,   245,  1235,   487,   250,   108,    81,
     884,  1201,   886,   724,   234,   726,   890,   508,   234,    10,
      11,    12,   212,   213,   214,    97,    98,   234,   248,   246,
     234,   834,   222,   756,   106,   251,   839,   137,   138,   234,
     234,   912,   913,  1273,   251,   768,   917,   251,   237,   238,
     109,   228,   884,   248,   886,    61,   250,   234,   890,     6,
     154,   190,   182,   183,   184,   185,   140,   167,   871,   189,
    1187,   248,    19,    20,   234,    19,   665,  1224,  1126,   234,
     654,   955,   701,   954,   958,  1275,   918,   741,   658,   249,
     250,   665,   186,  1187,   188,   250,   228,  1486,   140,   173,
     234,   234,   234,  1452,   110,   724,   248,   726,  1255,  1498,
    1499,   234,  1461,  1462,   248,   653,   249,   250,   741,   227,
     923,   705,   696,   955,   234,   703,   958,   236,  1224,   234,
    1126,   173,  1329,   936,   857,   938,   248,  1254,   703,   234,
     250,   248,    97,    98,    99,   250,   205,   206,   871,   653,
    1267,   227,   211,   227,   160,   250,  1346,   112,  1254,  1255,
    1208,   884,   234,   886,   223,   224,     1,   890,   905,    13,
      14,  1267,  1378,   120,   121,   227,  1452,   251,  1208,   251,
     905,   918,   905,    97,    98,    99,   230,  1126,    61,   693,
     234,   234,   234,   148,  1224,   918,   747,   748,   112,   750,
     751,   205,   208,   209,   210,   248,   744,   745,   746,   251,
    1486,  1073,  1208,   936,     0,  1077,   222,     3,   955,   223,
     701,   958,   227,  1499,  1254,  1255,     6,   950,  1224,  1225,
     955,   712,   955,   958,   148,   958,   227,   110,   229,   250,
     231,   236,   228,   724,   233,   726,   241,   242,   234,    84,
      85,    86,    87,    88,  1643,    41,    42,   250,  1254,  1255,
      46,    47,   248,  1073,  1074,   228,    52,  1077,   227,  1208,
     229,   234,   228,    59,  1663,  1664,    62,   110,   234,   234,
      17,    18,    68,  1672,  1155,   248,  1225,   160,   235,   236,
     237,   238,  1069,    66,  1643,  1644,   251,  1168,   245,   246,
      88,    21,    22,    23,    24,    25,    26,    27,    28,    29,
      30,   663,   100,  1195,   102,  1462,   668,   234,   558,   559,
     228,   232,  1193,  1126,   564,   199,   234,  1104,   202,   203,
    1201,   248,  1101,  1207,  1208,   208,   209,   210,   103,   227,
     923,   229,     6,     7,  1461,   234,   586,   587,   236,   222,
    1224,  1225,   227,   593,   229,   446,   447,  1563,   449,   248,
     234,   234,   103,     6,     7,  1461,  1462,  1643,  1574,    81,
    1487,   611,    74,    75,   614,  1207,  1208,   251,   251,   212,
     213,   214,  1771,  1772,  1187,   150,   151,   152,  1664,   222,
      81,  1487,  1224,  1225,   233,   234,   108,     6,  1787,   228,
     234,   234,   234,  1126,  1275,   234,    97,    98,    99,   150,
     151,   152,   103,  1295,   248,   985,   248,    78,   251,   228,
    1244,  1224,  1771,  1772,   228,   137,   232,   228,   140,   141,
     234,  1461,  1462,   234,   150,   151,   152,   149,   126,   127,
     128,   129,   130,   131,   230,  1635,  1100,   318,   319,   320,
     321,  1254,  1255,    81,  1073,  1074,  1486,  1487,  1077,   249,
    1849,   228,   228,  1287,  1267,  1461,  1462,   234,   234,    97,
      98,    99,   133,   228,   260,   103,   232,  1100,   108,   234,
     571,   572,   573,   574,   575,  1208,   272,   233,   234,  1679,
     243,  1487,   133,   234,    81,   228,  1772,   158,  1076,    81,
    1849,  1224,  1225,    78,   558,   559,   228,   137,   138,   228,
     251,    64,   234,  1395,   248,   234,   756,  1399,  1400,   228,
     181,   108,   234,  1300,  1301,   234,   108,  1644,   768,   249,
     227,  1254,   586,   250,   228,     9,   590,   167,   154,   251,
     234,    81,   782,   234,  1267,  1355,   234,   163,  1644,   149,
     137,   138,   251,  1424,  1364,   137,   138,   611,   133,    81,
     251,   801,   149,   251,  1115,  1116,   251,   149,   108,  1120,
     186,   187,   188,    97,    98,  1113,   100,   101,  1452,   103,
    1118,   233,   234,   158,   159,   251,   108,  1461,  1462,   228,
     125,    81,  1073,  1074,   834,   234,  1077,   137,   138,   839,
     251,  1378,     6,     7,   234,   251,   181,    97,    98,   149,
     227,   227,  1483,  1643,  1644,   137,   106,   857,   140,   141,
    1452,   251,   146,   147,   251,   558,   559,   149,   145,  1461,
    1462,   564,   228,  1663,  1664,   251,   228,   228,   234,   228,
    1511,  1224,   234,   234,   884,   234,   886,   192,  1644,   228,
     890,   227,   234,   586,   587,   234,   228,   590,  1461,  1462,
     593,   228,   234,   228,  1318,   233,   234,   234,   228,   251,
     228,  1254,  1255,   228,   234,   232,   234,   228,   611,   234,
     228,   614,   228,   923,  1487,   925,   234,   228,   234,     6,
    1241,  1242,     6,   234,   234,  1318,   936,    97,   938,    99,
     791,   792,   756,   103,  1358,   232,  1325,   228,   108,  1591,
     234,   251,   112,   234,   768,   227,   502,   200,   201,  1496,
    1544,   812,   813,   814,   815,   816,   817,   251,   782,   129,
     130,  1602,   132,   232,   228,  1358,  1355,  1937,  1461,  1462,
     234,  1771,  1772,   228,   233,  1364,   228,  1298,  1299,   234,
    1527,  1528,   234,   233,   234,    97,    98,  1787,   100,   101,
    1631,   852,   227,   854,  1487,  1636,   108,   228,   110,  1643,
    1644,   113,   114,   234,  1397,   228,  1327,    81,    82,    83,
     834,   234,   228,  1334,   228,   839,  1563,  1363,   234,  1363,
     234,   232,   228,    97,    98,    99,   227,  1574,   234,   103,
       6,   227,     8,     9,   228,    11,    12,   149,   112,  1680,
     234,  1643,  1644,   228,   228,   228,   228,   871,   228,  1849,
     234,   234,   234,   756,   234,    31,    32,   228,   170,   227,
     884,   228,   886,   234,  1658,   768,   178,   234,  1662,  1390,
     228,  1644,   197,   198,  1382,   228,   234,  1385,  1386,   782,
    1388,   234,  1734,  1735,  1392,  1393,   227,  1739,    97,    98,
    1684,   100,   101,   230,   103,    71,    72,    73,   801,   923,
     228,   925,   237,   238,  1355,   228,   234,   234,  1461,  1462,
     154,   234,   228,  1364,  1435,   228,  1126,   228,   234,   163,
     228,   234,   234,   234,  1750,  1751,   234,  1771,  1772,   228,
    1451,   834,   230,  1486,  1487,   234,   839,   146,   147,   251,
     215,   216,   186,   187,   188,  1569,    88,   703,   217,   218,
     224,  1644,   708,  1747,   857,    97,    98,    99,   100,   101,
    1749,   103,   104,   105,  1753,  1754,   108,  1714,   871,  1771,
    1772,  1823,  1766,    81,    82,    83,  1569,  1187,   734,   228,
     122,   884,   228,   886,    81,   234,   228,   890,   234,    97,
      98,    99,   234,   228,   125,   103,   228,   228,  1208,   234,
      97,    98,   234,   234,   112,  1849,  1565,   251,  1802,   243,
    1531,   108,   228,   228,  1224,  1225,   228,   228,   234,  1567,
     923,  1565,   925,   234,   228,   228,   228,  1548,  1880,   234,
    1551,   234,   234,   936,   234,   938,   234,   228,  1152,  1153,
     137,   138,  1156,   234,  1254,  1255,  1160,  1849,  1795,  1796,
     147,   227,   149,   316,   317,   227,  1170,  1267,   125,   235,
     236,   237,   238,   239,   240,   322,   323,  1861,  1862,   166,
     228,  1579,   248,  1581,  1582,   227,   234,   174,  1586,     6,
       6,     8,     9,   228,    11,    12,    97,    98,    99,   199,
    1643,  1644,   202,   203,   251,   107,   145,   108,  1892,  1893,
     227,   112,  1126,   227,    31,    32,   227,   107,  1902,  1903,
    1663,  1664,   251,  1702,   227,   251,   224,     6,   129,   130,
    1234,   132,   227,  1237,   227,   227,   234,   126,   127,   128,
     129,   130,   131,  1654,   227,  1656,   227,   148,     6,   229,
       6,   230,   230,   251,    71,    72,    73,   230,     6,     6,
       8,     9,  1899,    11,    12,   251,   232,  1750,  1751,   228,
     228,   149,  1721,  1187,   230,   230,  1725,   227,   227,   227,
     227,   251,   228,    31,    32,   227,     6,  1721,   251,   227,
     227,  1725,   227,   227,  1208,   227,   227,   227,   227,  1710,
    1937,     6,   107,     8,     9,   125,    11,    12,   227,   227,
    1224,  1225,   179,   108,   227,   251,   227,   227,   227,    89,
     227,   249,  1733,    71,    72,    73,    31,    32,  1771,  1772,
     251,   248,  1730,  1126,     6,     6,   229,   251,   230,   227,
    1254,  1255,   248,   227,  1787,  1828,  1757,   227,  1759,   230,
     227,   230,  1763,   244,   228,   228,  1767,   228,   228,    62,
       6,  1461,  1462,   248,   230,   227,    71,    72,    73,   227,
     161,   227,   227,   227,   107,     6,   248,   234,   227,   248,
      88,   234,   125,   251,     6,   227,   234,  1487,   227,    97,
      98,    99,   100,   101,  1187,   103,   104,   105,   227,  1810,
     108,   234,     6,   250,     8,     9,  1849,    11,    12,     6,
     227,     6,   227,     6,   122,  1208,   228,   228,   235,   236,
     237,   238,   239,   240,  1938,   250,   230,    31,    32,  1840,
     230,  1224,  1225,   250,    97,    98,    99,   100,     6,     6,
     103,   234,   228,   162,   234,     6,   234,   234,   125,   112,
     234,   142,   228,   234,   248,  1938,  1867,    84,   230,   248,
     234,  1254,  1255,   248,   228,   228,   228,    71,    72,    73,
     248,     7,   229,   228,  1267,   228,   228,   228,   251,   227,
     251,     6,   228,   146,   147,   148,   228,   235,   236,   237,
     238,   239,   240,   228,   248,   234,  1907,    33,   228,   248,
     228,   228,   250,    39,    40,    41,    42,    43,    44,    45,
      46,    47,    48,    49,    50,   251,    52,    53,    54,    55,
      56,    57,   227,   248,   248,   248,   234,   228,   228,   228,
     235,   236,   237,   238,   239,   240,   234,   248,    74,   248,
     228,   248,   228,   251,  1644,   250,   228,  1461,  1462,     6,
       7,     8,     9,   234,    11,    12,   230,   230,   234,   248,
     228,   228,   175,   248,   248,   234,     6,   228,   230,   228,
     248,   228,   228,  1487,    31,    32,    33,    34,    35,    36,
      37,    38,    39,    40,    41,    42,    43,    44,    45,    46,
      47,    48,    49,    50,    51,    52,    53,    54,    55,    56,
      57,   248,    59,    60,    61,   248,    63,    64,    65,    66,
      67,    68,    69,    70,    71,    72,    73,    74,    75,    76,
      77,   230,   248,   227,   248,     6,   228,   228,   156,     6,
     251,   235,   236,   237,   238,   239,   240,   227,    88,     6,
     228,   228,   325,   462,   324,  1567,   250,    97,    98,   328,
     100,   101,   327,   103,   104,   105,   326,   708,   108,  1069,
    1105,     3,   538,    68,   386,   352,   465,  1399,  1461,  1462,
    1400,  1734,   122,  1739,     6,     7,     8,     9,   272,    11,
      12,   229,   768,   916,  1631,   782,   352,   200,   657,   801,
     871,  1639,  1011,    59,  1487,  1187,   905,   233,  1511,    31,
      32,    33,    34,    35,    36,    37,    38,    39,    40,    41,
      42,    43,    44,    45,    46,    47,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,  1208,    59,    60,    61,
    1644,    63,    64,    65,    66,    67,    68,    69,    70,    71,
      72,    73,    74,    75,    76,    77,   890,   204,    97,    98,
      99,   100,  1225,  1462,   103,    81,    82,    83,  1644,  1772,
    1849,  1452,  1482,   112,  1126,   568,   857,   947,   793,   819,
     227,    97,    98,    99,  1602,   232,   233,   103,   235,   236,
     237,   238,   239,   240,   234,  1547,   112,  1025,  1551,     6,
       7,     8,     9,   250,    11,    12,   375,   146,   147,   148,
    1308,   251,   229,   129,   130,  1716,   132,  1063,   976,    -1,
      -1,    -1,    -1,    -1,    31,    32,    33,    34,    35,    36,
      37,    38,    39,    40,    41,    42,    43,    44,    45,    46,
      47,    48,    49,    50,    51,    52,    53,    54,    55,    56,
      57,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    97,    98,
      99,  1644,    -1,    -1,    71,    72,    73,    74,    -1,   108,
      77,    -1,     6,   112,     8,     9,    -1,    11,    12,    -1,
      -1,    -1,   204,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     129,   130,    -1,   132,    -1,   234,    -1,    31,    32,    -1,
      -1,    -1,    -1,    -1,    -1,   227,    -1,    -1,   224,   148,
     232,    -1,   251,   235,   236,   237,   238,   239,   240,    -1,
      -1,    -1,    -1,    -1,    -1,    59,    60,    61,   250,    63,
      64,    65,    66,    67,    68,    69,    70,    71,    72,    73,
      -1,    75,    76,    77,     6,    -1,     8,     9,    -1,    11,
      12,     6,    -1,     8,     9,    -1,    11,    12,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    31,
      32,    -1,    -1,    -1,    -1,    -1,    31,    32,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   234,    -1,    59,    60,    61,
      -1,    63,    64,    65,    66,    67,    68,    69,    70,    71,
      72,    73,   251,    75,    76,    77,    71,    72,    73,     6,
     227,     8,     9,    -1,    11,    12,    -1,    -1,   235,   236,
     237,   238,   239,   240,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   250,    31,    32,    -1,    97,    98,    -1,
     100,   101,    -1,    -1,    -1,    -1,    -1,    -1,   108,    -1,
     110,    -1,    -1,   113,   114,    -1,    -1,    -1,    -1,    -1,
     204,    -1,    59,    60,    61,    -1,    63,    64,    65,    66,
      67,    68,    69,    70,    71,    72,    73,    -1,    75,    76,
      77,    -1,    -1,   227,    -1,    -1,    -1,    -1,   232,   149,
      -1,   235,   236,   237,   238,   239,   240,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   250,    -1,    -1,    -1,
     170,    -1,    -1,    -1,     6,    -1,     8,     9,   178,    11,
      12,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    81,   204,    -1,    -1,    -1,    -1,    -1,    -1,    31,
      32,    -1,    -1,    -1,    -1,    -1,    -1,    97,    98,    -1,
     100,   101,    -1,   103,    -1,   227,    -1,    -1,   108,    -1,
     232,    -1,   227,   235,   236,   237,   238,   239,   240,    -1,
     235,   236,   237,   238,   239,   240,     6,    -1,   250,    71,
      72,    73,   247,    -1,    -1,    -1,    -1,   137,   138,    19,
      20,    -1,    -1,    -1,    -1,    -1,   146,   147,    -1,   149,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   204,     6,    -1,
       8,     9,    -1,    11,    12,    -1,   166,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   174,    -1,    -1,    -1,    -1,    -1,
     227,    -1,    -1,    31,    32,   232,    -1,    -1,   235,   236,
     237,   238,   239,   240,    -1,    -1,    -1,    -1,    78,    79,
      80,    -1,    82,   250,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    91,    -1,    93,    94,    95,    96,    -1,    -1,    -1,
      -1,   101,    -1,    71,    72,    73,    -1,   107,    -1,   109,
      -1,   111,    -1,     6,   234,   115,    -1,    -1,    -1,    -1,
     120,   121,    -1,    -1,    -1,   125,    19,    20,    -1,    -1,
      -1,   251,    -1,    -1,   134,   135,   136,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   144,   145,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   153,    -1,   155,    -1,   157,   158,    -1,
      -1,    -1,    -1,    -1,    -1,   227,    -1,    -1,   168,   169,
     232,    -1,    -1,   235,   236,   237,   238,   239,   240,    -1,
     180,   181,    -1,    -1,    -1,    78,    79,    80,    -1,    82,
      -1,   191,    -1,    -1,    -1,    -1,   196,    -1,    91,    -1,
      93,    94,    95,    96,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   107,    -1,   109,    -1,   111,    -1,
      -1,    -1,   115,    -1,    -1,    -1,    -1,   120,   121,    -1,
      -1,    -1,   125,    -1,    -1,   235,   236,   237,   238,    -1,
      -1,   134,   135,   136,    -1,   245,   246,    -1,    -1,    -1,
      -1,   144,   145,    -1,    -1,    -1,    -1,    -1,    -1,   227,
     153,    -1,   155,    -1,   157,   158,    -1,   235,   236,   237,
     238,   239,   240,    -1,    -1,   168,   169,    -1,    -1,    -1,
      -1,     6,     7,     8,     9,    -1,    11,    12,   181,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   191,    -1,
      -1,    -1,    -1,   196,    -1,    -1,    31,    32,    33,    -1,
      -1,    -1,    -1,    -1,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    -1,    52,    53,    54,
      55,    56,    57,     6,    -1,     8,     9,    -1,    11,    12,
      -1,    -1,   235,   236,   237,   238,    71,    72,    73,    74,
      -1,    -1,   245,   246,    -1,    -1,    -1,    -1,    31,    32,
      -1,    -1,     6,    36,     8,     9,    39,    11,    12,    -1,
      -1,    -1,    -1,    -1,    -1,    48,    49,     6,    -1,     8,
       9,    -1,    11,    12,    -1,    -1,    -1,    31,    32,    -1,
      -1,     6,    36,     8,     9,    39,    11,    12,    71,    72,
      73,    74,    31,    32,    48,    49,     6,    -1,     8,     9,
      39,    11,    12,    -1,    -1,    -1,    31,    32,    -1,    48,
      49,    -1,    -1,    -1,    -1,    -1,    -1,    71,    72,    73,
      74,    31,    32,    -1,     6,    -1,     8,     9,    -1,    11,
      12,    -1,    71,    72,    73,    74,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    71,    72,    73,    31,
      32,     6,    -1,     8,     9,    -1,    11,    12,    -1,    -1,
      -1,    71,    72,    73,    -1,    -1,    -1,    -1,     6,    -1,
       8,     9,    -1,    11,    12,    -1,    31,    32,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,
      72,    73,   227,    31,    32,    -1,    -1,    -1,    -1,    -1,
     235,   236,   237,   238,   239,   240,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    71,    72,    73,    -1,
      -1,    -1,    -1,    -1,     6,    -1,     8,     9,    -1,    11,
      12,    -1,    -1,    71,    72,    73,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   227,    -1,    -1,   230,    -1,    31,
      32,    -1,   235,   236,   237,   238,   239,   240,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     6,
      -1,     8,     9,   227,    11,    12,   230,    -1,    -1,    -1,
      -1,   235,   236,   237,   238,   239,   240,    -1,   227,    71,
      72,    73,    -1,    -1,    31,    32,   235,   236,   237,   238,
     239,   240,   227,    -1,   229,    -1,   231,   232,   233,    -1,
     235,   236,   237,   238,   239,   240,    -1,   227,    -1,   229,
      -1,   231,   232,   233,    -1,   235,   236,   237,   238,   239,
     240,    -1,    -1,    -1,    71,    72,    73,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   227,    -1,   229,    -1,   231,
     232,    -1,    -1,   235,   236,   237,   238,   239,   240,    -1,
      -1,    -1,    -1,    -1,   219,   220,    -1,    -1,     6,    -1,
       8,     9,   227,    11,    12,    -1,    -1,    -1,    -1,    -1,
     235,   236,   237,   238,   239,   240,    -1,    -1,    -1,   227,
      -1,    -1,   230,    31,    32,    -1,    -1,   235,   236,   237,
     238,   239,   240,     6,    -1,     8,     9,    -1,    11,    12,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,     6,    -1,     8,
       9,    -1,    11,    12,    -1,    -1,    -1,    -1,    31,    32,
      -1,    -1,    -1,    71,    72,    73,    -1,    -1,    -1,    -1,
      -1,    -1,    31,    32,    -1,   227,     6,    -1,     8,     9,
     232,    11,    12,   235,   236,   237,   238,   239,   240,    -1,
       6,    -1,     8,     9,    -1,    11,    12,    -1,    71,    72,
      73,    31,    32,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    71,    72,    73,    31,    32,    -1,    -1,     6,
     227,     8,     9,   230,    11,    12,    -1,    -1,   235,   236,
     237,   238,   239,   240,     6,    -1,     8,     9,    -1,    11,
      12,    71,    72,    73,    31,    32,    -1,    -1,     6,    -1,
       8,     9,    -1,    11,    12,    71,    72,    73,    -1,    31,
      32,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    31,    32,    -1,    -1,     6,    -1,     8,
       9,    -1,    11,    12,    71,    72,    73,    -1,    -1,    -1,
      -1,     6,    -1,     8,     9,    -1,    11,    12,    -1,    71,
      72,    73,    31,    32,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    71,    72,    73,    31,    32,    -1,   227,
     228,    -1,    -1,    -1,    -1,    -1,    -1,   235,   236,   237,
     238,   239,   240,    -1,     6,    -1,     8,     9,    -1,    11,
      12,    -1,    71,    72,    73,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   227,   228,    71,    72,    73,    31,
      32,    -1,   235,   236,   237,   238,   239,   240,   227,   228,
      -1,    -1,    -1,    -1,    -1,    -1,   235,   236,   237,   238,
     239,   240,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   227,   228,    71,
      72,    73,    -1,    -1,    -1,   235,   236,   237,   238,   239,
     240,   227,   228,    -1,    -1,    -1,    -1,    -1,    -1,   235,
     236,   237,   238,   239,   240,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     227,   228,    -1,    -1,    -1,    -1,    -1,    -1,   235,   236,
     237,   238,   239,   240,    -1,   227,   228,    -1,    -1,    -1,
      -1,    -1,    -1,   235,   236,   237,   238,   239,   240,   227,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   235,   236,   237,
     238,   239,   240,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   227,     3,
       4,     5,     6,     7,    -1,    -1,   235,   236,   237,   238,
     239,   240,   227,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     235,   236,   237,   238,   239,   240,    -1,    -1,    -1,    33,
      34,    35,    36,    37,    38,    39,    40,    41,    42,    43,
      44,    45,    46,    47,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    -1,   227,     6,     7,    -1,    -1,
      -1,    -1,    -1,   235,   236,   237,   238,   239,   240,    -1,
      74,    -1,    76,    77,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    33,    34,    35,    36,    37,    38,    39,
      40,    41,    42,    43,    44,    45,    46,    47,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,     6,     7,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    74,    -1,    76,    77,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    33,    34,    35,    36,    37,
      38,    39,    40,    41,    42,    43,    44,    45,    46,    47,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    74,    -1,    -1,    -1,
      -1,    -1,    97,    -1,    99,    -1,    -1,    -1,   103,    -1,
      -1,    -1,    -1,   108,    -1,    -1,    88,   112,    -1,    -1,
     204,     7,    -1,    -1,    -1,    97,    98,    -1,   100,   101,
      -1,   103,   104,   105,   129,   130,   108,   132,    -1,    -1,
      -1,    -1,    -1,   227,    -1,    -1,    -1,    33,    -1,    -1,
     122,    -1,   236,    39,    40,    41,    42,    43,    44,    45,
      46,    47,    48,    49,    50,    -1,    52,    53,    54,    55,
      56,    57,    -1,    -1,   204,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,     6,     7,    -1,    -1,    74,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   227,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   236,    -1,    -1,    -1,
      -1,    33,    34,    35,    36,    37,    38,    39,    40,    41,
      42,    43,    44,    45,    46,    47,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,     6,     7,    -1,   234,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   227,
     228,   229,    74,    -1,    -1,    77,   251,    -1,   236,    -1,
      -1,    -1,    -1,    33,    34,    35,    36,    37,    38,    39,
      40,    41,    42,    43,    44,    45,    46,    47,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,     6,     7,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    74,    -1,    -1,    77,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    33,    34,    35,    36,    37,
      38,    39,    40,    41,    42,    43,    44,    45,    46,    47,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
       6,     7,    -1,    -1,    -1,    -1,    -1,   233,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    74,    -1,    -1,    77,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    33,    34,    35,
      36,    37,    38,    39,    40,    41,    42,    43,    44,    45,
      46,    47,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,     7,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   227,    -1,    -1,    74,    -1,
      -1,    -1,    -1,    -1,   236,    -1,    -1,    -1,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,     7,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   227,    -1,    74,
      -1,    -1,    -1,    -1,    -1,    -1,   236,    -1,    -1,    33,
      -1,    -1,    -1,    -1,    -1,    39,    40,    41,    42,    43,
      44,    45,    46,    47,    48,    49,    50,    -1,    52,    53,
      54,    55,    56,    57,    -1,     7,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   227,
      74,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   236,    -1,
      -1,    33,    34,    35,    36,    37,    38,    39,    40,    41,
      42,    43,    44,    45,    46,    47,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    -1,     6,     7,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   227,    74,    -1,    -1,    77,    -1,    -1,    -1,    -1,
     236,    -1,    -1,    -1,    33,    34,    35,    36,    37,    38,
      39,    40,    41,    42,    43,    44,    45,    46,    47,    48,
      49,    50,    51,    52,    53,    54,    55,    56,    57,     7,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   227,   228,   229,    74,    -1,    -1,    -1,    -1,
      -1,   236,    -1,    -1,    -1,    33,    34,    35,    36,    37,
      38,    39,    40,    41,    42,    43,    44,    45,    46,    47,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      -1,    -1,    -1,    -1,    -1,    -1,    81,    82,    83,    -1,
      -1,    -1,    -1,    88,    -1,    -1,    74,    -1,    -1,   233,
      -1,    -1,    97,    98,    99,   100,   101,    -1,   103,   104,
     105,    -1,    -1,   108,    -1,    -1,    -1,   112,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   122,    -1,    -1,
      -1,    -1,    -1,    -1,   129,   130,    -1,   132,    -1,    81,
      82,    83,   137,   138,    -1,    -1,    88,    -1,    -1,    -1,
     232,   146,   147,   148,   149,    97,    98,    99,   100,   101,
      -1,   103,   104,   105,    -1,    -1,   108,    -1,    82,    83,
     112,   166,    -1,    -1,    88,    -1,    -1,    -1,    -1,   174,
     122,    -1,    -1,    97,    98,    99,   100,   101,    -1,   103,
     104,   105,    -1,    -1,   108,   137,   138,    -1,   112,   228,
      -1,    -1,    -1,    -1,   146,   147,   148,   149,   122,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    81,    82,
      83,    -1,    -1,    -1,   166,    88,    -1,    -1,    -1,   224,
      -1,    -1,   174,    -1,    97,    98,    99,   100,   101,   234,
     103,   104,   105,    -1,    -1,   108,    -1,    -1,    -1,   112,
     228,    79,    80,    -1,    82,    -1,   251,    -1,    -1,   122,
      -1,    89,    -1,    91,    92,    93,    -1,    95,    -1,    -1,
      -1,    81,    -1,    -1,   137,   138,    -1,    -1,    -1,   107,
      -1,   109,   224,    -1,    -1,    -1,   149,    97,    98,    99,
     100,    -1,   234,   103,    -1,    -1,    -1,   125,   108,    -1,
      -1,    -1,   112,   166,    -1,    -1,   134,   135,    -1,   251,
     224,   174,    -1,    -1,    -1,    -1,   144,   145,    -1,   129,
     130,    -1,   132,    -1,    81,   153,    -1,   137,   138,    -1,
      -1,    88,    -1,    -1,    -1,    -1,   146,   147,   148,   149,
      97,    98,    -1,   100,   101,    -1,   103,   104,   105,    -1,
      -1,   108,    81,    82,    83,    -1,   166,    -1,    -1,    -1,
      -1,   224,    81,   191,   174,   122,    -1,    -1,    97,    98,
      99,   234,    -1,    -1,   103,    -1,    -1,    81,    97,    98,
     137,   138,    -1,   112,    -1,    -1,    -1,    -1,   251,   108,
     147,    -1,   149,    97,    98,    99,   100,    -1,    -1,   103,
     129,   130,    -1,   132,   108,    -1,    -1,    -1,   112,   166,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   174,   137,   138,
      -1,    -1,    -1,    -1,   234,    -1,    -1,    -1,   147,    -1,
     149,    -1,    -1,   137,   138,    -1,    -1,    -1,    -1,    -1,
      -1,   251,   146,   147,   148,   149,    -1,   166,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   174,    -1,    -1,    -1,    -1,
      -1,    -1,   166,    82,    83,    -1,    -1,    -1,    -1,    88,
     174,    -1,    -1,    -1,    -1,    -1,    -1,   234,    97,    98,
      99,   100,   101,    -1,   103,   104,   105,    -1,    -1,   108,
      -1,    -1,    -1,   112,   251,   224,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   122,    -1,   234,    -1,    -1,    -1,    -1,
     129,   130,    -1,   132,    -1,   234,    -1,    -1,    82,    83,
      -1,    -1,   251,    -1,    88,    -1,    -1,   146,   147,   148,
     234,    -1,   251,    97,    98,    99,   100,   101,    -1,   103,
     104,   105,    -1,    -1,   108,    -1,    -1,   251,   112,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    82,    83,   122,    -1,
      -1,    -1,    88,    -1,    -1,   129,   130,    -1,   132,    -1,
      -1,    97,    98,    99,   100,   101,    -1,   103,   104,   105,
      -1,    -1,   108,    -1,   148,    -1,   112,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   122,    -1,    -1,    -1,
      -1,    82,    83,   129,   130,   224,   132,    88,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   234,    97,    98,    99,   100,
     101,    -1,   103,   104,   105,    -1,    -1,   108,    -1,    82,
      83,   112,   251,    -1,    -1,    88,    -1,    -1,    -1,    -1,
      -1,   122,    -1,    -1,    97,    98,    99,   100,   101,    -1,
     103,   104,   105,    -1,    -1,   108,    -1,    -1,    -1,   112,
     224,    -1,    82,    83,    -1,   146,   147,   148,    88,   122,
     234,    -1,    -1,    -1,    -1,    -1,    -1,    97,    98,    99,
     100,   101,    -1,   103,   104,   105,    -1,   251,   108,    -1,
      -1,    -1,   112,    -1,    -1,   148,    -1,    -1,   224,    -1,
      -1,    -1,   122,    -1,    -1,    -1,    -1,    -1,   234,    97,
      98,    99,   100,    -1,    -1,   103,    -1,    -1,    -1,    -1,
     108,    -1,    -1,    -1,   112,   251,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   129,   130,   224,   132,    81,    82,    83,    -1,    -1,
      -1,    -1,    88,   234,    -1,    -1,    -1,    -1,   146,   147,
     148,    97,    98,    99,   100,   101,    -1,   103,   104,   105,
     251,   224,   108,    -1,    -1,    -1,   112,    -1,    -1,    -1,
      -1,   234,   116,   117,   118,   119,   122,    -1,    -1,    -1,
      -1,    -1,    -1,   129,   130,    -1,   132,    -1,   251,    -1,
      -1,   137,   138,    -1,   224,    -1,    -1,    -1,    -1,    -1,
     146,   147,   148,   149,   234,    -1,    -1,    81,    82,    83,
     154,    -1,    -1,    -1,    88,    -1,   160,    -1,    -1,   163,
     166,   251,    -1,    97,    98,    99,   100,   101,   174,   103,
     104,   105,    -1,    -1,   108,    -1,   234,    -1,   112,    -1,
      -1,    -1,   186,   187,   188,    -1,    -1,    -1,   122,   193,
     194,   195,    -1,   251,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   137,   138,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   146,   147,   148,   149,    -1,    -1,   224,    81,
      82,    83,    -1,    -1,    -1,    -1,    88,    -1,    -1,    -1,
     234,    -1,   166,    -1,    -1,    97,    98,    99,   100,   101,
     174,   103,   104,   105,    -1,    -1,   108,   251,    -1,    -1,
     112,    82,    83,    -1,    -1,    -1,    -1,    88,    -1,    -1,
     122,    -1,    -1,    -1,    -1,    -1,    97,    98,    99,   100,
     101,    -1,   103,   104,   105,   137,   138,   108,    -1,    -1,
      -1,   112,    -1,    -1,    -1,    -1,    -1,   149,    -1,    -1,
     224,   122,    -1,    -1,    -1,    -1,    -1,    -1,   129,   130,
      -1,   132,    -1,    -1,   166,    82,    83,    -1,    -1,    -1,
      -1,    88,   174,    -1,    -1,   146,   147,   148,    -1,    -1,
      97,    98,    99,   100,   101,    -1,   103,   104,   105,    -1,
      -1,   108,    -1,    -1,    -1,   112,    -1,    -1,    -1,    -1,
      -1,    -1,    82,    83,    -1,   122,    -1,    -1,    88,    -1,
      -1,    -1,   129,   130,    -1,   132,    -1,    97,    98,    99,
     100,   101,   224,   103,   104,   105,    -1,    -1,   108,    -1,
      -1,   148,   112,    -1,    -1,    -1,    -1,    -1,    -1,    82,
      83,    -1,   122,    -1,    -1,    88,    -1,    -1,    -1,   129,
     130,    -1,   132,   224,    97,    98,    99,   100,   101,    -1,
     103,   104,   105,    -1,    -1,   108,    82,    83,    -1,   112,
      -1,    -1,    88,    -1,    -1,    -1,    -1,    -1,    -1,   122,
      -1,    97,    98,    99,   100,   101,    -1,   103,   104,   105,
      -1,    -1,   108,    -1,    -1,    -1,   112,    -1,    78,    79,
      80,    -1,    82,   146,   147,   148,   122,   224,    -1,    -1,
      -1,    91,    -1,    93,    94,    95,    96,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   107,    -1,   109,
      -1,   111,   148,    -1,    -1,   115,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   224,   125,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   134,   135,   136,    -1,    -1,   139,
     140,   141,   142,    -1,   144,   145,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   153,    -1,   155,    -1,   157,   158,    -1,
      -1,   224,    -1,   163,   164,   165,    -1,    -1,   168,   169,
      -1,    -1,    -1,    -1,   116,   117,   118,   119,    -1,    -1,
      -1,   181,    78,    79,    80,    -1,    82,    -1,   224,    -1,
      -1,   191,    -1,    -1,    -1,    91,   196,    93,    94,    95,
      96,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   107,   154,   109,    -1,   111,    -1,    -1,   160,   115,
      -1,   163,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   125,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   134,   135,
     136,    -1,    -1,    -1,   186,   187,   188,    -1,   144,   145,
      -1,   193,   194,   195,   150,   151,   152,   153,    -1,   155,
      -1,   157,   158,    -1,    -1,    78,    79,    80,    -1,    82,
      -1,    -1,   168,   169,    -1,    -1,    -1,    90,    91,    -1,
      93,    94,    95,    96,    -1,   181,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   107,   191,   109,    -1,   111,    -1,
     196,    -1,   115,    97,    98,    99,   100,    -1,    -1,   103,
      -1,    -1,   125,    -1,   108,    -1,    -1,    -1,   112,    -1,
      -1,   134,   135,   136,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   144,   145,    -1,    -1,   129,   130,    -1,   132,    -1,
     153,    -1,   155,    -1,   157,   158,    -1,    -1,    -1,    -1,
      -1,    -1,   146,   147,   148,   168,   169,    78,    79,    80,
      -1,    82,    -1,   176,   177,    -1,    -1,    -1,   181,    -1,
      91,    92,    93,    94,    95,    96,    -1,    -1,   191,    -1,
      -1,    -1,    -1,   196,    -1,    -1,   107,    -1,   109,    -1,
     111,    -1,    -1,    -1,   115,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   125,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   133,   134,   135,   136,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   144,   145,    78,    79,    80,    -1,    82,
      -1,    -1,   153,    -1,   155,    -1,   157,   158,    91,    -1,
      93,    94,    95,    96,    -1,    -1,    -1,   168,   169,    -1,
      -1,    -1,    -1,    -1,   107,    -1,   109,    -1,   111,    -1,
     181,    -1,   115,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     191,    -1,   125,    -1,    -1,   196,    -1,    -1,    -1,    -1,
      -1,   134,   135,   136,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   144,   145,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     153,    -1,   155,    -1,   157,   158,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   168,   169,    78,    79,    80,
      -1,    82,    -1,   176,   177,    -1,    -1,    -1,   181,    -1,
      91,    -1,    93,    94,    95,    96,    -1,    -1,   191,    -1,
      -1,    -1,    -1,   196,    -1,    -1,   107,    -1,   109,    -1,
     111,    -1,    -1,    -1,   115,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   125,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   134,   135,   136,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   144,   145,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   153,    -1,   155,    -1,   157,   158,    -1,    -1,
      -1,   162,    -1,    79,    80,    -1,    82,   168,   169,    78,
      79,    80,    -1,    82,    -1,    91,    92,    93,    -1,    95,
     181,    -1,    91,    -1,    93,    94,    95,    96,    -1,    -1,
     191,   107,    -1,   109,    -1,   196,    -1,    -1,   107,    -1,
     109,    -1,   111,    -1,    -1,    -1,   115,    -1,    -1,   125,
      -1,    -1,    -1,    -1,    -1,    -1,   125,    -1,   134,   135,
      -1,    -1,    -1,    -1,    -1,   134,   135,   136,   144,   145,
      -1,    -1,    -1,    -1,    -1,   144,   145,   153,    79,    80,
      -1,    82,    -1,    -1,   153,    -1,   155,    -1,   157,   158,
      91,    92,    93,    94,    95,    96,    -1,    -1,    -1,   168,
     169,    -1,    -1,    -1,    -1,    -1,   107,    -1,   109,    -1,
     111,    -1,   181,    -1,   115,   191,    -1,    -1,    -1,    -1,
      -1,    -1,   191,    -1,   125,    -1,    -1,   196,    -1,    -1,
      -1,    81,    -1,   134,   135,   136,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   144,   145,    -1,    -1,    97,    98,    99,
     100,    -1,   153,   103,   155,    -1,   157,    -1,   108,    -1,
      -1,    -1,   112,    -1,    -1,    -1,    -1,   168,   169,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   129,
     130,    -1,   132,    -1,    81,    -1,    -1,   137,   138,    -1,
     191,    88,    -1,    -1,    -1,   196,   146,   147,   148,   149,
      97,    98,    -1,   100,   101,    -1,   103,   104,   105,    -1,
      -1,   108,    -1,    -1,    -1,    81,   166,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   174,   122,    -1,    -1,    -1,    -1,
      -1,    97,    98,    99,   100,    -1,    -1,   103,    81,    -1,
     137,   138,   108,    -1,    -1,    -1,   112,    -1,    -1,    -1,
     147,    -1,   149,    -1,    97,    98,    -1,   100,   101,    -1,
     103,    -1,    -1,    -1,    -1,   108,    -1,    -1,    -1,   166,
      -1,   137,   138,    -1,    -1,    -1,    -1,   174,    -1,     7,
     146,   147,   148,   149,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   137,   138,    -1,    -1,    -1,    -1,
     166,    -1,    -1,   146,   147,    33,   149,     7,   174,    -1,
      -1,    -1,    40,    41,    42,    43,    44,    45,    46,    47,
      -1,    -1,    50,   166,    52,    53,    54,    55,    56,    57,
      -1,   174,    -1,    33,    34,    35,    36,    37,    38,    39,
      40,    41,    42,    43,    44,    45,    46,    47,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,     7,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    74,    -1,    -1,    77,    -1,    -1,
      -1,    -1,    -1,    -1,    33,    34,    35,    36,    37,    38,
      39,    40,    41,    42,    43,    44,    45,    46,    47,    48,
      49,    50,    51,    52,    53,    54,    55,    56,    57,    58,
       7,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    74,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    33,    34,    35,    36,
      37,    38,    39,    40,    41,    42,    43,    44,    45,    46,
      47,    48,    49,    50,    51,    52,    53,    54,    55,    56,
      57,     7,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    74,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    33,    -1,    -1,
      -1,    -1,    -1,    39,    40,    41,    42,    43,    44,    45,
      46,    47,    48,    49,    50,    -1,    52,    53,    54,    55,
      56,    57,   144,    -1,    -1,    -1,    -1,    -1,   150,    -1,
     152,    -1,   154,    -1,    -1,    -1,    -1,    -1,    74,    -1,
      -1,    -1,    -1,    -1,   166,    -1,   168,    -1,   170,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   178,    -1,   180,    -1,
     182,    -1,   184,    -1,   186,    -1,   188,    -1,   190,    -1,
     192,    -1,   194,    -1,    -1,    -1,   198
};

  /* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
     symbol of state STATE-NUM.  */
static const yytype_int16 yystos[] =
{
       0,     3,     4,     5,     6,     7,    33,    34,    35,    36,
      37,    38,    39,    40,    41,    42,    43,    44,    45,    46,
      47,    48,    49,    50,    51,    52,    53,    54,    55,    56,
      57,    74,    76,    77,   204,   227,   236,   253,   277,   278,
     282,   284,   285,   286,   293,   299,   302,   303,   304,   305,
     306,   315,   333,   334,   335,   336,   339,   356,   422,   423,
     424,   483,   484,   486,   618,   642,   646,   689,   691,   701,
     702,     6,     8,     9,    11,    12,    31,    32,    71,    72,
      73,   227,   235,   236,   237,   238,   239,   240,   255,   256,
     257,   259,   260,   261,   262,   263,   264,   265,   266,   267,
     268,   269,   270,   271,   272,   273,   275,     6,    59,    60,
      61,    63,    64,    65,    66,    67,    68,    69,    70,    75,
      76,    77,   204,   232,   250,   275,   277,   278,   321,   323,
     324,   326,   327,   328,   329,   330,   331,   332,   343,   360,
     361,   363,   364,   380,   381,   394,   395,   401,   402,   407,
     408,   427,   428,   431,   432,   435,   436,   452,   454,   458,
     461,   464,   467,   493,   494,   502,   503,   508,   509,   512,
     513,   516,   517,   520,   521,   524,   525,   528,   529,   532,
     533,   536,   537,   540,   541,   544,   545,   548,   549,   552,
     553,   556,   557,   560,   561,   564,   565,   580,   581,   584,
     585,   588,   589,   590,   591,   595,   596,   597,   598,   604,
     605,   606,   615,   616,   627,   630,   631,   632,   639,   641,
     681,   682,   683,   688,   689,   697,   698,   701,   706,   707,
     333,   227,   354,   355,   356,    78,   133,   158,   181,   205,
     223,   304,   302,   306,   307,     0,   250,   279,   280,   282,
     283,   304,   338,   341,   278,   278,   354,   278,   278,   355,
     227,   229,   305,   334,    77,   278,   335,   358,   424,   277,
     335,   357,   359,   278,   282,   336,   227,   259,   259,   227,
     259,   227,   227,   227,   227,   275,   285,   296,   302,   312,
       9,    10,    11,    12,   227,   229,   231,    21,    22,    23,
      24,    25,    26,    27,    28,    29,    30,   249,   274,   259,
     261,   236,   241,   242,   237,   238,    13,    14,    15,    16,
     243,   244,    17,    18,   235,   245,   246,    19,    20,   247,
     234,   248,   272,   276,   248,   227,   227,   227,    77,   204,
     321,   227,     6,   250,   250,   250,   275,    49,    51,    67,
     227,   344,   345,   346,    79,    80,    82,    91,    92,    93,
      94,    95,    96,   107,   109,   111,   115,   125,   134,   135,
     136,   144,   145,   153,   155,   157,   168,   169,   191,   196,
     109,   206,   211,   224,   708,   233,   325,   250,   304,   327,
     321,   362,   331,   232,   398,   362,   331,   331,   331,   362,
     453,   362,   331,   331,   331,   362,   362,   362,   331,   331,
     331,   331,   331,   331,   331,   331,   331,   362,   331,   398,
     362,   362,   362,   321,   362,   362,     6,   360,   688,   272,
     312,     6,   232,   315,   356,   643,   103,   125,   140,   173,
     227,   251,   487,   488,     6,   182,   183,   184,   185,   189,
     619,   620,   621,   622,   623,   624,   626,   692,   703,   228,
     302,   306,   234,   250,   337,   340,   249,    75,   353,   355,
     324,   277,   342,     6,   232,   315,     6,   228,   278,   308,
     309,   310,   311,    36,   230,   236,   273,   307,   133,    77,
     357,   485,   282,   690,   312,   312,   312,   273,   312,   312,
     228,   296,   227,   229,   306,   313,   314,   296,   228,     6,
     315,   258,   273,   275,     6,   315,   273,   261,   261,   261,
     262,   262,   263,   263,   264,   264,   264,   264,   265,   265,
     266,   267,   268,   269,   270,   275,   273,   354,   248,    77,
     321,   322,   361,   275,   275,   275,    64,   250,   275,   277,
     250,   250,   227,   255,   344,   346,    80,   107,   365,   396,
     149,   633,   635,   636,   403,   251,   227,   251,   592,   251,
     607,   154,   163,   186,   187,   188,   227,   251,   609,   610,
     611,   612,   613,   614,   628,   125,   382,   566,   251,   251,
     409,    79,   144,   455,   437,    81,   108,   137,   140,   141,
     149,   384,   439,   465,   466,   478,   479,   481,   571,   665,
     145,   495,    79,   125,   504,   599,    79,    80,   107,   153,
     640,   640,   138,   384,   439,   441,   459,   460,   571,   665,
     384,   439,   441,   462,   463,   571,   665,   192,   475,   617,
     199,   202,   203,   468,   469,   470,   472,   474,   699,   251,
     684,   227,   251,   326,   355,    77,   362,   399,   400,   362,
     227,   228,   228,   232,     6,   254,   300,   301,   232,   227,
     227,   425,   489,   490,     6,   673,   674,   234,   251,   488,
     227,   373,   373,   373,   227,   373,   234,   251,   620,   693,
     227,   280,   324,   342,   281,   227,   355,   277,   324,   232,
     233,   287,   232,   227,   304,   306,   313,   228,   234,   228,
     234,   273,   307,   230,   230,    36,   230,   236,   273,   159,
     243,   228,   228,   228,   234,   234,   234,   228,   308,   313,
     230,   236,   273,   314,   227,   229,   232,   261,   228,   234,
     230,   248,   321,   322,   228,   228,   228,   227,   250,   275,
     250,   250,   275,   255,   228,   248,   586,   125,   582,    88,
      97,    98,   100,   101,   103,   104,   105,   122,   234,   251,
     366,   374,   376,   378,   652,   653,   655,   659,   661,   665,
     679,    99,   234,   251,   384,   397,   653,   655,   657,   661,
     227,   125,   172,   234,   251,   634,   149,   234,   251,   636,
     106,   234,   251,   384,   404,   405,   653,   655,     6,   160,
     251,   593,   116,   117,   118,   119,   193,   194,   195,   234,
     251,   593,   608,   609,   373,   373,   373,   373,   373,   228,
     629,   251,   251,   609,   429,    82,    83,   112,   224,   234,
     251,   383,   384,   385,   386,   388,   653,   655,   657,   661,
     668,   710,   110,   113,   114,   170,   178,   234,   251,   567,
     568,   571,   576,   652,   653,   655,   659,   665,   129,   130,
     132,   234,   251,   410,   411,   412,   417,   419,   653,   657,
     661,   665,   668,   107,   526,   145,   522,   147,   166,   174,
     234,   251,   384,   439,   441,   449,   450,   456,   457,   497,
     571,   653,   655,   665,   167,   234,   251,   438,   439,   441,
     447,   665,   227,   227,   440,   480,   482,   227,   234,   251,
     466,    79,   125,   530,   146,   234,   251,   496,   497,   500,
     652,   653,   655,   659,   661,   107,   510,   148,   234,   251,
     505,   506,   653,   655,   657,   668,   179,   234,   251,   600,
     234,   251,   665,   251,   227,   234,   251,   460,   234,   251,
     463,   476,   251,   227,   227,   227,   234,   251,   469,    61,
     110,   160,   208,   209,   210,   222,   234,   251,   700,   685,
     255,   233,    89,    77,   233,   400,   362,   258,   300,   354,
     233,   234,   300,     6,   645,     6,    19,    20,   120,   121,
     235,   236,   237,   238,   245,   246,   649,   126,   127,   128,
     131,   234,   251,   414,   415,   417,   419,   426,   227,   491,
     227,   492,   229,   675,   228,   234,   488,    78,    79,    80,
      82,    91,    93,    94,    95,    96,   107,   109,   111,   115,
     125,   134,   135,   136,   144,   145,   153,   155,   157,   158,
     168,   169,   181,   191,   196,   371,   371,   372,   620,   103,
     150,   151,   152,   234,   251,   694,     6,   705,   324,   232,
     273,   316,   255,   289,   294,   295,   296,   291,    58,   310,
       6,   230,   273,   273,   230,   230,   251,   324,   312,     6,
     312,   228,   228,   230,   230,   228,   308,   230,   236,   273,
     229,   231,   316,   317,   318,   319,   320,   273,   272,   321,
     321,   321,   275,   228,   275,   250,   250,   275,   228,   275,
     250,   248,   229,   255,   347,   348,   234,   251,   378,   587,
     652,   653,   655,   657,   659,   661,   665,   433,   234,   251,
     378,   385,   583,   652,   653,   655,   657,   659,   661,   665,
     379,   654,   656,   660,   227,   227,   377,   375,   227,   366,
     658,   397,   162,   371,   372,   373,   373,   634,   227,   636,
     406,   404,   228,   594,   251,   373,   373,   373,   373,   373,
     373,   227,   608,   609,     6,   670,   251,   234,   251,   383,
     411,   430,   387,   227,   669,   227,   383,   373,   569,   373,
     570,   227,   567,   418,   420,   227,   410,   562,   234,   251,
     378,   384,   457,   497,   527,   571,   652,   653,   655,   659,
     661,   665,    79,   125,   538,   234,   251,   384,   457,   496,
     523,   571,   665,   498,   451,   227,   456,   448,   438,   371,
     371,   666,   227,   367,   227,   370,   370,   150,   151,   152,
     371,   575,   466,   107,   534,   234,   251,   497,   500,   505,
     531,   659,   661,   501,   496,   125,   514,   234,   251,   411,
     505,   511,   665,   227,   505,   227,   600,   665,   251,   139,
     140,   141,   142,   163,   164,   165,   371,   442,   444,   445,
     446,   460,   463,   367,   372,   372,   372,   469,   227,   227,
     227,   227,   700,   110,   212,   213,   214,   222,   234,   251,
     686,   228,   709,   251,   362,   228,   233,   234,   249,   233,
     301,   233,   234,   228,   234,   248,   416,   227,   426,     6,
     673,     6,   671,   672,   677,   229,   251,   674,   228,   248,
     248,     1,   154,   186,   188,   625,   227,   227,   227,   227,
     694,   228,   234,   317,   228,   294,   233,   295,   248,   250,
     283,   297,   298,   304,   294,   230,   230,   244,   228,   228,
     228,   228,   230,   230,   276,     6,   315,   233,   234,   316,
     249,   320,    62,   228,   321,   228,   228,   275,   228,   275,
     250,   321,   228,   228,   275,   248,     6,   227,   228,   234,
     248,   587,   234,   251,   411,   434,   583,   583,   227,   227,
     369,   369,   369,   372,   101,   180,   371,   649,   663,   664,
     369,   367,   372,   369,   234,   248,   234,   161,   371,   369,
     367,   372,   228,   234,   430,   227,   368,    90,   176,   177,
     371,   392,   393,   367,   255,   367,   367,   371,   649,   227,
     227,   413,   234,   251,   384,   457,   563,   571,   583,   527,
     107,   542,   234,   251,   384,   457,   531,   539,   571,   665,
     523,   367,   369,   372,   369,   248,   248,   275,     6,   275,
       6,   671,   234,   234,   572,   125,   546,   234,   251,   497,
     500,   511,   535,   659,   661,   531,   227,   499,   518,   234,
     251,   506,   515,   583,   511,   372,   371,   649,   251,     6,
     671,   234,   443,   200,   201,   473,   255,   197,   198,   471,
     275,   275,   219,   220,   236,   273,   273,   227,   227,   227,
     686,   234,   250,   233,   276,   233,   644,     6,   285,   650,
     227,   275,   248,   228,   248,   675,   228,   234,   248,   275,
     678,   676,   228,   228,   649,     6,   695,   696,   695,   695,
     704,     6,   233,   234,   233,   288,   276,   234,   250,   248,
     233,   230,   233,   316,   318,   321,   250,   321,   321,   228,
     321,   228,   228,   275,   321,   321,   228,   229,   255,   349,
     350,   230,   259,   348,   349,   434,   670,     6,   670,    88,
     100,   102,   234,   662,     1,    92,   123,   124,   190,   680,
     371,     6,   637,   638,   162,   228,   154,   187,   188,   477,
       6,     6,   275,   234,     1,    84,    85,    86,    87,    88,
     391,   234,   248,   228,   711,   234,   234,   577,   670,   670,
     275,   563,   125,   550,   234,   251,   384,   457,   535,   543,
     571,   539,   142,   228,   667,   228,   248,   228,   248,   228,
     575,   371,   248,   554,   234,   251,   497,   500,   515,   547,
     535,   273,   234,   251,   434,   506,   519,   515,    84,   234,
     234,   601,   228,   445,   248,   228,   228,   228,   228,   228,
     228,   228,   228,   228,   228,   273,   273,   215,   216,   687,
     275,   251,   234,   248,   670,   228,   673,   671,   672,   275,
     248,   230,   678,   248,   229,   228,   234,   228,   228,   251,
     233,   290,   354,   298,   276,   292,   316,   321,   321,   321,
     228,   321,     6,   227,   234,   248,   255,   228,   228,   248,
     228,   248,   228,   228,   228,   228,   664,   248,   228,   248,
     237,   238,   228,   234,   248,   251,   228,   248,   228,   390,
     228,   389,   393,   234,   649,   371,   248,   248,   421,   421,
     228,   558,   234,   251,   384,   457,   547,   551,   571,   543,
     248,   275,   275,   671,   573,   574,   671,   234,   251,   497,
     500,   519,   555,   547,   228,   234,   248,   519,   228,   507,
     649,   371,   248,   671,   228,   228,   234,   228,   228,   285,
     647,   228,   228,   228,   275,   230,   695,   247,   273,   696,
     354,   354,   321,   230,   275,   350,   255,   351,   227,   351,
     670,   671,   637,   262,   262,   637,   637,   228,   275,   275,
     234,   248,   275,   578,   579,   671,   275,   228,   228,   234,
     251,   384,   457,   555,   559,   571,   551,   175,   228,   228,
     228,   248,   248,   228,   555,   273,   273,   234,   602,   603,
     671,   228,   217,   218,   275,   228,     6,   230,   255,   228,
     234,   248,   259,   228,   228,   228,   228,   228,   228,   228,
     275,   228,   248,   248,   228,   559,   228,   671,   671,   248,
     228,   275,   248,   248,   228,   228,   230,   227,   255,     6,
     352,   228,   228,   671,   671,   228,   228,   273,   228,   671,
     671,   648,   275,   228,   234,   228,   228,   228,   228,   228,
     156,   651,   228,     6,   227,   251,     6,   227,   249,   258,
     272,   228,   228,   228
};

  /* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_int16 yyr1[] =
{
       0,   252,   253,   253,   253,   253,   254,   255,   255,   256,
     256,   256,   256,   257,   257,   257,   257,   257,   257,   257,
     257,   257,   257,   257,   258,   258,   258,   259,   259,   259,
     259,   259,   259,   259,   259,   259,   259,   260,   260,   260,
     260,   260,   260,   261,   261,   262,   262,   262,   262,   263,
     263,   263,   264,   264,   264,   265,   265,   265,   265,   265,
     266,   266,   266,   267,   267,   268,   268,   269,   269,   270,
     270,   271,   271,   272,   272,   273,   273,   274,   274,   274,
     274,   274,   274,   274,   274,   274,   274,   274,   275,   275,
     276,   277,   277,   277,   277,   277,   277,   277,   278,   278,
     278,   278,   278,   278,   278,   278,   279,   279,   280,   281,
     280,   282,   282,   283,   283,   283,   283,   284,   284,   284,
     284,   284,   285,   285,   285,   285,   285,   285,   285,   285,
     285,   285,   285,   285,   285,   285,   285,   285,   285,   287,
     288,   286,   286,   289,   290,   286,   291,   292,   286,   286,
     286,   293,   293,   294,   294,   295,   295,   296,   296,   296,
     296,   297,   297,   298,   298,   298,   299,   299,   299,   299,
     299,   299,   299,   299,   300,   300,   301,   301,   302,   302,
     302,   302,   303,   304,   304,   305,   305,   305,   305,   305,
     305,   305,   305,   305,   305,   305,   305,   305,   305,   306,
     306,   306,   306,   307,   307,   308,   308,   309,   309,   310,
     310,   310,   311,   311,   312,   312,   313,   313,   313,   314,
     314,   314,   314,   314,   314,   314,   314,   314,   314,   314,
     315,   316,   316,   316,   317,   317,   317,   317,   318,   319,
     319,   320,   320,   320,   321,   321,   321,   321,   321,   321,
     321,   321,   321,   321,   322,   322,   323,   323,   323,   324,
     325,   324,   326,   326,   327,   327,   327,   327,   328,   328,
     329,   329,   329,   330,   330,   330,   331,   331,   331,   331,
     331,   331,   331,   331,   331,   331,   331,   331,   332,   332,
     332,   332,   332,   333,   333,   334,   334,   334,   334,   334,
     335,   335,   337,   336,   338,   336,   340,   339,   341,   339,
     342,   342,   343,   343,   344,   344,   344,   344,   344,   345,
     345,   346,   346,   347,   347,   347,   348,   348,   349,   349,
     349,   350,   350,   351,   351,   352,   352,   353,   354,   354,
     355,   355,   356,   357,   357,   358,   359,   359,   360,   360,
     360,   360,   360,   360,   360,   360,   360,   360,   360,   360,
     360,   360,   360,   360,   360,   360,   360,   360,   360,   360,
     360,   360,   360,   360,   360,   360,   360,   360,   360,   360,
     360,   360,   361,   361,   361,   361,   361,   361,   361,   361,
     361,   361,   362,   363,   364,   365,   365,   365,   366,   366,
     366,   366,   366,   366,   366,   367,   367,   368,   368,   368,
     369,   369,   370,   370,   371,   371,   371,   371,   371,   371,
     371,   371,   371,   371,   371,   371,   371,   371,   371,   371,
     371,   371,   371,   371,   371,   371,   371,   371,   371,   371,
     371,   371,   372,   372,   373,   373,   373,   375,   374,   377,
     376,   378,   378,   378,   379,   378,   380,   381,   382,   382,
     382,   383,   383,   383,   383,   383,   383,   384,   384,   385,
     385,   385,   385,   386,   387,   386,   388,   389,   388,   390,
     388,   391,   391,   391,   391,   391,   391,   392,   392,   392,
     393,   393,   393,   394,   395,   396,   396,   396,   397,   397,
     397,   397,   397,   398,   399,   399,   399,   400,   401,   402,
     403,   403,   403,   404,   404,   404,   404,   406,   405,   407,
     408,   409,   409,   409,   410,   410,   410,   410,   410,   410,
     411,   411,   411,   413,   412,   414,   414,   416,   415,   418,
     417,   420,   419,   421,   421,   422,   423,   423,   424,   425,
     425,   425,   426,   426,   426,   426,   426,   427,   428,   429,
     429,   429,   430,   430,   431,   432,   433,   433,   433,   434,
     434,   435,   436,   437,   437,   437,   438,   438,   438,   438,
     440,   439,   442,   441,   443,   441,   444,   444,   445,   445,
     445,   446,   446,   446,   446,   446,   446,   448,   447,   449,
     451,   450,   453,   452,   454,   455,   455,   455,   456,   456,
     456,   456,   456,   456,   456,   457,   457,   457,   457,   458,
     459,   459,   459,   460,   460,   460,   460,   460,   461,   462,
     462,   462,   463,   463,   463,   463,   463,   464,   465,   465,
     465,   466,   466,   466,   466,   466,   467,   468,   468,   468,
     469,   469,   469,   470,   471,   471,   472,   473,   473,   474,
     476,   475,   477,   477,   477,   478,   478,   480,   479,   482,
     481,   483,   483,   484,   485,   486,   486,   487,   487,   487,
     489,   488,   490,   488,   491,   491,   492,   492,   493,   494,
     495,   495,   495,   496,   496,   496,   496,   496,   496,   496,
     498,   497,   499,   499,   499,   501,   500,   502,   503,   504,
     504,   504,   505,   505,   505,   505,   505,   506,   507,   506,
     508,   509,   510,   510,   510,   511,   511,   511,   512,   513,
     514,   514,   514,   515,   515,   516,   517,   518,   518,   518,
     519,   519,   520,   521,   522,   522,   522,   523,   523,   523,
     523,   523,   524,   525,   526,   526,   526,   527,   527,   527,
     527,   527,   527,   527,   527,   527,   527,   527,   528,   529,
     530,   530,   530,   531,   531,   531,   531,   531,   532,   533,
     534,   534,   534,   535,   535,   535,   535,   535,   536,   537,
     538,   538,   538,   539,   539,   539,   539,   539,   540,   541,
     542,   542,   542,   543,   543,   543,   543,   544,   545,   546,
     546,   546,   547,   547,   547,   548,   549,   550,   550,   550,
     551,   551,   551,   551,   552,   553,   554,   554,   554,   555,
     555,   555,   556,   557,   558,   558,   558,   559,   559,   559,
     559,   560,   561,   562,   562,   562,   563,   563,   563,   563,
     564,   565,   566,   566,   566,   567,   567,   567,   567,   567,
     567,   567,   567,   569,   568,   568,   568,   570,   568,   572,
     571,   573,   571,   574,   571,   575,   575,   575,   577,   576,
     578,   576,   579,   576,   580,   581,   582,   582,   582,   583,
     583,   583,   583,   583,   583,   583,   583,   583,   584,   585,
     586,   586,   586,   587,   587,   587,   587,   587,   587,   587,
     587,   588,   589,   590,   591,   591,   591,   592,   594,   593,
     595,   596,   597,   598,   599,   599,   599,   601,   600,   602,
     600,   603,   600,   604,   605,   606,   607,   607,   607,   607,
     607,   608,   608,   608,   608,   608,   608,   608,   608,   609,
     609,   609,   609,   609,   610,   611,   612,   613,   614,   615,
     616,   617,   617,   618,   619,   619,   619,   620,   620,   620,
     620,   620,   620,   621,   622,   623,   624,   625,   625,   625,
     625,   626,   627,   627,   627,   627,   628,   629,   628,   630,
     630,   631,   632,   632,   633,   633,   633,   634,   634,   635,
     635,   635,   636,   636,   636,   637,   637,   638,   638,   638,
     639,   639,   639,   640,   640,   640,   640,   641,   643,   644,
     642,   645,   645,   647,   648,   646,   649,   649,   649,   649,
     649,   649,   649,   649,   649,   649,   649,   650,   650,   651,
     651,   651,   652,   652,   652,   654,   653,   656,   655,   658,
     657,   660,   659,   662,   661,   663,   663,   664,   664,   664,
     664,   666,   665,   667,   665,   669,   668,   670,   670,   671,
     671,   672,   672,   673,   673,   674,   674,   676,   675,   677,
     675,   678,   678,   678,   678,   678,   679,   680,   680,   680,
     680,   680,   681,   681,   682,   684,   683,   685,   685,   685,
     686,   686,   686,   686,   686,   687,   687,   687,   687,   688,
     688,   688,   688,   690,   689,   689,   692,   691,   693,   693,
     693,   694,   694,   694,   694,   695,   695,   696,   696,   696,
     697,   698,   699,   699,   699,   700,   700,   700,   700,   700,
     700,   700,   700,   700,   700,   701,   703,   704,   702,   705,
     705,   706,   706,   707,   708,   709,   708,   710,   711,   710
};

  /* YYR2[YYN] -- Number of symbols on the right hand side of rule YYN.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     1,     2,     2,     2,     1,     1,     2,     1,
       1,     1,     3,     1,     4,     4,     3,     3,     3,     3,
       2,     2,     6,     7,     0,     1,     3,     1,     2,     2,
       2,     2,     4,     4,     6,     6,     6,     1,     1,     1,
       1,     1,     1,     1,     4,     1,     3,     3,     3,     1,
       3,     3,     1,     3,     3,     1,     3,     3,     3,     3,
       1,     3,     3,     1,     3,     1,     3,     1,     3,     1,
       3,     1,     3,     1,     5,     1,     3,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     3,
       1,     2,     3,     1,     1,     1,     1,     1,     1,     2,
       1,     2,     1,     2,     1,     2,     1,     3,     1,     0,
       4,     1,     2,     1,     2,     2,     3,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     4,     4,     0,
       0,     8,     4,     0,     0,     9,     0,     0,     9,     3,
       3,     1,     1,     1,     2,     3,     2,     1,     2,     1,
       2,     1,     3,     1,     3,     2,     5,     6,     6,     6,
       7,     7,     3,     3,     1,     3,     2,     4,     1,     1,
       1,     1,     1,     1,     2,     1,     3,     3,     4,     4,
       5,     5,     6,     6,     4,     5,     4,     3,     4,     1,
       2,     2,     3,     1,     2,     1,     3,     1,     3,     2,
       1,     2,     1,     3,     1,     2,     1,     1,     2,     3,
       2,     3,     3,     4,     3,     4,     2,     3,     3,     4,
       1,     1,     3,     4,     1,     2,     3,     4,     2,     1,
       2,     3,     2,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     4,     4,     3,     2,
       0,     4,     1,     2,     1,     1,     1,     1,     1,     2,
       5,     7,     5,     5,     7,     1,     6,     7,     7,     7,
       8,     8,     8,     9,     6,     7,     7,     8,     3,     2,
       2,     2,     3,     1,     2,     1,     1,     1,     1,     1,
       1,     1,     0,     4,     0,     3,     0,     5,     0,     4,
       1,     2,     2,     3,     3,     5,     7,     9,    11,     1,
       2,     1,     1,     0,     1,     3,     7,     4,     0,     1,
       3,     7,     4,     1,     3,     1,     3,     4,     0,     1,
       1,     2,     1,     1,     1,     1,     1,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     2,     4,     0,     2,     3,     1,     1,
       1,     1,     1,     1,     1,     3,     5,     3,     4,     5,
       3,     5,     3,     5,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     0,     2,     0,     3,     4,     0,     3,     0,
       3,     1,     1,     1,     0,     5,     2,     4,     0,     2,
       3,     1,     1,     1,     1,     1,     1,     1,     5,     1,
       1,     1,     1,     1,     0,     3,     5,     0,     8,     0,
       7,     1,     1,     1,     1,     1,     1,     0,     2,     4,
       1,     1,     1,     2,     4,     0,     2,     3,     1,     1,
       1,     1,     1,     3,     1,     2,     3,     3,     2,     4,
       0,     2,     3,     1,     1,     1,     1,     0,     3,     2,
       4,     0,     2,     3,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     0,     5,     1,     1,     0,     5,     0,
       6,     0,     6,     0,     2,     2,     1,     2,     5,     0,
       2,     3,     4,     1,     1,     1,     1,     2,     5,     0,
       2,     3,     1,     1,     2,     6,     0,     2,     3,     1,
       1,     2,     4,     0,     2,     3,     1,     1,     1,     1,
       0,     3,     0,     5,     0,     7,     1,     3,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     0,     3,     7,
       0,     3,     0,     3,     4,     0,     2,     3,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     4,
       1,     2,     3,     1,     1,     1,     1,     1,     4,     1,
       2,     3,     1,     1,     1,     1,     1,     4,     1,     2,
       3,     1,     1,     1,     1,     1,     4,     1,     2,     3,
       1,     1,     1,     5,     1,     1,     5,     1,     1,     5,
       0,     3,     1,     1,     1,     1,     1,     0,     3,     0,
       3,     3,     1,     3,     3,     6,     4,     1,     2,     3,
       0,     3,     0,     3,     3,     5,     3,     5,     2,     4,
       0,     2,     3,     1,     1,     1,     1,     1,     1,     1,
       0,     3,     3,     5,     7,     0,     3,     2,     4,     0,
       2,     3,     1,     1,     1,     1,     1,     5,     0,     8,
       2,     5,     0,     2,     3,     1,     1,     1,     2,     6,
       0,     2,     3,     1,     1,     2,     7,     0,     2,     3,
       1,     1,     2,     5,     0,     2,     3,     1,     1,     1,
       1,     1,     2,     5,     0,     2,     3,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     2,     5,
       0,     2,     3,     1,     1,     1,     1,     1,     2,     6,
       0,     2,     3,     1,     1,     1,     1,     1,     2,     6,
       0,     2,     3,     1,     1,     1,     1,     1,     2,     7,
       0,     2,     3,     1,     1,     1,     1,     2,     7,     0,
       2,     3,     1,     1,     1,     2,     8,     0,     2,     3,
       1,     1,     1,     1,     2,     8,     0,     2,     3,     1,
       1,     1,     2,     9,     0,     2,     3,     1,     1,     1,
       1,     2,     6,     0,     2,     3,     1,     1,     1,     1,
       2,     4,     0,     2,     3,     1,     1,     1,     1,     1,
       1,     1,     1,     0,     3,     2,     2,     0,     3,     0,
       7,     0,     9,     0,     9,     1,     1,     1,     0,     7,
       0,     9,     0,     9,     2,     5,     0,     2,     3,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     2,     5,
       0,     2,     3,     1,     1,     1,     1,     1,     1,     1,
       1,     2,     3,     2,     3,     4,     5,     3,     0,     3,
       3,     3,     2,     4,     0,     2,     3,     0,     7,     0,
       9,     0,     9,     3,     2,     4,     0,     2,     3,     2,
       3,     2,     2,     2,     2,     2,     2,     5,     1,     1,
       1,     1,     1,     1,     2,     2,     2,     2,     2,     2,
       4,     0,     1,     4,     1,     2,     3,     1,     1,     1,
       1,     1,     1,     2,     2,     2,     2,     1,     1,     1,
       1,     5,     3,     4,     4,     5,     2,     0,     4,     2,
       1,     4,     8,     4,     0,     2,     3,     2,     2,     1,
       2,     3,     6,     8,     8,     1,     3,     1,     3,     3,
       4,     5,     6,     1,     1,     1,     1,     4,     0,     0,
       8,     1,     3,     0,     0,    14,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     3,     0,
       6,     7,     5,     5,     5,     0,     3,     0,     3,     0,
       3,     0,     3,     0,     7,     1,     3,     1,     1,     1,
       1,     0,     5,     0,     7,     0,     3,     1,     3,     1,
       3,     1,     2,     1,     3,     1,     2,     0,     5,     0,
       4,     3,     2,     1,     2,     1,     5,     1,     1,     1,
       1,     1,     1,     1,     3,     0,     5,     0,     2,     3,
       4,     4,     4,     1,     1,     1,     1,     3,     3,     1,
       1,     1,     1,     0,     6,     2,     0,     5,     0,     2,
       3,     4,     4,     4,     6,     1,     3,     1,     5,     4,
       6,     4,     0,     2,     3,     4,     4,     4,     4,     4,
       1,     1,     1,     4,     4,     1,     0,     0,     8,     1,
       3,     2,     2,     3,     4,     0,     7,     4,     0,     7
};


enum { YYENOMEM = -2 };

#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == YYEMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Backward compatibility with an undocumented macro.
   Use YYerror or YYUNDEF. */
#define YYERRCODE YYUNDEF


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)

/* This macro is provided for backward compatibility. */
# ifndef YY_LOCATION_PRINT
#  define YY_LOCATION_PRINT(File, Loc) ((void) 0)
# endif


# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Kind, Value); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo,
                       yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep)
{
  FILE *yyoutput = yyo;
  YYUSE (yyoutput);
  if (!yyvaluep)
    return;
# ifdef YYPRINT
  if (yykind < YYNTOKENS)
    YYPRINT (yyo, yytoknum[yykind], *yyvaluep);
# endif
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YYUSE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo,
                 yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep)
{
  YYFPRINTF (yyo, "%s %s (",
             yykind < YYNTOKENS ? "token" : "nterm", yysymbol_name (yykind));

  yy_symbol_value_print (yyo, yykind, yyvaluep);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp,
                 int yyrule)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       YY_ACCESSING_SYMBOL (+yyssp[yyi + 1 - yynrhs]),
                       &yyvsp[(yyi + 1) - (yynrhs)]);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, Rule); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args) ((void) 0)
# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif






/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg,
            yysymbol_kind_t yykind, YYSTYPE *yyvaluep)
{
  YYUSE (yyvaluep);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yykind, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YYUSE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/* Lookahead token kind.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;
/* Number of syntax errors so far.  */
int yynerrs;




/*----------.
| yyparse.  |
`----------*/

int
yyparse (void)
{
    yy_state_fast_t yystate = 0;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus = 0;

    /* Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* Their size.  */
    YYPTRDIFF_T yystacksize = YYINITDEPTH;

    /* The state stack: array, bottom, top.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss = yyssa;
    yy_state_t *yyssp = yyss;

    /* The semantic value stack: array, bottom, top.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs = yyvsa;
    YYSTYPE *yyvsp = yyvs;

  int yyn;
  /* The return value of yyparse.  */
  int yyresult;
  /* Lookahead symbol kind.  */
  yysymbol_kind_t yytoken = YYSYMBOL_YYEMPTY;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;



#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yychar = YYEMPTY; /* Cause a token to be read.  */
  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END
  YY_STACK_PRINT (yyss, yyssp);

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    goto yyexhaustedlab;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          goto yyexhaustedlab;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */

  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either empty, or end-of-input, or a valid lookahead.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token\n"));
      yychar = yylex ();
    }

  if (yychar <= YYEOF)
    {
      yychar = YYEOF;
      yytoken = YYSYMBOL_YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else if (yychar == YYerror)
    {
      /* The scanner already issued an error message, process directly
         to error recovery.  But do not keep the error token as
         lookahead, it is too special and may lead us to an endless
         loop in error recovery. */
      yychar = YYUNDEF;
      yytoken = YYSYMBOL_YYerror;
      goto yyerrlab1;
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  /* Discard the shifted token.  */
  yychar = YYEMPTY;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
  case 2: /* start_trick: translation_unit  */
#line 633 "../compiler/parser.y"
                                            { /* to avoid warnings */ }
#line 4426 "compiler/parser.c"
    break;

  case 3: /* start_trick: START_SYMBOL_EXPRESSION expression  */
#line 634 "../compiler/parser.y"
                                            { pastree_expr = (yyvsp[0].expr); }
#line 4432 "compiler/parser.c"
    break;

  case 4: /* start_trick: START_SYMBOL_BLOCKLIST block_item_list  */
#line 635 "../compiler/parser.y"
                                            { pastree_stmt = (yyvsp[0].stmt); }
#line 4438 "compiler/parser.c"
    break;

  case 5: /* start_trick: START_SYMBOL_TRANSUNIT translation_unit  */
#line 636 "../compiler/parser.y"
                                            { pastree_stmt = (yyvsp[0].stmt); }
#line 4444 "compiler/parser.c"
    break;

  case 6: /* enumeration_constant: IDENTIFIER  */
#line 654 "../compiler/parser.y"
    {
      symbol s = Symbol((yyvsp[0].name));
      if (checkDecls)
      {
        if ( symtab_get(stab, s, LABELNAME) )  /* NOT a type name */
          parse_error(-1, "enum symbol '%s' is already in use.", (yyvsp[0].name));
        symtab_put(stab, s, LABELNAME);
      }
      (yyval.symb) = s;
    }
#line 4459 "compiler/parser.c"
    break;

  case 7: /* string_literal: STRING_LITERAL  */
#line 675 "../compiler/parser.y"
    {
      (yyval.string) = strdup((yyvsp[0].name));
    }
#line 4467 "compiler/parser.c"
    break;

  case 8: /* string_literal: string_literal STRING_LITERAL  */
#line 679 "../compiler/parser.y"
    {
      /* Or we could leave it as is (as a SpaceList) */
      if (((yyvsp[-1].string) = realloc((yyvsp[-1].string), strlen((yyvsp[-1].string)) + strlen((yyvsp[0].name)))) == NULL)
        parse_error(-1, "string out of memory\n");
      strcpy(((yyvsp[-1].string))+(strlen((yyvsp[-1].string))-1),((yyvsp[0].name))+1);  /* Catenate on the '"' */
      (yyval.string) = (yyvsp[-1].string);
    }
#line 4479 "compiler/parser.c"
    break;

  case 9: /* primary_expression: IDENTIFIER  */
#line 702 "../compiler/parser.y"
    {
      symbol  id = Symbol((yyvsp[0].name));
      stentry e;
      
      /* The parser constructs the original AST; this is the only
       * place it doesn't (actually there is one more place, when replacing
       * the "main" function): threadprivate variables are replaced on the
       * fly by pointers. This makes the job of later stages much smoother,
       * but the produced AST is semantically incorrect.
       *
       * FIXME: handle threadprivate variables better
       */
      if (checkDecls && ((e = symtab_get(stab, id, IDNAME)) != NULL) 
                     && istp(e) && threadmode)
        (yyval.expr) = Parenthesis(Deref(Identifier(id)));
      else
        (yyval.expr) = Identifier(id);
    }
#line 4502 "compiler/parser.c"
    break;

  case 10: /* primary_expression: CONSTANT  */
#line 721 "../compiler/parser.y"
    {
      (yyval.expr) = Constant( strdup((yyvsp[0].name)) );
    }
#line 4510 "compiler/parser.c"
    break;

  case 11: /* primary_expression: string_literal  */
#line 725 "../compiler/parser.y"
    {
      (yyval.expr) = String((yyvsp[0].string));
    }
#line 4518 "compiler/parser.c"
    break;

  case 12: /* primary_expression: '(' expression ')'  */
#line 729 "../compiler/parser.y"
    {
      if ((yyvsp[-1].expr)->type == IDENT || (yyvsp[-1].expr)->type == CONSTVAL || (yyvsp[-1].expr)->type == STRING)
        (yyval.expr) = (yyvsp[-1].expr);   /* simplify */
      else
        (yyval.expr) = Parenthesis((yyvsp[-1].expr));
    }
#line 4529 "compiler/parser.c"
    break;

  case 13: /* postfix_expression: primary_expression  */
#line 755 "../compiler/parser.y"
    {
      /* It may be a simple identifier but don't check at this point */
      (yyval.expr) = (yyvsp[0].expr);
    }
#line 4538 "compiler/parser.c"
    break;

  case 14: /* postfix_expression: postfix_expression '[' expression ']'  */
#line 760 "../compiler/parser.y"
    {
      check_for_unknown_identifier((yyvsp[-3].expr));
      (yyval.expr) = ArrayIndex((yyvsp[-3].expr), (yyvsp[-1].expr));
    }
#line 4547 "compiler/parser.c"
    break;

  case 15: /* postfix_expression: postfix_expression '(' argument_expression_list ')'  */
#line 765 "../compiler/parser.y"
    {
      /* Don't check; allow for unknown function calls */
      (yyval.expr) = FunctionCall((yyvsp[-3].expr), (yyvsp[-1].expr));
    }
#line 4556 "compiler/parser.c"
    break;

  case 16: /* postfix_expression: postfix_expression '.' IDENTIFIER  */
#line 770 "../compiler/parser.y"
    {
      check_for_unknown_identifier((yyvsp[-2].expr));
      (yyval.expr) = DotField((yyvsp[-2].expr), Symbol((yyvsp[0].name)));
    }
#line 4565 "compiler/parser.c"
    break;

  case 17: /* postfix_expression: postfix_expression PTR_OP IDENTIFIER  */
#line 775 "../compiler/parser.y"
    {
      check_for_unknown_identifier((yyvsp[-2].expr));
      (yyval.expr) = PtrField((yyvsp[-2].expr), Symbol((yyvsp[0].name)));
    }
#line 4574 "compiler/parser.c"
    break;

  case 18: /* postfix_expression: postfix_expression '.' typedef_name  */
#line 785 "../compiler/parser.y"
    {
      check_for_unknown_identifier((yyvsp[-2].expr));
      (yyval.expr) = DotField((yyvsp[-2].expr), (yyvsp[0].symb));
    }
#line 4583 "compiler/parser.c"
    break;

  case 19: /* postfix_expression: postfix_expression PTR_OP typedef_name  */
#line 790 "../compiler/parser.y"
    {
      check_for_unknown_identifier((yyvsp[-2].expr));
      (yyval.expr) = PtrField((yyvsp[-2].expr), (yyvsp[0].symb));
    }
#line 4592 "compiler/parser.c"
    break;

  case 20: /* postfix_expression: postfix_expression INC_OP  */
#line 795 "../compiler/parser.y"
    {
      check_for_unknown_identifier((yyvsp[-1].expr));
      (yyval.expr) = PostOperator((yyvsp[-1].expr), UOP_inc);
    }
#line 4601 "compiler/parser.c"
    break;

  case 21: /* postfix_expression: postfix_expression DEC_OP  */
#line 800 "../compiler/parser.y"
    {
      check_for_unknown_identifier((yyvsp[-1].expr));
      (yyval.expr) = PostOperator((yyvsp[-1].expr), UOP_dec);
    }
#line 4610 "compiler/parser.c"
    break;

  case 22: /* postfix_expression: '(' type_name ')' '{' initializer_list '}'  */
#line 805 "../compiler/parser.y"
    {
      (yyval.expr) = CastedExpr((yyvsp[-4].decl), BracedInitializer((yyvsp[-1].expr)));
    }
#line 4618 "compiler/parser.c"
    break;

  case 23: /* postfix_expression: '(' type_name ')' '{' initializer_list ',' '}'  */
#line 809 "../compiler/parser.y"
    {
      (yyval.expr) = CastedExpr((yyvsp[-5].decl), BracedInitializer((yyvsp[-2].expr)));
    }
#line 4626 "compiler/parser.c"
    break;

  case 24: /* argument_expression_list: %empty  */
#line 817 "../compiler/parser.y"
    {
      (yyval.expr) = NULL;
    }
#line 4634 "compiler/parser.c"
    break;

  case 25: /* argument_expression_list: assignment_expression  */
#line 820 "../compiler/parser.y"
                          { (yyval.expr) = (yyvsp[0].expr); }
#line 4640 "compiler/parser.c"
    break;

  case 26: /* argument_expression_list: argument_expression_list ',' assignment_expression  */
#line 822 "../compiler/parser.y"
    {
      (yyval.expr) = CommaList((yyvsp[-2].expr), (yyvsp[0].expr));
    }
#line 4648 "compiler/parser.c"
    break;

  case 27: /* unary_expression: postfix_expression  */
#line 830 "../compiler/parser.y"
    { 
      check_for_unknown_identifier((yyvsp[0].expr));
      (yyval.expr) = (yyvsp[0].expr); 
    }
#line 4657 "compiler/parser.c"
    break;

  case 28: /* unary_expression: INC_OP unary_expression  */
#line 835 "../compiler/parser.y"
    {
      (yyval.expr) = PreOperator((yyvsp[0].expr), UOP_inc);
    }
#line 4665 "compiler/parser.c"
    break;

  case 29: /* unary_expression: DEC_OP unary_expression  */
#line 839 "../compiler/parser.y"
    {
      (yyval.expr) = PreOperator((yyvsp[0].expr), UOP_dec);
    }
#line 4673 "compiler/parser.c"
    break;

  case 30: /* unary_expression: unary_operator cast_expression  */
#line 843 "../compiler/parser.y"
    {
      if ((yyvsp[-1].type) == -1)
        (yyval.expr) = (yyvsp[0].expr);                    /* simplify */
      else
        (yyval.expr) = UnaryOperator((yyvsp[-1].type), (yyvsp[0].expr));
    }
#line 4684 "compiler/parser.c"
    break;

  case 31: /* unary_expression: SIZEOF unary_expression  */
#line 850 "../compiler/parser.y"
    {
      (yyval.expr) = Sizeof((yyvsp[0].expr));
    }
#line 4692 "compiler/parser.c"
    break;

  case 32: /* unary_expression: SIZEOF '(' type_name ')'  */
#line 854 "../compiler/parser.y"
    {
      (yyval.expr) = Sizeoftype((yyvsp[-1].decl));
    }
#line 4700 "compiler/parser.c"
    break;

  case 33: /* unary_expression: ALIGNOF '(' type_name ')'  */
#line 858 "../compiler/parser.y"
    {
      (yyval.expr) = Alignoftype((yyvsp[-1].decl));
    }
#line 4708 "compiler/parser.c"
    break;

  case 34: /* unary_expression: __BUILTIN_VA_ARG '(' assignment_expression ',' type_name ')'  */
#line 867 "../compiler/parser.y"
    {
      (yyval.expr) = FunctionCall(IdentName("__builtin_va_arg"),
                        CommaList((yyvsp[-3].expr), TypeTrick((yyvsp[-1].decl))));
    }
#line 4717 "compiler/parser.c"
    break;

  case 35: /* unary_expression: __BUILTIN_OFFSETOF '(' type_name ',' IDENTIFIER ')'  */
#line 872 "../compiler/parser.y"
    {
      (yyval.expr) = FunctionCall(IdentName("__builtin_offsetof"),
                        CommaList(TypeTrick((yyvsp[-3].decl)), IdentName((yyvsp[-1].name))));
    }
#line 4726 "compiler/parser.c"
    break;

  case 36: /* unary_expression: __BUILTIN_TYPES_COMPATIBLE_P '(' type_name ',' type_name ')'  */
#line 877 "../compiler/parser.y"
    {
      (yyval.expr) = FunctionCall(IdentName("__builtin_types_compatible_p"),
                        CommaList(TypeTrick((yyvsp[-3].decl)), TypeTrick((yyvsp[-1].decl))));
    }
#line 4735 "compiler/parser.c"
    break;

  case 37: /* unary_operator: '&'  */
#line 886 "../compiler/parser.y"
    {
      (yyval.type) = UOP_addr;
    }
#line 4743 "compiler/parser.c"
    break;

  case 38: /* unary_operator: '*'  */
#line 890 "../compiler/parser.y"
    {
      (yyval.type) = UOP_star;
    }
#line 4751 "compiler/parser.c"
    break;

  case 39: /* unary_operator: '+'  */
#line 894 "../compiler/parser.y"
    {
      (yyval.type) = -1;         /* Ingore this one */
    }
#line 4759 "compiler/parser.c"
    break;

  case 40: /* unary_operator: '-'  */
#line 898 "../compiler/parser.y"
    {
      (yyval.type) = UOP_neg;
    }
#line 4767 "compiler/parser.c"
    break;

  case 41: /* unary_operator: '~'  */
#line 902 "../compiler/parser.y"
    {
      (yyval.type) = UOP_bnot;
    }
#line 4775 "compiler/parser.c"
    break;

  case 42: /* unary_operator: '!'  */
#line 906 "../compiler/parser.y"
    {
      (yyval.type) = UOP_lnot;
    }
#line 4783 "compiler/parser.c"
    break;

  case 43: /* cast_expression: unary_expression  */
#line 913 "../compiler/parser.y"
                     { (yyval.expr) = (yyvsp[0].expr); }
#line 4789 "compiler/parser.c"
    break;

  case 44: /* cast_expression: '(' type_name ')' cast_expression  */
#line 915 "../compiler/parser.y"
    {
      (yyval.expr) = CastedExpr((yyvsp[-2].decl), (yyvsp[0].expr));
    }
#line 4797 "compiler/parser.c"
    break;

  case 45: /* multiplicative_expression: cast_expression  */
#line 922 "../compiler/parser.y"
                    { (yyval.expr) = (yyvsp[0].expr); }
#line 4803 "compiler/parser.c"
    break;

  case 46: /* multiplicative_expression: multiplicative_expression '*' cast_expression  */
#line 924 "../compiler/parser.y"
    {
      (yyval.expr) = BinaryOperator(BOP_mul, (yyvsp[-2].expr), (yyvsp[0].expr));
    }
#line 4811 "compiler/parser.c"
    break;

  case 47: /* multiplicative_expression: multiplicative_expression '/' cast_expression  */
#line 928 "../compiler/parser.y"
    {
      (yyval.expr) = BinaryOperator(BOP_div, (yyvsp[-2].expr), (yyvsp[0].expr));
    }
#line 4819 "compiler/parser.c"
    break;

  case 48: /* multiplicative_expression: multiplicative_expression '%' cast_expression  */
#line 932 "../compiler/parser.y"
    {
      (yyval.expr) = BinaryOperator(BOP_mod, (yyvsp[-2].expr), (yyvsp[0].expr));
    }
#line 4827 "compiler/parser.c"
    break;

  case 49: /* additive_expression: multiplicative_expression  */
#line 939 "../compiler/parser.y"
                              { (yyval.expr) = (yyvsp[0].expr); }
#line 4833 "compiler/parser.c"
    break;

  case 50: /* additive_expression: additive_expression '+' multiplicative_expression  */
#line 941 "../compiler/parser.y"
    {
      (yyval.expr) = BinaryOperator(BOP_add, (yyvsp[-2].expr), (yyvsp[0].expr));
    }
#line 4841 "compiler/parser.c"
    break;

  case 51: /* additive_expression: additive_expression '-' multiplicative_expression  */
#line 945 "../compiler/parser.y"
    {
      (yyval.expr) = BinaryOperator(BOP_sub, (yyvsp[-2].expr), (yyvsp[0].expr));
    }
#line 4849 "compiler/parser.c"
    break;

  case 52: /* shift_expression: additive_expression  */
#line 952 "../compiler/parser.y"
                        { (yyval.expr) = (yyvsp[0].expr); }
#line 4855 "compiler/parser.c"
    break;

  case 53: /* shift_expression: shift_expression LEFT_OP additive_expression  */
#line 954 "../compiler/parser.y"
    {
      (yyval.expr) = BinaryOperator(BOP_shl, (yyvsp[-2].expr), (yyvsp[0].expr));
    }
#line 4863 "compiler/parser.c"
    break;

  case 54: /* shift_expression: shift_expression RIGHT_OP additive_expression  */
#line 958 "../compiler/parser.y"
    {
      (yyval.expr) = BinaryOperator(BOP_shr, (yyvsp[-2].expr), (yyvsp[0].expr));
    }
#line 4871 "compiler/parser.c"
    break;

  case 55: /* relational_expression: shift_expression  */
#line 965 "../compiler/parser.y"
                     { (yyval.expr) = (yyvsp[0].expr); }
#line 4877 "compiler/parser.c"
    break;

  case 56: /* relational_expression: relational_expression '<' shift_expression  */
#line 967 "../compiler/parser.y"
    {
      (yyval.expr) = BinaryOperator(BOP_lt, (yyvsp[-2].expr), (yyvsp[0].expr));
    }
#line 4885 "compiler/parser.c"
    break;

  case 57: /* relational_expression: relational_expression '>' shift_expression  */
#line 971 "../compiler/parser.y"
    {
      (yyval.expr) = BinaryOperator(BOP_gt, (yyvsp[-2].expr), (yyvsp[0].expr));
    }
#line 4893 "compiler/parser.c"
    break;

  case 58: /* relational_expression: relational_expression LE_OP shift_expression  */
#line 975 "../compiler/parser.y"
    {
      (yyval.expr) = BinaryOperator(BOP_leq, (yyvsp[-2].expr), (yyvsp[0].expr));
     }
#line 4901 "compiler/parser.c"
    break;

  case 59: /* relational_expression: relational_expression GE_OP shift_expression  */
#line 979 "../compiler/parser.y"
    {
      (yyval.expr) = BinaryOperator(BOP_geq, (yyvsp[-2].expr), (yyvsp[0].expr));
    }
#line 4909 "compiler/parser.c"
    break;

  case 60: /* equality_expression: relational_expression  */
#line 986 "../compiler/parser.y"
                          { (yyval.expr) = (yyvsp[0].expr); }
#line 4915 "compiler/parser.c"
    break;

  case 61: /* equality_expression: equality_expression EQ_OP relational_expression  */
#line 988 "../compiler/parser.y"
    {
      (yyval.expr) = BinaryOperator(BOP_eqeq, (yyvsp[-2].expr), (yyvsp[0].expr));
    }
#line 4923 "compiler/parser.c"
    break;

  case 62: /* equality_expression: equality_expression NE_OP relational_expression  */
#line 992 "../compiler/parser.y"
    {
      (yyval.expr) = BinaryOperator(BOP_neq, (yyvsp[-2].expr), (yyvsp[0].expr));
    }
#line 4931 "compiler/parser.c"
    break;

  case 63: /* AND_expression: equality_expression  */
#line 999 "../compiler/parser.y"
                        { (yyval.expr) = (yyvsp[0].expr); }
#line 4937 "compiler/parser.c"
    break;

  case 64: /* AND_expression: AND_expression '&' equality_expression  */
#line 1001 "../compiler/parser.y"
    {
      (yyval.expr) = BinaryOperator(BOP_band, (yyvsp[-2].expr), (yyvsp[0].expr));
    }
#line 4945 "compiler/parser.c"
    break;

  case 65: /* exclusive_OR_expression: AND_expression  */
#line 1008 "../compiler/parser.y"
                   { (yyval.expr) = (yyvsp[0].expr); }
#line 4951 "compiler/parser.c"
    break;

  case 66: /* exclusive_OR_expression: exclusive_OR_expression '^' AND_expression  */
#line 1010 "../compiler/parser.y"
    {
      (yyval.expr) = BinaryOperator(BOP_xor, (yyvsp[-2].expr), (yyvsp[0].expr));
    }
#line 4959 "compiler/parser.c"
    break;

  case 67: /* inclusive_OR_expression: exclusive_OR_expression  */
#line 1017 "../compiler/parser.y"
                            { (yyval.expr) = (yyvsp[0].expr); }
#line 4965 "compiler/parser.c"
    break;

  case 68: /* inclusive_OR_expression: inclusive_OR_expression '|' exclusive_OR_expression  */
#line 1019 "../compiler/parser.y"
    {
      (yyval.expr) = BinaryOperator(BOP_bor, (yyvsp[-2].expr), (yyvsp[0].expr));
    }
#line 4973 "compiler/parser.c"
    break;

  case 69: /* logical_AND_expression: inclusive_OR_expression  */
#line 1026 "../compiler/parser.y"
                            { (yyval.expr) = (yyvsp[0].expr); }
#line 4979 "compiler/parser.c"
    break;

  case 70: /* logical_AND_expression: logical_AND_expression AND_OP inclusive_OR_expression  */
#line 1028 "../compiler/parser.y"
    {
      (yyval.expr) = BinaryOperator(BOP_land, (yyvsp[-2].expr), (yyvsp[0].expr));
    }
#line 4987 "compiler/parser.c"
    break;

  case 71: /* logical_OR_expression: logical_AND_expression  */
#line 1035 "../compiler/parser.y"
                           { (yyval.expr) = (yyvsp[0].expr); }
#line 4993 "compiler/parser.c"
    break;

  case 72: /* logical_OR_expression: logical_OR_expression OR_OP logical_AND_expression  */
#line 1037 "../compiler/parser.y"
    {
      (yyval.expr) = BinaryOperator(BOP_lor, (yyvsp[-2].expr), (yyvsp[0].expr));
    }
#line 5001 "compiler/parser.c"
    break;

  case 73: /* conditional_expression: logical_OR_expression  */
#line 1044 "../compiler/parser.y"
                          { (yyval.expr) = (yyvsp[0].expr); }
#line 5007 "compiler/parser.c"
    break;

  case 74: /* conditional_expression: logical_OR_expression '?' expression ':' conditional_expression  */
#line 1046 "../compiler/parser.y"
    {
      (yyval.expr) = ConditionalExpr((yyvsp[-4].expr), (yyvsp[-2].expr), (yyvsp[0].expr));
    }
#line 5015 "compiler/parser.c"
    break;

  case 75: /* assignment_expression: conditional_expression  */
#line 1053 "../compiler/parser.y"
                           { (yyval.expr) = (yyvsp[0].expr); }
#line 5021 "compiler/parser.c"
    break;

  case 76: /* assignment_expression: unary_expression assignment_operator assignment_expression  */
#line 1055 "../compiler/parser.y"
    {
      (yyval.expr) = Assignment((yyvsp[-2].expr), (yyvsp[-1].type), (yyvsp[0].expr));
    }
#line 5029 "compiler/parser.c"
    break;

  case 77: /* assignment_operator: '='  */
#line 1063 "../compiler/parser.y"
    {
      (yyval.type) = ASS_eq;  /* Need fix here! */
    }
#line 5037 "compiler/parser.c"
    break;

  case 78: /* assignment_operator: MUL_ASSIGN  */
#line 1067 "../compiler/parser.y"
    {
      (yyval.type) = ASS_mul;
    }
#line 5045 "compiler/parser.c"
    break;

  case 79: /* assignment_operator: DIV_ASSIGN  */
#line 1071 "../compiler/parser.y"
    {
      (yyval.type) = ASS_div;
    }
#line 5053 "compiler/parser.c"
    break;

  case 80: /* assignment_operator: MOD_ASSIGN  */
#line 1075 "../compiler/parser.y"
    {
      (yyval.type) = ASS_mod;
    }
#line 5061 "compiler/parser.c"
    break;

  case 81: /* assignment_operator: ADD_ASSIGN  */
#line 1079 "../compiler/parser.y"
    {
      (yyval.type) = ASS_add;
    }
#line 5069 "compiler/parser.c"
    break;

  case 82: /* assignment_operator: SUB_ASSIGN  */
#line 1083 "../compiler/parser.y"
    {
      (yyval.type) = ASS_sub;
    }
#line 5077 "compiler/parser.c"
    break;

  case 83: /* assignment_operator: LEFT_ASSIGN  */
#line 1087 "../compiler/parser.y"
    {
      (yyval.type) = ASS_shl;
    }
#line 5085 "compiler/parser.c"
    break;

  case 84: /* assignment_operator: RIGHT_ASSIGN  */
#line 1091 "../compiler/parser.y"
    {
      (yyval.type) = ASS_shr;
    }
#line 5093 "compiler/parser.c"
    break;

  case 85: /* assignment_operator: AND_ASSIGN  */
#line 1095 "../compiler/parser.y"
    {
      (yyval.type) = ASS_and;
    }
#line 5101 "compiler/parser.c"
    break;

  case 86: /* assignment_operator: XOR_ASSIGN  */
#line 1099 "../compiler/parser.y"
    {
      (yyval.type) = ASS_xor;
    }
#line 5109 "compiler/parser.c"
    break;

  case 87: /* assignment_operator: OR_ASSIGN  */
#line 1103 "../compiler/parser.y"
    {
      (yyval.type) = ASS_or;
    }
#line 5117 "compiler/parser.c"
    break;

  case 88: /* expression: assignment_expression  */
#line 1110 "../compiler/parser.y"
                          { (yyval.expr) = (yyvsp[0].expr); }
#line 5123 "compiler/parser.c"
    break;

  case 89: /* expression: expression ',' assignment_expression  */
#line 1112 "../compiler/parser.y"
    {
      (yyval.expr) = CommaList((yyvsp[-2].expr), (yyvsp[0].expr));
    }
#line 5131 "compiler/parser.c"
    break;

  case 90: /* constant_expression: conditional_expression  */
#line 1119 "../compiler/parser.y"
                           { (yyval.expr) = (yyvsp[0].expr); }
#line 5137 "compiler/parser.c"
    break;

  case 91: /* declaration: declaration_specifiers ';'  */
#line 1131 "../compiler/parser.y"
    {
      /* There is a special case which wrongly uses this rule:
       *   typedef xxx already_known_user_type.
       * In this case the already_known_user_type (T) is re-defined,
       * and because T is known, it is not considered as a declarator,
       * but a "typedef_name", and is part of the specifier.
       * We fix it here.
       */
      if (isTypedef && (yyvsp[-1].spec)->type == SPECLIST)
        (yyval.stmt) = Declaration((yyvsp[-1].spec), fix_known_typename((yyvsp[-1].spec)));
      else
        (yyval.stmt) = Declaration((yyvsp[-1].spec), NULL);
      isTypedef = 0;
    }
#line 5156 "compiler/parser.c"
    break;

  case 92: /* declaration: declaration_specifiers init_declarator_list ';'  */
#line 1146 "../compiler/parser.y"
    {
      (yyval.stmt) = Declaration((yyvsp[-2].spec), (yyvsp[-1].decl));
      if (checkDecls) add_declaration_links((yyvsp[-2].spec), (yyvsp[-1].decl));
      isTypedef = 0;

    }
#line 5167 "compiler/parser.c"
    break;

  case 93: /* declaration: threadprivate_directive  */
#line 1153 "../compiler/parser.y"
    {
      (yyval.stmt) = OmpStmt(OmpConstruct(DCTHREADPRIVATE, (yyvsp[0].odir), NULL));
    }
#line 5175 "compiler/parser.c"
    break;

  case 94: /* declaration: declare_simd_construct  */
#line 1158 "../compiler/parser.y"
    {
      //$$ = OmpStmt(OmpConstruct(DCTHREADPRIVATE, $1, NULL)); TODO
    }
#line 5183 "compiler/parser.c"
    break;

  case 95: /* declaration: declare_target_construct  */
#line 1162 "../compiler/parser.y"
    {
      (yyval.stmt) = OmpStmt((yyvsp[0].ocon));
    }
#line 5191 "compiler/parser.c"
    break;

  case 96: /* declaration: declare_reduction_directive  */
#line 1166 "../compiler/parser.y"
    {
      //$$ = OmpStmt(OmpConstruct(DCTHREADPRIVATE, $1, NULL)); TODO
    }
#line 5199 "compiler/parser.c"
    break;

  case 97: /* declaration: requires_directive  */
#line 1171 "../compiler/parser.y"
    {
      (yyval.stmt) = OmpStmt(OmpConstruct(DCREQUIRES, (yyvsp[0].odir), NULL));
    }
#line 5207 "compiler/parser.c"
    break;

  case 98: /* declaration_specifiers: storage_class_specifier  */
#line 1178 "../compiler/parser.y"
                            { (yyval.spec) = (yyvsp[0].spec); }
#line 5213 "compiler/parser.c"
    break;

  case 99: /* declaration_specifiers: storage_class_specifier declaration_specifiers  */
#line 1180 "../compiler/parser.y"
    {
      (yyval.spec) = Speclist_right((yyvsp[-1].spec), (yyvsp[0].spec));
    }
#line 5221 "compiler/parser.c"
    break;

  case 100: /* declaration_specifiers: type_specifier  */
#line 1183 "../compiler/parser.y"
                   { (yyval.spec) = (yyvsp[0].spec); }
#line 5227 "compiler/parser.c"
    break;

  case 101: /* declaration_specifiers: type_specifier declaration_specifiers  */
#line 1185 "../compiler/parser.y"
    {
      (yyval.spec) = Speclist_right((yyvsp[-1].spec), (yyvsp[0].spec));
    }
#line 5235 "compiler/parser.c"
    break;

  case 102: /* declaration_specifiers: type_qualifier  */
#line 1188 "../compiler/parser.y"
                   { (yyval.spec) = (yyvsp[0].spec); }
#line 5241 "compiler/parser.c"
    break;

  case 103: /* declaration_specifiers: type_qualifier declaration_specifiers  */
#line 1190 "../compiler/parser.y"
    {
      (yyval.spec) = Speclist_right((yyvsp[-1].spec), (yyvsp[0].spec));
    }
#line 5249 "compiler/parser.c"
    break;

  case 104: /* declaration_specifiers: function_specifier  */
#line 1193 "../compiler/parser.y"
                       { (yyval.spec) = (yyvsp[0].spec); }
#line 5255 "compiler/parser.c"
    break;

  case 105: /* declaration_specifiers: function_specifier declaration_specifiers  */
#line 1195 "../compiler/parser.y"
    {
      (yyval.spec) = Speclist_right((yyvsp[-1].spec), (yyvsp[0].spec));
    }
#line 5263 "compiler/parser.c"
    break;

  case 106: /* init_declarator_list: init_declarator  */
#line 1202 "../compiler/parser.y"
                    { (yyval.decl) = (yyvsp[0].decl); }
#line 5269 "compiler/parser.c"
    break;

  case 107: /* init_declarator_list: init_declarator_list ',' init_declarator  */
#line 1204 "../compiler/parser.y"
    {
      (yyval.decl) = DeclList((yyvsp[-2].decl), (yyvsp[0].decl));
    }
#line 5277 "compiler/parser.c"
    break;

  case 108: /* init_declarator: declarator_and_maybe_attributes_asm  */
#line 1218 "../compiler/parser.y"
    {
      astdecl s = decl_getidentifier((yyvsp[0].decl));
      int     declkind = decl_getkind((yyvsp[0].decl));
      stentry e;

      if (!isTypedef && declkind == DFUNC && strcmp(s->u.id->name, "main") == 0)
        s->u.id = Symbol(MAIN_NEWNAME);       /* Catch main()'s declaration */
      if (checkDecls)
      {
        e = symtab_put(stab, s->u.id, (isTypedef) ? TYPENAME :
                                       (declkind == DFUNC) ? FUNCNAME : IDNAME);
        e->isarray = (declkind == DARRAY);
      }
      (yyval.decl) = (yyvsp[0].decl);
    }
#line 5297 "compiler/parser.c"
    break;

  case 109: /* $@1: %empty  */
#line 1234 "../compiler/parser.y"
    {
      astdecl s = decl_getidentifier((yyvsp[-1].decl));
      int     declkind = decl_getkind((yyvsp[-1].decl));
      stentry e;

      if (!isTypedef && declkind == DFUNC && strcmp(s->u.id->name, "main") == 0)
        s->u.id = Symbol(MAIN_NEWNAME);         /* Catch main()'s declaration */
      if (checkDecls)
      {
        e = symtab_put(stab, s->u.id, (isTypedef) ? TYPENAME :
                                       (declkind == DFUNC) ? FUNCNAME : IDNAME);
        e->isarray = (declkind == DARRAY);
      }
    }
#line 5316 "compiler/parser.c"
    break;

  case 110: /* init_declarator: declarator_and_maybe_attributes_asm '=' $@1 initializer  */
#line 1249 "../compiler/parser.y"
    {
      (yyval.decl) = InitDecl((yyvsp[-3].decl), (yyvsp[0].expr));
    }
#line 5324 "compiler/parser.c"
    break;

  case 111: /* declarator_and_maybe_attributes: declarator  */
#line 1256 "../compiler/parser.y"
               { (yyval.decl) = (yyvsp[0].decl); }
#line 5330 "compiler/parser.c"
    break;

  case 112: /* declarator_and_maybe_attributes: declarator attribute_seq  */
#line 1257 "../compiler/parser.y"
                             { (yyval.decl) = (yyvsp[-1].decl); }
#line 5336 "compiler/parser.c"
    break;

  case 113: /* declarator_and_maybe_attributes_asm: declarator  */
#line 1262 "../compiler/parser.y"
               { (yyval.decl) = (yyvsp[0].decl); }
#line 5342 "compiler/parser.c"
    break;

  case 114: /* declarator_and_maybe_attributes_asm: declarator attribute_seq  */
#line 1263 "../compiler/parser.y"
                             { (yyval.decl) = (yyvsp[-1].decl); (yyval.decl)->postspec = (yyvsp[0].spec); }
#line 5348 "compiler/parser.c"
    break;

  case 115: /* declarator_and_maybe_attributes_asm: declarator asm_asmname  */
#line 1264 "../compiler/parser.y"
                                 { (yyval.decl) = (yyvsp[-1].decl); (yyval.decl)->postspec = (yyvsp[0].spec); }
#line 5354 "compiler/parser.c"
    break;

  case 116: /* declarator_and_maybe_attributes_asm: declarator asm_asmname attribute_seq  */
#line 1266 "../compiler/parser.y"
    { 
      (yyval.decl) = (yyvsp[-2].decl); 
      (yyval.decl)->postspec = Speclist_right((yyvsp[-1].spec), (yyvsp[0].spec));
    }
#line 5363 "compiler/parser.c"
    break;

  case 117: /* storage_class_specifier: TYPEDEF  */
#line 1275 "../compiler/parser.y"
    {
      (yyval.spec) = StClassSpec(SPEC_typedef);    /* Just a string */
      isTypedef = 1;
    }
#line 5372 "compiler/parser.c"
    break;

  case 118: /* storage_class_specifier: EXTERN  */
#line 1280 "../compiler/parser.y"
    {
      (yyval.spec) = StClassSpec(SPEC_extern);
    }
#line 5380 "compiler/parser.c"
    break;

  case 119: /* storage_class_specifier: STATIC  */
#line 1284 "../compiler/parser.y"
    {
      (yyval.spec) = StClassSpec(SPEC_static);
    }
#line 5388 "compiler/parser.c"
    break;

  case 120: /* storage_class_specifier: AUTO  */
#line 1288 "../compiler/parser.y"
    {
      (yyval.spec) = StClassSpec(SPEC_auto);
    }
#line 5396 "compiler/parser.c"
    break;

  case 121: /* storage_class_specifier: REGISTER  */
#line 1292 "../compiler/parser.y"
    {
      (yyval.spec) = StClassSpec(SPEC_register);
    }
#line 5404 "compiler/parser.c"
    break;

  case 122: /* type_specifier: VOID  */
#line 1300 "../compiler/parser.y"
    {
      (yyval.spec) = Declspec(SPEC_void);
    }
#line 5412 "compiler/parser.c"
    break;

  case 123: /* type_specifier: CHAR  */
#line 1304 "../compiler/parser.y"
    {
      (yyval.spec) = Declspec(SPEC_char);
    }
#line 5420 "compiler/parser.c"
    break;

  case 124: /* type_specifier: SHORT  */
#line 1308 "../compiler/parser.y"
    {
      (yyval.spec) = Declspec(SPEC_short);
    }
#line 5428 "compiler/parser.c"
    break;

  case 125: /* type_specifier: INT  */
#line 1312 "../compiler/parser.y"
    {
      (yyval.spec) = Declspec(SPEC_int);
    }
#line 5436 "compiler/parser.c"
    break;

  case 126: /* type_specifier: LONG  */
#line 1316 "../compiler/parser.y"
    {
      (yyval.spec) = Declspec(SPEC_long);
    }
#line 5444 "compiler/parser.c"
    break;

  case 127: /* type_specifier: FLOAT  */
#line 1320 "../compiler/parser.y"
    {
      (yyval.spec) = Declspec(SPEC_float);
    }
#line 5452 "compiler/parser.c"
    break;

  case 128: /* type_specifier: DOUBLE  */
#line 1324 "../compiler/parser.y"
    {
      (yyval.spec) = Declspec(SPEC_double);
    }
#line 5460 "compiler/parser.c"
    break;

  case 129: /* type_specifier: SIGNED  */
#line 1328 "../compiler/parser.y"
    {
      (yyval.spec) = Declspec(SPEC_signed);
    }
#line 5468 "compiler/parser.c"
    break;

  case 130: /* type_specifier: UNSIGNED  */
#line 1332 "../compiler/parser.y"
    {
      (yyval.spec) = Declspec(SPEC_unsigned);
    }
#line 5476 "compiler/parser.c"
    break;

  case 131: /* type_specifier: UBOOL  */
#line 1336 "../compiler/parser.y"
    {
      (yyval.spec) = Declspec(SPEC_ubool);
    }
#line 5484 "compiler/parser.c"
    break;

  case 132: /* type_specifier: UCOMPLEX  */
#line 1340 "../compiler/parser.y"
    {
      (yyval.spec) = Declspec(SPEC_ucomplex);
    }
#line 5492 "compiler/parser.c"
    break;

  case 133: /* type_specifier: UIMAGINARY  */
#line 1344 "../compiler/parser.y"
    {
      (yyval.spec) = Declspec(SPEC_uimaginary);
    }
#line 5500 "compiler/parser.c"
    break;

  case 134: /* type_specifier: struct_or_union_specifier  */
#line 1347 "../compiler/parser.y"
                              { (yyval.spec) = (yyvsp[0].spec); }
#line 5506 "compiler/parser.c"
    break;

  case 135: /* type_specifier: enum_specifier  */
#line 1348 "../compiler/parser.y"
                   { (yyval.spec) = (yyvsp[0].spec); }
#line 5512 "compiler/parser.c"
    break;

  case 136: /* type_specifier: typedef_name  */
#line 1350 "../compiler/parser.y"
    {
      (yyval.spec) = Usertype((yyvsp[0].symb));
    }
#line 5520 "compiler/parser.c"
    break;

  case 137: /* type_specifier: TYPEOF '(' conditional_expression ')'  */
#line 1354 "../compiler/parser.y"
    {
      (yyval.spec) = TypeofExpr((yyvsp[-1].expr));
    }
#line 5528 "compiler/parser.c"
    break;

  case 138: /* type_specifier: TYPEOF '(' type_name ')'  */
#line 1358 "../compiler/parser.y"
    {
      (yyval.spec) = TypeofType((yyvsp[-1].decl));
    }
#line 5536 "compiler/parser.c"
    break;

  case 139: /* $@2: %empty  */
#line 1366 "../compiler/parser.y"
                                         { suDepth++; }
#line 5542 "compiler/parser.c"
    break;

  case 140: /* $@3: %empty  */
#line 1367 "../compiler/parser.y"
                                         { suDepth--; }
#line 5548 "compiler/parser.c"
    break;

  case 141: /* struct_or_union_specifier: struct_or_union attribute_optseq '{' $@2 struct_declaration_list '}' $@3 attribute_optseq  */
#line 1368 "../compiler/parser.y"
    {
      (yyval.spec) = SUdecl((yyvsp[-7].type), NULL, (yyvsp[-3].decl), (yyvsp[-6].spec) && (yyvsp[0].spec) ? Speclist_left((yyvsp[-6].spec),(yyvsp[0].spec)) : ((yyvsp[-6].spec) ? (yyvsp[-6].spec):(yyvsp[0].spec)));
    }
#line 5556 "compiler/parser.c"
    break;

  case 142: /* struct_or_union_specifier: struct_or_union attribute_optseq '{' '}'  */
#line 1372 "../compiler/parser.y"
    {
      (yyval.spec) = SUdecl((yyvsp[-3].type), NULL, NULL, (yyvsp[-2].spec));
    }
#line 5564 "compiler/parser.c"
    break;

  case 143: /* $@4: %empty  */
#line 1375 "../compiler/parser.y"
                                                    { suDepth++; }
#line 5570 "compiler/parser.c"
    break;

  case 144: /* $@5: %empty  */
#line 1376 "../compiler/parser.y"
                                         { suDepth--; }
#line 5576 "compiler/parser.c"
    break;

  case 145: /* struct_or_union_specifier: struct_or_union attribute_optseq IDENTIFIER '{' $@4 struct_declaration_list '}' $@5 attribute_optseq  */
#line 1377 "../compiler/parser.y"
    {
      symbol s = Symbol((yyvsp[-6].name));
      (yyval.spec) = SUdecl((yyvsp[-8].type), s, (yyvsp[-3].decl), (yyvsp[-7].spec) && (yyvsp[0].spec) ? Speclist_left((yyvsp[-7].spec), (yyvsp[0].spec)) : ((yyvsp[-7].spec) ? (yyvsp[-7].spec) : (yyvsp[0].spec)));
      /* Well, struct & union names have their own name space, and
       * their own scopes. I.e. they can be re-declared in nested
       * scopes. We don't do any kind of duplicate checks.
       */
      if (checkDecls && suDepth == 0)
        symtab_put(stab, s, SUNAME)->spec = (yyval.spec);
    }
#line 5591 "compiler/parser.c"
    break;

  case 146: /* $@6: %empty  */
#line 1391 "../compiler/parser.y"
                                                      { suDepth++; }
#line 5597 "compiler/parser.c"
    break;

  case 147: /* $@7: %empty  */
#line 1392 "../compiler/parser.y"
                                         { suDepth--; }
#line 5603 "compiler/parser.c"
    break;

  case 148: /* struct_or_union_specifier: struct_or_union attribute_optseq typedef_name '{' $@6 struct_declaration_list '}' $@7 attribute_optseq  */
#line 1393 "../compiler/parser.y"
    {
      symbol s = (yyvsp[-6].symb);
      (yyval.spec) = SUdecl((yyvsp[-8].type), s, (yyvsp[-3].decl), (yyvsp[-7].spec) && (yyvsp[0].spec) ? Speclist_left((yyvsp[-7].spec), (yyvsp[0].spec)) : ((yyvsp[-7].spec) ? (yyvsp[-7].spec) : (yyvsp[0].spec)));
      if (checkDecls && suDepth == 0)
        symtab_put(stab, s, SUNAME)->spec = (yyval.spec);
    }
#line 5614 "compiler/parser.c"
    break;

  case 149: /* struct_or_union_specifier: struct_or_union attribute_optseq IDENTIFIER  */
#line 1400 "../compiler/parser.y"
    {
      symbol s = Symbol((yyvsp[0].name));
      (yyval.spec) = SUdecl((yyvsp[-2].type), s, NULL, (yyvsp[-1].spec));
      if (checkDecls && suDepth == 0)
        symtab_put(stab, s, SUNAME)->spec = (yyval.spec);
    }
#line 5625 "compiler/parser.c"
    break;

  case 150: /* struct_or_union_specifier: struct_or_union attribute_optseq typedef_name  */
#line 1407 "../compiler/parser.y"
    {
      symbol s = (yyvsp[0].symb);
      (yyval.spec) = SUdecl((yyvsp[-2].type), s, NULL, (yyvsp[-1].spec));
      if (checkDecls && suDepth == 0)
        symtab_put(stab, s, SUNAME)->spec = (yyval.spec);
    }
#line 5636 "compiler/parser.c"
    break;

  case 151: /* struct_or_union: STRUCT  */
#line 1418 "../compiler/parser.y"
    {
      (yyval.type) = SPEC_struct;
    }
#line 5644 "compiler/parser.c"
    break;

  case 152: /* struct_or_union: UNION  */
#line 1422 "../compiler/parser.y"
    {
      (yyval.type) = SPEC_union;
    }
#line 5652 "compiler/parser.c"
    break;

  case 153: /* struct_declaration_list: struct_declaration  */
#line 1429 "../compiler/parser.y"
                       { (yyval.decl) = (yyvsp[0].decl); }
#line 5658 "compiler/parser.c"
    break;

  case 154: /* struct_declaration_list: struct_declaration_list struct_declaration  */
#line 1431 "../compiler/parser.y"
    {
      (yyval.decl) = StructfieldList((yyvsp[-1].decl), (yyvsp[0].decl));
    }
#line 5666 "compiler/parser.c"
    break;

  case 155: /* struct_declaration: specifier_qualifier_list struct_declarator_list ';'  */
#line 1439 "../compiler/parser.y"
    {
      (yyval.decl) = StructfieldDecl((yyvsp[-2].spec), (yyvsp[-1].decl));
    }
#line 5674 "compiler/parser.c"
    break;

  case 156: /* struct_declaration: specifier_qualifier_list ';'  */
#line 1443 "../compiler/parser.y"
    {
      (yyval.decl) = StructfieldDecl((yyvsp[-1].spec), NULL);
    }
#line 5682 "compiler/parser.c"
    break;

  case 157: /* specifier_qualifier_list: type_specifier  */
#line 1450 "../compiler/parser.y"
                   { (yyval.spec) = (yyvsp[0].spec); }
#line 5688 "compiler/parser.c"
    break;

  case 158: /* specifier_qualifier_list: type_specifier specifier_qualifier_list  */
#line 1452 "../compiler/parser.y"
    {
      (yyval.spec) = Speclist_right((yyvsp[-1].spec), (yyvsp[0].spec));
    }
#line 5696 "compiler/parser.c"
    break;

  case 159: /* specifier_qualifier_list: type_qualifier  */
#line 1455 "../compiler/parser.y"
                   { (yyval.spec) = (yyvsp[0].spec); }
#line 5702 "compiler/parser.c"
    break;

  case 160: /* specifier_qualifier_list: type_qualifier specifier_qualifier_list  */
#line 1457 "../compiler/parser.y"
    {
      (yyval.spec) = Speclist_right((yyvsp[-1].spec), (yyvsp[0].spec));
    }
#line 5710 "compiler/parser.c"
    break;

  case 161: /* struct_declarator_list: struct_declarator  */
#line 1464 "../compiler/parser.y"
                      { (yyval.decl) = (yyvsp[0].decl); }
#line 5716 "compiler/parser.c"
    break;

  case 162: /* struct_declarator_list: struct_declarator_list ',' struct_declarator  */
#line 1466 "../compiler/parser.y"
    {
      (yyval.decl) = DeclList((yyvsp[-2].decl), (yyvsp[0].decl));
    }
#line 5724 "compiler/parser.c"
    break;

  case 163: /* struct_declarator: declarator_and_maybe_attributes_asm  */
#line 1473 "../compiler/parser.y"
                                        { (yyval.decl) = (yyvsp[0].decl); }
#line 5730 "compiler/parser.c"
    break;

  case 164: /* struct_declarator: declarator ':' constant_expression  */
#line 1475 "../compiler/parser.y"
    {
      (yyval.decl) = BitDecl((yyvsp[-2].decl), (yyvsp[0].expr));
    }
#line 5738 "compiler/parser.c"
    break;

  case 165: /* struct_declarator: ':' constant_expression  */
#line 1479 "../compiler/parser.y"
    {
      (yyval.decl) = BitDecl(NULL, (yyvsp[0].expr));
    }
#line 5746 "compiler/parser.c"
    break;

  case 166: /* enum_specifier: ENUM attribute_optseq '{' enumerator_list '}'  */
#line 1487 "../compiler/parser.y"
    {
      (yyval.spec) = Enumdecl(NULL, (yyvsp[-1].spec), (yyvsp[-3].spec));
    }
#line 5754 "compiler/parser.c"
    break;

  case 167: /* enum_specifier: ENUM attribute_optseq IDENTIFIER '{' enumerator_list '}'  */
#line 1491 "../compiler/parser.y"
    {
      symbol s = Symbol((yyvsp[-3].name));

      if (checkDecls)
      {
        if (symtab_get(stab, s, ENUMNAME))
          parse_error(-1, "enum name '%s' is already in use.", (yyvsp[-3].name));
        symtab_put(stab, s, ENUMNAME);
      }
      (yyval.spec) = Enumdecl(s, (yyvsp[-1].spec), (yyvsp[-4].spec));
    }
#line 5770 "compiler/parser.c"
    break;

  case 168: /* enum_specifier: ENUM attribute_optseq typedef_name '{' enumerator_list '}'  */
#line 1504 "../compiler/parser.y"
    {
      symbol s = (yyvsp[-3].symb);

      if (checkDecls)
      {
        if (symtab_get(stab, s, ENUMNAME))
          parse_error(-1, "enum name '%s' is already in use.", s->name);
        symtab_put(stab, s, ENUMNAME);
      }
      (yyval.spec) = Enumdecl(s, (yyvsp[-1].spec), (yyvsp[-4].spec));
    }
#line 5786 "compiler/parser.c"
    break;

  case 169: /* enum_specifier: ENUM attribute_optseq '{' enumerator_list ',' '}'  */
#line 1516 "../compiler/parser.y"
    {
      (yyval.spec) = Enumdecl(NULL, (yyvsp[-2].spec), (yyvsp[-4].spec));
    }
#line 5794 "compiler/parser.c"
    break;

  case 170: /* enum_specifier: ENUM attribute_optseq IDENTIFIER '{' enumerator_list ',' '}'  */
#line 1520 "../compiler/parser.y"
    {
      symbol s = Symbol((yyvsp[-4].name));

      if (checkDecls)
      {
        if (symtab_get(stab, s, ENUMNAME))
          parse_error(-1, "enum name '%s' is already in use.", (yyvsp[-4].name));
        symtab_put(stab, s, ENUMNAME);
      }
      (yyval.spec) = Enumdecl(s, (yyvsp[-2].spec), (yyvsp[-5].spec));
    }
#line 5810 "compiler/parser.c"
    break;

  case 171: /* enum_specifier: ENUM attribute_optseq typedef_name '{' enumerator_list ',' '}'  */
#line 1532 "../compiler/parser.y"
    {
      symbol s = (yyvsp[-4].symb);

      if (checkDecls)
      {
        if (symtab_get(stab, s, ENUMNAME))
          parse_error(-1, "enum name '%s' is already in use.", s->name);
        symtab_put(stab, s, ENUMNAME);
      }
      (yyval.spec) = Enumdecl(s, (yyvsp[-2].spec), (yyvsp[-5].spec));
    }
#line 5826 "compiler/parser.c"
    break;

  case 172: /* enum_specifier: ENUM attribute_optseq IDENTIFIER  */
#line 1544 "../compiler/parser.y"
    {
      /*
      if (symtab_get(stab, s, ENUMNAME))
        parse_error(-1, "enum name '%s' is unknown.", $2);
      */
      (yyval.spec) = Enumdecl(Symbol((yyvsp[0].name)), NULL, (yyvsp[-1].spec));
    }
#line 5838 "compiler/parser.c"
    break;

  case 173: /* enum_specifier: ENUM attribute_optseq typedef_name  */
#line 1552 "../compiler/parser.y"
    {
      /*
      if (symtab_get(stab, s, ENUMNAME))
        parse_error(-1, "enum name '%s' is unknown.", $2);
      */
      (yyval.spec) = Enumdecl((yyvsp[0].symb), NULL, (yyvsp[-1].spec));
    }
#line 5850 "compiler/parser.c"
    break;

  case 174: /* enumerator_list: enumerator  */
#line 1563 "../compiler/parser.y"
               { (yyval.spec) = (yyvsp[0].spec); }
#line 5856 "compiler/parser.c"
    break;

  case 175: /* enumerator_list: enumerator_list ',' enumerator  */
#line 1565 "../compiler/parser.y"
    {
      (yyval.spec) = Enumbodylist((yyvsp[-2].spec), (yyvsp[0].spec));
    }
#line 5864 "compiler/parser.c"
    break;

  case 176: /* enumerator: enumeration_constant attribute_optseq  */
#line 1574 "../compiler/parser.y"
    {
      (yyval.spec) = Enumerator((yyvsp[-1].symb), NULL);
    }
#line 5872 "compiler/parser.c"
    break;

  case 177: /* enumerator: enumeration_constant attribute_optseq '=' constant_expression  */
#line 1578 "../compiler/parser.y"
    {
      (yyval.spec) = Enumerator((yyvsp[-3].symb), (yyvsp[0].expr));
    }
#line 5880 "compiler/parser.c"
    break;

  case 178: /* type_qualifier: CONST  */
#line 1586 "../compiler/parser.y"
    {
      (yyval.spec) = Declspec(SPEC_const);
    }
#line 5888 "compiler/parser.c"
    break;

  case 179: /* type_qualifier: RESTRICT  */
#line 1590 "../compiler/parser.y"
    {
      (yyval.spec) = Declspec(SPEC_restrict);
    }
#line 5896 "compiler/parser.c"
    break;

  case 180: /* type_qualifier: VOLATILE  */
#line 1594 "../compiler/parser.y"
    {
      (yyval.spec) = Declspec(SPEC_volatile);
    }
#line 5904 "compiler/parser.c"
    break;

  case 181: /* type_qualifier: attribute  */
#line 1597 "../compiler/parser.y"
              { (yyval.spec) = (yyvsp[0].spec); }
#line 5910 "compiler/parser.c"
    break;

  case 182: /* function_specifier: INLINE  */
#line 1603 "../compiler/parser.y"
    {
      (yyval.spec) = Declspec(SPEC_inline);
    }
#line 5918 "compiler/parser.c"
    break;

  case 183: /* declarator: direct_declarator  */
#line 1611 "../compiler/parser.y"
    {
      (yyval.decl) = Declarator(NULL, (yyvsp[0].decl));
    }
#line 5926 "compiler/parser.c"
    break;

  case 184: /* declarator: pointer direct_declarator  */
#line 1615 "../compiler/parser.y"
    {
      (yyval.decl) = Declarator((yyvsp[-1].spec), (yyvsp[0].decl));
    }
#line 5934 "compiler/parser.c"
    break;

  case 185: /* direct_declarator: IDENTIFIER  */
#line 1624 "../compiler/parser.y"
    {
      (yyval.decl) = IdentifierDecl( Symbol((yyvsp[0].name)) );
    }
#line 5942 "compiler/parser.c"
    break;

  case 186: /* direct_declarator: '(' declarator ')'  */
#line 1628 "../compiler/parser.y"
    {
      /* Try to simplify a bit: (ident) -> ident */
      if ((yyvsp[-1].decl)->spec == NULL && (yyvsp[-1].decl)->decl->type == DIDENT)
        (yyval.decl) = (yyvsp[-1].decl)->decl;
      else
        (yyval.decl) = ParenDecl((yyvsp[-1].decl));
    }
#line 5954 "compiler/parser.c"
    break;

  case 187: /* direct_declarator: direct_declarator '[' ']'  */
#line 1636 "../compiler/parser.y"
    {
      (yyval.decl) = ArrayDecl((yyvsp[-2].decl), NULL, NULL);
    }
#line 5962 "compiler/parser.c"
    break;

  case 188: /* direct_declarator: direct_declarator '[' type_qualifier_list ']'  */
#line 1640 "../compiler/parser.y"
    {
      (yyval.decl) = ArrayDecl((yyvsp[-3].decl), (yyvsp[-1].spec), NULL);
    }
#line 5970 "compiler/parser.c"
    break;

  case 189: /* direct_declarator: direct_declarator '[' assignment_expression ']'  */
#line 1644 "../compiler/parser.y"
    {
      (yyval.decl) = ArrayDecl((yyvsp[-3].decl), NULL, (yyvsp[-1].expr));
    }
#line 5978 "compiler/parser.c"
    break;

  case 190: /* direct_declarator: direct_declarator '[' type_qualifier_list assignment_expression ']'  */
#line 1648 "../compiler/parser.y"
    {
      (yyval.decl) = ArrayDecl((yyvsp[-4].decl), (yyvsp[-2].spec), (yyvsp[-1].expr));
    }
#line 5986 "compiler/parser.c"
    break;

  case 191: /* direct_declarator: direct_declarator '[' STATIC assignment_expression ']'  */
#line 1652 "../compiler/parser.y"
    {
      (yyval.decl) = ArrayDecl((yyvsp[-4].decl), StClassSpec(SPEC_static), (yyvsp[-1].expr));
    }
#line 5994 "compiler/parser.c"
    break;

  case 192: /* direct_declarator: direct_declarator '[' STATIC type_qualifier_list assignment_expression ']'  */
#line 1656 "../compiler/parser.y"
    {
      (yyval.decl) = ArrayDecl((yyvsp[-5].decl), Speclist_right( StClassSpec(SPEC_static), (yyvsp[-2].spec) ), (yyvsp[-1].expr));
    }
#line 6002 "compiler/parser.c"
    break;

  case 193: /* direct_declarator: direct_declarator '[' type_qualifier_list STATIC assignment_expression ']'  */
#line 1660 "../compiler/parser.y"
    {
      (yyval.decl) = ArrayDecl((yyvsp[-5].decl), Speclist_left( (yyvsp[-3].spec), StClassSpec(SPEC_static) ), (yyvsp[-1].expr));
    }
#line 6010 "compiler/parser.c"
    break;

  case 194: /* direct_declarator: direct_declarator '[' '*' ']'  */
#line 1664 "../compiler/parser.y"
    {
      (yyval.decl) = ArrayDecl((yyvsp[-3].decl), Declspec(SPEC_star), NULL);
    }
#line 6018 "compiler/parser.c"
    break;

  case 195: /* direct_declarator: direct_declarator '[' type_qualifier_list '*' ']'  */
#line 1668 "../compiler/parser.y"
    {
      (yyval.decl) = ArrayDecl((yyvsp[-4].decl), Speclist_left( (yyvsp[-2].spec), Declspec(SPEC_star) ), NULL);
    }
#line 6026 "compiler/parser.c"
    break;

  case 196: /* direct_declarator: direct_declarator '(' parameter_type_list ')'  */
#line 1672 "../compiler/parser.y"
    {
      (yyval.decl) = FuncDecl((yyvsp[-3].decl), (yyvsp[-1].decl));
    }
#line 6034 "compiler/parser.c"
    break;

  case 197: /* direct_declarator: direct_declarator '(' ')'  */
#line 1676 "../compiler/parser.y"
    {
      (yyval.decl) = FuncDecl((yyvsp[-2].decl), NULL);
    }
#line 6042 "compiler/parser.c"
    break;

  case 198: /* direct_declarator: direct_declarator '(' identifier_list ')'  */
#line 1680 "../compiler/parser.y"
    {
      (yyval.decl) = FuncDecl((yyvsp[-3].decl), (yyvsp[-1].decl));
    }
#line 6050 "compiler/parser.c"
    break;

  case 199: /* pointer: '*'  */
#line 1688 "../compiler/parser.y"
    {
      (yyval.spec) = Pointer();
    }
#line 6058 "compiler/parser.c"
    break;

  case 200: /* pointer: '*' type_qualifier_list  */
#line 1692 "../compiler/parser.y"
    {
      (yyval.spec) = Speclist_right(Pointer(), (yyvsp[0].spec));
    }
#line 6066 "compiler/parser.c"
    break;

  case 201: /* pointer: '*' pointer  */
#line 1696 "../compiler/parser.y"
    {
      (yyval.spec) = Speclist_right(Pointer(), (yyvsp[0].spec));
    }
#line 6074 "compiler/parser.c"
    break;

  case 202: /* pointer: '*' type_qualifier_list pointer  */
#line 1700 "../compiler/parser.y"
    {
      (yyval.spec) = Speclist_right( Pointer(), Speclist_left((yyvsp[-1].spec), (yyvsp[0].spec)) );
    }
#line 6082 "compiler/parser.c"
    break;

  case 203: /* type_qualifier_list: type_qualifier  */
#line 1707 "../compiler/parser.y"
                   { (yyval.spec) = (yyvsp[0].spec); }
#line 6088 "compiler/parser.c"
    break;

  case 204: /* type_qualifier_list: type_qualifier_list type_qualifier  */
#line 1709 "../compiler/parser.y"
    {
      (yyval.spec) = Speclist_left((yyvsp[-1].spec), (yyvsp[0].spec));
    }
#line 6096 "compiler/parser.c"
    break;

  case 205: /* parameter_type_list: parameter_list  */
#line 1716 "../compiler/parser.y"
                   { (yyval.decl) = (yyvsp[0].decl); }
#line 6102 "compiler/parser.c"
    break;

  case 206: /* parameter_type_list: parameter_list ',' ELLIPSIS  */
#line 1718 "../compiler/parser.y"
    {
      (yyval.decl) = ParamList((yyvsp[-2].decl), Ellipsis());
    }
#line 6110 "compiler/parser.c"
    break;

  case 207: /* parameter_list: parameter_declaration  */
#line 1725 "../compiler/parser.y"
                          { (yyval.decl) = (yyvsp[0].decl); }
#line 6116 "compiler/parser.c"
    break;

  case 208: /* parameter_list: parameter_list ',' parameter_declaration  */
#line 1727 "../compiler/parser.y"
    {
      (yyval.decl) = ParamList((yyvsp[-2].decl), (yyvsp[0].decl));
    }
#line 6124 "compiler/parser.c"
    break;

  case 209: /* parameter_declaration: declaration_specifiers declarator  */
#line 1735 "../compiler/parser.y"
    {
      (yyval.decl) = ParamDecl((yyvsp[-1].spec), (yyvsp[0].decl));
    }
#line 6132 "compiler/parser.c"
    break;

  case 210: /* parameter_declaration: declaration_specifiers  */
#line 1739 "../compiler/parser.y"
    {
      (yyval.decl) = ParamDecl((yyvsp[0].spec), NULL);
    }
#line 6140 "compiler/parser.c"
    break;

  case 211: /* parameter_declaration: declaration_specifiers abstract_declarator  */
#line 1743 "../compiler/parser.y"
    {
      (yyval.decl) = ParamDecl((yyvsp[-1].spec), (yyvsp[0].decl));
    }
#line 6148 "compiler/parser.c"
    break;

  case 212: /* identifier_list: IDENTIFIER  */
#line 1751 "../compiler/parser.y"
    {
      (yyval.decl) = IdentifierDecl( Symbol((yyvsp[0].name)) );
    }
#line 6156 "compiler/parser.c"
    break;

  case 213: /* identifier_list: identifier_list ',' IDENTIFIER  */
#line 1755 "../compiler/parser.y"
    {
      (yyval.decl) = IdList((yyvsp[-2].decl), IdentifierDecl( Symbol((yyvsp[0].name)) ));
    }
#line 6164 "compiler/parser.c"
    break;

  case 214: /* type_name: specifier_qualifier_list  */
#line 1763 "../compiler/parser.y"
    {
      (yyval.decl) = Casttypename((yyvsp[0].spec), NULL);
    }
#line 6172 "compiler/parser.c"
    break;

  case 215: /* type_name: specifier_qualifier_list abstract_declarator  */
#line 1767 "../compiler/parser.y"
    {
      (yyval.decl) = Casttypename((yyvsp[-1].spec), (yyvsp[0].decl));
    }
#line 6180 "compiler/parser.c"
    break;

  case 216: /* abstract_declarator: pointer  */
#line 1775 "../compiler/parser.y"
    {
      (yyval.decl) = AbstractDeclarator((yyvsp[0].spec), NULL);
    }
#line 6188 "compiler/parser.c"
    break;

  case 217: /* abstract_declarator: direct_abstract_declarator  */
#line 1779 "../compiler/parser.y"
    {
      (yyval.decl) = AbstractDeclarator(NULL, (yyvsp[0].decl));
    }
#line 6196 "compiler/parser.c"
    break;

  case 218: /* abstract_declarator: pointer direct_abstract_declarator  */
#line 1783 "../compiler/parser.y"
    {
      (yyval.decl) = AbstractDeclarator((yyvsp[-1].spec), (yyvsp[0].decl));
    }
#line 6204 "compiler/parser.c"
    break;

  case 219: /* direct_abstract_declarator: '(' abstract_declarator ')'  */
#line 1791 "../compiler/parser.y"
    {
      (yyval.decl) = ParenDecl((yyvsp[-1].decl));
    }
#line 6212 "compiler/parser.c"
    break;

  case 220: /* direct_abstract_declarator: '[' ']'  */
#line 1795 "../compiler/parser.y"
    {
      (yyval.decl) = ArrayDecl(NULL, NULL, NULL);
    }
#line 6220 "compiler/parser.c"
    break;

  case 221: /* direct_abstract_declarator: direct_abstract_declarator '[' ']'  */
#line 1799 "../compiler/parser.y"
    {
      (yyval.decl) = ArrayDecl((yyvsp[-2].decl), NULL, NULL);
    }
#line 6228 "compiler/parser.c"
    break;

  case 222: /* direct_abstract_declarator: '[' assignment_expression ']'  */
#line 1803 "../compiler/parser.y"
    {
      (yyval.decl) = ArrayDecl(NULL, NULL, (yyvsp[-1].expr));
    }
#line 6236 "compiler/parser.c"
    break;

  case 223: /* direct_abstract_declarator: direct_abstract_declarator '[' assignment_expression ']'  */
#line 1807 "../compiler/parser.y"
    {
      (yyval.decl) = ArrayDecl((yyvsp[-3].decl), NULL, (yyvsp[-1].expr));
    }
#line 6244 "compiler/parser.c"
    break;

  case 224: /* direct_abstract_declarator: '[' '*' ']'  */
#line 1811 "../compiler/parser.y"
    {
      (yyval.decl) = ArrayDecl(NULL, Declspec(SPEC_star), NULL);
    }
#line 6252 "compiler/parser.c"
    break;

  case 225: /* direct_abstract_declarator: direct_abstract_declarator '[' '*' ']'  */
#line 1815 "../compiler/parser.y"
    {
      (yyval.decl) = ArrayDecl((yyvsp[-3].decl), Declspec(SPEC_star), NULL);
    }
#line 6260 "compiler/parser.c"
    break;

  case 226: /* direct_abstract_declarator: '(' ')'  */
#line 1819 "../compiler/parser.y"
    {
      (yyval.decl) = FuncDecl(NULL, NULL);
    }
#line 6268 "compiler/parser.c"
    break;

  case 227: /* direct_abstract_declarator: direct_abstract_declarator '(' ')'  */
#line 1823 "../compiler/parser.y"
    {
      (yyval.decl) = FuncDecl((yyvsp[-2].decl), NULL);
    }
#line 6276 "compiler/parser.c"
    break;

  case 228: /* direct_abstract_declarator: '(' parameter_type_list ')'  */
#line 1827 "../compiler/parser.y"
    {
      (yyval.decl) = FuncDecl(NULL, (yyvsp[-1].decl));
    }
#line 6284 "compiler/parser.c"
    break;

  case 229: /* direct_abstract_declarator: direct_abstract_declarator '(' parameter_type_list ')'  */
#line 1831 "../compiler/parser.y"
    {
      (yyval.decl) = FuncDecl((yyvsp[-3].decl), (yyvsp[-1].decl));
    }
#line 6292 "compiler/parser.c"
    break;

  case 230: /* typedef_name: TYPE_NAME  */
#line 1839 "../compiler/parser.y"
    {
      (yyval.symb) = Symbol((yyvsp[0].name));
    }
#line 6300 "compiler/parser.c"
    break;

  case 231: /* initializer: assignment_expression  */
#line 1846 "../compiler/parser.y"
                          { (yyval.expr) = (yyvsp[0].expr); }
#line 6306 "compiler/parser.c"
    break;

  case 232: /* initializer: '{' initializer_list '}'  */
#line 1848 "../compiler/parser.y"
    {
      (yyval.expr) = BracedInitializer((yyvsp[-1].expr));
    }
#line 6314 "compiler/parser.c"
    break;

  case 233: /* initializer: '{' initializer_list ',' '}'  */
#line 1852 "../compiler/parser.y"
    {
      (yyval.expr) = BracedInitializer((yyvsp[-2].expr));
    }
#line 6322 "compiler/parser.c"
    break;

  case 234: /* initializer_list: initializer  */
#line 1859 "../compiler/parser.y"
                { (yyval.expr) = (yyvsp[0].expr); }
#line 6328 "compiler/parser.c"
    break;

  case 235: /* initializer_list: designation initializer  */
#line 1861 "../compiler/parser.y"
    {
      (yyval.expr) = Designated((yyvsp[-1].expr), (yyvsp[0].expr));
    }
#line 6336 "compiler/parser.c"
    break;

  case 236: /* initializer_list: initializer_list ',' initializer  */
#line 1865 "../compiler/parser.y"
    {
      (yyval.expr) = CommaList((yyvsp[-2].expr), (yyvsp[0].expr));
    }
#line 6344 "compiler/parser.c"
    break;

  case 237: /* initializer_list: initializer_list ',' designation initializer  */
#line 1869 "../compiler/parser.y"
    {
      (yyval.expr) = CommaList((yyvsp[-3].expr), Designated((yyvsp[-1].expr), (yyvsp[0].expr)));
    }
#line 6352 "compiler/parser.c"
    break;

  case 238: /* designation: designator_list '='  */
#line 1876 "../compiler/parser.y"
                        { (yyval.expr) = (yyvsp[-1].expr); }
#line 6358 "compiler/parser.c"
    break;

  case 239: /* designator_list: designator  */
#line 1881 "../compiler/parser.y"
               { (yyval.expr) = (yyvsp[0].expr); }
#line 6364 "compiler/parser.c"
    break;

  case 240: /* designator_list: designator_list designator  */
#line 1883 "../compiler/parser.y"
    {
      (yyval.expr) = SpaceList((yyvsp[-1].expr), (yyvsp[0].expr));
    }
#line 6372 "compiler/parser.c"
    break;

  case 241: /* designator: '[' constant_expression ']'  */
#line 1891 "../compiler/parser.y"
    {
      (yyval.expr) = IdxDesignator((yyvsp[-1].expr));
    }
#line 6380 "compiler/parser.c"
    break;

  case 242: /* designator: '.' IDENTIFIER  */
#line 1895 "../compiler/parser.y"
    {
      (yyval.expr) = DotDesignator( Symbol((yyvsp[0].name)) );
    }
#line 6388 "compiler/parser.c"
    break;

  case 243: /* designator: '.' typedef_name  */
#line 1899 "../compiler/parser.y"
    {
      (yyval.expr) = DotDesignator((yyvsp[0].symb));
    }
#line 6396 "compiler/parser.c"
    break;

  case 244: /* statement: labeled_statement  */
#line 1912 "../compiler/parser.y"
                      { (yyval.stmt) = (yyvsp[0].stmt); }
#line 6402 "compiler/parser.c"
    break;

  case 245: /* statement: compound_statement  */
#line 1913 "../compiler/parser.y"
                       { (yyval.stmt) = (yyvsp[0].stmt); }
#line 6408 "compiler/parser.c"
    break;

  case 246: /* statement: expression_statement  */
#line 1914 "../compiler/parser.y"
                         { (yyval.stmt) = (yyvsp[0].stmt); }
#line 6414 "compiler/parser.c"
    break;

  case 247: /* statement: selection_statement  */
#line 1915 "../compiler/parser.y"
                        { (yyval.stmt) = (yyvsp[0].stmt); }
#line 6420 "compiler/parser.c"
    break;

  case 248: /* statement: iteration_statement  */
#line 1916 "../compiler/parser.y"
                        { (yyval.stmt) = (yyvsp[0].stmt); }
#line 6426 "compiler/parser.c"
    break;

  case 249: /* statement: jump_statement  */
#line 1917 "../compiler/parser.y"
                   { (yyval.stmt) = (yyvsp[0].stmt); }
#line 6432 "compiler/parser.c"
    break;

  case 251: /* statement: openmp_construct  */
#line 1920 "../compiler/parser.y"
    {
      (yyval.stmt) = OmpStmt((yyvsp[0].ocon));
      (yyval.stmt)->l = (yyvsp[0].ocon)->l;    /* i.e. it stores the beginning line number */
    }
#line 6441 "compiler/parser.c"
    break;

  case 252: /* statement: ompix_construct  */
#line 1925 "../compiler/parser.y"
    {
      #ifdef OMPI_OMP_EXT
        (yyval.stmt) = OmpixStmt((yyvsp[0].xcon));
        (yyval.stmt)->l = (yyvsp[0].xcon)->l;
      #else
        if ((yyvsp[0].xcon)->type==OX_DCTAG){
          parse_warning("tag construct ignored;"
                "activate it by configuring OMPi with -Dext=true\n");
          (yyval.stmt) = (yyvsp[0].xcon)->body;
        } else {
          (yyval.stmt) = OmpixStmt((yyvsp[0].xcon));
          (yyval.stmt)->l = (yyvsp[0].xcon)->l;
        }
      #endif
    }
#line 6461 "compiler/parser.c"
    break;

  case 253: /* statement: PRAGMA_OTHER  */
#line 1941 "../compiler/parser.y"
    {
      (yyval.stmt) = Verbatim(strdup((yyvsp[0].name)));
    }
#line 6469 "compiler/parser.c"
    break;

  case 254: /* statement_for_labeled: statement  */
#line 1949 "../compiler/parser.y"
    { 
      (yyval.stmt) = (yyvsp[0].stmt); 
    }
#line 6477 "compiler/parser.c"
    break;

  case 255: /* statement_for_labeled: openmp_directive  */
#line 1953 "../compiler/parser.y"
    {       
      (yyval.stmt) = OmpStmt((yyvsp[0].ocon));
      (yyval.stmt)->l = (yyvsp[0].ocon)->l;
    }
#line 6486 "compiler/parser.c"
    break;

  case 256: /* labeled_statement: IDENTIFIER ':' attribute_optseq statement  */
#line 1963 "../compiler/parser.y"
    {
      (yyval.stmt) = Labeled( Symbol((yyvsp[-3].name)), (yyvsp[0].stmt) );
    }
#line 6494 "compiler/parser.c"
    break;

  case 257: /* labeled_statement: CASE constant_expression ':' statement_for_labeled  */
#line 1967 "../compiler/parser.y"
    {
      (yyval.stmt) = Case((yyvsp[-2].expr), (yyvsp[0].stmt));
    }
#line 6502 "compiler/parser.c"
    break;

  case 258: /* labeled_statement: DEFAULT ':' statement_for_labeled  */
#line 1971 "../compiler/parser.y"
    {
      (yyval.stmt) = Default((yyvsp[0].stmt));
    }
#line 6510 "compiler/parser.c"
    break;

  case 259: /* compound_statement: '{' '}'  */
#line 1979 "../compiler/parser.y"
    {
      (yyval.stmt) = Compound(NULL);
    }
#line 6518 "compiler/parser.c"
    break;

  case 260: /* @8: %empty  */
#line 1982 "../compiler/parser.y"
         { (yyval.type) = sc_original_line()-1; scope_start(stab); }
#line 6524 "compiler/parser.c"
    break;

  case 261: /* compound_statement: '{' @8 block_item_list '}'  */
#line 1984 "../compiler/parser.y"
    {
      (yyval.stmt) = Compound((yyvsp[-1].stmt));
      scope_end(stab);
      (yyval.stmt)->l = (yyvsp[-2].type);     /* Remember the line of { */
    }
#line 6534 "compiler/parser.c"
    break;

  case 262: /* block_item_list: block_item  */
#line 1993 "../compiler/parser.y"
               { (yyval.stmt) = (yyvsp[0].stmt); }
#line 6540 "compiler/parser.c"
    break;

  case 263: /* block_item_list: block_item_list block_item  */
#line 1995 "../compiler/parser.y"
    {
      (yyval.stmt) = BlockList((yyvsp[-1].stmt), (yyvsp[0].stmt));
      (yyval.stmt)->l = (yyvsp[-1].stmt)->l;
    }
#line 6549 "compiler/parser.c"
    break;

  case 264: /* block_item: declaration  */
#line 2003 "../compiler/parser.y"
                { (yyval.stmt) = (yyvsp[0].stmt); }
#line 6555 "compiler/parser.c"
    break;

  case 265: /* block_item: statement  */
#line 2004 "../compiler/parser.y"
              { (yyval.stmt) = (yyvsp[0].stmt); }
#line 6561 "compiler/parser.c"
    break;

  case 266: /* block_item: openmp_directive  */
#line 2006 "../compiler/parser.y"
    {
      (yyval.stmt) = OmpStmt((yyvsp[0].ocon));
      (yyval.stmt)->l = (yyvsp[0].ocon)->l;
    }
#line 6570 "compiler/parser.c"
    break;

  case 267: /* block_item: ompix_directive  */
#line 2011 "../compiler/parser.y"
    {
      (yyval.stmt) = OmpixStmt((yyvsp[0].xcon));
      (yyval.stmt)->l = (yyvsp[0].xcon)->l;
    }
#line 6579 "compiler/parser.c"
    break;

  case 268: /* expression_statement: ';'  */
#line 2020 "../compiler/parser.y"
    {
      (yyval.stmt) = Expression(NULL);
    }
#line 6587 "compiler/parser.c"
    break;

  case 269: /* expression_statement: expression ';'  */
#line 2024 "../compiler/parser.y"
    {
      (yyval.stmt) = Expression((yyvsp[-1].expr));
      (yyval.stmt)->l = (yyvsp[-1].expr)->l;
    }
#line 6596 "compiler/parser.c"
    break;

  case 270: /* selection_statement: IF '(' expression ')' statement  */
#line 2033 "../compiler/parser.y"
    {
      (yyval.stmt) = If((yyvsp[-2].expr), (yyvsp[0].stmt), NULL);
    }
#line 6604 "compiler/parser.c"
    break;

  case 271: /* selection_statement: IF '(' expression ')' statement ELSE statement  */
#line 2037 "../compiler/parser.y"
    {
      (yyval.stmt) = If((yyvsp[-4].expr), (yyvsp[-2].stmt), (yyvsp[0].stmt));
    }
#line 6612 "compiler/parser.c"
    break;

  case 272: /* selection_statement: SWITCH '(' expression ')' statement  */
#line 2041 "../compiler/parser.y"
    {
      (yyval.stmt) = Switch((yyvsp[-2].expr), (yyvsp[0].stmt));
    }
#line 6620 "compiler/parser.c"
    break;

  case 273: /* iteration_statement: WHILE '(' expression ')' statement  */
#line 2050 "../compiler/parser.y"
    {
      (yyval.stmt) = While((yyvsp[-2].expr), (yyvsp[0].stmt));
    }
#line 6628 "compiler/parser.c"
    break;

  case 274: /* iteration_statement: DO statement WHILE '(' expression ')' ';'  */
#line 2054 "../compiler/parser.y"
    {
      (yyval.stmt) = Do((yyvsp[-5].stmt), (yyvsp[-2].expr));
    }
#line 6636 "compiler/parser.c"
    break;

  case 276: /* iteration_statement_for: FOR '(' ';' ';' ')' statement  */
#line 2062 "../compiler/parser.y"
    {
      (yyval.stmt) = For(NULL, NULL, NULL, (yyvsp[0].stmt));
    }
#line 6644 "compiler/parser.c"
    break;

  case 277: /* iteration_statement_for: FOR '(' expression ';' ';' ')' statement  */
#line 2066 "../compiler/parser.y"
    {
      (yyval.stmt) = For(Expression((yyvsp[-4].expr)), NULL, NULL, (yyvsp[0].stmt));
    }
#line 6652 "compiler/parser.c"
    break;

  case 278: /* iteration_statement_for: FOR '(' ';' expression ';' ')' statement  */
#line 2070 "../compiler/parser.y"
    {
      (yyval.stmt) = For(NULL, (yyvsp[-3].expr), NULL, (yyvsp[0].stmt));
    }
#line 6660 "compiler/parser.c"
    break;

  case 279: /* iteration_statement_for: FOR '(' ';' ';' expression ')' statement  */
#line 2074 "../compiler/parser.y"
    {
      (yyval.stmt) = For(NULL, NULL, (yyvsp[-2].expr), (yyvsp[0].stmt));
    }
#line 6668 "compiler/parser.c"
    break;

  case 280: /* iteration_statement_for: FOR '(' expression ';' expression ';' ')' statement  */
#line 2078 "../compiler/parser.y"
    {
      (yyval.stmt) = For(Expression((yyvsp[-5].expr)), (yyvsp[-3].expr), NULL, (yyvsp[0].stmt));
    }
#line 6676 "compiler/parser.c"
    break;

  case 281: /* iteration_statement_for: FOR '(' expression ';' ';' expression ')' statement  */
#line 2082 "../compiler/parser.y"
    {
      (yyval.stmt) = For(Expression((yyvsp[-5].expr)), NULL, (yyvsp[-2].expr), (yyvsp[0].stmt));
    }
#line 6684 "compiler/parser.c"
    break;

  case 282: /* iteration_statement_for: FOR '(' ';' expression ';' expression ')' statement  */
#line 2086 "../compiler/parser.y"
    {
      (yyval.stmt) = For(NULL, (yyvsp[-4].expr), (yyvsp[-2].expr), (yyvsp[0].stmt));
    }
#line 6692 "compiler/parser.c"
    break;

  case 283: /* iteration_statement_for: FOR '(' expression ';' expression ';' expression ')' statement  */
#line 2090 "../compiler/parser.y"
    {
      (yyval.stmt) = For(Expression((yyvsp[-6].expr)), (yyvsp[-4].expr), (yyvsp[-2].expr), (yyvsp[0].stmt));
    }
#line 6700 "compiler/parser.c"
    break;

  case 284: /* iteration_statement_for: FOR '(' declaration ';' ')' statement  */
#line 2094 "../compiler/parser.y"
    {
      (yyval.stmt) = For((yyvsp[-3].stmt), NULL, NULL, (yyvsp[0].stmt));
    }
#line 6708 "compiler/parser.c"
    break;

  case 285: /* iteration_statement_for: FOR '(' declaration expression ';' ')' statement  */
#line 2098 "../compiler/parser.y"
    {
      (yyval.stmt) = For((yyvsp[-4].stmt), (yyvsp[-3].expr), NULL, (yyvsp[0].stmt));
    }
#line 6716 "compiler/parser.c"
    break;

  case 286: /* iteration_statement_for: FOR '(' declaration ';' expression ')' statement  */
#line 2102 "../compiler/parser.y"
    {
      (yyval.stmt) = For((yyvsp[-4].stmt), NULL, (yyvsp[-2].expr), (yyvsp[0].stmt));
    }
#line 6724 "compiler/parser.c"
    break;

  case 287: /* iteration_statement_for: FOR '(' declaration expression ';' expression ')' statement  */
#line 2106 "../compiler/parser.y"
    {
      (yyval.stmt) = For((yyvsp[-5].stmt), (yyvsp[-4].expr), (yyvsp[-2].expr), (yyvsp[0].stmt));
    }
#line 6732 "compiler/parser.c"
    break;

  case 288: /* jump_statement: GOTO IDENTIFIER ';'  */
#line 2114 "../compiler/parser.y"
    {
      /* We don't keep track of labels -- we leave it to the native compiler */
      (yyval.stmt) = Goto( Symbol((yyvsp[-1].name)) );
    }
#line 6741 "compiler/parser.c"
    break;

  case 289: /* jump_statement: CONTINUE ';'  */
#line 2119 "../compiler/parser.y"
    {
      (yyval.stmt) = Continue();
    }
#line 6749 "compiler/parser.c"
    break;

  case 290: /* jump_statement: BREAK ';'  */
#line 2123 "../compiler/parser.y"
    {
      (yyval.stmt) = Break();
    }
#line 6757 "compiler/parser.c"
    break;

  case 291: /* jump_statement: RETURN ';'  */
#line 2127 "../compiler/parser.y"
    {
      //TODO: simple hack, not 100% correct, does not cover goto
      if (errorOnReturn)
        parse_error(1, "return statement not allowed in an outlined region\n");
      (yyval.stmt) = Return(NULL);
    }
#line 6768 "compiler/parser.c"
    break;

  case 292: /* jump_statement: RETURN expression ';'  */
#line 2134 "../compiler/parser.y"
    {
      //TODO: simple hack, not 100% correct, does not cover goto
      if (errorOnReturn)
        parse_error(1, "return statement not allowed in an outlined region\n");
      (yyval.stmt) = Return((yyvsp[-1].expr));
    }
#line 6779 "compiler/parser.c"
    break;

  case 293: /* translation_unit: external_declaration  */
#line 2151 "../compiler/parser.y"
    {
      (yyval.stmt) = pastree = (yyvsp[0].stmt);
    }
#line 6787 "compiler/parser.c"
    break;

  case 294: /* translation_unit: translation_unit external_declaration  */
#line 2155 "../compiler/parser.y"
    {
      (yyval.stmt) = pastree = BlockList((yyvsp[-1].stmt), (yyvsp[0].stmt));
    }
#line 6795 "compiler/parser.c"
    break;

  case 295: /* external_declaration: function_definition  */
#line 2162 "../compiler/parser.y"
                        { (yyval.stmt) = (yyvsp[0].stmt); }
#line 6801 "compiler/parser.c"
    break;

  case 296: /* external_declaration: declaration  */
#line 2163 "../compiler/parser.y"
                { (yyval.stmt) = (yyvsp[0].stmt); }
#line 6807 "compiler/parser.c"
    break;

  case 297: /* external_declaration: ox_taskdef_construct  */
#line 2168 "../compiler/parser.y"
    {
      (yyval.stmt) = OmpixStmt((yyvsp[0].xcon));
    }
#line 6815 "compiler/parser.c"
    break;

  case 298: /* external_declaration: ox_procextern_construct  */
#line 2172 "../compiler/parser.y"
    {
      (yyval.stmt) = OmpixStmt((yyvsp[0].xcon));
    }
#line 6823 "compiler/parser.c"
    break;

  case 299: /* external_declaration: PRAGMA_OTHER  */
#line 2176 "../compiler/parser.y"
    {
      (yyval.stmt) = Verbatim(strdup((yyvsp[0].name)));
    }
#line 6831 "compiler/parser.c"
    break;

  case 300: /* function_definition: normal_function_definition  */
#line 2187 "../compiler/parser.y"
                                 { (yyval.stmt) = (yyvsp[0].stmt); }
#line 6837 "compiler/parser.c"
    break;

  case 301: /* function_definition: oldstyle_function_definition  */
#line 2188 "../compiler/parser.y"
                                 { (yyval.stmt) = (yyvsp[0].stmt); }
#line 6843 "compiler/parser.c"
    break;

  case 302: /* $@9: %empty  */
#line 2193 "../compiler/parser.y"
    {
      stentry f;
      
      if (isTypedef || (yyvsp[0].decl)->decl->type != DFUNC)
        parse_error(1, "function definition cannot be parsed.\n");
      f = symtab_get(stab, decl_getidentifier_symbol((yyvsp[0].decl)), FUNCNAME);
      if (f && f->funcdef)
        parse_error(1, "function %s is multiply defined.\n", f->key->name);
      if (f == NULL)
      {
        f = symtab_put(stab, decl_getidentifier_symbol((yyvsp[0].decl)), FUNCNAME);
        f->spec = (yyvsp[-1].spec);
        f->decl = (yyvsp[0].decl);
      }

      scope_start(stab);
      ast_declare_function_params((yyvsp[0].decl));
    }
#line 6866 "compiler/parser.c"
    break;

  case 303: /* normal_function_definition: declaration_specifiers declarator_and_maybe_attributes $@9 compound_statement  */
#line 2212 "../compiler/parser.y"
    {
      scope_end(stab);
      check_for_main_and_declare((yyvsp[-3].spec), (yyvsp[-2].decl));
      (yyval.stmt) = FuncDef((yyvsp[-3].spec), (yyvsp[-2].decl), NULL, (yyvsp[0].stmt));
      symtab_get(stab, decl_getidentifier_symbol((yyvsp[-2].decl)), FUNCNAME)->funcdef = (yyval.stmt);
    }
#line 6877 "compiler/parser.c"
    break;

  case 304: /* $@10: %empty  */
#line 2219 "../compiler/parser.y"
    {
      stentry f;
      
      if (isTypedef || (yyvsp[0].decl)->decl->type != DFUNC)
        parse_error(1, "function definition cannot be parsed.\n");
      f = symtab_get(stab, decl_getidentifier_symbol((yyvsp[0].decl)), FUNCNAME);
      if (f && f->funcdef)
        parse_error(1, "function %s is multiply defined.\n", f->key->name);
      if (f == NULL)
      {
        f = symtab_put(stab, decl_getidentifier_symbol((yyvsp[0].decl)), FUNCNAME);
        f->spec = NULL;
        f->decl = (yyvsp[0].decl);
      }

      scope_start(stab);
      ast_declare_function_params((yyvsp[0].decl));
    }
#line 6900 "compiler/parser.c"
    break;

  case 305: /* normal_function_definition: declarator_and_maybe_attributes $@10 compound_statement  */
#line 2238 "../compiler/parser.y"
    {
      astspec s = Declspec(SPEC_int);  /* return type defaults to "int" */
      stentry f;
      
      scope_end(stab);
      check_for_main_and_declare(s, (yyvsp[-2].decl));
      (yyval.stmt) = FuncDef(s, (yyvsp[-2].decl), NULL, (yyvsp[0].stmt));
      
      f = symtab_get(stab, decl_getidentifier_symbol((yyvsp[-2].decl)), FUNCNAME);
      if (!f->spec) f->spec = s;
      f->funcdef = (yyval.stmt);
    }
#line 6917 "compiler/parser.c"
    break;

  case 306: /* $@11: %empty  */
#line 2254 "../compiler/parser.y"
    {
      stentry f;
      
      if (isTypedef || (yyvsp[0].decl)->decl->type != DFUNC)
        parse_error(1, "function definition cannot be parsed.\n");
      f = symtab_get(stab, decl_getidentifier_symbol((yyvsp[0].decl)), FUNCNAME);
      if (f && f->funcdef)
        parse_error(1, "function %s is multiply defined.\n", f->key->name);
      if (f == NULL)
      {
        f = symtab_put(stab, decl_getidentifier_symbol((yyvsp[0].decl)), FUNCNAME);
        f->spec = (yyvsp[-1].spec);
        f->decl = (yyvsp[0].decl);
      }

      scope_start(stab);
      /* Notice here that the function parameters are declared through
       * the declaration_list and we need to do nothing else!
       */
    }
#line 6942 "compiler/parser.c"
    break;

  case 307: /* oldstyle_function_definition: declaration_specifiers declarator_and_maybe_attributes $@11 declaration_list compound_statement  */
#line 2275 "../compiler/parser.y"
    {
      scope_end(stab);
      check_for_main_and_declare((yyvsp[-4].spec), (yyvsp[-3].decl));
      (yyval.stmt) = FuncDef((yyvsp[-4].spec), (yyvsp[-3].decl), (yyvsp[-1].stmt), (yyvsp[0].stmt));
      symtab_get(stab, decl_getidentifier_symbol((yyvsp[-3].decl)), FUNCNAME)->funcdef = (yyval.stmt);
    }
#line 6953 "compiler/parser.c"
    break;

  case 308: /* $@12: %empty  */
#line 2282 "../compiler/parser.y"
    {
      stentry f;
      
      if (isTypedef || (yyvsp[0].decl)->decl->type != DFUNC)
        parse_error(1, "function definition cannot be parsed.\n");
      f = symtab_get(stab, decl_getidentifier_symbol((yyvsp[0].decl)), FUNCNAME);
      if (f && f->funcdef)
        parse_error(1, "function %s is multiply defined.\n", f->key->name);
      if (f == NULL)
      {
        f = symtab_put(stab, decl_getidentifier_symbol((yyvsp[0].decl)), FUNCNAME);
        f->spec = NULL;
        f->decl = (yyvsp[0].decl);
      }

      scope_start(stab);
      /* Notice here that the function parameters are declared through
       * the declaration_list and we need to do nothing else!
       */
    }
#line 6978 "compiler/parser.c"
    break;

  case 309: /* oldstyle_function_definition: declarator_and_maybe_attributes $@12 declaration_list compound_statement  */
#line 2303 "../compiler/parser.y"
    {
      astspec s = Declspec(SPEC_int);  /* return type defaults to "int" */
      stentry f;

      scope_end(stab);
      check_for_main_and_declare(s, (yyvsp[-3].decl));
      (yyval.stmt) = FuncDef(s, (yyvsp[-3].decl), (yyvsp[-1].stmt), (yyvsp[0].stmt));
      
      f = symtab_get(stab, decl_getidentifier_symbol((yyvsp[-3].decl)), FUNCNAME);
      if (!f->spec) f->spec = s;
      f->funcdef = (yyval.stmt);
    }
#line 6995 "compiler/parser.c"
    break;

  case 310: /* declaration_list: declaration  */
#line 2319 "../compiler/parser.y"
                { (yyval.stmt) = (yyvsp[0].stmt); }
#line 7001 "compiler/parser.c"
    break;

  case 311: /* declaration_list: declaration_list declaration  */
#line 2321 "../compiler/parser.y"
    {
      (yyval.stmt) = BlockList((yyvsp[-1].stmt), (yyvsp[0].stmt));         /* Same as block list */
    }
#line 7009 "compiler/parser.c"
    break;

  case 312: /* asm_statement: __ASM__ asm_stmtrest  */
#line 2341 "../compiler/parser.y"
    {
      ((yyval.stmt) = (yyvsp[0].stmt))->u.assem->qualifiers = NULL;
    }
#line 7017 "compiler/parser.c"
    break;

  case 313: /* asm_statement: __ASM__ asm_qualifiers asm_stmtrest  */
#line 2345 "../compiler/parser.y"
    {
      ((yyval.stmt) = (yyvsp[0].stmt))->u.assem->qualifiers = (yyvsp[-1].spec);
    }
#line 7025 "compiler/parser.c"
    break;

  case 314: /* asm_stmtrest: '(' string_literal ')'  */
#line 2352 "../compiler/parser.y"
    {
      (yyval.stmt) = BasicAsm(NULL, (yyvsp[-1].string));
    }
#line 7033 "compiler/parser.c"
    break;

  case 315: /* asm_stmtrest: '(' string_literal ':' asm_output ')'  */
#line 2356 "../compiler/parser.y"
    {
      (yyval.stmt) = XtendAsm(NULL, (yyvsp[-3].string), (yyvsp[-1].asmo), NULL, NULL);
    }
#line 7041 "compiler/parser.c"
    break;

  case 316: /* asm_stmtrest: '(' string_literal ':' asm_output ':' asm_input ')'  */
#line 2360 "../compiler/parser.y"
    {
      (yyval.stmt) = XtendAsm(NULL, (yyvsp[-5].string), (yyvsp[-3].asmo), (yyvsp[-1].asmo), NULL);
    }
#line 7049 "compiler/parser.c"
    break;

  case 317: /* asm_stmtrest: '(' string_literal ':' asm_output ':' asm_input ':' asm_clobbers ')'  */
#line 2364 "../compiler/parser.y"
    {
      (yyval.stmt) = XtendAsm(NULL, (yyvsp[-7].string), (yyvsp[-5].asmo), (yyvsp[-3].asmo), (yyvsp[-1].expr));
    }
#line 7057 "compiler/parser.c"
    break;

  case 318: /* asm_stmtrest: GOTO '(' string_literal ':' ':' asm_input ':' asm_clobbers ':' labellist ')'  */
#line 2368 "../compiler/parser.y"
    {
      (yyval.stmt) = XtendAsmGoto((yyvsp[-8].string), (yyvsp[-5].asmo), (yyvsp[-3].expr), (yyvsp[-1].expr));
    }
#line 7065 "compiler/parser.c"
    break;

  case 319: /* asm_qualifiers: asm_qualifier  */
#line 2374 "../compiler/parser.y"
                  { (yyval.spec) = (yyvsp[0].spec); }
#line 7071 "compiler/parser.c"
    break;

  case 320: /* asm_qualifiers: asm_qualifiers asm_qualifier  */
#line 2376 "../compiler/parser.y"
    {
      (yyval.spec) = Speclist_right((yyvsp[-1].spec), (yyvsp[0].spec));
    }
#line 7079 "compiler/parser.c"
    break;

  case 321: /* asm_qualifier: VOLATILE  */
#line 2382 "../compiler/parser.y"
             { (yyval.spec) = Declspec(SPEC_volatile); }
#line 7085 "compiler/parser.c"
    break;

  case 322: /* asm_qualifier: INLINE  */
#line 2383 "../compiler/parser.y"
             { (yyval.spec) = Declspec(SPEC_inline); }
#line 7091 "compiler/parser.c"
    break;

  case 323: /* asm_output: %empty  */
#line 2387 "../compiler/parser.y"
    {
      (yyval.asmo) = NULL;
    }
#line 7099 "compiler/parser.c"
    break;

  case 324: /* asm_output: asm_outoperand  */
#line 2390 "../compiler/parser.y"
                   { (yyval.asmo) = (yyvsp[0].asmo); }
#line 7105 "compiler/parser.c"
    break;

  case 325: /* asm_output: asm_output ',' asm_outoperand  */
#line 2392 "../compiler/parser.y"
    {
      (yyval.asmo) = XAsmOpList((yyvsp[-2].asmo), (yyvsp[0].asmo));
    }
#line 7113 "compiler/parser.c"
    break;

  case 326: /* asm_outoperand: '[' IDENTIFIER ']' string_literal '(' unary_expression ')'  */
#line 2399 "../compiler/parser.y"
    {
      (yyval.asmo) = XAsmOperand(IdentName((yyvsp[-5].name)), (yyvsp[-3].string), (yyvsp[-1].expr));
    }
#line 7121 "compiler/parser.c"
    break;

  case 327: /* asm_outoperand: string_literal '(' unary_expression ')'  */
#line 2403 "../compiler/parser.y"
    {
      (yyval.asmo) = XAsmOperand(NULL, (yyvsp[-3].string), (yyvsp[-1].expr));
    }
#line 7129 "compiler/parser.c"
    break;

  case 328: /* asm_input: %empty  */
#line 2409 "../compiler/parser.y"
    {
      (yyval.asmo) = NULL;
    }
#line 7137 "compiler/parser.c"
    break;

  case 329: /* asm_input: asm_inoperand  */
#line 2412 "../compiler/parser.y"
                  { (yyval.asmo) = (yyvsp[0].asmo); }
#line 7143 "compiler/parser.c"
    break;

  case 330: /* asm_input: asm_input ',' asm_inoperand  */
#line 2414 "../compiler/parser.y"
    {
      (yyval.asmo) = XAsmOpList((yyvsp[-2].asmo), (yyvsp[0].asmo));
    }
#line 7151 "compiler/parser.c"
    break;

  case 331: /* asm_inoperand: '[' IDENTIFIER ']' string_literal '(' expression ')'  */
#line 2421 "../compiler/parser.y"
    {
      (yyval.asmo) = XAsmOperand(IdentName((yyvsp[-5].name)), (yyvsp[-3].string), (yyvsp[-1].expr));
    }
#line 7159 "compiler/parser.c"
    break;

  case 332: /* asm_inoperand: string_literal '(' expression ')'  */
#line 2425 "../compiler/parser.y"
    {
      (yyval.asmo) = XAsmOperand(NULL, (yyvsp[-3].string), (yyvsp[-1].expr));
    }
#line 7167 "compiler/parser.c"
    break;

  case 333: /* asm_clobbers: string_literal  */
#line 2432 "../compiler/parser.y"
    {
      (yyval.expr) = String((yyvsp[0].string));
    }
#line 7175 "compiler/parser.c"
    break;

  case 334: /* asm_clobbers: asm_clobbers ',' string_literal  */
#line 2436 "../compiler/parser.y"
    {
       (yyval.expr) = CommaList((yyvsp[-2].expr), String((yyvsp[0].string)));
    }
#line 7183 "compiler/parser.c"
    break;

  case 335: /* labellist: IDENTIFIER  */
#line 2443 "../compiler/parser.y"
    { 
      (yyval.expr) = IdentName((yyvsp[0].name));
    }
#line 7191 "compiler/parser.c"
    break;

  case 336: /* labellist: labellist ',' IDENTIFIER  */
#line 2447 "../compiler/parser.y"
    {
       (yyval.expr) = CommaList((yyvsp[-2].expr), IdentName((yyvsp[0].name)));
    }
#line 7199 "compiler/parser.c"
    break;

  case 337: /* asm_asmname: __ASM__ '(' string_literal ')'  */
#line 2454 "../compiler/parser.y"
    {
      (yyval.spec) = AsmNameSpec((yyvsp[-1].string));
    }
#line 7207 "compiler/parser.c"
    break;

  case 338: /* attribute_optseq: %empty  */
#line 2465 "../compiler/parser.y"
                {
			(yyval.spec) = NULL;
		}
#line 7215 "compiler/parser.c"
    break;

  case 339: /* attribute_optseq: attribute_seq  */
#line 2469 "../compiler/parser.y"
                {
			(yyval.spec) = (yyvsp[0].spec);
		}
#line 7223 "compiler/parser.c"
    break;

  case 340: /* attribute_seq: attribute  */
#line 2476 "../compiler/parser.y"
                {
			(yyval.spec) = (yyvsp[0].spec);
		}
#line 7231 "compiler/parser.c"
    break;

  case 341: /* attribute_seq: attribute_seq attribute  */
#line 2480 "../compiler/parser.y"
                {
			(yyval.spec) = Speclist_left((yyvsp[-1].spec), (yyvsp[0].spec));
		}
#line 7239 "compiler/parser.c"
    break;

  case 342: /* attribute: __ATTRIBUTE__  */
#line 2487 "../compiler/parser.y"
                {
			if (strlen((yyvsp[0].name)) == 0) parse_error(1, "invalid attribute syntax");
			(yyval.spec) = AttrSpec(strdup((yyvsp[0].name)));
		}
#line 7248 "compiler/parser.c"
    break;

  case 343: /* declaration_definition: function_definition  */
#line 2509 "../compiler/parser.y"
                        { (yyval.stmt) = (yyvsp[0].stmt); }
#line 7254 "compiler/parser.c"
    break;

  case 344: /* declaration_definition: declaration  */
#line 2510 "../compiler/parser.y"
                { (yyval.stmt) = (yyvsp[0].stmt); }
#line 7260 "compiler/parser.c"
    break;

  case 345: /* function_statement: function_definition  */
#line 2515 "../compiler/parser.y"
                        { (yyval.stmt) = (yyvsp[0].stmt); }
#line 7266 "compiler/parser.c"
    break;

  case 346: /* declarations_definitions_seq: declaration_definition  */
#line 2521 "../compiler/parser.y"
                           { (yyval.stmt) = (yyvsp[0].stmt); }
#line 7272 "compiler/parser.c"
    break;

  case 347: /* declarations_definitions_seq: declarations_definitions_seq declaration_definition  */
#line 2523 "../compiler/parser.y"
    {
      (yyval.stmt) = pastree = BlockList((yyvsp[-1].stmt), (yyvsp[0].stmt));
    }
#line 7280 "compiler/parser.c"
    break;

  case 348: /* openmp_construct: parallel_construct  */
#line 2529 "../compiler/parser.y"
                       { (yyval.ocon) = (yyvsp[0].ocon); }
#line 7286 "compiler/parser.c"
    break;

  case 349: /* openmp_construct: for_construct  */
#line 2530 "../compiler/parser.y"
                  { (yyval.ocon) = (yyvsp[0].ocon); }
#line 7292 "compiler/parser.c"
    break;

  case 350: /* openmp_construct: sections_construct  */
#line 2531 "../compiler/parser.y"
                       { (yyval.ocon) = (yyvsp[0].ocon); }
#line 7298 "compiler/parser.c"
    break;

  case 351: /* openmp_construct: single_construct  */
#line 2532 "../compiler/parser.y"
                     { (yyval.ocon) = (yyvsp[0].ocon); }
#line 7304 "compiler/parser.c"
    break;

  case 352: /* openmp_construct: parallel_for_construct  */
#line 2533 "../compiler/parser.y"
                           { (yyval.ocon) = (yyvsp[0].ocon); }
#line 7310 "compiler/parser.c"
    break;

  case 353: /* openmp_construct: parallel_sections_construct  */
#line 2534 "../compiler/parser.y"
                                { (yyval.ocon) = (yyvsp[0].ocon); }
#line 7316 "compiler/parser.c"
    break;

  case 354: /* openmp_construct: master_construct  */
#line 2535 "../compiler/parser.y"
                     { (yyval.ocon) = (yyvsp[0].ocon); }
#line 7322 "compiler/parser.c"
    break;

  case 355: /* openmp_construct: critical_construct  */
#line 2536 "../compiler/parser.y"
                       { (yyval.ocon) = (yyvsp[0].ocon); }
#line 7328 "compiler/parser.c"
    break;

  case 356: /* openmp_construct: atomic_construct  */
#line 2537 "../compiler/parser.y"
                     { (yyval.ocon) = (yyvsp[0].ocon); }
#line 7334 "compiler/parser.c"
    break;

  case 357: /* openmp_construct: ordered_construct  */
#line 2538 "../compiler/parser.y"
                      { (yyval.ocon) = (yyvsp[0].ocon); }
#line 7340 "compiler/parser.c"
    break;

  case 358: /* openmp_construct: task_construct  */
#line 2540 "../compiler/parser.y"
                    { (yyval.ocon) = (yyvsp[0].ocon); }
#line 7346 "compiler/parser.c"
    break;

  case 359: /* openmp_construct: simd_construct  */
#line 2542 "../compiler/parser.y"
                   { (yyval.ocon) = (yyvsp[0].ocon); }
#line 7352 "compiler/parser.c"
    break;

  case 360: /* openmp_construct: for_simd_construct  */
#line 2543 "../compiler/parser.y"
                       { (yyval.ocon) = (yyvsp[0].ocon); }
#line 7358 "compiler/parser.c"
    break;

  case 361: /* openmp_construct: parallel_for_simd_construct  */
#line 2544 "../compiler/parser.y"
                                { (yyval.ocon) = (yyvsp[0].ocon); }
#line 7364 "compiler/parser.c"
    break;

  case 362: /* openmp_construct: target_data_construct  */
#line 2545 "../compiler/parser.y"
                          { (yyval.ocon) = (yyvsp[0].ocon); }
#line 7370 "compiler/parser.c"
    break;

  case 363: /* openmp_construct: target_construct  */
#line 2546 "../compiler/parser.y"
                     { (yyval.ocon) = (yyvsp[0].ocon); }
#line 7376 "compiler/parser.c"
    break;

  case 364: /* openmp_construct: teams_construct  */
#line 2547 "../compiler/parser.y"
                    { (yyval.ocon) = (yyvsp[0].ocon); }
#line 7382 "compiler/parser.c"
    break;

  case 365: /* openmp_construct: distribute_construct  */
#line 2548 "../compiler/parser.y"
                         { (yyval.ocon) = (yyvsp[0].ocon); }
#line 7388 "compiler/parser.c"
    break;

  case 366: /* openmp_construct: distribute_simd_construct  */
#line 2549 "../compiler/parser.y"
                              { (yyval.ocon) = (yyvsp[0].ocon); }
#line 7394 "compiler/parser.c"
    break;

  case 367: /* openmp_construct: distribute_parallel_for_construct  */
#line 2550 "../compiler/parser.y"
                                      { (yyval.ocon) = (yyvsp[0].ocon); }
#line 7400 "compiler/parser.c"
    break;

  case 368: /* openmp_construct: distribute_parallel_for_simd_construct  */
#line 2551 "../compiler/parser.y"
                                           { (yyval.ocon) = (yyvsp[0].ocon); }
#line 7406 "compiler/parser.c"
    break;

  case 369: /* openmp_construct: target_teams_construct  */
#line 2552 "../compiler/parser.y"
                           { (yyval.ocon) = (yyvsp[0].ocon); }
#line 7412 "compiler/parser.c"
    break;

  case 370: /* openmp_construct: target_parallel_construct  */
#line 2553 "../compiler/parser.y"
                              { (yyval.ocon) = (yyvsp[0].ocon); }
#line 7418 "compiler/parser.c"
    break;

  case 371: /* openmp_construct: target_parallel_for_construct  */
#line 2554 "../compiler/parser.y"
                                  { (yyval.ocon) = (yyvsp[0].ocon); }
#line 7424 "compiler/parser.c"
    break;

  case 372: /* openmp_construct: teams_distribute_construct  */
#line 2555 "../compiler/parser.y"
                               { (yyval.ocon) = (yyvsp[0].ocon); }
#line 7430 "compiler/parser.c"
    break;

  case 373: /* openmp_construct: teams_distribute_simd_construct  */
#line 2556 "../compiler/parser.y"
                                    { (yyval.ocon) = (yyvsp[0].ocon); }
#line 7436 "compiler/parser.c"
    break;

  case 374: /* openmp_construct: target_teams_distribute_construct  */
#line 2557 "../compiler/parser.y"
                                      { (yyval.ocon) = (yyvsp[0].ocon); }
#line 7442 "compiler/parser.c"
    break;

  case 375: /* openmp_construct: target_teams_distribute_simd_construct  */
#line 2558 "../compiler/parser.y"
                                           { (yyval.ocon) = (yyvsp[0].ocon); }
#line 7448 "compiler/parser.c"
    break;

  case 376: /* openmp_construct: teams_distribute_parallel_for_construct  */
#line 2559 "../compiler/parser.y"
                                            { (yyval.ocon) = (yyvsp[0].ocon); }
#line 7454 "compiler/parser.c"
    break;

  case 377: /* openmp_construct: target_teams_distribute_parallel_for_construct  */
#line 2560 "../compiler/parser.y"
                                                   { (yyval.ocon) = (yyvsp[0].ocon); }
#line 7460 "compiler/parser.c"
    break;

  case 378: /* openmp_construct: teams_distribute_parallel_for_simd_construct  */
#line 2561 "../compiler/parser.y"
                                                 { (yyval.ocon) = (yyvsp[0].ocon); }
#line 7466 "compiler/parser.c"
    break;

  case 379: /* openmp_construct: target_teams_distribute_parallel_for_simd_construct  */
#line 2562 "../compiler/parser.y"
                                                        { (yyval.ocon) = (yyvsp[0].ocon); }
#line 7472 "compiler/parser.c"
    break;

  case 380: /* openmp_construct: taskgroup_construct  */
#line 2564 "../compiler/parser.y"
                        { (yyval.ocon) = (yyvsp[0].ocon); }
#line 7478 "compiler/parser.c"
    break;

  case 381: /* openmp_construct: masked_construct  */
#line 2566 "../compiler/parser.y"
                     { (yyval.ocon) = (yyvsp[0].ocon); }
#line 7484 "compiler/parser.c"
    break;

  case 382: /* openmp_directive: barrier_directive  */
#line 2578 "../compiler/parser.y"
    {
      (yyval.ocon) = OmpConstruct(DCBARRIER, (yyvsp[0].odir), NULL);
    }
#line 7492 "compiler/parser.c"
    break;

  case 383: /* openmp_directive: flush_directive  */
#line 2582 "../compiler/parser.y"
    {
      (yyval.ocon) = OmpConstruct(DCFLUSH, (yyvsp[0].odir), NULL);
    }
#line 7500 "compiler/parser.c"
    break;

  case 384: /* openmp_directive: taskwait_directive  */
#line 2587 "../compiler/parser.y"
    {
      (yyval.ocon) = OmpConstruct(DCTASKWAIT, (yyvsp[0].odir), NULL);
    }
#line 7508 "compiler/parser.c"
    break;

  case 385: /* openmp_directive: taskyield_directive  */
#line 2592 "../compiler/parser.y"
    {
      (yyval.ocon) = OmpConstruct(DCTASKYIELD, (yyvsp[0].odir), NULL);
    }
#line 7516 "compiler/parser.c"
    break;

  case 386: /* openmp_directive: cancel_directive  */
#line 2597 "../compiler/parser.y"
    {
      (yyval.ocon) = OmpConstruct(DCCANCEL, (yyvsp[0].odir), NULL);
    }
#line 7524 "compiler/parser.c"
    break;

  case 387: /* openmp_directive: cancellation_point_directive  */
#line 2602 "../compiler/parser.y"
    {
      (yyval.ocon) = OmpConstruct(DCCANCELLATIONPOINT, (yyvsp[0].odir), NULL);
    }
#line 7532 "compiler/parser.c"
    break;

  case 388: /* openmp_directive: target_update_directive  */
#line 2607 "../compiler/parser.y"
    {
      (yyval.ocon) = OmpConstruct(DCTARGETUPDATE, (yyvsp[0].odir), NULL);
    }
#line 7540 "compiler/parser.c"
    break;

  case 389: /* openmp_directive: target_enter_data_directive  */
#line 2612 "../compiler/parser.y"
    {
      (yyval.ocon) = OmpConstruct(DCTARGETENTERDATA, (yyvsp[0].odir), NULL);
    }
#line 7548 "compiler/parser.c"
    break;

  case 390: /* openmp_directive: target_exit_data_directive  */
#line 2617 "../compiler/parser.y"
    {
      (yyval.ocon) = OmpConstruct(DCTARGETEXITDATA, (yyvsp[0].odir), NULL);
    }
#line 7556 "compiler/parser.c"
    break;

  case 391: /* openmp_directive: error_directive  */
#line 2622 "../compiler/parser.y"
    { 
      (yyval.ocon) = OmpConstruct(DCERROR, (yyvsp[0].odir), NULL);
    }
#line 7564 "compiler/parser.c"
    break;

  case 392: /* structured_block: statement  */
#line 2628 "../compiler/parser.y"
              { (yyval.stmt) = (yyvsp[0].stmt); }
#line 7570 "compiler/parser.c"
    break;

  case 393: /* parallel_construct: parallel_directive structured_block  */
#line 2633 "../compiler/parser.y"
    {
      (yyval.ocon) = OmpConstruct(DCPARALLEL, (yyvsp[-1].odir), (yyvsp[0].stmt));
      (yyval.ocon)->l = (yyvsp[-1].odir)->l;
    }
#line 7579 "compiler/parser.c"
    break;

  case 394: /* parallel_directive: PRAGMA_OMP OMP_PARALLEL parallel_clause_optseq '\n'  */
#line 2641 "../compiler/parser.y"
    {
      (yyval.odir) = OmpDirective(DCPARALLEL, (yyvsp[-1].ocla));
    }
#line 7587 "compiler/parser.c"
    break;

  case 395: /* parallel_clause_optseq: %empty  */
#line 2648 "../compiler/parser.y"
    {
      (yyval.ocla) = NULL;
    }
#line 7595 "compiler/parser.c"
    break;

  case 396: /* parallel_clause_optseq: parallel_clause_optseq parallel_clause  */
#line 2652 "../compiler/parser.y"
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
    }
#line 7603 "compiler/parser.c"
    break;

  case 397: /* parallel_clause_optseq: parallel_clause_optseq ',' parallel_clause  */
#line 2656 "../compiler/parser.y"
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
    }
#line 7611 "compiler/parser.c"
    break;

  case 398: /* parallel_clause: unique_parallel_clause  */
#line 2662 "../compiler/parser.y"
                           { (yyval.ocla) = (yyvsp[0].ocla); }
#line 7617 "compiler/parser.c"
    break;

  case 399: /* parallel_clause: if_clause  */
#line 2663 "../compiler/parser.y"
              { (yyval.ocla) = (yyvsp[0].ocla); }
#line 7623 "compiler/parser.c"
    break;

  case 400: /* parallel_clause: data_default_clause  */
#line 2664 "../compiler/parser.y"
                        { (yyval.ocla) = (yyvsp[0].ocla); }
#line 7629 "compiler/parser.c"
    break;

  case 401: /* parallel_clause: data_privatization_clause  */
#line 2665 "../compiler/parser.y"
                              { (yyval.ocla) = (yyvsp[0].ocla); }
#line 7635 "compiler/parser.c"
    break;

  case 402: /* parallel_clause: data_privatization_in_clause  */
#line 2666 "../compiler/parser.y"
                                 { (yyval.ocla) = (yyvsp[0].ocla); }
#line 7641 "compiler/parser.c"
    break;

  case 403: /* parallel_clause: data_sharing_clause  */
#line 2667 "../compiler/parser.y"
                        { (yyval.ocla) = (yyvsp[0].ocla); }
#line 7647 "compiler/parser.c"
    break;

  case 404: /* parallel_clause: data_reduction_clause  */
#line 2668 "../compiler/parser.y"
                          { (yyval.ocla) = (yyvsp[0].ocla); }
#line 7653 "compiler/parser.c"
    break;

  case 405: /* paren_dirnamemod_and_expr: '(' expression ')'  */
#line 2692 "../compiler/parser.y"
                { 
		  (yyval.expr) = UnaryOperator(OCM_none, (yyvsp[-1].expr));
		}
#line 7661 "compiler/parser.c"
    break;

  case 406: /* paren_dirnamemod_and_expr: '(' IDENTIFIER ':' expression ')'  */
#line 2696 "../compiler/parser.y"
          {
	    (yyval.expr) = UnaryOperator(mk_dirname_modifier((yyvsp[-3].name)), (yyvsp[-1].expr));
	  }
#line 7669 "compiler/parser.c"
    break;

  case 407: /* paren_dirnamemod_and_optexpr: '(' expression ')'  */
#line 2706 "../compiler/parser.y"
                { 
		  (yyval.expr) = UnaryOperator(OCM_none, (yyvsp[-1].expr));
		}
#line 7677 "compiler/parser.c"
    break;

  case 408: /* paren_dirnamemod_and_optexpr: '(' IDENTIFIER ':' ')'  */
#line 2710 "../compiler/parser.y"
          {
	    (yyval.expr) = UnaryOperator(mk_dirname_modifier((yyvsp[-2].name)), NULL);
	  }
#line 7685 "compiler/parser.c"
    break;

  case 409: /* paren_dirnamemod_and_optexpr: '(' IDENTIFIER ':' expression ')'  */
#line 2714 "../compiler/parser.y"
          {
	    (yyval.expr) = UnaryOperator(mk_dirname_modifier((yyvsp[-3].name)), (yyvsp[-1].expr));
	  }
#line 7693 "compiler/parser.c"
    break;

  case 410: /* paren_dirnamemod_and_varlist: '(' variable_list ')'  */
#line 2722 "../compiler/parser.y"
                { 
		  (yyval.ocla) = VarlistClause(OCM_none, (yyvsp[-1].decl));                  /* Dummy type */
		}
#line 7701 "compiler/parser.c"
    break;

  case 411: /* paren_dirnamemod_and_varlist: '(' IDENTIFIER ':' variable_list ')'  */
#line 2726 "../compiler/parser.y"
          {
	    (yyval.ocla) = VarlistClause(OCM_none, (yyvsp[-1].decl));  /* Dummy type */
	    add_modifier((yyval.ocla), mk_dirname_modifier((yyvsp[-3].name)));
	  }
#line 7710 "compiler/parser.c"
    break;

  case 412: /* paren_dirnamemod_and_xlist: '(' variable_array_section_list ')'  */
#line 2735 "../compiler/parser.y"
                { 
		  (yyval.ocla) = OmpXlistClause(OCM_none, OC_DontCare, (yyvsp[-1].oxli)); /* Dummy type */
		}
#line 7718 "compiler/parser.c"
    break;

  case 413: /* paren_dirnamemod_and_xlist: '(' IDENTIFIER ':' variable_array_section_list ')'  */
#line 2739 "../compiler/parser.y"
          {
	    (yyval.ocla) = OmpXlistClause(OCM_none, OC_DontCare, (yyvsp[-1].oxli)); /* Dummy type */
	    add_modifier((yyval.ocla), mk_dirname_modifier((yyvsp[-3].name)));
	  }
#line 7727 "compiler/parser.c"
    break;

  case 414: /* dirname_modifier: OMP_PARALLEL  */
#line 2747 "../compiler/parser.y"
                          { (yyval.type) = DirnameModifier(DCPARALLEL); }
#line 7733 "compiler/parser.c"
    break;

  case 415: /* dirname_modifier: OMP_FOR  */
#line 2748 "../compiler/parser.y"
                          { (yyval.type) = DirnameModifier(DCFOR); }
#line 7739 "compiler/parser.c"
    break;

  case 416: /* dirname_modifier: OMP_SECTIONS  */
#line 2749 "../compiler/parser.y"
                          { (yyval.type) = DirnameModifier(DCSECTIONS); }
#line 7745 "compiler/parser.c"
    break;

  case 417: /* dirname_modifier: OMP_SINGLE  */
#line 2750 "../compiler/parser.y"
                          { (yyval.type) = DirnameModifier(DCSINGLE); }
#line 7751 "compiler/parser.c"
    break;

  case 418: /* dirname_modifier: OMP_CRITICAL  */
#line 2751 "../compiler/parser.y"
                          { (yyval.type) = DirnameModifier(DCCRITICAL); }
#line 7757 "compiler/parser.c"
    break;

  case 419: /* dirname_modifier: OMP_ATOMIC  */
#line 2752 "../compiler/parser.y"
                          { (yyval.type) = DirnameModifier(DCATOMIC); }
#line 7763 "compiler/parser.c"
    break;

  case 420: /* dirname_modifier: OMP_ORDERED  */
#line 2753 "../compiler/parser.y"
                          { (yyval.type) = DirnameModifier(DCORDERED); }
#line 7769 "compiler/parser.c"
    break;

  case 421: /* dirname_modifier: OMP_BARRIER  */
#line 2754 "../compiler/parser.y"
                          { (yyval.type) = DirnameModifier(DCBARRIER); }
#line 7775 "compiler/parser.c"
    break;

  case 422: /* dirname_modifier: OMP_FLUSH  */
#line 2755 "../compiler/parser.y"
                          { (yyval.type) = DirnameModifier(DCFLUSH); }
#line 7781 "compiler/parser.c"
    break;

  case 423: /* dirname_modifier: OMP_THREADPRIVATE  */
#line 2756 "../compiler/parser.y"
                          { (yyval.type) = DirnameModifier(DCTHREADPRIVATE); }
#line 7787 "compiler/parser.c"
    break;

  case 424: /* dirname_modifier: OMP_TASK  */
#line 2757 "../compiler/parser.y"
                          { (yyval.type) = DirnameModifier(DCTASK); }
#line 7793 "compiler/parser.c"
    break;

  case 425: /* dirname_modifier: OMP_TASKWAIT  */
#line 2758 "../compiler/parser.y"
                          { (yyval.type) = DirnameModifier(DCTASKWAIT); }
#line 7799 "compiler/parser.c"
    break;

  case 426: /* dirname_modifier: OMP_TASKYIELD  */
#line 2759 "../compiler/parser.y"
                          { (yyval.type) = DirnameModifier(DCTASKYIELD); }
#line 7805 "compiler/parser.c"
    break;

  case 427: /* dirname_modifier: OMP_SIMD  */
#line 2760 "../compiler/parser.y"
                          { (yyval.type) = DirnameModifier(DCSIMD); }
#line 7811 "compiler/parser.c"
    break;

  case 428: /* dirname_modifier: OMP_DISTRIBUTE  */
#line 2761 "../compiler/parser.y"
                          { (yyval.type) = DirnameModifier(DCDISTRIBUTE); }
#line 7817 "compiler/parser.c"
    break;

  case 429: /* dirname_modifier: OMP_TARGET  */
#line 2762 "../compiler/parser.y"
                          { (yyval.type) = DirnameModifier(DCTARGET); }
#line 7823 "compiler/parser.c"
    break;

  case 430: /* dirname_modifier: OMP_TARGETDATA  */
#line 2763 "../compiler/parser.y"
                          { (yyval.type) = DirnameModifier(DCTARGETDATA); }
#line 7829 "compiler/parser.c"
    break;

  case 431: /* dirname_modifier: OMP_TARGETUPDATE  */
#line 2764 "../compiler/parser.y"
                          { (yyval.type) = DirnameModifier(DCTARGETUPDATE); }
#line 7835 "compiler/parser.c"
    break;

  case 432: /* dirname_modifier: OMP_DECLARETARGET  */
#line 2765 "../compiler/parser.y"
                          { (yyval.type) = DirnameModifier(DCDECLARETARGET); }
#line 7841 "compiler/parser.c"
    break;

  case 433: /* dirname_modifier: OMP_CANCEL  */
#line 2766 "../compiler/parser.y"
                          { (yyval.type) = DirnameModifier(DCCANCEL); }
#line 7847 "compiler/parser.c"
    break;

  case 434: /* dirname_modifier: OMP_CANCELLATIONPOINT  */
#line 2767 "../compiler/parser.y"
                          { (yyval.type) = DirnameModifier(DCCANCELLATIONPOINT); }
#line 7853 "compiler/parser.c"
    break;

  case 435: /* dirname_modifier: OMP_TASKGROUP  */
#line 2768 "../compiler/parser.y"
                          { (yyval.type) = DirnameModifier(DCTASKGROUP); }
#line 7859 "compiler/parser.c"
    break;

  case 436: /* dirname_modifier: OMP_TEAMS  */
#line 2769 "../compiler/parser.y"
                          { (yyval.type) = DirnameModifier(DCTEAMS); }
#line 7865 "compiler/parser.c"
    break;

  case 437: /* dirname_modifier: OMP_TARGETENTERDATA  */
#line 2770 "../compiler/parser.y"
                          { (yyval.type) = DirnameModifier(DCTARGETENTERDATA); }
#line 7871 "compiler/parser.c"
    break;

  case 438: /* dirname_modifier: OMP_TARGETEXITDATA  */
#line 2771 "../compiler/parser.y"
                          { (yyval.type) = DirnameModifier(DCTARGETEXITDATA); }
#line 7877 "compiler/parser.c"
    break;

  case 439: /* dirname_modifier: OMP_REQUIRES  */
#line 2772 "../compiler/parser.y"
                          { (yyval.type) = DirnameModifier(DCREQUIRES); }
#line 7883 "compiler/parser.c"
    break;

  case 440: /* dirname_modifier: OMP_MASKED  */
#line 2773 "../compiler/parser.y"
                          { (yyval.type) = DirnameModifier(DCMASKED); }
#line 7889 "compiler/parser.c"
    break;

  case 441: /* dirname_modifier: OMP_ERROR  */
#line 2774 "../compiler/parser.y"
                          { (yyval.type) = DirnameModifier(DCERROR); }
#line 7895 "compiler/parser.c"
    break;

  case 442: /* dirname_modifier_opt: %empty  */
#line 2782 "../compiler/parser.y"
                         { (yyval.type) = OCM_none; }
#line 7901 "compiler/parser.c"
    break;

  case 443: /* dirname_modifier_opt: dirname_modifier ':'  */
#line 2783 "../compiler/parser.y"
                         { (yyval.type) = (yyvsp[-1].type); }
#line 7907 "compiler/parser.c"
    break;

  case 444: /* paren_dirnamemod_maybe: %empty  */
#line 2788 "../compiler/parser.y"
                                             { (yyval.type) = OCM_none; }
#line 7913 "compiler/parser.c"
    break;

  case 445: /* paren_dirnamemod_maybe: '(' dirname_modifier ')'  */
#line 2789 "../compiler/parser.y"
                                       { (yyval.type) = (yyvsp[-1].type); }
#line 7919 "compiler/parser.c"
    break;

  case 446: /* paren_dirnamemod_maybe: '(' dirname_modifier ':' ')'  */
#line 2790 "../compiler/parser.y"
                                       { (yyval.type) = (yyvsp[-2].type); }
#line 7925 "compiler/parser.c"
    break;

  case 447: /* $@13: %empty  */
#line 2794 "../compiler/parser.y"
                               { sc_pause_openmp(); }
#line 7931 "compiler/parser.c"
    break;

  case 448: /* num_threads_clause: OMP_NUMTHREADS $@13 paren_dirnamemod_and_expr  */
#line 2795 "../compiler/parser.y"
    {
      sc_start_openmp();
      (yyval.ocla) = add_modifier(NumthreadsClause((yyvsp[0].expr)->left), (yyvsp[0].expr)->opid);
      free((yyvsp[0].expr));
		}
#line 7941 "compiler/parser.c"
    break;

  case 449: /* $@14: %empty  */
#line 2803 "../compiler/parser.y"
               { sc_pause_openmp(); }
#line 7947 "compiler/parser.c"
    break;

  case 450: /* copyin_clause: OMP_COPYIN $@14 paren_dirnamemod_and_varlist  */
#line 2804 "../compiler/parser.y"
    {
      sc_start_openmp();
      (yyvsp[0].ocla)->type = OCCOPYIN;
      (yyval.ocla) = (yyvsp[0].ocla);
		}
#line 7957 "compiler/parser.c"
    break;

  case 451: /* unique_parallel_clause: num_threads_clause  */
#line 2812 "../compiler/parser.y"
                       { (yyval.ocla) = (yyvsp[0].ocla); }
#line 7963 "compiler/parser.c"
    break;

  case 452: /* unique_parallel_clause: copyin_clause  */
#line 2813 "../compiler/parser.y"
                  { (yyval.ocla) = (yyvsp[0].ocla); }
#line 7969 "compiler/parser.c"
    break;

  case 453: /* unique_parallel_clause: procbind_clause  */
#line 2814 "../compiler/parser.y"
                    { (yyval.ocla) = (yyvsp[0].ocla); }
#line 7975 "compiler/parser.c"
    break;

  case 454: /* $@15: %empty  */
#line 2816 "../compiler/parser.y"
             { sc_pause_openmp(); }
#line 7981 "compiler/parser.c"
    break;

  case 455: /* unique_parallel_clause: OMP_AUTO $@15 '(' variable_list ')'  */
#line 2817 "../compiler/parser.y"
    {
      sc_start_openmp();
      (yyval.ocla) = VarlistClause(OCAUTO, (yyvsp[-1].decl));
    }
#line 7990 "compiler/parser.c"
    break;

  case 456: /* for_construct: for_directive iteration_statement_for  */
#line 2825 "../compiler/parser.y"
    {
      (yyval.ocon) = OmpConstruct(DCFOR, (yyvsp[-1].odir), (yyvsp[0].stmt));
    }
#line 7998 "compiler/parser.c"
    break;

  case 457: /* for_directive: PRAGMA_OMP OMP_FOR for_clause_optseq '\n'  */
#line 2832 "../compiler/parser.y"
    {
      (yyval.odir) = OmpDirective(DCFOR, (yyvsp[-1].ocla));
    }
#line 8006 "compiler/parser.c"
    break;

  case 458: /* for_clause_optseq: %empty  */
#line 2839 "../compiler/parser.y"
    {
      (yyval.ocla) = NULL;
    }
#line 8014 "compiler/parser.c"
    break;

  case 459: /* for_clause_optseq: for_clause_optseq for_clause  */
#line 2843 "../compiler/parser.y"
    {
      #ifdef OMPI_OMP_EXT
        (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
      #else
        if ((yyvsp[0].ocla)->type==OCTAG){
          parse_warning("tag clause ignored;"
                "activate it by configuring OMPi with -Dext=true\n");
          (yyval.ocla) = (yyvsp[-1].ocla);
        }else
          (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
      #endif
    }
#line 8031 "compiler/parser.c"
    break;

  case 460: /* for_clause_optseq: for_clause_optseq ',' for_clause  */
#line 2856 "../compiler/parser.y"
    {
      #ifdef OMPI_OMP_EXT
        (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
      #else
        if ((yyvsp[0].ocla)->type==OCTAG){
          parse_warning("tag clause ignored;"
                "activate it by configuring OMPi with -Dext=true\n");
          (yyval.ocla) = (yyvsp[-2].ocla);
        }else
          (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
      #endif
    }
#line 8048 "compiler/parser.c"
    break;

  case 461: /* for_clause: unique_for_clause  */
#line 2871 "../compiler/parser.y"
                      { (yyval.ocla) = (yyvsp[0].ocla); }
#line 8054 "compiler/parser.c"
    break;

  case 462: /* for_clause: data_privatization_clause  */
#line 2872 "../compiler/parser.y"
                              { (yyval.ocla) = (yyvsp[0].ocla); }
#line 8060 "compiler/parser.c"
    break;

  case 463: /* for_clause: data_privatization_in_clause  */
#line 2873 "../compiler/parser.y"
                                 { (yyval.ocla) = (yyvsp[0].ocla); }
#line 8066 "compiler/parser.c"
    break;

  case 464: /* for_clause: data_privatization_out_clause  */
#line 2874 "../compiler/parser.y"
                                  { (yyval.ocla) = (yyvsp[0].ocla); }
#line 8072 "compiler/parser.c"
    break;

  case 465: /* for_clause: data_reduction_clause  */
#line 2875 "../compiler/parser.y"
                          { (yyval.ocla) = (yyvsp[0].ocla); }
#line 8078 "compiler/parser.c"
    break;

  case 466: /* for_clause: nowait_clause  */
#line 2876 "../compiler/parser.y"
                  { (yyval.ocla) = (yyvsp[0].ocla); }
#line 8084 "compiler/parser.c"
    break;

  case 467: /* nowait_clause: OMP_NOWAIT  */
#line 2880 "../compiler/parser.y"
               { (yyval.ocla) = PlainClause(OCNOWAIT); }
#line 8090 "compiler/parser.c"
    break;

  case 468: /* nowait_clause: OMP_NOWAIT '(' dirname_modifier ':' ')'  */
#line 2882 "../compiler/parser.y"
    {
      (yyval.ocla) = add_modifier(PlainClause(OCNOWAIT), (yyvsp[-2].type));
    }
#line 8098 "compiler/parser.c"
    break;

  case 469: /* unique_for_clause: ordered_clause  */
#line 2888 "../compiler/parser.y"
                   { (yyval.ocla) = (yyvsp[0].ocla); }
#line 8104 "compiler/parser.c"
    break;

  case 470: /* unique_for_clause: schedule_clause  */
#line 2889 "../compiler/parser.y"
                    { (yyval.ocla) = (yyvsp[0].ocla); }
#line 8110 "compiler/parser.c"
    break;

  case 471: /* unique_for_clause: collapse_clause  */
#line 2890 "../compiler/parser.y"
                    { (yyval.ocla) = (yyvsp[0].ocla); }
#line 8116 "compiler/parser.c"
    break;

  case 472: /* unique_for_clause: tag_clause  */
#line 2891 "../compiler/parser.y"
               { (yyval.ocla) = (yyvsp[0].ocla); }
#line 8122 "compiler/parser.c"
    break;

  case 473: /* ordered_clause: OMP_ORDERED  */
#line 2896 "../compiler/parser.y"
    {
      (yyval.ocla) = PlainClause(OCORDERED);
    }
#line 8130 "compiler/parser.c"
    break;

  case 474: /* $@16: %empty  */
#line 2899 "../compiler/parser.y"
                { sc_pause_openmp(); }
#line 8136 "compiler/parser.c"
    break;

  case 475: /* ordered_clause: OMP_ORDERED $@16 paren_dirnamemod_and_optexpr  */
#line 2900 "../compiler/parser.y"
    {
      int n = 0, er = 0;
      sc_start_openmp();
      if ((yyvsp[0].expr)->left == NULL)
        (yyval.ocla) = add_modifier(PlainClause(OCORDERED), (yyvsp[0].expr)->opid);
			else
			{
	      if (xar_expr_is_constant((yyvsp[0].expr)->left))
	      {
	        n = xar_calc_int_expr((yyvsp[0].expr)->left, &er);
	        if (er) n = 0;
	      }
	      if (n <= 0)
	        parse_error(1, "invalid number in collapse() clause.\n");
	      (yyval.ocla) = add_modifier(OrderedNumClause(n), (yyvsp[0].expr)->opid);
			}
			free((yyvsp[0].expr));
    }
#line 8159 "compiler/parser.c"
    break;

  case 476: /* schedule_clause: OMP_SCHEDULE '(' schedule_mod_seq schedule_kind ')'  */
#line 2922 "../compiler/parser.y"
    {
      check_schedule((yyvsp[-1].type), (yyvsp[-2].ivec));
      (yyval.ocla) = ScheduleClause((yyvsp[-1].type), NULL);
      if ((yyvsp[-2].ivec)) 
        (yyval.ocla)->modifs = (yyvsp[-2].ivec);
    }
#line 8170 "compiler/parser.c"
    break;

  case 477: /* $@17: %empty  */
#line 2928 "../compiler/parser.y"
                                                    { sc_pause_openmp(); }
#line 8176 "compiler/parser.c"
    break;

  case 478: /* schedule_clause: OMP_SCHEDULE '(' schedule_mod_seq schedule_kind $@17 ',' expression ')'  */
#line 2930 "../compiler/parser.y"
    {
      sc_start_openmp();
      if ((yyvsp[-4].type) == OC_runtime)
        parse_error(1, "\"runtime\" schedules may not have a chunksize.\n");
      check_schedule((yyvsp[-4].type), (yyvsp[-5].ivec));
      (yyval.ocla) = ScheduleClause((yyvsp[-4].type), (yyvsp[-1].expr));
      if ((yyvsp[-5].ivec)) 
        (yyval.ocla)->modifs = (yyvsp[-5].ivec);
    }
#line 8190 "compiler/parser.c"
    break;

  case 479: /* $@18: %empty  */
#line 2940 "../compiler/parser.y"
    {  /* non-OpenMP schedule */
      tempsave = checkDecls;
      checkDecls = 0;   /* Because the index of the loop is usualy involved */
      sc_pause_openmp();
    }
#line 8200 "compiler/parser.c"
    break;

  case 480: /* schedule_clause: OMP_SCHEDULE '(' OMP_AFFINITY ',' $@18 expression ')'  */
#line 2946 "../compiler/parser.y"
    {
      sc_start_openmp();
      checkDecls = tempsave;
      (yyval.ocla) = ScheduleClause(OC_affinity, (yyvsp[-1].expr));
    }
#line 8210 "compiler/parser.c"
    break;

  case 481: /* schedule_kind: OMP_STATIC  */
#line 2954 "../compiler/parser.y"
               { (yyval.type) = OC_static; }
#line 8216 "compiler/parser.c"
    break;

  case 482: /* schedule_kind: OMP_DYNAMIC  */
#line 2955 "../compiler/parser.y"
                { (yyval.type) = OC_dynamic; }
#line 8222 "compiler/parser.c"
    break;

  case 483: /* schedule_kind: OMP_GUIDED  */
#line 2956 "../compiler/parser.y"
               { (yyval.type) = OC_guided; }
#line 8228 "compiler/parser.c"
    break;

  case 484: /* schedule_kind: OMP_RUNTIME  */
#line 2957 "../compiler/parser.y"
                { (yyval.type) = OC_runtime; }
#line 8234 "compiler/parser.c"
    break;

  case 485: /* schedule_kind: OMP_AUTO  */
#line 2958 "../compiler/parser.y"
             { (yyval.type) = OC_auto; }
#line 8240 "compiler/parser.c"
    break;

  case 486: /* schedule_kind: error  */
#line 2959 "../compiler/parser.y"
          { parse_error(1, "invalid openmp schedule type.\n"); }
#line 8246 "compiler/parser.c"
    break;

  case 487: /* schedule_mod_seq: %empty  */
#line 2963 "../compiler/parser.y"
                { (yyval.ivec) = NULL; }
#line 8252 "compiler/parser.c"
    break;

  case 488: /* schedule_mod_seq: schedule_mod ':'  */
#line 2965 "../compiler/parser.y"
    { 
      (yyval.ivec) = intvec_new_withelems(1, (yyvsp[-1].type));
    }
#line 8260 "compiler/parser.c"
    break;

  case 489: /* schedule_mod_seq: schedule_mod ',' schedule_mod ':'  */
#line 2969 "../compiler/parser.y"
    { 
      if ((IsDirnameModifier((yyvsp[-3].type)) && IsDirnameModifier((yyvsp[-1].type))) ||
          (!IsDirnameModifier((yyvsp[-3].type)) && !IsDirnameModifier((yyvsp[-1].type))))
        parse_error(1, "invalid schedule clause modifiers.\n");
      if (IsDirnameModifier((yyvsp[-3].type)))
        (yyval.ivec) = intvec_new_withelems(2, (yyvsp[-3].type), (yyvsp[-1].type));
      else
        (yyval.ivec) = intvec_new_withelems(2, (yyvsp[-1].type), (yyvsp[-3].type)); /* prefer direname-modifier 1st */
 		}
#line 8274 "compiler/parser.c"
    break;

  case 490: /* schedule_mod: OMP_MONOTONIC  */
#line 2981 "../compiler/parser.y"
                     { (yyval.type) = OCM_monotonic; }
#line 8280 "compiler/parser.c"
    break;

  case 491: /* schedule_mod: OMP_NONMONOTONIC  */
#line 2982 "../compiler/parser.y"
                     { (yyval.type) = OCM_nonmonotonic; }
#line 8286 "compiler/parser.c"
    break;

  case 492: /* schedule_mod: dirname_modifier  */
#line 2983 "../compiler/parser.y"
                     { (yyval.type) = (yyvsp[0].type); }
#line 8292 "compiler/parser.c"
    break;

  case 493: /* sections_construct: sections_directive section_scope  */
#line 2988 "../compiler/parser.y"
    {
      (yyval.ocon) = OmpConstruct(DCSECTIONS, (yyvsp[-1].odir), (yyvsp[0].stmt));
    }
#line 8300 "compiler/parser.c"
    break;

  case 494: /* sections_directive: PRAGMA_OMP OMP_SECTIONS sections_clause_optseq '\n'  */
#line 2995 "../compiler/parser.y"
    {
      (yyval.odir) = OmpDirective(DCSECTIONS, (yyvsp[-1].ocla));
    }
#line 8308 "compiler/parser.c"
    break;

  case 495: /* sections_clause_optseq: %empty  */
#line 3002 "../compiler/parser.y"
    {
      (yyval.ocla) = NULL;
    }
#line 8316 "compiler/parser.c"
    break;

  case 496: /* sections_clause_optseq: sections_clause_optseq sections_clause  */
#line 3006 "../compiler/parser.y"
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
    }
#line 8324 "compiler/parser.c"
    break;

  case 497: /* sections_clause_optseq: sections_clause_optseq ',' sections_clause  */
#line 3010 "../compiler/parser.y"
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
    }
#line 8332 "compiler/parser.c"
    break;

  case 498: /* sections_clause: data_privatization_clause  */
#line 3016 "../compiler/parser.y"
                              { (yyval.ocla) = (yyvsp[0].ocla); }
#line 8338 "compiler/parser.c"
    break;

  case 499: /* sections_clause: data_privatization_in_clause  */
#line 3017 "../compiler/parser.y"
                                 { (yyval.ocla) = (yyvsp[0].ocla); }
#line 8344 "compiler/parser.c"
    break;

  case 500: /* sections_clause: data_privatization_out_clause  */
#line 3018 "../compiler/parser.y"
                                  { (yyval.ocla) = (yyvsp[0].ocla); }
#line 8350 "compiler/parser.c"
    break;

  case 501: /* sections_clause: data_reduction_clause  */
#line 3019 "../compiler/parser.y"
                          { (yyval.ocla) = (yyvsp[0].ocla); }
#line 8356 "compiler/parser.c"
    break;

  case 502: /* sections_clause: nowait_clause  */
#line 3020 "../compiler/parser.y"
                  { (yyval.ocla) = (yyvsp[0].ocla); }
#line 8362 "compiler/parser.c"
    break;

  case 503: /* section_scope: '{' section_sequence '}'  */
#line 3025 "../compiler/parser.y"
    {
      (yyval.stmt) = Compound((yyvsp[-1].stmt));
    }
#line 8370 "compiler/parser.c"
    break;

  case 504: /* section_sequence: structured_block  */
#line 3032 "../compiler/parser.y"
    {
      /* Make it look like it had a section pragma */
      (yyval.stmt) = OmpStmt( OmpConstruct(DCSECTION, OmpDirective(DCSECTION,NULL), (yyvsp[0].stmt)) );
    }
#line 8379 "compiler/parser.c"
    break;

  case 505: /* section_sequence: section_directive structured_block  */
#line 3037 "../compiler/parser.y"
    {
      (yyval.stmt) = OmpStmt( OmpConstruct(DCSECTION, (yyvsp[-1].odir), (yyvsp[0].stmt)) );
    }
#line 8387 "compiler/parser.c"
    break;

  case 506: /* section_sequence: section_sequence section_directive structured_block  */
#line 3041 "../compiler/parser.y"
    {
      (yyval.stmt) = BlockList((yyvsp[-2].stmt), OmpStmt( OmpConstruct(DCSECTION, (yyvsp[-1].odir), (yyvsp[0].stmt)) ));
    }
#line 8395 "compiler/parser.c"
    break;

  case 507: /* section_directive: PRAGMA_OMP OMP_SECTION '\n'  */
#line 3048 "../compiler/parser.y"
    {
      (yyval.odir) = OmpDirective(DCSECTION, NULL);
    }
#line 8403 "compiler/parser.c"
    break;

  case 508: /* single_construct: single_directive structured_block  */
#line 3055 "../compiler/parser.y"
    {
      (yyval.ocon) = OmpConstruct(DCSINGLE, (yyvsp[-1].odir), (yyvsp[0].stmt));
    }
#line 8411 "compiler/parser.c"
    break;

  case 509: /* single_directive: PRAGMA_OMP OMP_SINGLE single_clause_optseq '\n'  */
#line 3062 "../compiler/parser.y"
    {
      (yyval.odir) = OmpDirective(DCSINGLE, (yyvsp[-1].ocla));
    }
#line 8419 "compiler/parser.c"
    break;

  case 510: /* single_clause_optseq: %empty  */
#line 3069 "../compiler/parser.y"
    {
      (yyval.ocla) = NULL;
    }
#line 8427 "compiler/parser.c"
    break;

  case 511: /* single_clause_optseq: single_clause_optseq single_clause  */
#line 3073 "../compiler/parser.y"
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
    }
#line 8435 "compiler/parser.c"
    break;

  case 512: /* single_clause_optseq: single_clause_optseq ',' single_clause  */
#line 3077 "../compiler/parser.y"
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
    }
#line 8443 "compiler/parser.c"
    break;

  case 513: /* single_clause: unique_single_clause  */
#line 3083 "../compiler/parser.y"
                         { (yyval.ocla) = (yyvsp[0].ocla); }
#line 8449 "compiler/parser.c"
    break;

  case 514: /* single_clause: data_privatization_clause  */
#line 3084 "../compiler/parser.y"
                              { (yyval.ocla) = (yyvsp[0].ocla); }
#line 8455 "compiler/parser.c"
    break;

  case 515: /* single_clause: data_privatization_in_clause  */
#line 3085 "../compiler/parser.y"
                                 { (yyval.ocla) = (yyvsp[0].ocla); }
#line 8461 "compiler/parser.c"
    break;

  case 516: /* single_clause: nowait_clause  */
#line 3086 "../compiler/parser.y"
                  { (yyval.ocla) = (yyvsp[0].ocla); }
#line 8467 "compiler/parser.c"
    break;

  case 517: /* $@19: %empty  */
#line 3090 "../compiler/parser.y"
                    { sc_pause_openmp(); }
#line 8473 "compiler/parser.c"
    break;

  case 518: /* unique_single_clause: OMP_COPYPRIVATE $@19 paren_dirnamemod_and_varlist  */
#line 3091 "../compiler/parser.y"
    {
      sc_start_openmp();
      (yyvsp[0].ocla)->type = OCCOPYPRIVATE;
      (yyval.ocla) = (yyvsp[0].ocla);
		}
#line 8483 "compiler/parser.c"
    break;

  case 519: /* simd_construct: simd_directive iteration_statement_for  */
#line 3101 "../compiler/parser.y"
    {
      (yyval.ocon) = OmpConstruct(DCSIMD, (yyvsp[-1].odir), (yyvsp[0].stmt));
    }
#line 8491 "compiler/parser.c"
    break;

  case 520: /* simd_directive: PRAGMA_OMP OMP_SIMD simd_clause_optseq '\n'  */
#line 3109 "../compiler/parser.y"
    {
      (yyval.odir) = OmpDirective(DCSIMD, (yyvsp[-1].ocla));
    }
#line 8499 "compiler/parser.c"
    break;

  case 521: /* simd_clause_optseq: %empty  */
#line 3116 "../compiler/parser.y"
    {
      (yyval.ocla) = NULL;
    }
#line 8507 "compiler/parser.c"
    break;

  case 522: /* simd_clause_optseq: simd_clause_optseq simd_clause  */
#line 3120 "../compiler/parser.y"
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
    }
#line 8515 "compiler/parser.c"
    break;

  case 523: /* simd_clause_optseq: simd_clause_optseq ',' simd_clause  */
#line 3124 "../compiler/parser.y"
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
    }
#line 8523 "compiler/parser.c"
    break;

  case 524: /* simd_clause: unique_simd_clause  */
#line 3131 "../compiler/parser.y"
                       { (yyval.ocla) = (yyvsp[0].ocla); }
#line 8529 "compiler/parser.c"
    break;

  case 525: /* simd_clause: if_clause  */
#line 3132 "../compiler/parser.y"
              { (yyval.ocla) = (yyvsp[0].ocla); }
#line 8535 "compiler/parser.c"
    break;

  case 526: /* simd_clause: data_privatization_clause  */
#line 3133 "../compiler/parser.y"
                              { (yyval.ocla) = (yyvsp[0].ocla); }
#line 8541 "compiler/parser.c"
    break;

  case 527: /* simd_clause: data_privatization_out_clause  */
#line 3134 "../compiler/parser.y"
                                  { (yyval.ocla) = (yyvsp[0].ocla); }
#line 8547 "compiler/parser.c"
    break;

  case 528: /* simd_clause: data_reduction_clause  */
#line 3135 "../compiler/parser.y"
                          { (yyval.ocla) = (yyvsp[0].ocla); }
#line 8553 "compiler/parser.c"
    break;

  case 529: /* simd_clause: collapse_clause  */
#line 3136 "../compiler/parser.y"
                    { (yyval.ocla) = (yyvsp[0].ocla); }
#line 8559 "compiler/parser.c"
    break;

  case 530: /* unique_simd_clause: safelen_clause  */
#line 3140 "../compiler/parser.y"
                   { (yyval.ocla) = (yyvsp[0].ocla); }
#line 8565 "compiler/parser.c"
    break;

  case 531: /* unique_simd_clause: linear_clause  */
#line 3141 "../compiler/parser.y"
                  { (yyval.ocla) = (yyvsp[0].ocla); }
#line 8571 "compiler/parser.c"
    break;

  case 532: /* unique_simd_clause: aligned_clause  */
#line 3142 "../compiler/parser.y"
                   { (yyval.ocla) = (yyvsp[0].ocla); }
#line 8577 "compiler/parser.c"
    break;

  case 533: /* $@20: %empty  */
#line 3147 "../compiler/parser.y"
                    { sc_pause_openmp(); }
#line 8583 "compiler/parser.c"
    break;

  case 534: /* safelen_clause: OMP_SAFELEN '(' $@20 expression ')'  */
#line 3148 "../compiler/parser.y"
    {
      int n = 0, er = 0;
      sc_start_openmp();
      if (xar_expr_is_constant((yyvsp[-1].expr)))
      {
        n = xar_calc_int_expr((yyvsp[-1].expr), &er);
        if (er) n = 0;
      }
      if (n <= 0)
        parse_error(1, "invalid number in simdlen() clause.\n");
      //$$ = CollapseClause(n); //TODO SAFELEN
    }
#line 8600 "compiler/parser.c"
    break;

  case 535: /* inbranch_clause: OMP_INBRANCH  */
#line 3165 "../compiler/parser.y"
    {
      //$$ = PlainClause(OCINBRANCH); TODO ast
    }
#line 8608 "compiler/parser.c"
    break;

  case 536: /* inbranch_clause: OMP_NOTINBRANCH  */
#line 3169 "../compiler/parser.y"
    {
      //$$ = PlainClause(OCNOTINBRANCH); TODO ast
    }
#line 8616 "compiler/parser.c"
    break;

  case 537: /* $@21: %empty  */
#line 3176 "../compiler/parser.y"
                { sc_pause_openmp(); }
#line 8622 "compiler/parser.c"
    break;

  case 538: /* uniform_clause: OMP_UNIFORM $@21 '(' variable_list ')'  */
#line 3177 "../compiler/parser.y"
    {
      sc_start_openmp();
      //$$ = VarlistClause(OCUNIFORM, $4); TODO ast
    }
#line 8631 "compiler/parser.c"
    break;

  case 539: /* $@22: %empty  */
#line 3185 "../compiler/parser.y"
               { sc_pause_openmp(); }
#line 8637 "compiler/parser.c"
    break;

  case 540: /* linear_clause: OMP_LINEAR $@22 '(' variable_list optional_expression ')'  */
#line 3186 "../compiler/parser.y"
    {
      sc_start_openmp();
      // TODO ast
    }
#line 8646 "compiler/parser.c"
    break;

  case 541: /* $@23: %empty  */
#line 3194 "../compiler/parser.y"
                { sc_pause_openmp(); }
#line 8652 "compiler/parser.c"
    break;

  case 542: /* aligned_clause: OMP_ALIGNED $@23 '(' variable_list optional_expression ')'  */
#line 3195 "../compiler/parser.y"
    {
      sc_start_openmp();
      // TODO ast
    }
#line 8661 "compiler/parser.c"
    break;

  case 543: /* optional_expression: %empty  */
#line 3203 "../compiler/parser.y"
    {
      (yyval.expr) = NULL;
    }
#line 8669 "compiler/parser.c"
    break;

  case 544: /* optional_expression: ':' expression  */
#line 3207 "../compiler/parser.y"
    {
      // TODO ast
    }
#line 8677 "compiler/parser.c"
    break;

  case 545: /* declare_simd_construct: declare_simd_directive_seq function_statement  */
#line 3215 "../compiler/parser.y"
    {
      //$$ = OmpConstruct(DCDECLSIMD, $1, $2); TODO DCDECLSIMD or change it to stmt
    }
#line 8685 "compiler/parser.c"
    break;

  case 546: /* declare_simd_directive_seq: declare_simd_directive  */
#line 3223 "../compiler/parser.y"
    {
      //TODO
    }
#line 8693 "compiler/parser.c"
    break;

  case 547: /* declare_simd_directive_seq: declare_simd_directive_seq declare_simd_directive  */
#line 3227 "../compiler/parser.y"
    {
        //TODO
    }
#line 8701 "compiler/parser.c"
    break;

  case 548: /* declare_simd_directive: PRAGMA_OMP OMP_DECLARE OMP_SIMD declare_simd_clause_optseq '\n'  */
#line 3235 "../compiler/parser.y"
    {
      //$$ = OmpDirective(DCDECLSIMD, $4); TODO DCDECLSIMD
    }
#line 8709 "compiler/parser.c"
    break;

  case 549: /* declare_simd_clause_optseq: %empty  */
#line 3242 "../compiler/parser.y"
    {
      (yyval.ocla) = NULL;
    }
#line 8717 "compiler/parser.c"
    break;

  case 550: /* declare_simd_clause_optseq: declare_simd_clause_optseq declare_simd_clause  */
#line 3246 "../compiler/parser.y"
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
    }
#line 8725 "compiler/parser.c"
    break;

  case 551: /* declare_simd_clause_optseq: declare_simd_clause_optseq ',' declare_simd_clause  */
#line 3250 "../compiler/parser.y"
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
    }
#line 8733 "compiler/parser.c"
    break;

  case 552: /* declare_simd_clause: OMP_SIMDLEN '(' expression ')'  */
#line 3259 "../compiler/parser.y"
    {
      int n = 0, er = 0;
      if (xar_expr_is_constant((yyvsp[-1].expr)))
      {
        n = xar_calc_int_expr((yyvsp[-1].expr), &er);
        if (er) n = 0;
      }
      if (n <= 0)
        parse_error(1, "invalid number in simdlen() clause.\n");
      //$$ = CollapseClause(n); //TODO SIMDLEN
    }
#line 8749 "compiler/parser.c"
    break;

  case 553: /* declare_simd_clause: linear_clause  */
#line 3270 "../compiler/parser.y"
                  { (yyval.ocla) = (yyvsp[0].ocla); }
#line 8755 "compiler/parser.c"
    break;

  case 554: /* declare_simd_clause: aligned_clause  */
#line 3271 "../compiler/parser.y"
                   { (yyval.ocla) = (yyvsp[0].ocla); }
#line 8761 "compiler/parser.c"
    break;

  case 555: /* declare_simd_clause: uniform_clause  */
#line 3272 "../compiler/parser.y"
                   { (yyval.ocla) = (yyvsp[0].ocla); }
#line 8767 "compiler/parser.c"
    break;

  case 556: /* declare_simd_clause: inbranch_clause  */
#line 3273 "../compiler/parser.y"
                    { (yyval.ocla) = (yyvsp[0].ocla); }
#line 8773 "compiler/parser.c"
    break;

  case 557: /* for_simd_construct: for_simd_directive iteration_statement_for  */
#line 3279 "../compiler/parser.y"
    {
      (yyval.ocon) = OmpConstruct(DCFORSIMD, (yyvsp[-1].odir), (yyvsp[0].stmt));
    }
#line 8781 "compiler/parser.c"
    break;

  case 558: /* for_simd_directive: PRAGMA_OMP OMP_FOR OMP_SIMD for_simd_clause_optseq '\n'  */
#line 3287 "../compiler/parser.y"
    {
      (yyval.odir) = OmpDirective(DCFORSIMD, (yyvsp[-1].ocla));
    }
#line 8789 "compiler/parser.c"
    break;

  case 559: /* for_simd_clause_optseq: %empty  */
#line 3294 "../compiler/parser.y"
    {
      (yyval.ocla) = NULL;
    }
#line 8797 "compiler/parser.c"
    break;

  case 560: /* for_simd_clause_optseq: for_simd_clause_optseq for_simd_clause  */
#line 3298 "../compiler/parser.y"
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
    }
#line 8805 "compiler/parser.c"
    break;

  case 561: /* for_simd_clause_optseq: for_simd_clause_optseq ',' for_simd_clause  */
#line 3302 "../compiler/parser.y"
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
    }
#line 8813 "compiler/parser.c"
    break;

  case 562: /* for_simd_clause: for_clause  */
#line 3308 "../compiler/parser.y"
               { (yyval.ocla) = (yyvsp[0].ocla); }
#line 8819 "compiler/parser.c"
    break;

  case 563: /* for_simd_clause: unique_simd_clause  */
#line 3309 "../compiler/parser.y"
                       { (yyval.ocla) = (yyvsp[0].ocla); }
#line 8825 "compiler/parser.c"
    break;

  case 564: /* parallel_for_simd_construct: parallel_for_simd_directive iteration_statement_for  */
#line 3315 "../compiler/parser.y"
    {
      (yyval.ocon) = OmpConstruct(DCPARFORSIMD, (yyvsp[-1].odir), (yyvsp[0].stmt));
    }
#line 8833 "compiler/parser.c"
    break;

  case 565: /* parallel_for_simd_directive: PRAGMA_OMP OMP_PARALLEL OMP_FOR OMP_SIMD parallel_for_simd_clause_optseq '\n'  */
#line 3323 "../compiler/parser.y"
    {
      (yyval.odir) = OmpDirective(DCPARFORSIMD, (yyvsp[-1].ocla));
    }
#line 8841 "compiler/parser.c"
    break;

  case 566: /* parallel_for_simd_clause_optseq: %empty  */
#line 3330 "../compiler/parser.y"
    {
      (yyval.ocla) = NULL;
    }
#line 8849 "compiler/parser.c"
    break;

  case 567: /* parallel_for_simd_clause_optseq: parallel_for_simd_clause_optseq parallel_for_simd_clause  */
#line 3334 "../compiler/parser.y"
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
    }
#line 8857 "compiler/parser.c"
    break;

  case 568: /* parallel_for_simd_clause_optseq: parallel_for_simd_clause_optseq ',' parallel_for_simd_clause  */
#line 3338 "../compiler/parser.y"
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
    }
#line 8865 "compiler/parser.c"
    break;

  case 569: /* parallel_for_simd_clause: parallel_for_clause  */
#line 3344 "../compiler/parser.y"
                        { (yyval.ocla) = (yyvsp[0].ocla); }
#line 8871 "compiler/parser.c"
    break;

  case 570: /* parallel_for_simd_clause: unique_simd_clause  */
#line 3345 "../compiler/parser.y"
                       { (yyval.ocla) = (yyvsp[0].ocla); }
#line 8877 "compiler/parser.c"
    break;

  case 571: /* target_data_construct: target_data_directive structured_block  */
#line 3351 "../compiler/parser.y"
    {
      (yyval.ocon) = OmpConstruct(DCTARGETDATA, (yyvsp[-1].odir), (yyvsp[0].stmt));
      __has_target = 1;
    }
#line 8886 "compiler/parser.c"
    break;

  case 572: /* target_data_directive: PRAGMA_OMP OMP_TARGETDATA target_data_clause_optseq '\n'  */
#line 3360 "../compiler/parser.y"
    {
      (yyval.odir) = OmpDirective(DCTARGETDATA, (yyvsp[-1].ocla));
    }
#line 8894 "compiler/parser.c"
    break;

  case 573: /* target_data_clause_optseq: %empty  */
#line 3367 "../compiler/parser.y"
    {
      (yyval.ocla) = NULL;
    }
#line 8902 "compiler/parser.c"
    break;

  case 574: /* target_data_clause_optseq: target_data_clause_optseq target_data_clause  */
#line 3371 "../compiler/parser.y"
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
    }
#line 8910 "compiler/parser.c"
    break;

  case 575: /* target_data_clause_optseq: target_data_clause_optseq ',' target_data_clause  */
#line 3375 "../compiler/parser.y"
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
    }
#line 8918 "compiler/parser.c"
    break;

  case 576: /* target_data_clause: device_clause  */
#line 3381 "../compiler/parser.y"
                  { (yyval.ocla) = (yyvsp[0].ocla); }
#line 8924 "compiler/parser.c"
    break;

  case 577: /* target_data_clause: map_clause  */
#line 3383 "../compiler/parser.y"
    {
      (yyval.ocla) = (yyvsp[0].ocla);
      /* OpenMP v4.5, 2.10.1, page 97: must be to/from/tofrom/alloc */
      if ((yyval.ocla)->subtype != OC_tofrom && (yyval.ocla)->subtype != OC_to && 
          (yyval.ocla)->subtype != OC_from   && (yyval.ocla)->subtype != OC_alloc)
        parse_error(1, "expected a map type of 'to', 'from', 'tofrom' or 'alloc'\n");
    }
#line 8936 "compiler/parser.c"
    break;

  case 578: /* target_data_clause: if_clause  */
#line 3390 "../compiler/parser.y"
              { (yyval.ocla) = (yyvsp[0].ocla); }
#line 8942 "compiler/parser.c"
    break;

  case 579: /* target_data_clause: use_device_ptr_clause  */
#line 3391 "../compiler/parser.y"
                                                                { (yyval.ocla) = (yyvsp[0].ocla); }
#line 8948 "compiler/parser.c"
    break;

  case 580: /* $@24: %empty  */
#line 3396 "../compiler/parser.y"
               { sc_pause_openmp(); }
#line 8954 "compiler/parser.c"
    break;

  case 581: /* device_clause: OMP_DEVICE $@24 paren_dirnamemod_and_expr  */
#line 3397 "../compiler/parser.y"
    {
      sc_start_openmp();
      (yyval.ocla) = add_modifier(DeviceClause((yyvsp[0].expr)->left), (yyvsp[0].expr)->opid);
      free((yyvsp[0].expr));
		}
#line 8964 "compiler/parser.c"
    break;

  case 582: /* $@25: %empty  */
#line 3407 "../compiler/parser.y"
                { sc_pause_openmp(); }
#line 8970 "compiler/parser.c"
    break;

  case 583: /* map_clause: OMP_MAP '(' $@25 variable_array_section_list ')'  */
#line 3408 "../compiler/parser.y"
    {
      sc_start_openmp();
      (yyval.ocla) = MapClause(OC_tofrom, (yyvsp[-1].oxli));
    }
#line 8979 "compiler/parser.c"
    break;

  case 584: /* $@26: %empty  */
#line 3412 "../compiler/parser.y"
                                 { sc_pause_openmp(); }
#line 8985 "compiler/parser.c"
    break;

  case 585: /* map_clause: OMP_MAP '(' map_modifier_seq $@26 ':' variable_array_section_list ')'  */
#line 3414 "../compiler/parser.y"
    {
      sc_start_openmp();
      (yyval.ocla) = MapClause(check_map_clause_modifiers((yyvsp[-4].ivec)), (yyvsp[-1].oxli));
      (yyval.ocla)->modifs = (yyvsp[-4].ivec);
    }
#line 8995 "compiler/parser.c"
    break;

  case 586: /* map_modifier_seq: map_modifier  */
#line 3422 "../compiler/parser.y"
                 { (yyval.ivec) = intvec_new_withelems(1, (yyvsp[0].type)); }
#line 9001 "compiler/parser.c"
    break;

  case 587: /* map_modifier_seq: map_modifier_seq ',' map_modifier  */
#line 3423 "../compiler/parser.y"
                                      { (yyval.ivec) = intvec_append((yyvsp[-2].ivec), 1, (yyvsp[0].type)); }
#line 9007 "compiler/parser.c"
    break;

  case 588: /* map_modifier: OMP_ALWAYS  */
#line 3429 "../compiler/parser.y"
                     { (yyval.type) = OCM_always; }
#line 9013 "compiler/parser.c"
    break;

  case 589: /* map_modifier: map_type  */
#line 3430 "../compiler/parser.y"
                     { (yyval.type) = MaptypeModifier((yyvsp[0].type)); }
#line 9019 "compiler/parser.c"
    break;

  case 590: /* map_modifier: dirname_modifier  */
#line 3431 "../compiler/parser.y"
                     { (yyval.type) = (yyvsp[0].type); }
#line 9025 "compiler/parser.c"
    break;

  case 591: /* map_type: OMP_ALLOC  */
#line 3437 "../compiler/parser.y"
              { (yyval.type) = OC_alloc; }
#line 9031 "compiler/parser.c"
    break;

  case 592: /* map_type: OMP_TO  */
#line 3438 "../compiler/parser.y"
           { (yyval.type) = OC_to; }
#line 9037 "compiler/parser.c"
    break;

  case 593: /* map_type: OMP_FROM  */
#line 3439 "../compiler/parser.y"
             { (yyval.type) = OC_from; }
#line 9043 "compiler/parser.c"
    break;

  case 594: /* map_type: OMP_TOFROM  */
#line 3440 "../compiler/parser.y"
               { (yyval.type) = OC_tofrom; }
#line 9049 "compiler/parser.c"
    break;

  case 595: /* map_type: OMP_RELEASE  */
#line 3441 "../compiler/parser.y"
                { (yyval.type) = OC_release;  }
#line 9055 "compiler/parser.c"
    break;

  case 596: /* map_type: OMP_DELETE  */
#line 3442 "../compiler/parser.y"
               { (yyval.type) = OC_delete; }
#line 9061 "compiler/parser.c"
    break;

  case 597: /* $@27: %empty  */
#line 3447 "../compiler/parser.y"
                       { sc_pause_openmp(); }
#line 9067 "compiler/parser.c"
    break;

  case 598: /* use_device_ptr_clause: OMP_USE_DEVICE_PTR $@27 paren_dirnamemod_and_varlist  */
#line 3448 "../compiler/parser.y"
    {
      sc_start_openmp();
      (yyvsp[0].ocla)->type = OCUSEDEVPTR;
      (yyval.ocla) = (yyvsp[0].ocla);
		}
#line 9077 "compiler/parser.c"
    break;

  case 599: /* defaultmap_clause: OMP_DEFAULTMAP '(' dirname_modifier_opt OMP_TOFROM ':' OMP_SCALAR ')'  */
#line 3458 "../compiler/parser.y"
    {
      (yyval.ocla) = add_modifier(PlainClause(OCDEFAULTMAP), (yyvsp[-4].type)); /* No params needed */
    }
#line 9085 "compiler/parser.c"
    break;

  case 600: /* $@28: %empty  */
#line 3465 "../compiler/parser.y"
                      { sc_pause_openmp(); }
#line 9091 "compiler/parser.c"
    break;

  case 601: /* is_device_ptr_clause: OMP_IS_DEVICE_PTR $@28 paren_dirnamemod_and_varlist  */
#line 3466 "../compiler/parser.y"
    {
      sc_start_openmp();
      (yyvsp[0].ocla)->type = OCISDEVPTR;
      (yyval.ocla) = (yyvsp[0].ocla);
		}
#line 9101 "compiler/parser.c"
    break;

  case 602: /* @29: %empty  */
#line 3475 "../compiler/parser.y"
                     { (yyval.type) = errorOnReturn;  errorOnReturn = 1; }
#line 9107 "compiler/parser.c"
    break;

  case 603: /* target_construct: target_directive @29 structured_block  */
#line 3477 "../compiler/parser.y"
    {
      errorOnReturn = (yyvsp[-1].type);
      (yyval.ocon) = OmpConstruct(DCTARGET, (yyvsp[-2].odir), (yyvsp[0].stmt));
      __has_target = 1;
      codetargs_kernel_add((yyval.ocon));
    }
#line 9118 "compiler/parser.c"
    break;

  case 604: /* target_directive: PRAGMA_OMP OMP_TARGET target_clause_optseq '\n'  */
#line 3488 "../compiler/parser.y"
    {
      (yyval.odir) = OmpDirective(DCTARGET, (yyvsp[-1].ocla));
    }
#line 9126 "compiler/parser.c"
    break;

  case 605: /* target_clause_optseq: %empty  */
#line 3494 "../compiler/parser.y"
                { (yyval.ocla) = NULL; }
#line 9132 "compiler/parser.c"
    break;

  case 606: /* target_clause_optseq: target_clause_optseq target_clause  */
#line 3495 "../compiler/parser.y"
                                       { (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla)); }
#line 9138 "compiler/parser.c"
    break;

  case 607: /* target_clause_optseq: target_clause_optseq ',' target_clause  */
#line 3496 "../compiler/parser.y"
                                           { (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla)); }
#line 9144 "compiler/parser.c"
    break;

  case 608: /* target_clause: unique_target_clause  */
#line 3500 "../compiler/parser.y"
                         { (yyval.ocla) = (yyvsp[0].ocla); }
#line 9150 "compiler/parser.c"
    break;

  case 609: /* target_clause: if_clause  */
#line 3501 "../compiler/parser.y"
              { (yyval.ocla) = (yyvsp[0].ocla); }
#line 9156 "compiler/parser.c"
    break;

  case 610: /* target_clause: depend_clause  */
#line 3502 "../compiler/parser.y"
                  { (yyval.ocla) = (yyvsp[0].ocla); }
#line 9162 "compiler/parser.c"
    break;

  case 611: /* target_clause: nowait_clause  */
#line 3503 "../compiler/parser.y"
                  { (yyval.ocla) = (yyvsp[0].ocla); }
#line 9168 "compiler/parser.c"
    break;

  case 612: /* target_clause: data_privatization_clause  */
#line 3504 "../compiler/parser.y"
                              { (yyval.ocla) = (yyvsp[0].ocla); }
#line 9174 "compiler/parser.c"
    break;

  case 613: /* target_clause: data_privatization_in_clause  */
#line 3505 "../compiler/parser.y"
                                 { (yyval.ocla) = (yyvsp[0].ocla); }
#line 9180 "compiler/parser.c"
    break;

  case 614: /* target_clause: thread_limit_clause  */
#line 3506 "../compiler/parser.y"
                        { (yyval.ocla) = (yyvsp[0].ocla); }
#line 9186 "compiler/parser.c"
    break;

  case 615: /* unique_target_clause: device_clause  */
#line 3510 "../compiler/parser.y"
                  { (yyval.ocla) = (yyvsp[0].ocla); }
#line 9192 "compiler/parser.c"
    break;

  case 616: /* unique_target_clause: map_clause  */
#line 3512 "../compiler/parser.y"
    {
      (yyval.ocla) = (yyvsp[0].ocla);
      /* OpenMP v4.5, 2.10.4, page 106: must be to/from/tofrom/alloc */
      if ((yyval.ocla)->subtype != OC_tofrom && (yyval.ocla)->subtype != OC_to && 
          (yyval.ocla)->subtype != OC_from   && (yyval.ocla)->subtype != OC_alloc)
        parse_error(1, "expected a map type of 'to', 'from', 'tofrom' or 'alloc'\n");
    }
#line 9204 "compiler/parser.c"
    break;

  case 617: /* unique_target_clause: defaultmap_clause  */
#line 3519 "../compiler/parser.y"
                         { (yyval.ocla) = (yyvsp[0].ocla); }
#line 9210 "compiler/parser.c"
    break;

  case 618: /* unique_target_clause: is_device_ptr_clause  */
#line 3520 "../compiler/parser.y"
                         { (yyval.ocla) = (yyvsp[0].ocla); }
#line 9216 "compiler/parser.c"
    break;

  case 619: /* target_enter_data_directive: PRAGMA_OMP OMP_TARGETENTERDATA target_enter_data_clause_seq '\n'  */
#line 3526 "../compiler/parser.y"
    {
      if (xc_clauselist_get_clause((yyvsp[-1].ocla), OCMAP, DCIGNORE, false) == NULL)
        parse_error(1, "target enter data directives must contain at least 1 "
                       "map() clause");
      (yyval.odir) = OmpDirective(DCTARGETENTERDATA, (yyvsp[-1].ocla));
      __has_target = 1;
    }
#line 9228 "compiler/parser.c"
    break;

  case 620: /* target_enter_data_clause_seq: target_enter_data_clause  */
#line 3536 "../compiler/parser.y"
                             { (yyval.ocla) = (yyvsp[0].ocla); }
#line 9234 "compiler/parser.c"
    break;

  case 621: /* target_enter_data_clause_seq: target_enter_data_clause_seq target_enter_data_clause  */
#line 3538 "../compiler/parser.y"
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
    }
#line 9242 "compiler/parser.c"
    break;

  case 622: /* target_enter_data_clause_seq: target_enter_data_clause_seq ',' target_enter_data_clause  */
#line 3542 "../compiler/parser.y"
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
    }
#line 9250 "compiler/parser.c"
    break;

  case 623: /* target_enter_data_clause: map_clause  */
#line 3549 "../compiler/parser.y"
    {
      (yyval.ocla) = (yyvsp[0].ocla);
      /* OpenMP v4.5, 2.10.2, page 99: must be to/alloc */
      if ((yyval.ocla)->subtype != OC_to && (yyval.ocla)->subtype != OC_alloc)
        parse_error(1, "expected a map type of 'to' or 'alloc'\n");
    }
#line 9261 "compiler/parser.c"
    break;

  case 624: /* target_enter_data_clause: device_clause  */
#line 3555 "../compiler/parser.y"
                  { (yyval.ocla) = (yyvsp[0].ocla); }
#line 9267 "compiler/parser.c"
    break;

  case 625: /* target_enter_data_clause: if_clause  */
#line 3556 "../compiler/parser.y"
              { (yyval.ocla) = (yyvsp[0].ocla); }
#line 9273 "compiler/parser.c"
    break;

  case 626: /* target_enter_data_clause: depend_clause  */
#line 3557 "../compiler/parser.y"
                  { (yyval.ocla) = (yyvsp[0].ocla); }
#line 9279 "compiler/parser.c"
    break;

  case 627: /* target_enter_data_clause: nowait_clause  */
#line 3558 "../compiler/parser.y"
                  { (yyval.ocla) = (yyvsp[0].ocla); }
#line 9285 "compiler/parser.c"
    break;

  case 628: /* target_exit_data_directive: PRAGMA_OMP OMP_TARGETEXITDATA target_exit_data_clause_seq '\n'  */
#line 3564 "../compiler/parser.y"
    {
      if (xc_clauselist_get_clause((yyvsp[-1].ocla), OCMAP, DCIGNORE, false) == NULL)
        parse_error(1, "target exit data directives must contain at least 1 "
                       "map() clause");
      (yyval.odir) = OmpDirective(DCTARGETEXITDATA, (yyvsp[-1].ocla));
      __has_target = 1;
    }
#line 9297 "compiler/parser.c"
    break;

  case 629: /* target_exit_data_clause_seq: target_exit_data_clause  */
#line 3574 "../compiler/parser.y"
                            { (yyval.ocla) = (yyvsp[0].ocla); }
#line 9303 "compiler/parser.c"
    break;

  case 630: /* target_exit_data_clause_seq: target_exit_data_clause_seq target_exit_data_clause  */
#line 3576 "../compiler/parser.y"
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
    }
#line 9311 "compiler/parser.c"
    break;

  case 631: /* target_exit_data_clause_seq: target_exit_data_clause_seq ',' target_exit_data_clause  */
#line 3580 "../compiler/parser.y"
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
    }
#line 9319 "compiler/parser.c"
    break;

  case 632: /* target_exit_data_clause: map_clause  */
#line 3587 "../compiler/parser.y"
    {
      (yyval.ocla) = (yyvsp[0].ocla);
      /* OpenMP v4.5, 2.10.3, page 102: must be from/release/delete */
      if ((yyval.ocla)->subtype != OC_from && (yyval.ocla)->subtype != OC_release &&
          (yyval.ocla)->subtype != OC_delete)
        parse_error(1, "expected a map type of 'from', 'release' or 'delete'\n");
    }
#line 9331 "compiler/parser.c"
    break;

  case 633: /* target_exit_data_clause: device_clause  */
#line 3594 "../compiler/parser.y"
                  { (yyval.ocla) = (yyvsp[0].ocla); }
#line 9337 "compiler/parser.c"
    break;

  case 634: /* target_exit_data_clause: if_clause  */
#line 3595 "../compiler/parser.y"
                  { (yyval.ocla) = (yyvsp[0].ocla); }
#line 9343 "compiler/parser.c"
    break;

  case 635: /* target_exit_data_clause: depend_clause  */
#line 3596 "../compiler/parser.y"
                  { (yyval.ocla) = (yyvsp[0].ocla); }
#line 9349 "compiler/parser.c"
    break;

  case 636: /* target_exit_data_clause: nowait_clause  */
#line 3597 "../compiler/parser.y"
                  { (yyval.ocla) = (yyvsp[0].ocla); }
#line 9355 "compiler/parser.c"
    break;

  case 637: /* target_update_directive: PRAGMA_OMP OMP_TARGETUPDATE target_update_clause_seq '\n'  */
#line 3603 "../compiler/parser.y"
    {
      (yyval.odir) = OmpDirective(DCTARGETUPDATE, (yyvsp[-1].ocla));
      __has_target = 1;
    }
#line 9364 "compiler/parser.c"
    break;

  case 638: /* target_update_clause_seq: target_update_clause  */
#line 3610 "../compiler/parser.y"
                         { (yyval.ocla) = (yyvsp[0].ocla); }
#line 9370 "compiler/parser.c"
    break;

  case 639: /* target_update_clause_seq: target_update_clause_seq target_update_clause  */
#line 3612 "../compiler/parser.y"
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
    }
#line 9378 "compiler/parser.c"
    break;

  case 640: /* target_update_clause_seq: target_update_clause_seq ',' target_update_clause  */
#line 3616 "../compiler/parser.y"
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
    }
#line 9386 "compiler/parser.c"
    break;

  case 641: /* target_update_clause: motion_clause  */
#line 3622 "../compiler/parser.y"
                  { (yyval.ocla) = (yyvsp[0].ocla); }
#line 9392 "compiler/parser.c"
    break;

  case 642: /* target_update_clause: device_clause  */
#line 3623 "../compiler/parser.y"
                  { (yyval.ocla) = (yyvsp[0].ocla); }
#line 9398 "compiler/parser.c"
    break;

  case 643: /* target_update_clause: if_clause  */
#line 3624 "../compiler/parser.y"
                  { (yyval.ocla) = (yyvsp[0].ocla); }
#line 9404 "compiler/parser.c"
    break;

  case 644: /* target_update_clause: depend_clause  */
#line 3625 "../compiler/parser.y"
                  { (yyval.ocla) = (yyvsp[0].ocla); }
#line 9410 "compiler/parser.c"
    break;

  case 645: /* target_update_clause: nowait_clause  */
#line 3626 "../compiler/parser.y"
                  { (yyval.ocla) = (yyvsp[0].ocla); }
#line 9416 "compiler/parser.c"
    break;

  case 646: /* error_directive: PRAGMA_OMP OMP_ERROR error_clause_seq '\n'  */
#line 3632 "../compiler/parser.y"
                {
			(yyval.odir) = OmpDirective(DCERROR, (yyvsp[-1].ocla));
		}
#line 9424 "compiler/parser.c"
    break;

  case 647: /* error_clause_seq: error_clause  */
#line 3638 "../compiler/parser.y"
                             {(yyval.ocla) = (yyvsp[0].ocla); }
#line 9430 "compiler/parser.c"
    break;

  case 648: /* error_clause_seq: error_clause_seq error_clause  */
#line 3639 "../compiler/parser.y"
                                        {(yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla)); }
#line 9436 "compiler/parser.c"
    break;

  case 649: /* error_clause_seq: error_clause_seq ',' error_clause  */
#line 3640 "../compiler/parser.y"
                                            {(yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla)); }
#line 9442 "compiler/parser.c"
    break;

  case 650: /* error_clause: at_clause  */
#line 3644 "../compiler/parser.y"
              { (yyval.ocla) = (yyvsp[0].ocla); }
#line 9448 "compiler/parser.c"
    break;

  case 651: /* error_clause: severity_clause  */
#line 3645 "../compiler/parser.y"
                    { (yyval.ocla) = (yyvsp[0].ocla); }
#line 9454 "compiler/parser.c"
    break;

  case 652: /* error_clause: message_clause  */
#line 3646 "../compiler/parser.y"
                   { (yyval.ocla) = (yyvsp[0].ocla); }
#line 9460 "compiler/parser.c"
    break;

  case 653: /* at_clause: OMP_AT '(' dirname_modifier_opt at_action ')'  */
#line 3651 "../compiler/parser.y"
    { 
      (yyval.ocla) = add_modifier(AtClause((yyvsp[-1].type)), (yyvsp[-2].type));
    }
#line 9468 "compiler/parser.c"
    break;

  case 654: /* at_action: OMP_COMPILATION  */
#line 3657 "../compiler/parser.y"
                    { (yyval.type) = OC_compilation; }
#line 9474 "compiler/parser.c"
    break;

  case 655: /* at_action: OMP_EXECUTION  */
#line 3658 "../compiler/parser.y"
                  { (yyval.type) = OC_execution; }
#line 9480 "compiler/parser.c"
    break;

  case 656: /* severity_clause: OMP_SEVERITY '(' dirname_modifier_opt severity_level ')'  */
#line 3663 "../compiler/parser.y"
    { 
      (yyval.ocla) = add_modifier(SeverityClause((yyvsp[-1].type)), (yyvsp[-2].type));
    }
#line 9488 "compiler/parser.c"
    break;

  case 657: /* severity_level: OMP_FATAL  */
#line 3669 "../compiler/parser.y"
              { (yyval.type) = OC_fatal; }
#line 9494 "compiler/parser.c"
    break;

  case 658: /* severity_level: OMP_WARNING  */
#line 3670 "../compiler/parser.y"
                { (yyval.type) = OC_warning; }
#line 9500 "compiler/parser.c"
    break;

  case 659: /* message_clause: OMP_MESSAGE '(' dirname_modifier_opt string_literal ')'  */
#line 3675 "../compiler/parser.y"
    { 
      (yyval.ocla) = add_modifier(MessageClause((yyvsp[-1].string)), (yyvsp[-2].type)); 
    }
#line 9508 "compiler/parser.c"
    break;

  case 660: /* $@30: %empty  */
#line 3682 "../compiler/parser.y"
               { sc_pause_openmp(); }
#line 9514 "compiler/parser.c"
    break;

  case 661: /* filter_clause: OMP_FILTER $@30 paren_dirnamemod_and_expr  */
#line 3683 "../compiler/parser.y"
    {
      sc_start_openmp();
      (yyval.ocla) = add_modifier(FilterClause((yyvsp[0].expr)->left), (yyvsp[0].expr)->opid);
      free((yyvsp[0].expr));
		}
#line 9524 "compiler/parser.c"
    break;

  case 662: /* fail_memmodel: OMP_SEQ_CST  */
#line 3691 "../compiler/parser.y"
                { (yyval.type) = OC_seq_cst; }
#line 9530 "compiler/parser.c"
    break;

  case 663: /* fail_memmodel: OMP_ACQUIRE  */
#line 3692 "../compiler/parser.y"
                { (yyval.type) = OC_acquire; }
#line 9536 "compiler/parser.c"
    break;

  case 664: /* fail_memmodel: OMP_RELAXED  */
#line 3693 "../compiler/parser.y"
                { (yyval.type) = OC_relaxed; }
#line 9542 "compiler/parser.c"
    break;

  case 665: /* motion_clause: to_clause  */
#line 3698 "../compiler/parser.y"
              { (yyval.ocla) = (yyvsp[0].ocla); }
#line 9548 "compiler/parser.c"
    break;

  case 666: /* motion_clause: from_clause  */
#line 3699 "../compiler/parser.y"
                { (yyval.ocla) = (yyvsp[0].ocla); }
#line 9554 "compiler/parser.c"
    break;

  case 667: /* $@31: %empty  */
#line 3704 "../compiler/parser.y"
           { sc_pause_openmp(); }
#line 9560 "compiler/parser.c"
    break;

  case 668: /* to_clause: OMP_TO $@31 paren_dirnamemod_and_xlist  */
#line 3705 "../compiler/parser.y"
                {
			sc_start_openmp();
			(yyvsp[0].ocla)->type = OCTO;
			(yyval.ocla) = (yyvsp[0].ocla);
		}
#line 9570 "compiler/parser.c"
    break;

  case 669: /* $@32: %empty  */
#line 3713 "../compiler/parser.y"
             { sc_pause_openmp(); }
#line 9576 "compiler/parser.c"
    break;

  case 670: /* from_clause: OMP_FROM $@32 paren_dirnamemod_and_xlist  */
#line 3714 "../compiler/parser.y"
                {
			sc_start_openmp();
			(yyvsp[0].ocla)->type = OCFROM;
			(yyval.ocla) = (yyvsp[0].ocla);
		}
#line 9586 "compiler/parser.c"
    break;

  case 671: /* declare_target_construct: declare_target_directive declarations_definitions_seq end_declare_target_directive  */
#line 3726 "../compiler/parser.y"
    {
      (yyval.ocon) = OmpConstruct(DCDECLARETARGET, (yyvsp[-2].odir), (yyvsp[-1].stmt));
    }
#line 9594 "compiler/parser.c"
    break;

  case 672: /* declare_target_construct: declare_target_directive_v45  */
#line 3730 "../compiler/parser.y"
    {
      (yyval.ocon) = OmpConstruct(DCDECLARETARGET, (yyvsp[0].odir), NULL);
    }
#line 9602 "compiler/parser.c"
    break;

  case 673: /* declare_target_directive: PRAGMA_OMP OMP_DECLARETARGET '\n'  */
#line 3737 "../compiler/parser.y"
    {
      (yyval.odir) = OmpDirective(DCDECLARETARGET, NULL);
    }
#line 9610 "compiler/parser.c"
    break;

  case 674: /* end_declare_target_directive: PRAGMA_OMP OMP_ENDDECLARETARGET '\n'  */
#line 3744 "../compiler/parser.y"
    {
      //$$ = OmpDirective(DCENDDECLARETARGET, NULL); TODO DCENDDECLARETARGET
    }
#line 9618 "compiler/parser.c"
    break;

  case 675: /* declare_target_directive_v45: PRAGMA_OMP OMP_DECLARETARGET '(' funcname_variable_array_section_list ')' '\n'  */
#line 3753 "../compiler/parser.y"
    {
      (yyval.odir) = OmpDirective(DCDECLARETARGET, UpdateClause(OCTO, (yyvsp[-2].oxli)));
    }
#line 9626 "compiler/parser.c"
    break;

  case 676: /* declare_target_directive_v45: PRAGMA_OMP OMP_DECLARETARGET declare_target_clause_optseq '\n'  */
#line 3757 "../compiler/parser.y"
    {
      (yyval.odir) = OmpDirective(DCDECLARETARGET, (yyvsp[-1].ocla));
    }
#line 9634 "compiler/parser.c"
    break;

  case 677: /* declare_target_clause_optseq: unique_declare_target_clause  */
#line 3764 "../compiler/parser.y"
                                 { (yyval.ocla) = (yyvsp[0].ocla); }
#line 9640 "compiler/parser.c"
    break;

  case 678: /* declare_target_clause_optseq: declare_target_clause_optseq unique_declare_target_clause  */
#line 3766 "../compiler/parser.y"
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
    }
#line 9648 "compiler/parser.c"
    break;

  case 679: /* declare_target_clause_optseq: declare_target_clause_optseq ',' unique_declare_target_clause  */
#line 3770 "../compiler/parser.y"
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
    }
#line 9656 "compiler/parser.c"
    break;

  case 680: /* $@33: %empty  */
#line 3777 "../compiler/parser.y"
           { sc_pause_openmp(); }
#line 9662 "compiler/parser.c"
    break;

  case 681: /* unique_declare_target_clause: OMP_TO $@33 decltarg_to_clause_args  */
#line 3778 "../compiler/parser.y"
    {
      sc_start_openmp();
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 9671 "compiler/parser.c"
    break;

  case 682: /* $@34: %empty  */
#line 3783 "../compiler/parser.y"
    { 
      tempsave = checkDecls;   /* No check--the directive can appear anywhere */
      checkDecls = 0; 
      sc_pause_openmp(); 
    }
#line 9681 "compiler/parser.c"
    break;

  case 683: /* unique_declare_target_clause: OMP_LINK $@34 link_clause_args  */
#line 3789 "../compiler/parser.y"
    {
      sc_start_openmp();
      checkDecls = tempsave;
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 9691 "compiler/parser.c"
    break;

  case 684: /* decltarg_to_clause_args: '(' funcname_variable_array_section_list ')'  */
#line 3798 "../compiler/parser.y"
                {
			(yyval.ocla) = UpdateClause(OCTO, (yyvsp[-1].oxli));
		}
#line 9699 "compiler/parser.c"
    break;

  case 685: /* decltarg_to_clause_args: '(' IDENTIFIER ':' funcname_variable_array_section_list ')'  */
#line 3802 "../compiler/parser.y"
                {
			(yyval.ocla) = UpdateClause(OCTO, (yyvsp[-1].oxli));
		}
#line 9707 "compiler/parser.c"
    break;

  case 686: /* link_clause_args: '(' variable_array_section_list ')'  */
#line 3809 "../compiler/parser.y"
                {
			(yyval.ocla) = UpdateClause(OCLINK, (yyvsp[-1].oxli));
		}
#line 9715 "compiler/parser.c"
    break;

  case 687: /* link_clause_args: '(' IDENTIFIER ':' variable_array_section_list ')'  */
#line 3813 "../compiler/parser.y"
                {
			(yyval.ocla) = UpdateClause(OCLINK, (yyvsp[-1].oxli));
		}
#line 9723 "compiler/parser.c"
    break;

  case 688: /* teams_construct: teams_directive structured_block  */
#line 3823 "../compiler/parser.y"
    {
      (yyval.ocon) = OmpConstruct(DCTEAMS, (yyvsp[-1].odir), (yyvsp[0].stmt));
    }
#line 9731 "compiler/parser.c"
    break;

  case 689: /* teams_directive: PRAGMA_OMP OMP_TEAMS teams_clause_optseq '\n'  */
#line 3833 "../compiler/parser.y"
    {
      (yyval.odir) = OmpDirective(DCTEAMS, (yyvsp[-1].ocla));
    }
#line 9739 "compiler/parser.c"
    break;

  case 690: /* teams_clause_optseq: %empty  */
#line 3839 "../compiler/parser.y"
                { (yyval.ocla) = NULL; }
#line 9745 "compiler/parser.c"
    break;

  case 691: /* teams_clause_optseq: teams_clause_optseq teams_clause  */
#line 3840 "../compiler/parser.y"
                                     { (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla)); }
#line 9751 "compiler/parser.c"
    break;

  case 692: /* teams_clause_optseq: teams_clause_optseq ',' teams_clause  */
#line 3841 "../compiler/parser.y"
                                         { (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla)); }
#line 9757 "compiler/parser.c"
    break;

  case 693: /* teams_clause: unique_teams_clause  */
#line 3845 "../compiler/parser.y"
                        { (yyval.ocla) = (yyvsp[0].ocla); }
#line 9763 "compiler/parser.c"
    break;

  case 694: /* teams_clause: data_default_clause  */
#line 3846 "../compiler/parser.y"
                        { (yyval.ocla) = (yyvsp[0].ocla); }
#line 9769 "compiler/parser.c"
    break;

  case 695: /* teams_clause: data_privatization_clause  */
#line 3847 "../compiler/parser.y"
                              { (yyval.ocla) = (yyvsp[0].ocla); }
#line 9775 "compiler/parser.c"
    break;

  case 696: /* teams_clause: data_privatization_in_clause  */
#line 3848 "../compiler/parser.y"
                                 { (yyval.ocla) = (yyvsp[0].ocla); }
#line 9781 "compiler/parser.c"
    break;

  case 697: /* teams_clause: data_sharing_clause  */
#line 3849 "../compiler/parser.y"
                        { (yyval.ocla) = (yyvsp[0].ocla); }
#line 9787 "compiler/parser.c"
    break;

  case 698: /* teams_clause: data_reduction_clause  */
#line 3850 "../compiler/parser.y"
                          { (yyval.ocla) = (yyvsp[0].ocla); }
#line 9793 "compiler/parser.c"
    break;

  case 699: /* teams_clause: thread_limit_clause  */
#line 3851 "../compiler/parser.y"
                        { (yyval.ocla) = (yyvsp[0].ocla); }
#line 9799 "compiler/parser.c"
    break;

  case 700: /* $@35: %empty  */
#line 3857 "../compiler/parser.y"
                    { sc_pause_openmp(); }
#line 9805 "compiler/parser.c"
    break;

  case 701: /* thread_limit_clause: OMP_THREADLIMIT $@35 paren_dirnamemod_and_expr  */
#line 3858 "../compiler/parser.y"
    {
      sc_start_openmp();
      (yyval.ocla) = add_modifier(ThreadlimitClause((yyvsp[0].expr)->left), (yyvsp[0].expr)->opid);
      free((yyvsp[0].expr));
		}
#line 9815 "compiler/parser.c"
    break;

  case 702: /* numteams_args: '(' assignment_expression ')'  */
#line 3867 "../compiler/parser.y"
                { 
		  (yyval.ocla) = NumteamsClause(NULL, (yyvsp[-1].expr));
		}
#line 9823 "compiler/parser.c"
    break;

  case 703: /* numteams_args: '(' assignment_expression ':' assignment_expression ')'  */
#line 3871 "../compiler/parser.y"
          {
	    if ((yyvsp[-3].expr)->type == IDENT && mk_dirname_modifier((yyvsp[-3].expr)->u.sym->name) != OCM_none)
	      (yyval.ocla) = NumteamsClause(NULL, (yyvsp[-1].expr));   /* FIXME: use the modifier */
	    else
	      (yyval.ocla) = NumteamsClause((yyvsp[-3].expr), (yyvsp[-1].expr));
	  }
#line 9834 "compiler/parser.c"
    break;

  case 704: /* numteams_args: '(' assignment_expression ',' assignment_expression ':' assignment_expression ')'  */
#line 3878 "../compiler/parser.y"
          {
	    if ((yyvsp[-5].expr)->type == IDENT && mk_dirname_modifier((yyvsp[-5].expr)->u.sym->name) != OCM_none)
	      (yyval.ocla) = NumteamsClause((yyvsp[-3].expr), (yyvsp[-1].expr));   /* FIXME: use the modifier */
	    else
	      if ((yyvsp[-3].expr)->type == IDENT && mk_dirname_modifier((yyvsp[-3].expr)->u.sym->name) != OCM_none)
	        (yyval.ocla) = NumteamsClause((yyvsp[-5].expr), (yyvsp[-1].expr));   /* FIXME: use the modifier */
	      else
	        parse_error(1, "incorrect arguements in numteams clause.\n");
	  }
#line 9848 "compiler/parser.c"
    break;

  case 705: /* $@36: %empty  */
#line 3892 "../compiler/parser.y"
                 { sc_pause_openmp(); }
#line 9854 "compiler/parser.c"
    break;

  case 706: /* unique_teams_clause: OMP_NUMTEAMS $@36 numteams_args  */
#line 3893 "../compiler/parser.y"
    {
      sc_start_openmp();
      (yyval.ocla) = (yyvsp[0].ocla);
    }
#line 9863 "compiler/parser.c"
    break;

  case 707: /* distribute_construct: distribute_directive iteration_statement_for  */
#line 3902 "../compiler/parser.y"
    {
      (yyval.ocon) = OmpConstruct(DCDISTRIBUTE, (yyvsp[-1].odir), (yyvsp[0].stmt));
    }
#line 9871 "compiler/parser.c"
    break;

  case 708: /* distribute_directive: PRAGMA_OMP OMP_DISTRIBUTE distribute_clause_optseq '\n'  */
#line 3910 "../compiler/parser.y"
    {
      (yyval.odir) = OmpDirective(DCDISTRIBUTE, (yyvsp[-1].ocla));
    }
#line 9879 "compiler/parser.c"
    break;

  case 709: /* distribute_clause_optseq: %empty  */
#line 3917 "../compiler/parser.y"
    {
      (yyval.ocla) = NULL;
    }
#line 9887 "compiler/parser.c"
    break;

  case 710: /* distribute_clause_optseq: distribute_clause_optseq distribute_clause  */
#line 3921 "../compiler/parser.y"
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
    }
#line 9895 "compiler/parser.c"
    break;

  case 711: /* distribute_clause_optseq: distribute_clause_optseq ',' distribute_clause  */
#line 3925 "../compiler/parser.y"
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
    }
#line 9903 "compiler/parser.c"
    break;

  case 712: /* distribute_clause: data_privatization_clause  */
#line 3931 "../compiler/parser.y"
                              { (yyval.ocla) = (yyvsp[0].ocla); }
#line 9909 "compiler/parser.c"
    break;

  case 713: /* distribute_clause: data_privatization_in_clause  */
#line 3932 "../compiler/parser.y"
                                 { (yyval.ocla) = (yyvsp[0].ocla); }
#line 9915 "compiler/parser.c"
    break;

  case 714: /* distribute_clause: data_privatization_out_clause  */
#line 3933 "../compiler/parser.y"
                                  { (yyval.ocla) = (yyvsp[0].ocla); }
#line 9921 "compiler/parser.c"
    break;

  case 715: /* distribute_clause: collapse_clause  */
#line 3934 "../compiler/parser.y"
                    { (yyval.ocla) = (yyvsp[0].ocla); }
#line 9927 "compiler/parser.c"
    break;

  case 716: /* distribute_clause: unique_distribute_clause  */
#line 3935 "../compiler/parser.y"
                             { (yyval.ocla) = (yyvsp[0].ocla); }
#line 9933 "compiler/parser.c"
    break;

  case 717: /* unique_distribute_clause: OMP_DISTSCHEDULE '(' dirname_modifier_opt OMP_STATIC ')'  */
#line 3940 "../compiler/parser.y"
    {
      (yyval.ocla) = add_modifier(DistScheduleClause(OC_static, NULL), (yyvsp[-2].type));
    }
#line 9941 "compiler/parser.c"
    break;

  case 718: /* $@37: %empty  */
#line 3944 "../compiler/parser.y"
                         { sc_pause_openmp(); }
#line 9947 "compiler/parser.c"
    break;

  case 719: /* unique_distribute_clause: OMP_DISTSCHEDULE '(' dirname_modifier_opt OMP_STATIC $@37 ',' expression ')'  */
#line 3945 "../compiler/parser.y"
    {
      sc_start_openmp();
      (yyval.ocla) = add_modifier(DistScheduleClause(OC_static, (yyvsp[-1].expr)), (yyvsp[-5].type));
    }
#line 9956 "compiler/parser.c"
    break;

  case 720: /* distribute_simd_construct: distribute_simd_directive iteration_statement_for  */
#line 3954 "../compiler/parser.y"
    {
      (yyval.ocon) = OmpConstruct(DCDISTSIMD, (yyvsp[-1].odir), (yyvsp[0].stmt));
      (yyval.ocon)->l = (yyvsp[-1].odir)->l;
    }
#line 9965 "compiler/parser.c"
    break;

  case 721: /* distribute_simd_directive: PRAGMA_OMP OMP_DISTRIBUTE OMP_SIMD distribute_simd_clause_optseq '\n'  */
#line 3963 "../compiler/parser.y"
    {
      (yyval.odir) = OmpDirective(DCDISTSIMD, (yyvsp[-1].ocla));
    }
#line 9973 "compiler/parser.c"
    break;

  case 722: /* distribute_simd_clause_optseq: %empty  */
#line 3970 "../compiler/parser.y"
    {
      (yyval.ocla) = NULL;
    }
#line 9981 "compiler/parser.c"
    break;

  case 723: /* distribute_simd_clause_optseq: distribute_simd_clause_optseq distribute_simd_clause  */
#line 3974 "../compiler/parser.y"
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
    }
#line 9989 "compiler/parser.c"
    break;

  case 724: /* distribute_simd_clause_optseq: distribute_simd_clause_optseq ',' distribute_simd_clause  */
#line 3978 "../compiler/parser.y"
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
    }
#line 9997 "compiler/parser.c"
    break;

  case 725: /* distribute_simd_clause: distribute_clause  */
#line 3984 "../compiler/parser.y"
                       { (yyval.ocla) = (yyvsp[0].ocla); }
#line 10003 "compiler/parser.c"
    break;

  case 726: /* distribute_simd_clause: unique_simd_clause  */
#line 3985 "../compiler/parser.y"
                       { (yyval.ocla) = (yyvsp[0].ocla); }
#line 10009 "compiler/parser.c"
    break;

  case 727: /* distribute_simd_clause: if_clause  */
#line 3986 "../compiler/parser.y"
                       { (yyval.ocla) = (yyvsp[0].ocla); }
#line 10015 "compiler/parser.c"
    break;

  case 728: /* distribute_parallel_for_construct: distribute_parallel_for_directive iteration_statement_for  */
#line 3992 "../compiler/parser.y"
    {
      (yyval.ocon) = OmpConstruct(DCDISTPARFOR, (yyvsp[-1].odir), (yyvsp[0].stmt));
      (yyval.ocon)->l = (yyvsp[-1].odir)->l;
    }
#line 10024 "compiler/parser.c"
    break;

  case 729: /* distribute_parallel_for_directive: PRAGMA_OMP OMP_DISTRIBUTE OMP_PARALLEL OMP_FOR distribute_parallel_for_clause_optseq '\n'  */
#line 4001 "../compiler/parser.y"
    {
      (yyval.odir) = OmpDirective(DCDISTPARFOR, (yyvsp[-1].ocla));
    }
#line 10032 "compiler/parser.c"
    break;

  case 730: /* distribute_parallel_for_clause_optseq: %empty  */
#line 4008 "../compiler/parser.y"
    {
      (yyval.ocla) = NULL;
    }
#line 10040 "compiler/parser.c"
    break;

  case 731: /* distribute_parallel_for_clause_optseq: distribute_parallel_for_clause_optseq distribute_parallel_for_clause  */
#line 4012 "../compiler/parser.y"
    {
      #ifdef OMPI_OMP_EXT
        (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
      #else
        if ((yyvsp[0].ocla)->type==OCTAG){
          parse_warning("tag clause ignored;"
                "activate it by configuring OMPi with -Dext=true\n");
          (yyval.ocla) = (yyvsp[-1].ocla);
        }else
          (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
      #endif
    }
#line 10057 "compiler/parser.c"
    break;

  case 732: /* distribute_parallel_for_clause_optseq: distribute_parallel_for_clause_optseq ',' distribute_parallel_for_clause  */
#line 4025 "../compiler/parser.y"
    {
      #ifdef OMPI_OMP_EXT
        (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
      #else
        if ((yyvsp[0].ocla)->type==OCTAG){
          parse_warning("tag clause ignored;"
                "activate it by configuring OMPi with -Dext=true\n");
          (yyval.ocla) = (yyvsp[-2].ocla);
        }else
          (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
      #endif
    }
#line 10074 "compiler/parser.c"
    break;

  case 733: /* distribute_parallel_for_clause: unique_distribute_clause  */
#line 4040 "../compiler/parser.y"
                             { (yyval.ocla) = (yyvsp[0].ocla); }
#line 10080 "compiler/parser.c"
    break;

  case 734: /* distribute_parallel_for_clause: parallel_for_clause  */
#line 4041 "../compiler/parser.y"
                             { (yyval.ocla) = (yyvsp[0].ocla); }
#line 10086 "compiler/parser.c"
    break;

  case 735: /* distribute_parallel_for_simd_construct: distribute_parallel_for_simd_directive structured_block  */
#line 4047 "../compiler/parser.y"
    {
      (yyval.ocon) = OmpConstruct(DCDISTPARFORSIMD, (yyvsp[-1].odir), (yyvsp[0].stmt));
      (yyval.ocon)->l = (yyvsp[-1].odir)->l;
    }
#line 10095 "compiler/parser.c"
    break;

  case 736: /* distribute_parallel_for_simd_directive: PRAGMA_OMP OMP_DISTRIBUTE OMP_PARALLEL OMP_FOR OMP_SIMD distribute_parallel_for_simd_clause_optseq '\n'  */
#line 4057 "../compiler/parser.y"
    {
      (yyval.odir) = OmpDirective(DCDISTPARFORSIMD, (yyvsp[-1].ocla));
    }
#line 10103 "compiler/parser.c"
    break;

  case 737: /* distribute_parallel_for_simd_clause_optseq: %empty  */
#line 4064 "../compiler/parser.y"
    {
      (yyval.ocla) = NULL;
    }
#line 10111 "compiler/parser.c"
    break;

  case 738: /* distribute_parallel_for_simd_clause_optseq: distribute_parallel_for_simd_clause_optseq distribute_parallel_for_simd_clause  */
#line 4068 "../compiler/parser.y"
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
    }
#line 10119 "compiler/parser.c"
    break;

  case 739: /* distribute_parallel_for_simd_clause_optseq: distribute_parallel_for_simd_clause_optseq ',' distribute_parallel_for_simd_clause  */
#line 4072 "../compiler/parser.y"
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
    }
#line 10127 "compiler/parser.c"
    break;

  case 740: /* distribute_parallel_for_simd_clause: unique_distribute_clause  */
#line 4078 "../compiler/parser.y"
                             { (yyval.ocla) = (yyvsp[0].ocla); }
#line 10133 "compiler/parser.c"
    break;

  case 741: /* distribute_parallel_for_simd_clause: parallel_for_simd_clause  */
#line 4079 "../compiler/parser.y"
                             { (yyval.ocla) = (yyvsp[0].ocla); }
#line 10139 "compiler/parser.c"
    break;

  case 742: /* target_teams_construct: target_teams_directive structured_block  */
#line 4085 "../compiler/parser.y"
    {
      (yyval.ocon) = OmpConstruct(DCTARGETTEAMS, (yyvsp[-1].odir), (yyvsp[0].stmt));
      __has_target = 1;
      codetargs_kernel_add((yyval.ocon));
    }
#line 10149 "compiler/parser.c"
    break;

  case 743: /* target_teams_directive: PRAGMA_OMP OMP_TARGET OMP_TEAMS target_teams_clause_optseq '\n'  */
#line 4095 "../compiler/parser.y"
    {
      (yyval.odir) = OmpDirective(DCTARGETTEAMS, (yyvsp[-1].ocla));
    }
#line 10157 "compiler/parser.c"
    break;

  case 744: /* target_teams_clause_optseq: %empty  */
#line 4102 "../compiler/parser.y"
    {
      (yyval.ocla) = NULL;
    }
#line 10165 "compiler/parser.c"
    break;

  case 745: /* target_teams_clause_optseq: target_teams_clause_optseq target_teams_clause  */
#line 4106 "../compiler/parser.y"
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
    }
#line 10173 "compiler/parser.c"
    break;

  case 746: /* target_teams_clause_optseq: target_teams_clause_optseq ',' target_teams_clause  */
#line 4110 "../compiler/parser.y"
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
    }
#line 10181 "compiler/parser.c"
    break;

  case 747: /* target_teams_clause: teams_clause  */
#line 4116 "../compiler/parser.y"
                         { (yyval.ocla) = (yyvsp[0].ocla); }
#line 10187 "compiler/parser.c"
    break;

  case 748: /* target_teams_clause: unique_target_clause  */
#line 4117 "../compiler/parser.y"
                         { (yyval.ocla) = (yyvsp[0].ocla); }
#line 10193 "compiler/parser.c"
    break;

  case 749: /* target_teams_clause: if_clause  */
#line 4118 "../compiler/parser.y"
                         { (yyval.ocla) = (yyvsp[0].ocla); }
#line 10199 "compiler/parser.c"
    break;

  case 750: /* target_teams_clause: depend_clause  */
#line 4119 "../compiler/parser.y"
                         { (yyval.ocla) = (yyvsp[0].ocla); }
#line 10205 "compiler/parser.c"
    break;

  case 751: /* target_teams_clause: nowait_clause  */
#line 4120 "../compiler/parser.y"
                         { (yyval.ocla) = (yyvsp[0].ocla); }
#line 10211 "compiler/parser.c"
    break;

  case 752: /* target_parallel_construct: target_parallel_directive structured_block  */
#line 4126 "../compiler/parser.y"
    {
      (yyval.ocon) = OmpConstruct(DCTARGETPARALLEL, (yyvsp[-1].odir), (yyvsp[0].stmt));
      __has_target = 1;
      codetargs_kernel_add((yyval.ocon));
    }
#line 10221 "compiler/parser.c"
    break;

  case 753: /* target_parallel_directive: PRAGMA_OMP OMP_TARGET OMP_PARALLEL target_parallel_clause_optseq '\n'  */
#line 4136 "../compiler/parser.y"
    {
      (yyval.odir) = OmpDirective(DCTARGETPARALLEL, (yyvsp[-1].ocla));
    }
#line 10229 "compiler/parser.c"
    break;

  case 754: /* target_parallel_clause_optseq: %empty  */
#line 4143 "../compiler/parser.y"
    {
      (yyval.ocla) = NULL;
    }
#line 10237 "compiler/parser.c"
    break;

  case 755: /* target_parallel_clause_optseq: target_parallel_clause_optseq target_parallel_clause  */
#line 4147 "../compiler/parser.y"
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
    }
#line 10245 "compiler/parser.c"
    break;

  case 756: /* target_parallel_clause_optseq: target_parallel_clause_optseq ',' target_parallel_clause  */
#line 4151 "../compiler/parser.y"
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
    }
#line 10253 "compiler/parser.c"
    break;

  case 757: /* target_parallel_clause: unique_parallel_clause  */
#line 4157 "../compiler/parser.y"
                                 { (yyval.ocla) = (yyvsp[0].ocla); }
#line 10259 "compiler/parser.c"
    break;

  case 758: /* target_parallel_clause: unique_target_clause  */
#line 4158 "../compiler/parser.y"
                                 { (yyval.ocla) = (yyvsp[0].ocla); }
#line 10265 "compiler/parser.c"
    break;

  case 759: /* target_parallel_clause: if_clause  */
#line 4159 "../compiler/parser.y"
                                 { (yyval.ocla) = (yyvsp[0].ocla); }
#line 10271 "compiler/parser.c"
    break;

  case 760: /* target_parallel_clause: data_default_clause  */
#line 4160 "../compiler/parser.y"
                                 { (yyval.ocla) = (yyvsp[0].ocla); }
#line 10277 "compiler/parser.c"
    break;

  case 761: /* target_parallel_clause: data_privatization_clause  */
#line 4161 "../compiler/parser.y"
                                 { (yyval.ocla) = (yyvsp[0].ocla); }
#line 10283 "compiler/parser.c"
    break;

  case 762: /* target_parallel_clause: data_privatization_in_clause  */
#line 4162 "../compiler/parser.y"
                                 { (yyval.ocla) = (yyvsp[0].ocla); }
#line 10289 "compiler/parser.c"
    break;

  case 763: /* target_parallel_clause: data_sharing_clause  */
#line 4163 "../compiler/parser.y"
                                 { (yyval.ocla) = (yyvsp[0].ocla); }
#line 10295 "compiler/parser.c"
    break;

  case 764: /* target_parallel_clause: data_reduction_clause  */
#line 4164 "../compiler/parser.y"
                                 { (yyval.ocla) = (yyvsp[0].ocla); }
#line 10301 "compiler/parser.c"
    break;

  case 765: /* target_parallel_clause: depend_clause  */
#line 4165 "../compiler/parser.y"
                                 { (yyval.ocla) = (yyvsp[0].ocla); }
#line 10307 "compiler/parser.c"
    break;

  case 766: /* target_parallel_clause: nowait_clause  */
#line 4166 "../compiler/parser.y"
                                 { (yyval.ocla) = (yyvsp[0].ocla); }
#line 10313 "compiler/parser.c"
    break;

  case 767: /* target_parallel_clause: thread_limit_clause  */
#line 4167 "../compiler/parser.y"
                                 { (yyval.ocla) = (yyvsp[0].ocla); }
#line 10319 "compiler/parser.c"
    break;

  case 768: /* teams_distribute_construct: teams_distribute_directive iteration_statement_for  */
#line 4173 "../compiler/parser.y"
    {
      (yyval.ocon) = OmpConstruct(DCTEAMSDIST, (yyvsp[-1].odir), (yyvsp[0].stmt));
    }
#line 10327 "compiler/parser.c"
    break;

  case 769: /* teams_distribute_directive: PRAGMA_OMP OMP_TEAMS OMP_DISTRIBUTE teams_distribute_clause_optseq '\n'  */
#line 4181 "../compiler/parser.y"
    {
      (yyval.odir) = OmpDirective(DCTEAMSDIST, (yyvsp[-1].ocla));
    }
#line 10335 "compiler/parser.c"
    break;

  case 770: /* teams_distribute_clause_optseq: %empty  */
#line 4188 "../compiler/parser.y"
    {
      (yyval.ocla) = NULL;
    }
#line 10343 "compiler/parser.c"
    break;

  case 771: /* teams_distribute_clause_optseq: teams_distribute_clause_optseq teams_distribute_clause  */
#line 4192 "../compiler/parser.y"
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
    }
#line 10351 "compiler/parser.c"
    break;

  case 772: /* teams_distribute_clause_optseq: teams_distribute_clause_optseq ',' teams_distribute_clause  */
#line 4196 "../compiler/parser.y"
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
    }
#line 10359 "compiler/parser.c"
    break;

  case 773: /* teams_distribute_clause: unique_teams_clause  */
#line 4202 "../compiler/parser.y"
                          { (yyval.ocla) = (yyvsp[0].ocla); }
#line 10365 "compiler/parser.c"
    break;

  case 774: /* teams_distribute_clause: data_sharing_clause  */
#line 4203 "../compiler/parser.y"
                          { (yyval.ocla) = (yyvsp[0].ocla); }
#line 10371 "compiler/parser.c"
    break;

  case 775: /* teams_distribute_clause: data_reduction_clause  */
#line 4204 "../compiler/parser.y"
                          { (yyval.ocla) = (yyvsp[0].ocla); }
#line 10377 "compiler/parser.c"
    break;

  case 776: /* teams_distribute_clause: distribute_clause  */
#line 4205 "../compiler/parser.y"
                          { (yyval.ocla) = (yyvsp[0].ocla); }
#line 10383 "compiler/parser.c"
    break;

  case 777: /* teams_distribute_clause: thread_limit_clause  */
#line 4206 "../compiler/parser.y"
                          { (yyval.ocla) = (yyvsp[0].ocla); }
#line 10389 "compiler/parser.c"
    break;

  case 778: /* teams_distribute_simd_construct: teams_distribute_simd_directive iteration_statement_for  */
#line 4212 "../compiler/parser.y"
    {
      (yyval.ocon) = OmpConstruct(DCTEAMSDISTSIMD, (yyvsp[-1].odir), (yyvsp[0].stmt));
    }
#line 10397 "compiler/parser.c"
    break;

  case 779: /* teams_distribute_simd_directive: PRAGMA_OMP OMP_TEAMS OMP_DISTRIBUTE OMP_SIMD teams_distribute_simd_clause_optseq '\n'  */
#line 4220 "../compiler/parser.y"
    {
      (yyval.odir) = OmpDirective(DCTEAMSDISTSIMD, (yyvsp[-1].ocla));
    }
#line 10405 "compiler/parser.c"
    break;

  case 780: /* teams_distribute_simd_clause_optseq: %empty  */
#line 4227 "../compiler/parser.y"
    {
      (yyval.ocla) = NULL;
    }
#line 10413 "compiler/parser.c"
    break;

  case 781: /* teams_distribute_simd_clause_optseq: teams_distribute_simd_clause_optseq teams_distribute_simd_clause  */
#line 4231 "../compiler/parser.y"
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
    }
#line 10421 "compiler/parser.c"
    break;

  case 782: /* teams_distribute_simd_clause_optseq: teams_distribute_simd_clause_optseq ',' teams_distribute_simd_clause  */
#line 4235 "../compiler/parser.y"
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
    }
#line 10429 "compiler/parser.c"
    break;

  case 783: /* teams_distribute_simd_clause: unique_teams_clause  */
#line 4241 "../compiler/parser.y"
                           { (yyval.ocla) = (yyvsp[0].ocla); }
#line 10435 "compiler/parser.c"
    break;

  case 784: /* teams_distribute_simd_clause: data_sharing_clause  */
#line 4242 "../compiler/parser.y"
                           { (yyval.ocla) = (yyvsp[0].ocla); }
#line 10441 "compiler/parser.c"
    break;

  case 785: /* teams_distribute_simd_clause: data_reduction_clause  */
#line 4243 "../compiler/parser.y"
                           { (yyval.ocla) = (yyvsp[0].ocla); }
#line 10447 "compiler/parser.c"
    break;

  case 786: /* teams_distribute_simd_clause: distribute_simd_clause  */
#line 4244 "../compiler/parser.y"
                           { (yyval.ocla) = (yyvsp[0].ocla); }
#line 10453 "compiler/parser.c"
    break;

  case 787: /* teams_distribute_simd_clause: thread_limit_clause  */
#line 4245 "../compiler/parser.y"
                           { (yyval.ocla) = (yyvsp[0].ocla); }
#line 10459 "compiler/parser.c"
    break;

  case 788: /* target_teams_distribute_construct: target_teams_distribute_directive iteration_statement_for  */
#line 4251 "../compiler/parser.y"
    {
      (yyval.ocon) = OmpConstruct(DCTARGETTEAMSDIST, (yyvsp[-1].odir), (yyvsp[0].stmt));
      __has_target = 1;
      codetargs_kernel_add((yyval.ocon));
    }
#line 10469 "compiler/parser.c"
    break;

  case 789: /* target_teams_distribute_directive: PRAGMA_OMP OMP_TARGET OMP_TEAMS OMP_DISTRIBUTE target_teams_distribute_clause_optseq '\n'  */
#line 4261 "../compiler/parser.y"
    {
      (yyval.odir) = OmpDirective(DCTARGETTEAMSDIST, (yyvsp[-1].ocla));
    }
#line 10477 "compiler/parser.c"
    break;

  case 790: /* target_teams_distribute_clause_optseq: %empty  */
#line 4268 "../compiler/parser.y"
    {
      (yyval.ocla) = NULL;
    }
#line 10485 "compiler/parser.c"
    break;

  case 791: /* target_teams_distribute_clause_optseq: target_teams_distribute_clause_optseq target_teams_distribute_clause  */
#line 4272 "../compiler/parser.y"
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
    }
#line 10493 "compiler/parser.c"
    break;

  case 792: /* target_teams_distribute_clause_optseq: target_teams_distribute_clause_optseq ',' target_teams_distribute_clause  */
#line 4276 "../compiler/parser.y"
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
    }
#line 10501 "compiler/parser.c"
    break;

  case 793: /* target_teams_distribute_clause: teams_distribute_clause  */
#line 4282 "../compiler/parser.y"
                            { (yyval.ocla) = (yyvsp[0].ocla); }
#line 10507 "compiler/parser.c"
    break;

  case 794: /* target_teams_distribute_clause: unique_target_clause  */
#line 4283 "../compiler/parser.y"
                            { (yyval.ocla) = (yyvsp[0].ocla); }
#line 10513 "compiler/parser.c"
    break;

  case 795: /* target_teams_distribute_clause: if_clause  */
#line 4284 "../compiler/parser.y"
                            { (yyval.ocla) = (yyvsp[0].ocla); }
#line 10519 "compiler/parser.c"
    break;

  case 796: /* target_teams_distribute_clause: depend_clause  */
#line 4285 "../compiler/parser.y"
                            { (yyval.ocla) = (yyvsp[0].ocla); }
#line 10525 "compiler/parser.c"
    break;

  case 797: /* target_teams_distribute_clause: nowait_clause  */
#line 4286 "../compiler/parser.y"
                            { (yyval.ocla) = (yyvsp[0].ocla); }
#line 10531 "compiler/parser.c"
    break;

  case 798: /* target_teams_distribute_simd_construct: target_teams_distribute_simd_directive iteration_statement_for  */
#line 4292 "../compiler/parser.y"
    {
      (yyval.ocon) = OmpConstruct(DCTARGETTEAMSDISTSIMD, (yyvsp[-1].odir), (yyvsp[0].stmt));
      __has_target = 1;
      codetargs_kernel_add((yyval.ocon));
    }
#line 10541 "compiler/parser.c"
    break;

  case 799: /* target_teams_distribute_simd_directive: PRAGMA_OMP OMP_TARGET OMP_TEAMS OMP_DISTRIBUTE OMP_SIMD target_teams_distribute_simd_clause_optseq '\n'  */
#line 4303 "../compiler/parser.y"
    {
      (yyval.odir) = OmpDirective(DCTARGETTEAMSDISTSIMD, (yyvsp[-1].ocla));
    }
#line 10549 "compiler/parser.c"
    break;

  case 800: /* target_teams_distribute_simd_clause_optseq: %empty  */
#line 4310 "../compiler/parser.y"
    {
      (yyval.ocla) = NULL;
    }
#line 10557 "compiler/parser.c"
    break;

  case 801: /* target_teams_distribute_simd_clause_optseq: target_teams_distribute_simd_clause_optseq target_teams_distribute_simd_clause  */
#line 4315 "../compiler/parser.y"
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
    }
#line 10565 "compiler/parser.c"
    break;

  case 802: /* target_teams_distribute_simd_clause_optseq: target_teams_distribute_simd_clause_optseq ',' target_teams_distribute_simd_clause  */
#line 4320 "../compiler/parser.y"
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
    }
#line 10573 "compiler/parser.c"
    break;

  case 803: /* target_teams_distribute_simd_clause: teams_distribute_simd_clause  */
#line 4326 "../compiler/parser.y"
                                 { (yyval.ocla) = (yyvsp[0].ocla); }
#line 10579 "compiler/parser.c"
    break;

  case 804: /* target_teams_distribute_simd_clause: unique_target_clause  */
#line 4327 "../compiler/parser.y"
                                 { (yyval.ocla) = (yyvsp[0].ocla); }
#line 10585 "compiler/parser.c"
    break;

  case 805: /* target_teams_distribute_simd_clause: depend_clause  */
#line 4328 "../compiler/parser.y"
                                 { (yyval.ocla) = (yyvsp[0].ocla); }
#line 10591 "compiler/parser.c"
    break;

  case 806: /* target_teams_distribute_simd_clause: nowait_clause  */
#line 4329 "../compiler/parser.y"
                                 { (yyval.ocla) = (yyvsp[0].ocla); }
#line 10597 "compiler/parser.c"
    break;

  case 807: /* teams_distribute_parallel_for_construct: teams_distribute_parallel_for_directive iteration_statement_for  */
#line 4335 "../compiler/parser.y"
    {
      (yyval.ocon) = OmpConstruct(DCTEAMSDISTPARFOR, (yyvsp[-1].odir), (yyvsp[0].stmt));
      (yyval.ocon)->l = (yyvsp[-1].odir)->l;
    }
#line 10606 "compiler/parser.c"
    break;

  case 808: /* teams_distribute_parallel_for_directive: PRAGMA_OMP OMP_TEAMS OMP_DISTRIBUTE OMP_PARALLEL OMP_FOR teams_distribute_parallel_for_clause_optseq '\n'  */
#line 4345 "../compiler/parser.y"
    {
      (yyval.odir) = OmpDirective(DCTEAMSDISTPARFOR, (yyvsp[-1].ocla));
    }
#line 10614 "compiler/parser.c"
    break;

  case 809: /* teams_distribute_parallel_for_clause_optseq: %empty  */
#line 4352 "../compiler/parser.y"
    {
      (yyval.ocla) = NULL;
    }
#line 10622 "compiler/parser.c"
    break;

  case 810: /* teams_distribute_parallel_for_clause_optseq: teams_distribute_parallel_for_clause_optseq teams_distribute_parallel_for_clause  */
#line 4357 "../compiler/parser.y"
    {
      #ifdef OMPI_OMP_EXT
        (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
      #else
        if ((yyvsp[0].ocla)->type==OCTAG){
          parse_warning("tag clause ignored;"
                "activate it by configuring OMPi with -Dext=true\n");
          (yyval.ocla) = (yyvsp[-1].ocla);
        }else
          (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
      #endif
    }
#line 10639 "compiler/parser.c"
    break;

  case 811: /* teams_distribute_parallel_for_clause_optseq: teams_distribute_parallel_for_clause_optseq ',' teams_distribute_parallel_for_clause  */
#line 4371 "../compiler/parser.y"
    {
      #ifdef OMPI_OMP_EXT
        (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
      #else
        if ((yyvsp[0].ocla)->type==OCTAG){
          parse_warning("tag clause ignored;"
                "activate it by configuring OMPi with -Dext=true\n");
          (yyval.ocla) = (yyvsp[-2].ocla);
        }else
          (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
      #endif
    }
#line 10656 "compiler/parser.c"
    break;

  case 812: /* teams_distribute_parallel_for_clause: unique_teams_clause  */
#line 4386 "../compiler/parser.y"
                                   { (yyval.ocla) = (yyvsp[0].ocla); }
#line 10662 "compiler/parser.c"
    break;

  case 813: /* teams_distribute_parallel_for_clause: distribute_parallel_for_clause  */
#line 4387 "../compiler/parser.y"
                                   { (yyval.ocla) = (yyvsp[0].ocla); }
#line 10668 "compiler/parser.c"
    break;

  case 814: /* teams_distribute_parallel_for_clause: thread_limit_clause  */
#line 4388 "../compiler/parser.y"
                                   { (yyval.ocla) = (yyvsp[0].ocla); }
#line 10674 "compiler/parser.c"
    break;

  case 815: /* target_teams_distribute_parallel_for_construct: target_teams_distribute_parallel_for_directive iteration_statement_for  */
#line 4394 "../compiler/parser.y"
    {
      (yyval.ocon) = OmpConstruct(DCTARGETTEAMSDISTPARFOR, (yyvsp[-1].odir), (yyvsp[0].stmt));
      (yyval.ocon)->l = (yyvsp[-1].odir)->l;
      __has_target = 1;
      codetargs_kernel_add((yyval.ocon));
    }
#line 10685 "compiler/parser.c"
    break;

  case 816: /* target_teams_distribute_parallel_for_directive: PRAGMA_OMP OMP_TARGET OMP_TEAMS OMP_DISTRIBUTE OMP_PARALLEL OMP_FOR target_teams_distribute_parallel_for_clause_optseq '\n'  */
#line 4406 "../compiler/parser.y"
    {
      (yyval.odir) = OmpDirective(DCTARGETTEAMSDISTPARFOR, (yyvsp[-1].ocla));
    }
#line 10693 "compiler/parser.c"
    break;

  case 817: /* target_teams_distribute_parallel_for_clause_optseq: %empty  */
#line 4413 "../compiler/parser.y"
    {
      (yyval.ocla) = NULL;
    }
#line 10701 "compiler/parser.c"
    break;

  case 818: /* target_teams_distribute_parallel_for_clause_optseq: target_teams_distribute_parallel_for_clause_optseq target_teams_distribute_parallel_for_clause  */
#line 4418 "../compiler/parser.y"
    {
      #ifdef OMPI_OMP_EXT
        (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
      #else
        if ((yyvsp[0].ocla)->type==OCTAG){
          parse_warning("tag clause ignored;"
                "activate it by configuring OMPi with -Dext=true\n");
          (yyval.ocla) = (yyvsp[-1].ocla);
        }else
          (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
      #endif
    }
#line 10718 "compiler/parser.c"
    break;

  case 819: /* target_teams_distribute_parallel_for_clause_optseq: target_teams_distribute_parallel_for_clause_optseq ',' target_teams_distribute_parallel_for_clause  */
#line 4432 "../compiler/parser.y"
    {
      #ifdef OMPI_OMP_EXT
        (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
      #else
        if ((yyvsp[0].ocla)->type==OCTAG){
          parse_warning("tag clause ignored;"
                "activate it by configuring OMPi with -Dext=true\n");
          (yyval.ocla) = (yyvsp[-2].ocla);
        }else
          (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
      #endif
    }
#line 10735 "compiler/parser.c"
    break;

  case 820: /* target_teams_distribute_parallel_for_clause: unique_target_clause  */
#line 4447 "../compiler/parser.y"
                                         { (yyval.ocla) = (yyvsp[0].ocla); }
#line 10741 "compiler/parser.c"
    break;

  case 821: /* target_teams_distribute_parallel_for_clause: teams_distribute_parallel_for_clause  */
#line 4448 "../compiler/parser.y"
                                         { (yyval.ocla) = (yyvsp[0].ocla); }
#line 10747 "compiler/parser.c"
    break;

  case 822: /* target_teams_distribute_parallel_for_clause: depend_clause  */
#line 4449 "../compiler/parser.y"
                                         { (yyval.ocla) = (yyvsp[0].ocla); }
#line 10753 "compiler/parser.c"
    break;

  case 823: /* target_teams_distribute_parallel_for_clause: nowait_clause  */
#line 4450 "../compiler/parser.y"
                                         { (yyval.ocla) = (yyvsp[0].ocla); }
#line 10759 "compiler/parser.c"
    break;

  case 824: /* teams_distribute_parallel_for_simd_construct: teams_distribute_parallel_for_simd_directive iteration_statement_for  */
#line 4456 "../compiler/parser.y"
    {
      (yyval.ocon) = OmpConstruct(DCTEAMSDISTPARFORSIMD, (yyvsp[-1].odir), (yyvsp[0].stmt));
      (yyval.ocon)->l = (yyvsp[-1].odir)->l;
    }
#line 10768 "compiler/parser.c"
    break;

  case 825: /* teams_distribute_parallel_for_simd_directive: PRAGMA_OMP OMP_TEAMS OMP_DISTRIBUTE OMP_PARALLEL OMP_FOR OMP_SIMD teams_distribute_parallel_for_simd_clause_optseq '\n'  */
#line 4466 "../compiler/parser.y"
    {
      (yyval.odir) = OmpDirective(DCTEAMSDISTPARFORSIMD, (yyvsp[-1].ocla));
    }
#line 10776 "compiler/parser.c"
    break;

  case 826: /* teams_distribute_parallel_for_simd_clause_optseq: %empty  */
#line 4473 "../compiler/parser.y"
    {
      (yyval.ocla) = NULL;
    }
#line 10784 "compiler/parser.c"
    break;

  case 827: /* teams_distribute_parallel_for_simd_clause_optseq: teams_distribute_parallel_for_simd_clause_optseq teams_distribute_parallel_for_simd_clause  */
#line 4478 "../compiler/parser.y"
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
    }
#line 10792 "compiler/parser.c"
    break;

  case 828: /* teams_distribute_parallel_for_simd_clause_optseq: teams_distribute_parallel_for_simd_clause_optseq ',' teams_distribute_parallel_for_simd_clause  */
#line 4483 "../compiler/parser.y"
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
    }
#line 10800 "compiler/parser.c"
    break;

  case 829: /* teams_distribute_parallel_for_simd_clause: unique_teams_clause  */
#line 4489 "../compiler/parser.y"
                                        { (yyval.ocla) = (yyvsp[0].ocla); }
#line 10806 "compiler/parser.c"
    break;

  case 830: /* teams_distribute_parallel_for_simd_clause: distribute_parallel_for_simd_clause  */
#line 4490 "../compiler/parser.y"
                                        { (yyval.ocla) = (yyvsp[0].ocla); }
#line 10812 "compiler/parser.c"
    break;

  case 831: /* teams_distribute_parallel_for_simd_clause: thread_limit_clause  */
#line 4491 "../compiler/parser.y"
                                        { (yyval.ocla) = (yyvsp[0].ocla); }
#line 10818 "compiler/parser.c"
    break;

  case 832: /* target_teams_distribute_parallel_for_simd_construct: target_teams_distribute_parallel_for_simd_directive iteration_statement_for  */
#line 4497 "../compiler/parser.y"
    {
      (yyval.ocon) = OmpConstruct(DCTARGETTEAMSDISTPARFORSIMD, (yyvsp[-1].odir), (yyvsp[0].stmt));
      (yyval.ocon)->l = (yyvsp[-1].odir)->l;
      __has_target = 1;
      codetargs_kernel_add((yyval.ocon));
    }
#line 10829 "compiler/parser.c"
    break;

  case 833: /* target_teams_distribute_parallel_for_simd_directive: PRAGMA_OMP OMP_TARGET OMP_TEAMS OMP_DISTRIBUTE OMP_PARALLEL OMP_FOR OMP_SIMD target_teams_distribute_parallel_for_simd_clause_optseq '\n'  */
#line 4509 "../compiler/parser.y"
    {
      (yyval.odir) = OmpDirective(DCTARGETTEAMSDISTPARFORSIMD, (yyvsp[-1].ocla));
    }
#line 10837 "compiler/parser.c"
    break;

  case 834: /* target_teams_distribute_parallel_for_simd_clause_optseq: %empty  */
#line 4516 "../compiler/parser.y"
    {
      (yyval.ocla) = NULL;
    }
#line 10845 "compiler/parser.c"
    break;

  case 835: /* target_teams_distribute_parallel_for_simd_clause_optseq: target_teams_distribute_parallel_for_simd_clause_optseq target_teams_distribute_parallel_for_simd_clause  */
#line 4521 "../compiler/parser.y"
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
    }
#line 10853 "compiler/parser.c"
    break;

  case 836: /* target_teams_distribute_parallel_for_simd_clause_optseq: target_teams_distribute_parallel_for_simd_clause_optseq ',' target_teams_distribute_parallel_for_simd_clause  */
#line 4526 "../compiler/parser.y"
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
    }
#line 10861 "compiler/parser.c"
    break;

  case 837: /* target_teams_distribute_parallel_for_simd_clause: unique_target_clause  */
#line 4532 "../compiler/parser.y"
                                              { (yyval.ocla) = (yyvsp[0].ocla); }
#line 10867 "compiler/parser.c"
    break;

  case 838: /* target_teams_distribute_parallel_for_simd_clause: teams_distribute_parallel_for_simd_clause  */
#line 4533 "../compiler/parser.y"
                                              { (yyval.ocla) = (yyvsp[0].ocla); }
#line 10873 "compiler/parser.c"
    break;

  case 839: /* target_teams_distribute_parallel_for_simd_clause: nowait_clause  */
#line 4534 "../compiler/parser.y"
                                              { (yyval.ocla) = (yyvsp[0].ocla); }
#line 10879 "compiler/parser.c"
    break;

  case 840: /* target_teams_distribute_parallel_for_simd_clause: depend_clause  */
#line 4535 "../compiler/parser.y"
                                              { (yyval.ocla) = (yyvsp[0].ocla); }
#line 10885 "compiler/parser.c"
    break;

  case 841: /* target_parallel_for_construct: target_parallel_for_directive iteration_statement_for  */
#line 4541 "../compiler/parser.y"
    {
      (yyval.ocon) = OmpConstruct(DCTARGETPARFOR, (yyvsp[-1].odir), (yyvsp[0].stmt));
      __has_target = 1;
      codetargs_kernel_add((yyval.ocon));
    }
#line 10895 "compiler/parser.c"
    break;

  case 842: /* target_parallel_for_directive: PRAGMA_OMP OMP_TARGET OMP_PARALLEL OMP_FOR target_parallel_for_clause_optseq '\n'  */
#line 4551 "../compiler/parser.y"
    {
      (yyval.odir) = OmpDirective(DCTARGETPARFOR, (yyvsp[-1].ocla));
    }
#line 10903 "compiler/parser.c"
    break;

  case 843: /* target_parallel_for_clause_optseq: %empty  */
#line 4558 "../compiler/parser.y"
    {
      (yyval.ocla) = NULL;
    }
#line 10911 "compiler/parser.c"
    break;

  case 844: /* target_parallel_for_clause_optseq: target_parallel_for_clause_optseq target_parallel_for_clause  */
#line 4562 "../compiler/parser.y"
    {
      #ifdef OMPI_OMP_EXT
        (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
      #else
        if ((yyvsp[0].ocla)->type==OCTAG){
          parse_warning("tag clause ignored;"
                "activate it by configuring OMPi with -Dext=true\n");
          (yyval.ocla) = (yyvsp[-1].ocla);
        }else
          (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
      #endif
    }
#line 10928 "compiler/parser.c"
    break;

  case 845: /* target_parallel_for_clause_optseq: target_parallel_for_clause_optseq ',' target_parallel_for_clause  */
#line 4575 "../compiler/parser.y"
    {
      #ifdef OMPI_OMP_EXT
        (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
      #else
        if ((yyvsp[0].ocla)->type==OCTAG){
          parse_warning("tag clause ignored;"
                "activate it by configuring OMPi with -Dext=true\n");
          (yyval.ocla) = (yyvsp[-2].ocla);
        }else
          (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
      #endif
    }
#line 10945 "compiler/parser.c"
    break;

  case 846: /* target_parallel_for_clause: unique_target_clause  */
#line 4590 "../compiler/parser.y"
                         { (yyval.ocla) = (yyvsp[0].ocla); }
#line 10951 "compiler/parser.c"
    break;

  case 847: /* target_parallel_for_clause: parallel_for_clause  */
#line 4591 "../compiler/parser.y"
                         { (yyval.ocla) = (yyvsp[0].ocla); }
#line 10957 "compiler/parser.c"
    break;

  case 848: /* target_parallel_for_clause: depend_clause  */
#line 4592 "../compiler/parser.y"
                         { (yyval.ocla) = (yyvsp[0].ocla); }
#line 10963 "compiler/parser.c"
    break;

  case 849: /* target_parallel_for_clause: nowait_clause  */
#line 4593 "../compiler/parser.y"
                         { (yyval.ocla) = (yyvsp[0].ocla); }
#line 10969 "compiler/parser.c"
    break;

  case 850: /* task_construct: task_directive structured_block  */
#line 4599 "../compiler/parser.y"
    {
      (yyval.ocon) = OmpConstruct(DCTASK, (yyvsp[-1].odir), (yyvsp[0].stmt));
      (yyval.ocon)->l = (yyvsp[-1].odir)->l;
    }
#line 10978 "compiler/parser.c"
    break;

  case 851: /* task_directive: PRAGMA_OMP OMP_TASK task_clause_optseq '\n'  */
#line 4608 "../compiler/parser.y"
    {
      (yyval.odir) = OmpDirective(DCTASK, (yyvsp[-1].ocla));
    }
#line 10986 "compiler/parser.c"
    break;

  case 852: /* task_clause_optseq: %empty  */
#line 4615 "../compiler/parser.y"
                { (yyval.ocla) = NULL; }
#line 10992 "compiler/parser.c"
    break;

  case 853: /* task_clause_optseq: task_clause_optseq task_clause  */
#line 4616 "../compiler/parser.y"
                                   { (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla)); }
#line 10998 "compiler/parser.c"
    break;

  case 854: /* task_clause_optseq: task_clause_optseq ',' task_clause  */
#line 4617 "../compiler/parser.y"
                                       { (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla)); }
#line 11004 "compiler/parser.c"
    break;

  case 855: /* task_clause: unique_task_clause  */
#line 4622 "../compiler/parser.y"
                                 { (yyval.ocla) = (yyvsp[0].ocla); }
#line 11010 "compiler/parser.c"
    break;

  case 856: /* task_clause: if_clause  */
#line 4623 "../compiler/parser.y"
                                 { (yyval.ocla) = (yyvsp[0].ocla); }
#line 11016 "compiler/parser.c"
    break;

  case 857: /* task_clause: data_default_clause  */
#line 4624 "../compiler/parser.y"
                                 { (yyval.ocla) = (yyvsp[0].ocla); }
#line 11022 "compiler/parser.c"
    break;

  case 858: /* task_clause: data_privatization_clause  */
#line 4625 "../compiler/parser.y"
                                 { (yyval.ocla) = (yyvsp[0].ocla); }
#line 11028 "compiler/parser.c"
    break;

  case 859: /* task_clause: data_privatization_in_clause  */
#line 4626 "../compiler/parser.y"
                                 { (yyval.ocla) = (yyvsp[0].ocla); }
#line 11034 "compiler/parser.c"
    break;

  case 860: /* task_clause: data_sharing_clause  */
#line 4627 "../compiler/parser.y"
                                 { (yyval.ocla) = (yyvsp[0].ocla); }
#line 11040 "compiler/parser.c"
    break;

  case 861: /* task_clause: depend_clause  */
#line 4628 "../compiler/parser.y"
                                 { (yyval.ocla) = (yyvsp[0].ocla); }
#line 11046 "compiler/parser.c"
    break;

  case 862: /* task_clause: inreduction_clause  */
#line 4629 "../compiler/parser.y"
                                 { (yyval.ocla) = (yyvsp[0].ocla); }
#line 11052 "compiler/parser.c"
    break;

  case 863: /* $@38: %empty  */
#line 4635 "../compiler/parser.y"
             { sc_pause_openmp(); }
#line 11058 "compiler/parser.c"
    break;

  case 864: /* unique_task_clause: OMP_FINAL $@38 paren_dirnamemod_and_expr  */
#line 4636 "../compiler/parser.y"
    {
      sc_start_openmp();
      (yyval.ocla) = add_modifier(FinalClause((yyvsp[0].expr)->left), (yyvsp[0].expr)->opid);
      free((yyvsp[0].expr));
		}
#line 11068 "compiler/parser.c"
    break;

  case 865: /* unique_task_clause: OMP_UNTIED paren_dirnamemod_maybe  */
#line 4642 "../compiler/parser.y"
    {
      (yyval.ocla) = add_modifier(PlainClause(OCUNTIED), (yyvsp[0].type));
    }
#line 11076 "compiler/parser.c"
    break;

  case 866: /* unique_task_clause: OMP_MERGEABLE paren_dirnamemod_maybe  */
#line 4646 "../compiler/parser.y"
    {
      (yyval.ocla) = add_modifier(PlainClause(OCMERGEABLE), (yyvsp[0].type));
    }
#line 11084 "compiler/parser.c"
    break;

  case 867: /* $@39: %empty  */
#line 4650 "../compiler/parser.y"
                 { sc_pause_openmp(); }
#line 11090 "compiler/parser.c"
    break;

  case 868: /* unique_task_clause: OMP_PRIORITY $@39 paren_dirnamemod_and_expr  */
#line 4651 "../compiler/parser.y"
    {
      sc_start_openmp();
      (yyval.ocla) = add_modifier(PriorityClause((yyvsp[0].expr)->left), (yyvsp[0].expr)->opid);
      free((yyvsp[0].expr));
		}
#line 11100 "compiler/parser.c"
    break;

  case 869: /* $@40: %empty  */
#line 4665 "../compiler/parser.y"
                     { sc_pause_openmp(); }
#line 11106 "compiler/parser.c"
    break;

  case 870: /* depend_clause: OMP_DEPEND '(' dependence_type $@40 ':' variable_array_section_list ')'  */
#line 4666 "../compiler/parser.y"
    {
      sc_start_openmp();
      (yyval.ocla) = DependClause((yyvsp[-4].type), (yyvsp[-1].oxli));
		}
#line 11115 "compiler/parser.c"
    break;

  case 871: /* $@41: %empty  */
#line 4671 "../compiler/parser.y"
                     { sc_pause_openmp(); }
#line 11121 "compiler/parser.c"
    break;

  case 872: /* depend_clause: OMP_DEPEND '(' dirname_modifier ',' dependence_type $@41 ':' variable_array_section_list ')'  */
#line 4672 "../compiler/parser.y"
    {
      sc_start_openmp();
      (yyval.ocla) = add_modifier(DependClause((yyvsp[-4].type), (yyvsp[-1].oxli)), (yyvsp[-6].type));
		}
#line 11130 "compiler/parser.c"
    break;

  case 873: /* $@42: %empty  */
#line 4677 "../compiler/parser.y"
                     { sc_pause_openmp(); }
#line 11136 "compiler/parser.c"
    break;

  case 874: /* depend_clause: OMP_DEPEND '(' dependence_type ',' dirname_modifier $@42 ':' variable_array_section_list ')'  */
#line 4678 "../compiler/parser.y"
    {
      sc_start_openmp();
      (yyval.ocla) = add_modifier(DependClause((yyvsp[-6].type), (yyvsp[-1].oxli)), (yyvsp[-4].type));
    }
#line 11145 "compiler/parser.c"
    break;

  case 875: /* dependence_type: OMP_IN  */
#line 4686 "../compiler/parser.y"
           { (yyval.type) = OC_in; }
#line 11151 "compiler/parser.c"
    break;

  case 876: /* dependence_type: OMP_OUT  */
#line 4687 "../compiler/parser.y"
            { (yyval.type) = OC_out; }
#line 11157 "compiler/parser.c"
    break;

  case 877: /* dependence_type: OMP_INOUT  */
#line 4688 "../compiler/parser.y"
              { (yyval.type) = OC_inout; }
#line 11163 "compiler/parser.c"
    break;

  case 878: /* $@43: %empty  */
#line 4698 "../compiler/parser.y"
                     { sc_pause_openmp(); }
#line 11169 "compiler/parser.c"
    break;

  case 879: /* inreduction_clause: OMP_INREDUCTION '(' reduction_identifier $@43 ':' variable_array_section_list ')'  */
#line 4699 "../compiler/parser.y"
    {
      sc_start_openmp();
      (yyval.ocla) = InReductionClause((yyvsp[-4].type), (yyvsp[-1].oxli));
		}
#line 11178 "compiler/parser.c"
    break;

  case 880: /* $@44: %empty  */
#line 4704 "../compiler/parser.y"
                     { sc_pause_openmp(); }
#line 11184 "compiler/parser.c"
    break;

  case 881: /* inreduction_clause: OMP_INREDUCTION '(' dirname_modifier ',' reduction_identifier $@44 ':' variable_array_section_list ')'  */
#line 4705 "../compiler/parser.y"
    {
      sc_start_openmp();
      (yyval.ocla) = add_modifier(InReductionClause((yyvsp[-4].type), (yyvsp[-1].oxli)), (yyvsp[-6].type));
		}
#line 11193 "compiler/parser.c"
    break;

  case 882: /* $@45: %empty  */
#line 4710 "../compiler/parser.y"
                     { sc_pause_openmp(); }
#line 11199 "compiler/parser.c"
    break;

  case 883: /* inreduction_clause: OMP_INREDUCTION '(' reduction_identifier ',' dirname_modifier $@45 ':' variable_array_section_list ')'  */
#line 4711 "../compiler/parser.y"
    {
      sc_start_openmp();
      (yyval.ocla) = add_modifier(InReductionClause((yyvsp[-6].type), (yyvsp[-1].oxli)), (yyvsp[-4].type));
    }
#line 11208 "compiler/parser.c"
    break;

  case 884: /* parallel_for_construct: parallel_for_directive iteration_statement_for  */
#line 4719 "../compiler/parser.y"
    {
      (yyval.ocon) = OmpConstruct(DCPARFOR, (yyvsp[-1].odir), (yyvsp[0].stmt));
      (yyval.ocon)->l = (yyvsp[-1].odir)->l;
    }
#line 11217 "compiler/parser.c"
    break;

  case 885: /* parallel_for_directive: PRAGMA_OMP OMP_PARALLEL OMP_FOR parallel_for_clause_optseq '\n'  */
#line 4727 "../compiler/parser.y"
    {
      (yyval.odir) = OmpDirective(DCPARFOR, (yyvsp[-1].ocla));
    }
#line 11225 "compiler/parser.c"
    break;

  case 886: /* parallel_for_clause_optseq: %empty  */
#line 4734 "../compiler/parser.y"
    {
      (yyval.ocla) = NULL;
    }
#line 11233 "compiler/parser.c"
    break;

  case 887: /* parallel_for_clause_optseq: parallel_for_clause_optseq parallel_for_clause  */
#line 4738 "../compiler/parser.y"
    {
      #ifdef OMPI_OMP_EXT
        (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
      #else
        if ((yyvsp[0].ocla)->type==OCTAG){
          parse_warning("tag clause ignored;"
                "activate it by configuring OMPi with -Dext=true\n");
          (yyval.ocla) = (yyvsp[-1].ocla);
        }else
          (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
      #endif
    }
#line 11250 "compiler/parser.c"
    break;

  case 888: /* parallel_for_clause_optseq: parallel_for_clause_optseq ',' parallel_for_clause  */
#line 4751 "../compiler/parser.y"
    {
      #ifdef OMPI_OMP_EXT
        (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
      #else
        if ((yyvsp[0].ocla)->type==OCTAG){
          parse_warning("tag clause ignored;"
                "activate it by configuring OMPi with -Dext=true\n");
          (yyval.ocla) = (yyvsp[-2].ocla);
        }else
          (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
      #endif
    }
#line 11267 "compiler/parser.c"
    break;

  case 889: /* parallel_for_clause: unique_parallel_clause  */
#line 4766 "../compiler/parser.y"
                                  { (yyval.ocla) = (yyvsp[0].ocla); }
#line 11273 "compiler/parser.c"
    break;

  case 890: /* parallel_for_clause: unique_for_clause  */
#line 4767 "../compiler/parser.y"
                                  { (yyval.ocla) = (yyvsp[0].ocla); }
#line 11279 "compiler/parser.c"
    break;

  case 891: /* parallel_for_clause: if_clause  */
#line 4768 "../compiler/parser.y"
                                  { (yyval.ocla) = (yyvsp[0].ocla); }
#line 11285 "compiler/parser.c"
    break;

  case 892: /* parallel_for_clause: data_default_clause  */
#line 4769 "../compiler/parser.y"
                                  { (yyval.ocla) = (yyvsp[0].ocla); }
#line 11291 "compiler/parser.c"
    break;

  case 893: /* parallel_for_clause: data_privatization_clause  */
#line 4770 "../compiler/parser.y"
                                  { (yyval.ocla) = (yyvsp[0].ocla); }
#line 11297 "compiler/parser.c"
    break;

  case 894: /* parallel_for_clause: data_privatization_in_clause  */
#line 4771 "../compiler/parser.y"
                                  { (yyval.ocla) = (yyvsp[0].ocla); }
#line 11303 "compiler/parser.c"
    break;

  case 895: /* parallel_for_clause: data_privatization_out_clause  */
#line 4772 "../compiler/parser.y"
                                  { (yyval.ocla) = (yyvsp[0].ocla); }
#line 11309 "compiler/parser.c"
    break;

  case 896: /* parallel_for_clause: data_sharing_clause  */
#line 4773 "../compiler/parser.y"
                                  { (yyval.ocla) = (yyvsp[0].ocla); }
#line 11315 "compiler/parser.c"
    break;

  case 897: /* parallel_for_clause: data_reduction_clause  */
#line 4774 "../compiler/parser.y"
                                  { (yyval.ocla) = (yyvsp[0].ocla); }
#line 11321 "compiler/parser.c"
    break;

  case 898: /* parallel_sections_construct: parallel_sections_directive section_scope  */
#line 4779 "../compiler/parser.y"
    {
      (yyval.ocon) = OmpConstruct(DCPARSECTIONS, (yyvsp[-1].odir), (yyvsp[0].stmt));
      (yyval.ocon)->l = (yyvsp[-1].odir)->l;
    }
#line 11330 "compiler/parser.c"
    break;

  case 899: /* parallel_sections_directive: PRAGMA_OMP OMP_PARALLEL OMP_SECTIONS parallel_sections_clause_optseq '\n'  */
#line 4787 "../compiler/parser.y"
    {
      (yyval.odir) = OmpDirective(DCPARSECTIONS, (yyvsp[-1].ocla));
    }
#line 11338 "compiler/parser.c"
    break;

  case 900: /* parallel_sections_clause_optseq: %empty  */
#line 4794 "../compiler/parser.y"
    {
      (yyval.ocla) = NULL;
    }
#line 11346 "compiler/parser.c"
    break;

  case 901: /* parallel_sections_clause_optseq: parallel_sections_clause_optseq parallel_sections_clause  */
#line 4798 "../compiler/parser.y"
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
    }
#line 11354 "compiler/parser.c"
    break;

  case 902: /* parallel_sections_clause_optseq: parallel_sections_clause_optseq ',' parallel_sections_clause  */
#line 4802 "../compiler/parser.y"
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
    }
#line 11362 "compiler/parser.c"
    break;

  case 903: /* parallel_sections_clause: unique_parallel_clause  */
#line 4808 "../compiler/parser.y"
                                  { (yyval.ocla) = (yyvsp[0].ocla); }
#line 11368 "compiler/parser.c"
    break;

  case 904: /* parallel_sections_clause: if_clause  */
#line 4809 "../compiler/parser.y"
                                  { (yyval.ocla) = (yyvsp[0].ocla); }
#line 11374 "compiler/parser.c"
    break;

  case 905: /* parallel_sections_clause: data_default_clause  */
#line 4810 "../compiler/parser.y"
                                  { (yyval.ocla) = (yyvsp[0].ocla); }
#line 11380 "compiler/parser.c"
    break;

  case 906: /* parallel_sections_clause: data_privatization_clause  */
#line 4811 "../compiler/parser.y"
                                  { (yyval.ocla) = (yyvsp[0].ocla); }
#line 11386 "compiler/parser.c"
    break;

  case 907: /* parallel_sections_clause: data_privatization_in_clause  */
#line 4812 "../compiler/parser.y"
                                  { (yyval.ocla) = (yyvsp[0].ocla); }
#line 11392 "compiler/parser.c"
    break;

  case 908: /* parallel_sections_clause: data_privatization_out_clause  */
#line 4813 "../compiler/parser.y"
                                  { (yyval.ocla) = (yyvsp[0].ocla); }
#line 11398 "compiler/parser.c"
    break;

  case 909: /* parallel_sections_clause: data_sharing_clause  */
#line 4814 "../compiler/parser.y"
                                  { (yyval.ocla) = (yyvsp[0].ocla); }
#line 11404 "compiler/parser.c"
    break;

  case 910: /* parallel_sections_clause: data_reduction_clause  */
#line 4815 "../compiler/parser.y"
                                  { (yyval.ocla) = (yyvsp[0].ocla); }
#line 11410 "compiler/parser.c"
    break;

  case 911: /* master_construct: master_directive structured_block  */
#line 4820 "../compiler/parser.y"
    {
      (yyval.ocon) = OmpConstruct(DCMASTER, (yyvsp[-1].odir), (yyvsp[0].stmt));
    }
#line 11418 "compiler/parser.c"
    break;

  case 912: /* master_directive: PRAGMA_OMP OMP_MASTER '\n'  */
#line 4827 "../compiler/parser.y"
    {
      (yyval.odir) = OmpDirective(DCMASTER, NULL);
    }
#line 11426 "compiler/parser.c"
    break;

  case 913: /* critical_construct: critical_directive structured_block  */
#line 4834 "../compiler/parser.y"
    {
      (yyval.ocon) = OmpConstruct(DCCRITICAL, (yyvsp[-1].odir), (yyvsp[0].stmt));
    }
#line 11434 "compiler/parser.c"
    break;

  case 914: /* critical_directive: PRAGMA_OMP OMP_CRITICAL '\n'  */
#line 4841 "../compiler/parser.y"
    {
      (yyval.odir) = OmpCriticalDirective(NULL, NULL);
    }
#line 11442 "compiler/parser.c"
    break;

  case 915: /* critical_directive: PRAGMA_OMP OMP_CRITICAL region_phrase '\n'  */
#line 4845 "../compiler/parser.y"
    {
      (yyval.odir) = OmpCriticalDirective((yyvsp[-1].symb), NULL);
    }
#line 11450 "compiler/parser.c"
    break;

  case 916: /* critical_directive: PRAGMA_OMP OMP_CRITICAL region_phrase hint_clause '\n'  */
#line 4850 "../compiler/parser.y"
    {
      (yyval.odir) = OmpCriticalDirective((yyvsp[-2].symb), (yyvsp[-1].ocla));
    }
#line 11458 "compiler/parser.c"
    break;

  case 917: /* region_phrase: '(' IDENTIFIER ')'  */
#line 4857 "../compiler/parser.y"
    {
      (yyval.symb) = Symbol((yyvsp[-1].name));
    }
#line 11466 "compiler/parser.c"
    break;

  case 918: /* $@46: %empty  */
#line 4864 "../compiler/parser.y"
             { sc_pause_openmp(); }
#line 11472 "compiler/parser.c"
    break;

  case 919: /* hint_clause: OMP_HINT $@46 paren_dirnamemod_and_expr  */
#line 4865 "../compiler/parser.y"
    {
      sc_start_openmp();
      (yyval.ocla) = add_modifier(HintClause((yyvsp[0].expr)->left), (yyvsp[0].expr)->opid);
      free((yyvsp[0].expr));
		}
#line 11482 "compiler/parser.c"
    break;

  case 920: /* barrier_directive: PRAGMA_OMP OMP_BARRIER '\n'  */
#line 4874 "../compiler/parser.y"
    {
      (yyval.odir) = OmpDirective(DCBARRIER, NULL);
    }
#line 11490 "compiler/parser.c"
    break;

  case 921: /* taskwait_directive: PRAGMA_OMP OMP_TASKWAIT '\n'  */
#line 4882 "../compiler/parser.y"
    {
      (yyval.odir) = OmpDirective(DCTASKWAIT, NULL);
    }
#line 11498 "compiler/parser.c"
    break;

  case 922: /* taskgroup_construct: taskgroup_directive structured_block  */
#line 4890 "../compiler/parser.y"
    {
      (yyval.ocon) = OmpConstruct(DCTASKGROUP, (yyvsp[-1].odir), (yyvsp[0].stmt));
    }
#line 11506 "compiler/parser.c"
    break;

  case 923: /* taskgroup_directive: PRAGMA_OMP OMP_TASKGROUP taskgroup_clause_optseq '\n'  */
#line 4899 "../compiler/parser.y"
    {
      (yyval.odir) = OmpDirective(DCTASKGROUP, (yyvsp[-1].ocla));
    }
#line 11514 "compiler/parser.c"
    break;

  case 924: /* taskgroup_clause_optseq: %empty  */
#line 4906 "../compiler/parser.y"
    {
      (yyval.ocla) = NULL;
    }
#line 11522 "compiler/parser.c"
    break;

  case 925: /* taskgroup_clause_optseq: taskgroup_clause_optseq taskreduction_clause  */
#line 4910 "../compiler/parser.y"
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
    }
#line 11530 "compiler/parser.c"
    break;

  case 926: /* taskgroup_clause_optseq: taskgroup_clause_optseq ',' taskreduction_clause  */
#line 4914 "../compiler/parser.y"
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
    }
#line 11538 "compiler/parser.c"
    break;

  case 927: /* $@47: %empty  */
#line 4926 "../compiler/parser.y"
                     { sc_pause_openmp(); }
#line 11544 "compiler/parser.c"
    break;

  case 928: /* taskreduction_clause: OMP_TASKREDUCTION '(' reduction_identifier $@47 ':' variable_array_section_list ')'  */
#line 4927 "../compiler/parser.y"
    {
      sc_start_openmp();
      (yyval.ocla) = TaskReductionClause((yyvsp[-4].type), (yyvsp[-1].oxli));
		}
#line 11553 "compiler/parser.c"
    break;

  case 929: /* $@48: %empty  */
#line 4932 "../compiler/parser.y"
                     { sc_pause_openmp(); }
#line 11559 "compiler/parser.c"
    break;

  case 930: /* taskreduction_clause: OMP_TASKREDUCTION '(' dirname_modifier ',' reduction_identifier $@48 ':' variable_array_section_list ')'  */
#line 4933 "../compiler/parser.y"
    {
      sc_start_openmp();
      (yyval.ocla) = add_modifier(TaskReductionClause((yyvsp[-4].type), (yyvsp[-1].oxli)), (yyvsp[-6].type));
		}
#line 11568 "compiler/parser.c"
    break;

  case 931: /* $@49: %empty  */
#line 4938 "../compiler/parser.y"
                     { sc_pause_openmp(); }
#line 11574 "compiler/parser.c"
    break;

  case 932: /* taskreduction_clause: OMP_TASKREDUCTION '(' reduction_identifier ',' dirname_modifier $@49 ':' variable_array_section_list ')'  */
#line 4939 "../compiler/parser.y"
    {
      sc_start_openmp();
      (yyval.ocla) = add_modifier(TaskReductionClause((yyvsp[-6].type), (yyvsp[-1].oxli)), (yyvsp[-4].type));
    }
#line 11583 "compiler/parser.c"
    break;

  case 933: /* taskyield_directive: PRAGMA_OMP OMP_TASKYIELD '\n'  */
#line 4948 "../compiler/parser.y"
    {
      (yyval.odir) = OmpDirective(DCTASKYIELD, NULL);
    }
#line 11591 "compiler/parser.c"
    break;

  case 934: /* atomic_construct: atomic_directive statement  */
#line 4955 "../compiler/parser.y"
    {
      (yyval.ocon) = OmpConstruct(DCATOMIC, (yyvsp[-1].odir), (yyvsp[0].stmt));
    }
#line 11599 "compiler/parser.c"
    break;

  case 935: /* atomic_directive: PRAGMA_OMP OMP_ATOMIC atomic_clause_optseq '\n'  */
#line 4962 "../compiler/parser.y"
    {
      (yyval.odir) = OmpDirective(DCATOMIC, (yyvsp[-1].ocla));
    }
#line 11607 "compiler/parser.c"
    break;

  case 936: /* atomic_clause_optseq: %empty  */
#line 4969 "../compiler/parser.y"
    {
      (yyval.ocla) = NULL;
    }
#line 11615 "compiler/parser.c"
    break;

  case 937: /* atomic_clause_optseq: atomic_clause_optseq atomic_clause  */
#line 4973 "../compiler/parser.y"
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
    }
#line 11623 "compiler/parser.c"
    break;

  case 938: /* atomic_clause_optseq: atomic_clause_optseq ',' atomic_clause  */
#line 4977 "../compiler/parser.y"
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
    }
#line 11631 "compiler/parser.c"
    break;

  case 939: /* atomic_clause_optseq: atomic_clause_optseq memory_order_clause  */
#line 4981 "../compiler/parser.y"
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
    }
#line 11639 "compiler/parser.c"
    break;

  case 940: /* atomic_clause_optseq: atomic_clause_optseq ',' memory_order_clause  */
#line 4985 "../compiler/parser.y"
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
    }
#line 11647 "compiler/parser.c"
    break;

  case 941: /* atomic_clause: OMP_READ paren_dirnamemod_maybe  */
#line 4991 "../compiler/parser.y"
                                    { (yyval.ocla) = add_modifier(PlainClause(OCREAD), (yyvsp[0].type)); }
#line 11653 "compiler/parser.c"
    break;

  case 942: /* atomic_clause: OMP_WRITE paren_dirnamemod_maybe  */
#line 4992 "../compiler/parser.y"
                                     { (yyval.ocla) = add_modifier(PlainClause(OCWRITE), (yyvsp[0].type)); }
#line 11659 "compiler/parser.c"
    break;

  case 943: /* atomic_clause: OMP_UPDATE paren_dirnamemod_maybe  */
#line 4993 "../compiler/parser.y"
                                      { (yyval.ocla) = add_modifier(PlainClause(OCUPDATE), (yyvsp[0].type)); }
#line 11665 "compiler/parser.c"
    break;

  case 944: /* atomic_clause: OMP_CAPTURE paren_dirnamemod_maybe  */
#line 4994 "../compiler/parser.y"
                                       { (yyval.ocla) = add_modifier(PlainClause(OCCAPTURE), (yyvsp[0].type)); }
#line 11671 "compiler/parser.c"
    break;

  case 945: /* atomic_clause: OMP_COMPARE paren_dirnamemod_maybe  */
#line 4995 "../compiler/parser.y"
                                       { (yyval.ocla) = add_modifier(PlainClause(OCCOMPARE), (yyvsp[0].type)); }
#line 11677 "compiler/parser.c"
    break;

  case 946: /* atomic_clause: OMP_WEAK paren_dirnamemod_maybe  */
#line 4996 "../compiler/parser.y"
                                    { (yyval.ocla) = add_modifier(PlainClause(OCWEAK), (yyvsp[0].type)); }
#line 11683 "compiler/parser.c"
    break;

  case 947: /* atomic_clause: OMP_FAIL '(' dirname_modifier_opt fail_memmodel ')'  */
#line 4998 "../compiler/parser.y"
    { 
      (yyval.ocla) = add_modifier(FailClause((yyvsp[-1].type)), (yyvsp[-2].type));
    }
#line 11691 "compiler/parser.c"
    break;

  case 948: /* atomic_clause: hint_clause  */
#line 5001 "../compiler/parser.y"
                   { (yyval.ocla) = (yyvsp[0].ocla); }
#line 11697 "compiler/parser.c"
    break;

  case 949: /* memory_order_clause: seq_cst_clause  */
#line 5005 "../compiler/parser.y"
                   { (yyval.ocla) = (yyvsp[0].ocla); }
#line 11703 "compiler/parser.c"
    break;

  case 950: /* memory_order_clause: acq_rel_clause  */
#line 5006 "../compiler/parser.y"
                   { (yyval.ocla) = (yyvsp[0].ocla); }
#line 11709 "compiler/parser.c"
    break;

  case 951: /* memory_order_clause: acquire_clause  */
#line 5007 "../compiler/parser.y"
                   { (yyval.ocla) = (yyvsp[0].ocla); }
#line 11715 "compiler/parser.c"
    break;

  case 952: /* memory_order_clause: release_clause  */
#line 5008 "../compiler/parser.y"
                   { (yyval.ocla) = (yyvsp[0].ocla); }
#line 11721 "compiler/parser.c"
    break;

  case 953: /* memory_order_clause: relaxed_clause  */
#line 5009 "../compiler/parser.y"
                   { (yyval.ocla) = (yyvsp[0].ocla); }
#line 11727 "compiler/parser.c"
    break;

  case 954: /* seq_cst_clause: OMP_SEQ_CST paren_dirnamemod_maybe  */
#line 5013 "../compiler/parser.y"
                                                   { (yyval.ocla) = add_modifier(PlainClause(OCSEQCST), (yyvsp[0].type)); }
#line 11733 "compiler/parser.c"
    break;

  case 955: /* acq_rel_clause: OMP_ACQ_REL paren_dirnamemod_maybe  */
#line 5017 "../compiler/parser.y"
                                                   { (yyval.ocla) = add_modifier(PlainClause(OCACQREL), (yyvsp[0].type)); }
#line 11739 "compiler/parser.c"
    break;

  case 956: /* acquire_clause: OMP_ACQUIRE paren_dirnamemod_maybe  */
#line 5021 "../compiler/parser.y"
                                                   { (yyval.ocla) = add_modifier(PlainClause(OCACQUIRE), (yyvsp[0].type)); }
#line 11745 "compiler/parser.c"
    break;

  case 957: /* release_clause: OMP_RELEASE paren_dirnamemod_maybe  */
#line 5025 "../compiler/parser.y"
                                                   { (yyval.ocla) = add_modifier(PlainClause(OCRELEASE), (yyvsp[0].type)); }
#line 11751 "compiler/parser.c"
    break;

  case 958: /* relaxed_clause: OMP_RELAXED paren_dirnamemod_maybe  */
#line 5029 "../compiler/parser.y"
                                                   { (yyval.ocla) = add_modifier(PlainClause(OCRELAXED), (yyvsp[0].type)); }
#line 11757 "compiler/parser.c"
    break;

  case 959: /* masked_construct: masked_directive structured_block  */
#line 5035 "../compiler/parser.y"
    {
      (yyval.ocon) = OmpConstruct(DCMASKED, (yyvsp[-1].odir), (yyvsp[0].stmt));
    }
#line 11765 "compiler/parser.c"
    break;

  case 960: /* masked_directive: PRAGMA_OMP OMP_MASKED masked_clause_opt '\n'  */
#line 5042 "../compiler/parser.y"
    {
      (yyval.odir) = OmpDirective(DCMASKED, (yyvsp[-1].ocla));
    }
#line 11773 "compiler/parser.c"
    break;

  case 961: /* masked_clause_opt: %empty  */
#line 5049 "../compiler/parser.y"
    {
      (yyval.ocla) = NULL;
    }
#line 11781 "compiler/parser.c"
    break;

  case 962: /* masked_clause_opt: filter_clause  */
#line 5052 "../compiler/parser.y"
                  { (yyval.ocla) = (yyvsp[0].ocla); }
#line 11787 "compiler/parser.c"
    break;

  case 963: /* requires_directive: PRAGMA_OMP OMP_REQUIRES requires_clause_optseq '\n'  */
#line 5058 "../compiler/parser.y"
    {
      (yyval.odir) = OmpDirective(DCREQUIRES, (yyvsp[-1].ocla));
      if (stab->scopelevel != 0)
				parse_error(1, "the #requires directive must be at file scope level.\n");
    }
#line 11797 "compiler/parser.c"
    break;

  case 964: /* requires_clause_optseq: unique_requires_clause  */
#line 5066 "../compiler/parser.y"
                           { (yyval.ocla) = (yyvsp[0].ocla); }
#line 11803 "compiler/parser.c"
    break;

  case 965: /* requires_clause_optseq: requires_clause_optseq unique_requires_clause  */
#line 5068 "../compiler/parser.y"
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
    }
#line 11811 "compiler/parser.c"
    break;

  case 966: /* requires_clause_optseq: requires_clause_optseq ',' unique_requires_clause  */
#line 5072 "../compiler/parser.y"
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
    }
#line 11819 "compiler/parser.c"
    break;

  case 967: /* unique_requires_clause: reverse_offload_clause  */
#line 5078 "../compiler/parser.y"
                           { (yyval.ocla) = (yyvsp[0].ocla); }
#line 11825 "compiler/parser.c"
    break;

  case 968: /* unique_requires_clause: unified_address_clause  */
#line 5079 "../compiler/parser.y"
                           { (yyval.ocla) = (yyvsp[0].ocla); }
#line 11831 "compiler/parser.c"
    break;

  case 969: /* unique_requires_clause: unified_shared_memory_clause  */
#line 5080 "../compiler/parser.y"
                                 { (yyval.ocla) = (yyvsp[0].ocla); }
#line 11837 "compiler/parser.c"
    break;

  case 970: /* unique_requires_clause: atomic_default_mem_order_clause  */
#line 5081 "../compiler/parser.y"
                                    { (yyval.ocla) = (yyvsp[0].ocla); }
#line 11843 "compiler/parser.c"
    break;

  case 971: /* unique_requires_clause: dynamic_allocators_clause  */
#line 5082 "../compiler/parser.y"
                              { (yyval.ocla) = (yyvsp[0].ocla); }
#line 11849 "compiler/parser.c"
    break;

  case 972: /* unique_requires_clause: IDENTIFIER  */
#line 5084 "../compiler/parser.y"
    {
	    if ((strncmp((yyvsp[0].name), "ext_", 4) != 0) || (strlen((yyvsp[0].name)) == 4))
	      parse_error(-1, "incorrect requirement clause `%s'.\n", (yyvsp[0].name));
	    (yyval.ocla) = OmpExtClause(Symbol((yyvsp[0].name) + 4));
    }
#line 11859 "compiler/parser.c"
    break;

  case 973: /* reverse_offload_clause: OMP_REVERSE_OFFLOAD paren_dirnamemod_maybe  */
#line 5093 "../compiler/parser.y"
                {
			(yyval.ocla) = add_modifier(PlainClause(OCREVERSEOFFLOAD), (yyvsp[0].type));
		}
#line 11867 "compiler/parser.c"
    break;

  case 974: /* unified_address_clause: OMP_UNIFIED_ADDRESS paren_dirnamemod_maybe  */
#line 5100 "../compiler/parser.y"
                {
			(yyval.ocla) = add_modifier(PlainClause(OCUNIFIEDADDRESS), (yyvsp[0].type));
		}
#line 11875 "compiler/parser.c"
    break;

  case 975: /* unified_shared_memory_clause: OMP_UNIFIED_SHARED_MEMORY paren_dirnamemod_maybe  */
#line 5107 "../compiler/parser.y"
                {
			(yyval.ocla) = add_modifier(PlainClause(OCUNIFIEDSHAREDMEMORY), (yyvsp[0].type));
		}
#line 11883 "compiler/parser.c"
    break;

  case 976: /* dynamic_allocators_clause: OMP_DYNAMIC_ALLOCATORS paren_dirnamemod_maybe  */
#line 5114 "../compiler/parser.y"
                {
			(yyval.ocla) = add_modifier(PlainClause(OCDYNAMICALLOCATORS), (yyvsp[0].type));
		}
#line 11891 "compiler/parser.c"
    break;

  case 977: /* defmemorder_type: OMP_SEQ_CST  */
#line 5121 "../compiler/parser.y"
                {
			(yyval.type) = OC_seq_cst;
		}
#line 11899 "compiler/parser.c"
    break;

  case 978: /* defmemorder_type: OMP_ACQ_REL  */
#line 5125 "../compiler/parser.y"
                {
			(yyval.type) = OC_acq_rel;
		}
#line 11907 "compiler/parser.c"
    break;

  case 979: /* defmemorder_type: OMP_RELAXED  */
#line 5129 "../compiler/parser.y"
                {
			(yyval.type) = OC_relaxed;
		}
#line 11915 "compiler/parser.c"
    break;

  case 980: /* defmemorder_type: error  */
#line 5133 "../compiler/parser.y"
                {
			fprintf(stderr, "\t(unknown memory order).\n");
			exit(1);
		}
#line 11924 "compiler/parser.c"
    break;

  case 981: /* atomic_default_mem_order_clause: OMP_ATOMIC_DEFAULT_MEM_ORDER '(' dirname_modifier_opt defmemorder_type ')'  */
#line 5141 "../compiler/parser.y"
    {
      (yyval.ocla) = add_modifier(AtomicDefaultMemOrderClause((yyvsp[-1].type)), (yyvsp[-2].type));
    }
#line 11932 "compiler/parser.c"
    break;

  case 982: /* flush_directive: PRAGMA_OMP OMP_FLUSH '\n'  */
#line 5148 "../compiler/parser.y"
    {
      (yyval.odir) = OmpFlushDirective(NULL, NULL);
    }
#line 11940 "compiler/parser.c"
    break;

  case 983: /* flush_directive: PRAGMA_OMP OMP_FLUSH memory_order_clause '\n'  */
#line 5152 "../compiler/parser.y"
    {
      if ((yyvsp[-1].ocla)->type == OCRELAXED)
        parse_error(1, "the 'relaxed' memory order clause is not allowed in "
                       "#flush directives.\n");
      (yyval.odir) = OmpFlushDirective(NULL, (yyvsp[-1].ocla));
    }
#line 11951 "compiler/parser.c"
    break;

  case 984: /* flush_directive: PRAGMA_OMP OMP_FLUSH flush_vars '\n'  */
#line 5159 "../compiler/parser.y"
    {
      (yyval.odir) = OmpFlushDirective((yyvsp[-1].decl), NULL);
    }
#line 11959 "compiler/parser.c"
    break;

  case 985: /* flush_directive: PRAGMA_OMP OMP_FLUSH flush_vars memory_order_clause '\n'  */
#line 5163 "../compiler/parser.y"
    {
      if ((yyvsp[-2].decl) != NULL)
        parse_error(1, "if a variable list is given, no memory order clauses "
                       "are allowed\n\tin a #flush directive.\n");
      if ((yyvsp[-1].ocla)->type == OCRELAXED)
        parse_error(1, "the 'relaxed' memory order clause is not allowed in "
                       "#flush directives.\n");
      (yyval.odir) = OmpFlushDirective(NULL, (yyvsp[-1].ocla));
    }
#line 11973 "compiler/parser.c"
    break;

  case 986: /* flush_vars: '(' ')'  */
#line 5176 "../compiler/parser.y"
    { 
      (yyval.decl) = NULL; 
    }
#line 11981 "compiler/parser.c"
    break;

  case 987: /* $@50: %empty  */
#line 5179 "../compiler/parser.y"
        { sc_pause_openmp(); }
#line 11987 "compiler/parser.c"
    break;

  case 988: /* flush_vars: '(' $@50 variable_list ')'  */
#line 5180 "../compiler/parser.y"
    {
      sc_start_openmp();
      (yyval.decl) = (yyvsp[-1].decl);
    }
#line 11996 "compiler/parser.c"
    break;

  case 989: /* ordered_construct: ordered_directive_full structured_block  */
#line 5188 "../compiler/parser.y"
    {
      (yyval.ocon) = OmpConstruct(DCORDERED, (yyvsp[-1].odir), (yyvsp[0].stmt));
    }
#line 12004 "compiler/parser.c"
    break;

  case 990: /* ordered_construct: ordered_directive_standalone  */
#line 5192 "../compiler/parser.y"
    {
      (yyval.ocon) = OmpConstruct(DCORDERED, (yyvsp[0].odir), NULL);
    }
#line 12012 "compiler/parser.c"
    break;

  case 991: /* ordered_directive_full: PRAGMA_OMP OMP_ORDERED ordered_clause_optseq_full '\n'  */
#line 5199 "../compiler/parser.y"
    {
      (yyval.odir) = OmpDirective(DCORDERED, (yyvsp[-1].ocla));
    }
#line 12020 "compiler/parser.c"
    break;

  case 992: /* ordered_directive_standalone: PRAGMA_OMP OMP_ORDERED OMP_DEPEND '(' dirname_modifier_opt OMP_SOURCE ')' '\n'  */
#line 5207 "../compiler/parser.y"
    {
      (yyval.odir) = OmpDirective(DCORDERED, add_modifier(DependClause(OC_source,NULL), (yyvsp[-3].type)));
    }
#line 12028 "compiler/parser.c"
    break;

  case 993: /* ordered_directive_standalone: PRAGMA_OMP OMP_ORDERED ordered_clause_optseq_standalone '\n'  */
#line 5211 "../compiler/parser.y"
    {
      (yyval.odir) = OmpDirective(DCORDERED, (yyvsp[-1].ocla));
    }
#line 12036 "compiler/parser.c"
    break;

  case 994: /* ordered_clause_optseq_full: %empty  */
#line 5219 "../compiler/parser.y"
    {
      (yyval.ocla) = NULL;
    }
#line 12044 "compiler/parser.c"
    break;

  case 995: /* ordered_clause_optseq_full: ordered_clause_optseq_full ordered_clause_type_full  */
#line 5223 "../compiler/parser.y"
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
    }
#line 12052 "compiler/parser.c"
    break;

  case 996: /* ordered_clause_optseq_full: ordered_clause_optseq_full ',' ordered_clause_type_full  */
#line 5227 "../compiler/parser.y"
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
    }
#line 12060 "compiler/parser.c"
    break;

  case 997: /* ordered_clause_type_full: OMP_THREADS paren_dirnamemod_maybe  */
#line 5235 "../compiler/parser.y"
    { 
      (yyval.ocla) = add_modifier(PlainClause(OCTHREADS), (yyvsp[0].type)); 
    }
#line 12068 "compiler/parser.c"
    break;

  case 998: /* ordered_clause_type_full: OMP_SIMD paren_dirnamemod_maybe  */
#line 5238 "../compiler/parser.y"
                                    { /* TODO */ }
#line 12074 "compiler/parser.c"
    break;

  case 999: /* ordered_clause_optseq_standalone: ordered_clause_depend_sink  */
#line 5243 "../compiler/parser.y"
                               { (yyval.ocla) = (yyvsp[0].ocla); }
#line 12080 "compiler/parser.c"
    break;

  case 1000: /* ordered_clause_optseq_standalone: ordered_clause_optseq_standalone ordered_clause_depend_sink  */
#line 5245 "../compiler/parser.y"
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-1].ocla), (yyvsp[0].ocla));
    }
#line 12088 "compiler/parser.c"
    break;

  case 1001: /* ordered_clause_optseq_standalone: ordered_clause_optseq_standalone ',' ordered_clause_depend_sink  */
#line 5249 "../compiler/parser.y"
    {
      (yyval.ocla) = OmpClauseList((yyvsp[-2].ocla), (yyvsp[0].ocla));
    }
#line 12096 "compiler/parser.c"
    break;

  case 1002: /* ordered_clause_depend_sink: OMP_DEPEND '(' OMP_SINK ':' sink_vec ')'  */
#line 5258 "../compiler/parser.y"
    {
      (yyval.ocla) = DependClause(OC_sink, NULL);
      (yyval.ocla)->u.expr = (yyvsp[-1].expr);
    }
#line 12105 "compiler/parser.c"
    break;

  case 1003: /* ordered_clause_depend_sink: OMP_DEPEND '(' dirname_modifier ',' OMP_SINK ':' sink_vec ')'  */
#line 5263 "../compiler/parser.y"
    {
      (yyval.ocla) = add_modifier(DependClause(OC_sink, NULL), (yyvsp[-5].type));
      (yyval.ocla)->u.expr = (yyvsp[-1].expr);
    }
#line 12114 "compiler/parser.c"
    break;

  case 1004: /* ordered_clause_depend_sink: OMP_DEPEND '(' OMP_SINK ',' dirname_modifier ':' sink_vec ')'  */
#line 5268 "../compiler/parser.y"
    {
      (yyval.ocla) = add_modifier(DependClause(OC_sink, NULL), (yyvsp[-3].type));
      (yyval.ocla)->u.expr = (yyvsp[-1].expr);
    }
#line 12123 "compiler/parser.c"
    break;

  case 1005: /* sink_vec: sink_vec_elem  */
#line 5275 "../compiler/parser.y"
                    { (yyval.expr) = (yyvsp[0].expr); }
#line 12129 "compiler/parser.c"
    break;

  case 1006: /* sink_vec: sink_vec_elem ',' sink_vec  */
#line 5277 "../compiler/parser.y"
    { 
      (yyval.expr) = CommaList((yyvsp[-2].expr), (yyvsp[0].expr));
    }
#line 12137 "compiler/parser.c"
    break;

  case 1007: /* sink_vec_elem: IDENTIFIER  */
#line 5284 "../compiler/parser.y"
    {
      if (checkDecls)
        check_uknown_var((yyvsp[0].name));
      (yyval.expr) = BinaryOperator(BOP_add, IdentName((yyvsp[0].name)), ZeroExpr());
    }
#line 12147 "compiler/parser.c"
    break;

  case 1008: /* sink_vec_elem: IDENTIFIER '+' multiplicative_expression  */
#line 5290 "../compiler/parser.y"
    {
      if (checkDecls)
        check_uknown_var((yyvsp[-2].name));
      (yyval.expr) = BinaryOperator(BOP_add, IdentName((yyvsp[-2].name)), (yyvsp[0].expr));
    }
#line 12157 "compiler/parser.c"
    break;

  case 1009: /* sink_vec_elem: IDENTIFIER '-' multiplicative_expression  */
#line 5296 "../compiler/parser.y"
    {
      if (checkDecls)
        check_uknown_var((yyvsp[-2].name));
      (yyval.expr) = BinaryOperator(BOP_sub, IdentName((yyvsp[-2].name)), (yyvsp[0].expr));
    }
#line 12167 "compiler/parser.c"
    break;

  case 1010: /* cancel_directive: PRAGMA_OMP OMP_CANCEL construct_type_clause '\n'  */
#line 5306 "../compiler/parser.y"
    {
      (yyval.odir) = OmpDirective(DCCANCEL, (yyvsp[-1].ocla));
    }
#line 12175 "compiler/parser.c"
    break;

  case 1011: /* cancel_directive: PRAGMA_OMP OMP_CANCEL construct_type_clause if_clause '\n'  */
#line 5310 "../compiler/parser.y"
    {
      (yyval.odir) = OmpDirective(DCCANCEL, OmpClauseList((yyvsp[-2].ocla), (yyvsp[-1].ocla)));
    }
#line 12183 "compiler/parser.c"
    break;

  case 1012: /* cancel_directive: PRAGMA_OMP OMP_CANCEL construct_type_clause ',' if_clause '\n'  */
#line 5314 "../compiler/parser.y"
    {
      (yyval.odir) = OmpDirective(DCCANCEL, OmpClauseList((yyvsp[-3].ocla), (yyvsp[-1].ocla)));
    }
#line 12191 "compiler/parser.c"
    break;

  case 1013: /* construct_type_clause: OMP_PARALLEL  */
#line 5321 "../compiler/parser.y"
    {
      (yyval.ocla) = PlainClause(OCPARALLEL);
    }
#line 12199 "compiler/parser.c"
    break;

  case 1014: /* construct_type_clause: OMP_SECTIONS  */
#line 5325 "../compiler/parser.y"
    {
      (yyval.ocla) = PlainClause(OCSECTIONS);
    }
#line 12207 "compiler/parser.c"
    break;

  case 1015: /* construct_type_clause: OMP_FOR  */
#line 5329 "../compiler/parser.y"
    {
      (yyval.ocla) = PlainClause(OCFOR);
    }
#line 12215 "compiler/parser.c"
    break;

  case 1016: /* construct_type_clause: OMP_TASKGROUP  */
#line 5333 "../compiler/parser.y"
    {
      (yyval.ocla) = PlainClause(OCTASKGROUP);
    }
#line 12223 "compiler/parser.c"
    break;

  case 1017: /* cancellation_point_directive: PRAGMA_OMP OMP_CANCELLATIONPOINT construct_type_clause '\n'  */
#line 5341 "../compiler/parser.y"
    {
      (yyval.odir) = OmpDirective(DCCANCELLATIONPOINT, (yyvsp[-1].ocla));
    }
#line 12231 "compiler/parser.c"
    break;

  case 1018: /* $@51: %empty  */
#line 5347 "../compiler/parser.y"
                                 { sc_pause_openmp(); }
#line 12237 "compiler/parser.c"
    break;

  case 1019: /* $@52: %empty  */
#line 5348 "../compiler/parser.y"
                                                     { sc_start_openmp(); }
#line 12243 "compiler/parser.c"
    break;

  case 1020: /* threadprivate_directive: PRAGMA_OMP OMP_THREADPRIVATE $@51 '(' thrprv_variable_list ')' $@52 '\n'  */
#line 5349 "../compiler/parser.y"
    {
      (yyval.odir) = OmpThreadprivateDirective((yyvsp[-3].decl));
    }
#line 12251 "compiler/parser.c"
    break;

  case 1021: /* thrprv_variable_list: IDENTIFIER  */
#line 5361 "../compiler/parser.y"
    {
      if (checkDecls)
      {
        stentry e = symtab_get(stab, Symbol((yyvsp[0].name)), IDNAME);
        if (e == NULL)
          parse_error(-1, "unknown identifier `%s'.\n", (yyvsp[0].name));
        if (e->scopelevel != stab->scopelevel)
          parse_error(-1, "threadprivate directive appears at different "
                          "scope level\nfrom the one `%s' was declared.\n", (yyvsp[0].name));
        if (stab->scopelevel > 0)    /* Don't care for globals */
          if (speclist_getspec(e->spec, STCLASSSPEC, SPEC_static) == NULL)
            parse_error(-1, "threadprivate variable `%s' does not have static "
                            "storage type.\n", (yyvsp[0].name));
        e->isthrpriv = true;   /* Mark */
      }
      (yyval.decl) = IdentifierDecl( Symbol((yyvsp[0].name)) );
    }
#line 12273 "compiler/parser.c"
    break;

  case 1022: /* thrprv_variable_list: thrprv_variable_list ',' IDENTIFIER  */
#line 5379 "../compiler/parser.y"
    {
      if (checkDecls)
      {
        stentry e = symtab_get(stab, Symbol((yyvsp[0].name)), IDNAME);
        if (e == NULL)
          parse_error(-1, "unknown identifier `%s'.\n", (yyvsp[0].name));
        if (e->scopelevel != stab->scopelevel)
          parse_error(-1, "threadprivate directive appears at different "
                          "scope level\nfrom the one `%s' was declared.\n", (yyvsp[0].name));
        if (stab->scopelevel > 0)    /* Don't care for globals */
          if (speclist_getspec(e->spec, STCLASSSPEC, SPEC_static) == NULL)
            parse_error(-1, "threadprivate variable `%s' does not have static "
                            "storage type.\n", (yyvsp[0].name));
        e->isthrpriv = true;   /* Mark */
      }
      (yyval.decl) = IdList((yyvsp[-2].decl), IdentifierDecl( Symbol((yyvsp[0].name)) ));
    }
#line 12295 "compiler/parser.c"
    break;

  case 1023: /* $@53: %empty  */
#line 5401 "../compiler/parser.y"
                                           { sc_pause_openmp(); }
#line 12301 "compiler/parser.c"
    break;

  case 1024: /* $@54: %empty  */
#line 5402 "../compiler/parser.y"
                   { sc_start_openmp(); }
#line 12307 "compiler/parser.c"
    break;

  case 1025: /* declare_reduction_directive: PRAGMA_OMP OMP_DECLARE OMP_REDUCTION '(' reduction_identifier ':' reduction_type_list ':' $@53 expression ')' $@54 initializer_clause_opt '\n'  */
#line 5403 "../compiler/parser.y"
    {
      //$$ = TODO
    }
#line 12315 "compiler/parser.c"
    break;

  case 1026: /* reduction_identifier: IDENTIFIER  */
#line 5410 "../compiler/parser.y"
    {
      parse_error(1, "user-defined reductions are not implemented yet.\n");
      //$$ = OC_identifier TODO
      //Symbol($2);  TODO
    }
#line 12325 "compiler/parser.c"
    break;

  case 1027: /* reduction_identifier: '+'  */
#line 5415 "../compiler/parser.y"
        { (yyval.type) = OC_plus; }
#line 12331 "compiler/parser.c"
    break;

  case 1028: /* reduction_identifier: '*'  */
#line 5416 "../compiler/parser.y"
        { (yyval.type) = OC_times; }
#line 12337 "compiler/parser.c"
    break;

  case 1029: /* reduction_identifier: '-'  */
#line 5417 "../compiler/parser.y"
        { (yyval.type) = OC_minus; }
#line 12343 "compiler/parser.c"
    break;

  case 1030: /* reduction_identifier: '&'  */
#line 5418 "../compiler/parser.y"
        { (yyval.type) = OC_band; }
#line 12349 "compiler/parser.c"
    break;

  case 1031: /* reduction_identifier: '^'  */
#line 5419 "../compiler/parser.y"
        { (yyval.type) = OC_xor; }
#line 12355 "compiler/parser.c"
    break;

  case 1032: /* reduction_identifier: '|'  */
#line 5420 "../compiler/parser.y"
        { (yyval.type) = OC_bor; }
#line 12361 "compiler/parser.c"
    break;

  case 1033: /* reduction_identifier: AND_OP  */
#line 5421 "../compiler/parser.y"
           { (yyval.type) = OC_land; }
#line 12367 "compiler/parser.c"
    break;

  case 1034: /* reduction_identifier: OR_OP  */
#line 5422 "../compiler/parser.y"
          { (yyval.type) = OC_lor; }
#line 12373 "compiler/parser.c"
    break;

  case 1035: /* reduction_identifier: OMP_MIN  */
#line 5423 "../compiler/parser.y"
            { (yyval.type) = OC_min; }
#line 12379 "compiler/parser.c"
    break;

  case 1036: /* reduction_identifier: OMP_MAX  */
#line 5424 "../compiler/parser.y"
            { (yyval.type) = OC_max; }
#line 12385 "compiler/parser.c"
    break;

  case 1037: /* reduction_type_list: type_specifier  */
#line 5429 "../compiler/parser.y"
    {
      //TODO
    }
#line 12393 "compiler/parser.c"
    break;

  case 1038: /* reduction_type_list: reduction_type_list ',' type_specifier  */
#line 5433 "../compiler/parser.y"
    {
      //TODO
    }
#line 12401 "compiler/parser.c"
    break;

  case 1039: /* initializer_clause_opt: %empty  */
#line 5440 "../compiler/parser.y"
    {
      (yyval.ocla) = NULL;
    }
#line 12409 "compiler/parser.c"
    break;

  case 1040: /* initializer_clause_opt: OMP_INITIALIZER '(' IDENTIFIER '=' conditional_expression ')'  */
#line 5444 "../compiler/parser.y"
    {
        //TODO must check if identifier is omp_priv and that conditional
        //expression contains only omp_priv and omp_orig variables
    }
#line 12418 "compiler/parser.c"
    break;

  case 1041: /* initializer_clause_opt: OMP_INITIALIZER '(' IDENTIFIER '(' argument_expression_list ')' ')'  */
#line 5449 "../compiler/parser.y"
    {
      //TODO in argument_expression_list one of the variables must be &omp_priv
      // TODO check ox_funccall_expression
      //$$ = strcmp($1, "main") ?
      //       FunctionCall(IdentName($1), $3) :
      //       FunctionCall(IdentName(MAIN_NEWNAME), $3);
    }
#line 12430 "compiler/parser.c"
    break;

  case 1042: /* data_default_clause: OMP_DEFAULT '(' dirname_modifier_opt OMP_SHARED ')'  */
#line 5462 "../compiler/parser.y"
    {
      (yyval.ocla) = add_modifier(DefaultClause(OC_defshared), (yyvsp[-2].type));
    }
#line 12438 "compiler/parser.c"
    break;

  case 1043: /* data_default_clause: OMP_DEFAULT '(' dirname_modifier_opt OMP_NONE ')'  */
#line 5466 "../compiler/parser.y"
    {
      (yyval.ocla) = add_modifier(DefaultClause(OC_defnone), (yyvsp[-2].type)); 
    }
#line 12446 "compiler/parser.c"
    break;

  case 1044: /* data_default_clause: OMP_DEFAULT '(' dirname_modifier_opt OMP_AUTO ')'  */
#line 5471 "../compiler/parser.y"
    {
      (yyval.ocla) = add_modifier(DefaultClause(OC_auto), (yyvsp[-2].type)); 
    }
#line 12454 "compiler/parser.c"
    break;

  case 1045: /* $@55: %empty  */
#line 5477 "../compiler/parser.y"
                { sc_pause_openmp(); }
#line 12460 "compiler/parser.c"
    break;

  case 1046: /* data_privatization_clause: OMP_PRIVATE $@55 paren_dirnamemod_and_varlist  */
#line 5478 "../compiler/parser.y"
    {
      sc_start_openmp();
      (yyvsp[0].ocla)->type = OCPRIVATE;
      (yyval.ocla) = (yyvsp[0].ocla);
		}
#line 12470 "compiler/parser.c"
    break;

  case 1047: /* $@56: %empty  */
#line 5486 "../compiler/parser.y"
                     { sc_pause_openmp(); }
#line 12476 "compiler/parser.c"
    break;

  case 1048: /* data_privatization_in_clause: OMP_FIRSTPRIVATE $@56 paren_dirnamemod_and_varlist  */
#line 5487 "../compiler/parser.y"
    {
      sc_start_openmp();
      (yyvsp[0].ocla)->type = OCFIRSTPRIVATE;
      (yyval.ocla) = (yyvsp[0].ocla);
		}
#line 12486 "compiler/parser.c"
    break;

  case 1049: /* $@57: %empty  */
#line 5495 "../compiler/parser.y"
                    { sc_pause_openmp(); }
#line 12492 "compiler/parser.c"
    break;

  case 1050: /* data_privatization_out_clause: OMP_LASTPRIVATE $@57 paren_dirnamemod_and_varlist  */
#line 5496 "../compiler/parser.y"
    {
      sc_start_openmp();
      (yyvsp[0].ocla)->type = OCLASTPRIVATE; 
      (yyval.ocla) = (yyvsp[0].ocla);
		}
#line 12502 "compiler/parser.c"
    break;

  case 1051: /* $@58: %empty  */
#line 5504 "../compiler/parser.y"
               { sc_pause_openmp(); }
#line 12508 "compiler/parser.c"
    break;

  case 1052: /* data_sharing_clause: OMP_SHARED $@58 paren_dirnamemod_and_varlist  */
#line 5505 "../compiler/parser.y"
    {
      sc_start_openmp();
      (yyvsp[0].ocla)->type = OCSHARED;
      (yyval.ocla) = (yyvsp[0].ocla);
		}
#line 12518 "compiler/parser.c"
    break;

  case 1053: /* $@59: %empty  */
#line 5514 "../compiler/parser.y"
                                                  { sc_pause_openmp(); }
#line 12524 "compiler/parser.c"
    break;

  case 1054: /* data_reduction_clause: OMP_REDUCTION '(' data_reduction_modifier_seq $@59 ':' variable_array_section_list ')'  */
#line 5516 "../compiler/parser.y"
    {
      int opid;
      
      sc_start_openmp();
      opid = check_data_reduction_modifiers((yyvsp[-4].ivec));
      (yyval.ocla) = ReductionClause(opid, (yyvsp[-1].oxli));
      (yyval.ocla)->modifs = (yyvsp[-4].ivec);
    }
#line 12537 "compiler/parser.c"
    break;

  case 1055: /* data_reduction_modifier_seq: data_reduction_modifier  */
#line 5528 "../compiler/parser.y"
    {
      (yyval.ivec) = intvec_new_withelems(1, (yyvsp[0].type));
    }
#line 12545 "compiler/parser.c"
    break;

  case 1056: /* data_reduction_modifier_seq: data_reduction_modifier_seq ',' data_reduction_modifier  */
#line 5532 "../compiler/parser.y"
    {
      (yyval.ivec) = intvec_append((yyvsp[-2].ivec), 1, (yyvsp[0].type));
    }
#line 12553 "compiler/parser.c"
    break;

  case 1057: /* data_reduction_modifier: reduction_identifier  */
#line 5538 "../compiler/parser.y"
                         { (yyval.type) = ReductionidModifier((yyvsp[0].type)); }
#line 12559 "compiler/parser.c"
    break;

  case 1058: /* data_reduction_modifier: dirname_modifier  */
#line 5540 "../compiler/parser.y"
    { 
      (yyval.type) = (UnpackModifier((yyvsp[0].type)) == DCTASK) ? OCM_task : (yyvsp[0].type); 
    }
#line 12567 "compiler/parser.c"
    break;

  case 1059: /* data_reduction_modifier: OMP_DEFAULT  */
#line 5543 "../compiler/parser.y"
                  { (yyval.type) = OCM_default; }
#line 12573 "compiler/parser.c"
    break;

  case 1060: /* data_reduction_modifier: OMP_INSCAN  */
#line 5545 "../compiler/parser.y"
                  { (yyval.type) = OCM_inscan; }
#line 12579 "compiler/parser.c"
    break;

  case 1061: /* $@60: %empty  */
#line 5550 "../compiler/parser.y"
               { sc_pause_openmp(); }
#line 12585 "compiler/parser.c"
    break;

  case 1062: /* if_clause: OMP_IF '(' $@60 expression ')'  */
#line 5551 "../compiler/parser.y"
    {
      sc_start_openmp();
      (yyval.ocla) = IfClause((yyvsp[-1].expr));
    }
#line 12594 "compiler/parser.c"
    break;

  case 1063: /* $@61: %empty  */
#line 5556 "../compiler/parser.y"
                                    { sc_pause_openmp(); }
#line 12600 "compiler/parser.c"
    break;

  case 1064: /* if_clause: OMP_IF '(' dirname_modifier ':' $@61 expression ')'  */
#line 5557 "../compiler/parser.y"
    {
      sc_start_openmp();
      (yyval.ocla) = IfClause((yyvsp[-1].expr));
      /* TODO: use dirname_modifier */
      (yyval.ocla)->modifs = intvec_new_withelems(1, (yyvsp[-4].type));
    }
#line 12611 "compiler/parser.c"
    break;

  case 1065: /* $@62: %empty  */
#line 5567 "../compiler/parser.y"
                 { sc_pause_openmp(); }
#line 12617 "compiler/parser.c"
    break;

  case 1066: /* collapse_clause: OMP_COLLAPSE $@62 paren_dirnamemod_and_expr  */
#line 5568 "../compiler/parser.y"
    {
      int n = 0, er = 0;
      sc_start_openmp();
      if (xar_expr_is_constant((yyvsp[0].expr)->left))
      {
        n = xar_calc_int_expr((yyvsp[0].expr)->left, &er);
        if (er) n = 0;
      }
      if (n <= 0)
        parse_error(1, "invalid number in collapse() clause.\n");
      (yyval.ocla) = add_modifier(CollapseClause(n), (yyvsp[0].expr)->opid);
      free((yyvsp[0].expr));
    }
#line 12635 "compiler/parser.c"
    break;

  case 1067: /* variable_list: IDENTIFIER  */
#line 5585 "../compiler/parser.y"
    {
      if (checkDecls)
        if (symtab_get(stab, Symbol((yyvsp[0].name)), IDNAME) == NULL)
          parse_error(-1, "unknown identifier `%s'.\n", (yyvsp[0].name));
      (yyval.decl) = IdentifierDecl( Symbol((yyvsp[0].name)) );
    }
#line 12646 "compiler/parser.c"
    break;

  case 1068: /* variable_list: variable_list ',' IDENTIFIER  */
#line 5592 "../compiler/parser.y"
    {
      if (checkDecls)
        if (symtab_get(stab, Symbol((yyvsp[0].name)), IDNAME) == NULL)
          parse_error(-1, "unknown identifier `%s'.\n", (yyvsp[0].name));
      (yyval.decl) = IdList((yyvsp[-2].decl), IdentifierDecl( Symbol((yyvsp[0].name)) ));
    }
#line 12657 "compiler/parser.c"
    break;

  case 1069: /* variable_array_section_list: varid_or_array_section  */
#line 5601 "../compiler/parser.y"
                           { (yyval.oxli) = (yyvsp[0].oxli); }
#line 12663 "compiler/parser.c"
    break;

  case 1070: /* variable_array_section_list: variable_array_section_list ',' varid_or_array_section  */
#line 5603 "../compiler/parser.y"
    {
      ompxli l = (yyvsp[-2].oxli);
      
      for (; l->next; l = l->next) ;  /* Till the end */
      l->next = (yyvsp[0].oxli);
      (yyval.oxli) = (yyvsp[-2].oxli);
    }
#line 12675 "compiler/parser.c"
    break;

  case 1071: /* varid_or_array_section: IDENTIFIER  */
#line 5614 "../compiler/parser.y"
    {
      if (checkDecls)
        if (symtab_get(stab, Symbol((yyvsp[0].name)), IDNAME) == NULL)
          parse_error(-1, "unknown identifier `%s'.\n", (yyvsp[0].name));
      (yyval.oxli) = PlainXLI( Symbol((yyvsp[0].name)) );
    }
#line 12686 "compiler/parser.c"
    break;

  case 1072: /* varid_or_array_section: IDENTIFIER array_section_slice_list  */
#line 5621 "../compiler/parser.y"
    {
      if (checkDecls)
        if (symtab_get(stab, Symbol((yyvsp[-1].name)), IDNAME) == NULL)
          parse_error(-1, "unknown identifier `%s'.\n", (yyvsp[-1].name));
      (yyval.oxli) = ArraySection( Symbol((yyvsp[-1].name)), (yyvsp[0].oasd) );
    }
#line 12697 "compiler/parser.c"
    break;

  case 1073: /* funcname_variable_array_section_list: funcvarid_or_array_section  */
#line 5634 "../compiler/parser.y"
                               { (yyval.oxli) = (yyvsp[0].oxli); }
#line 12703 "compiler/parser.c"
    break;

  case 1074: /* funcname_variable_array_section_list: funcname_variable_array_section_list ',' funcvarid_or_array_section  */
#line 5636 "../compiler/parser.y"
    {
      ompxli l = (yyvsp[-2].oxli);
      
      for (; l->next; l = l->next) ;  /* Till the end */
      l->next = (yyvsp[0].oxli);
      (yyval.oxli) = (yyvsp[-2].oxli);
    }
#line 12715 "compiler/parser.c"
    break;

  case 1075: /* funcvarid_or_array_section: IDENTIFIER  */
#line 5647 "../compiler/parser.y"
    {
      /* No check for known identifiers since constuct can be anywhere */
      (yyval.oxli) = PlainXLI( Symbol((yyvsp[0].name)) );
    }
#line 12724 "compiler/parser.c"
    break;

  case 1076: /* funcvarid_or_array_section: IDENTIFIER array_section_slice_list  */
#line 5652 "../compiler/parser.y"
    {
      /* No check for known identifiers since constuct can be anywhere */
      (yyval.oxli) = ArraySection( Symbol((yyvsp[-1].name)), (yyvsp[0].oasd) );
    }
#line 12733 "compiler/parser.c"
    break;

  case 1077: /* $@63: %empty  */
#line 5659 "../compiler/parser.y"
                                 { sc_pause_openmp(); }
#line 12739 "compiler/parser.c"
    break;

  case 1078: /* array_section_slice_list: array_section_slice_list '[' $@63 array_section_slice ']'  */
#line 5660 "../compiler/parser.y"
    {
      omparrdim d = (yyvsp[-4].oasd);
      
      sc_start_openmp();
      for (; d->next; d = d->next) ;  /* Till the end */
      d->next = (yyvsp[-1].oasd);
      (yyval.oasd) = (yyvsp[-4].oasd);
    }
#line 12752 "compiler/parser.c"
    break;

  case 1079: /* $@64: %empty  */
#line 5668 "../compiler/parser.y"
        { sc_pause_openmp(); }
#line 12758 "compiler/parser.c"
    break;

  case 1080: /* array_section_slice_list: '[' $@64 array_section_slice ']'  */
#line 5669 "../compiler/parser.y"
    {
      sc_start_openmp();
      (yyval.oasd) = (yyvsp[-1].oasd);
    }
#line 12767 "compiler/parser.c"
    break;

  case 1081: /* array_section_slice: expression ':' expression  */
#line 5676 "../compiler/parser.y"
                              { (yyval.oasd) = OmpArrDim((yyvsp[-2].expr), (yyvsp[0].expr)); }
#line 12773 "compiler/parser.c"
    break;

  case 1082: /* array_section_slice: expression ':'  */
#line 5677 "../compiler/parser.y"
                              { (yyval.oasd) = OmpArrDim((yyvsp[-1].expr), NULL); }
#line 12779 "compiler/parser.c"
    break;

  case 1083: /* array_section_slice: expression  */
#line 5678 "../compiler/parser.y"
                              { (yyval.oasd) = OmpArrDim((yyvsp[0].expr), OneExpr()); }
#line 12785 "compiler/parser.c"
    break;

  case 1084: /* array_section_slice: ':' expression  */
#line 5679 "../compiler/parser.y"
                              { (yyval.oasd) = OmpArrDim(ZeroExpr(), (yyvsp[0].expr)); }
#line 12791 "compiler/parser.c"
    break;

  case 1085: /* array_section_slice: ':'  */
#line 5680 "../compiler/parser.y"
                              { (yyval.oasd) = OmpArrDim(ZeroExpr(), NULL); }
#line 12797 "compiler/parser.c"
    break;

  case 1086: /* procbind_clause: OMP_PROCBIND '(' dirname_modifier_opt procbind_policy ')'  */
#line 5685 "../compiler/parser.y"
    { 
      (yyval.ocla) = add_modifier(ProcBindClause((yyvsp[-1].type)), (yyvsp[-2].type)); 
    }
#line 12805 "compiler/parser.c"
    break;

  case 1087: /* procbind_policy: OMP_PRIMARY  */
#line 5691 "../compiler/parser.y"
                { (yyval.type) = OC_bindprimary; }
#line 12811 "compiler/parser.c"
    break;

  case 1088: /* procbind_policy: OMP_MASTER  */
#line 5692 "../compiler/parser.y"
                { (yyval.type) = OC_bindprimary; }
#line 12817 "compiler/parser.c"
    break;

  case 1089: /* procbind_policy: OMP_CLOSE  */
#line 5693 "../compiler/parser.y"
                { (yyval.type) = OC_bindclose; }
#line 12823 "compiler/parser.c"
    break;

  case 1090: /* procbind_policy: OMP_SPREAD  */
#line 5694 "../compiler/parser.y"
                { (yyval.type) = OC_bindspread; }
#line 12829 "compiler/parser.c"
    break;

  case 1091: /* procbind_policy: error  */
#line 5697 "../compiler/parser.y"
                {
			parse_error(1, "unknown proc_bind policy.\n");
			(yyval.type) = OC_bindprimary;  /* Default */
		}
#line 12838 "compiler/parser.c"
    break;

  case 1092: /* ompix_directive: ox_tasksync_directive  */
#line 5717 "../compiler/parser.y"
    {
      (yyval.xcon) = OmpixConstruct(OX_DCTASKSYNC, (yyvsp[0].xdir), NULL);
    }
#line 12846 "compiler/parser.c"
    break;

  case 1093: /* ompix_directive: ox_taskschedule_directive  */
#line 5721 "../compiler/parser.y"
    {
      (yyval.xcon) = OmpixConstruct(OX_DCTASKSCHEDULE, (yyvsp[0].xdir), NULL);
    }
#line 12854 "compiler/parser.c"
    break;

  case 1094: /* ox_tasksync_directive: PRAGMA_OMPIX OMPIX_TASKSYNC '\n'  */
#line 5728 "../compiler/parser.y"
    {
      (yyval.xdir) = OmpixDirective(OX_DCTASKSYNC, NULL);
    }
#line 12862 "compiler/parser.c"
    break;

  case 1095: /* $@65: %empty  */
#line 5735 "../compiler/parser.y"
    {
      scope_start(stab);
    }
#line 12870 "compiler/parser.c"
    break;

  case 1096: /* ox_taskschedule_directive: PRAGMA_OMPIX OMPIX_TASKSCHEDULE $@65 ox_taskschedule_clause_optseq '\n'  */
#line 5739 "../compiler/parser.y"
    {
      scope_end(stab);
      (yyval.xdir) = OmpixDirective(OX_DCTASKSCHEDULE, (yyvsp[-1].xcla));
    }
#line 12879 "compiler/parser.c"
    break;

  case 1097: /* ox_taskschedule_clause_optseq: %empty  */
#line 5747 "../compiler/parser.y"
    {
      (yyval.xcla) = NULL;
    }
#line 12887 "compiler/parser.c"
    break;

  case 1098: /* ox_taskschedule_clause_optseq: ox_taskschedule_clause_optseq ox_taskschedule_clause  */
#line 5751 "../compiler/parser.y"
    {
      (yyval.xcla) = OmpixClauseList((yyvsp[-1].xcla), (yyvsp[0].xcla));
    }
#line 12895 "compiler/parser.c"
    break;

  case 1099: /* ox_taskschedule_clause_optseq: ox_taskschedule_clause_optseq ',' ox_taskschedule_clause  */
#line 5755 "../compiler/parser.y"
    {
      (yyval.xcla) = OmpixClauseList((yyvsp[-2].xcla), (yyvsp[0].xcla));
    }
#line 12903 "compiler/parser.c"
    break;

  case 1100: /* ox_taskschedule_clause: OMPIX_STRIDE '(' assignment_expression ')'  */
#line 5762 "../compiler/parser.y"
    {
      (yyval.xcla) = OmpixStrideClause((yyvsp[-1].expr));
    }
#line 12911 "compiler/parser.c"
    break;

  case 1101: /* ox_taskschedule_clause: OMPIX_START '(' assignment_expression ')'  */
#line 5766 "../compiler/parser.y"
    {
      (yyval.xcla) = OmpixStartClause((yyvsp[-1].expr));
    }
#line 12919 "compiler/parser.c"
    break;

  case 1102: /* ox_taskschedule_clause: OMPIX_SCOPE '(' ox_scope_spec ')'  */
#line 5770 "../compiler/parser.y"
    {
      (yyval.xcla) = OmpixScopeClause((yyvsp[-1].type));
    }
#line 12927 "compiler/parser.c"
    break;

  case 1103: /* ox_taskschedule_clause: OMPIX_TIED  */
#line 5774 "../compiler/parser.y"
    {
      (yyval.xcla) = OmpixPlainClause(OX_OCTIED);
    }
#line 12935 "compiler/parser.c"
    break;

  case 1104: /* ox_taskschedule_clause: OMP_UNTIED  */
#line 5778 "../compiler/parser.y"
    {
      (yyval.xcla) = OmpixPlainClause(OX_OCUNTIED);
    }
#line 12943 "compiler/parser.c"
    break;

  case 1105: /* ox_scope_spec: OMPIX_NODES  */
#line 5785 "../compiler/parser.y"
    {
      (yyval.type) = OX_SCOPE_NODES;
    }
#line 12951 "compiler/parser.c"
    break;

  case 1106: /* ox_scope_spec: OMPIX_WORKERS  */
#line 5789 "../compiler/parser.y"
    {
      (yyval.type) = OX_SCOPE_WGLOBAL;
    }
#line 12959 "compiler/parser.c"
    break;

  case 1107: /* ox_scope_spec: OMPIX_WORKERS ',' OMPIX_GLOBAL  */
#line 5793 "../compiler/parser.y"
    {
      (yyval.type) = OX_SCOPE_WGLOBAL;
    }
#line 12967 "compiler/parser.c"
    break;

  case 1108: /* ox_scope_spec: OMPIX_WORKERS ',' OMPIX_LOCAL  */
#line 5797 "../compiler/parser.y"
    {
      (yyval.type) = OX_SCOPE_WLOCAL;
    }
#line 12975 "compiler/parser.c"
    break;

  case 1109: /* ompix_construct: ox_taskdef_construct  */
#line 5803 "../compiler/parser.y"
                         { (yyval.xcon) = (yyvsp[0].xcon); }
#line 12981 "compiler/parser.c"
    break;

  case 1110: /* ompix_construct: ox_task_construct  */
#line 5804 "../compiler/parser.y"
                      { (yyval.xcon) = (yyvsp[0].xcon); }
#line 12987 "compiler/parser.c"
    break;

  case 1111: /* ompix_construct: ox_procextern_construct  */
#line 5805 "../compiler/parser.y"
                            { (yyval.xcon) = (yyvsp[0].xcon); }
#line 12993 "compiler/parser.c"
    break;

  case 1112: /* ompix_construct: ox_tag_construct  */
#line 5806 "../compiler/parser.y"
                     { (yyval.xcon) = (yyvsp[0].xcon); }
#line 12999 "compiler/parser.c"
    break;

  case 1113: /* $@66: %empty  */
#line 5813 "../compiler/parser.y"
    {
      /* Should put the name of the callback function in the stab, too
      if (symtab_get(stab, decl_getidentifier_symbol($2->u.declaration.decl),
            FUNCNAME) == NULL)
        symtab_put(stab, decl_getidentifier_symbol($2->u.declaration.spec),
            FUNCNAME);
      */
      scope_start(stab);   /* re-declare the arguments of the task function */
      ast_declare_function_params((yyvsp[0].stmt)->u.declaration.decl);
    }
#line 13014 "compiler/parser.c"
    break;

  case 1114: /* ox_taskdef_construct: ox_taskdef_directive normal_function_definition $@66 '<' compound_statement '>'  */
#line 5824 "../compiler/parser.y"
    {
      scope_end(stab);
      (yyval.xcon) = OmpixTaskdef((yyvsp[-5].xdir), (yyvsp[-4].stmt), (yyvsp[-1].stmt));
      (yyval.xcon)->l = (yyvsp[-5].xdir)->l;
    }
#line 13024 "compiler/parser.c"
    break;

  case 1115: /* ox_taskdef_construct: ox_taskdef_directive normal_function_definition  */
#line 5830 "../compiler/parser.y"
    {
      (yyval.xcon) = OmpixTaskdef((yyvsp[-1].xdir), (yyvsp[0].stmt), NULL);
      (yyval.xcon)->l = (yyvsp[-1].xdir)->l;
    }
#line 13033 "compiler/parser.c"
    break;

  case 1116: /* $@67: %empty  */
#line 5838 "../compiler/parser.y"
    {
      scope_start(stab);
    }
#line 13041 "compiler/parser.c"
    break;

  case 1117: /* ox_taskdef_directive: PRAGMA_OMPIX OMPIX_TASKDEF $@67 ox_taskdef_clause_optseq '\n'  */
#line 5842 "../compiler/parser.y"
    {
      scope_end(stab);
      (yyval.xdir) = OmpixDirective(OX_DCTASKDEF, (yyvsp[-1].xcla));
    }
#line 13050 "compiler/parser.c"
    break;

  case 1118: /* ox_taskdef_clause_optseq: %empty  */
#line 5850 "../compiler/parser.y"
    {
      (yyval.xcla) = NULL;
    }
#line 13058 "compiler/parser.c"
    break;

  case 1119: /* ox_taskdef_clause_optseq: ox_taskdef_clause_optseq ox_taskdef_clause  */
#line 5854 "../compiler/parser.y"
    {
      (yyval.xcla) = OmpixClauseList((yyvsp[-1].xcla), (yyvsp[0].xcla));
    }
#line 13066 "compiler/parser.c"
    break;

  case 1120: /* ox_taskdef_clause_optseq: ox_taskdef_clause_optseq ',' ox_taskdef_clause  */
#line 5858 "../compiler/parser.y"
    {
      (yyval.xcla) = OmpixClauseList((yyvsp[-2].xcla), (yyvsp[0].xcla));
    }
#line 13074 "compiler/parser.c"
    break;

  case 1121: /* ox_taskdef_clause: OMP_IN '(' ox_variable_size_list ')'  */
#line 5865 "../compiler/parser.y"
    {
      (yyval.xcla) = OmpixVarlistClause(OX_OCIN, (yyvsp[-1].decl));
    }
#line 13082 "compiler/parser.c"
    break;

  case 1122: /* ox_taskdef_clause: OMP_OUT '(' ox_variable_size_list ')'  */
#line 5869 "../compiler/parser.y"
    {
      (yyval.xcla) = OmpixVarlistClause(OX_OCOUT, (yyvsp[-1].decl));
    }
#line 13090 "compiler/parser.c"
    break;

  case 1123: /* ox_taskdef_clause: OMP_INOUT '(' ox_variable_size_list ')'  */
#line 5873 "../compiler/parser.y"
    {
      (yyval.xcla) = OmpixVarlistClause(OX_OCINOUT, (yyvsp[-1].decl));
    }
#line 13098 "compiler/parser.c"
    break;

  case 1124: /* ox_taskdef_clause: OMP_REDUCTION '(' reduction_identifier ':' ox_variable_size_list ')'  */
#line 5877 "../compiler/parser.y"
    {
      (yyval.xcla) = OmpixReductionClause((yyvsp[-3].type), (yyvsp[-1].decl));
    }
#line 13106 "compiler/parser.c"
    break;

  case 1125: /* ox_variable_size_list: ox_variable_size_elem  */
#line 5883 "../compiler/parser.y"
                          { (yyval.decl) = (yyvsp[0].decl); }
#line 13112 "compiler/parser.c"
    break;

  case 1126: /* ox_variable_size_list: ox_variable_size_list ',' ox_variable_size_elem  */
#line 5885 "../compiler/parser.y"
    {
      (yyval.decl) = IdList((yyvsp[-2].decl), (yyvsp[0].decl));
    }
#line 13120 "compiler/parser.c"
    break;

  case 1127: /* ox_variable_size_elem: IDENTIFIER  */
#line 5892 "../compiler/parser.y"
    {
      (yyval.decl) = IdentifierDecl( Symbol((yyvsp[0].name)) );
      symtab_put(stab, Symbol((yyvsp[0].name)), IDNAME);
    }
#line 13129 "compiler/parser.c"
    break;

  case 1128: /* ox_variable_size_elem: IDENTIFIER '[' '?' IDENTIFIER ']'  */
#line 5897 "../compiler/parser.y"
    {
      if (checkDecls) check_uknown_var((yyvsp[-1].name));
      /* Use extern to differentiate */
      (yyval.decl) = ArrayDecl(IdentifierDecl( Symbol((yyvsp[-4].name)) ), StClassSpec(SPEC_extern),
                     IdentName((yyvsp[-1].name)));
      symtab_put(stab, Symbol((yyvsp[-4].name)), IDNAME);
    }
#line 13141 "compiler/parser.c"
    break;

  case 1129: /* ox_variable_size_elem: IDENTIFIER '[' assignment_expression ']'  */
#line 5905 "../compiler/parser.y"
    {
      (yyval.decl) = ArrayDecl(IdentifierDecl( Symbol((yyvsp[-3].name)) ), NULL, (yyvsp[-1].expr));
      symtab_put(stab, Symbol((yyvsp[-3].name)), IDNAME);
    }
#line 13150 "compiler/parser.c"
    break;

  case 1130: /* ox_task_construct: ox_task_directive IDENTIFIER '(' argument_expression_list ')' ';'  */
#line 5913 "../compiler/parser.y"
    {
      (yyval.xcon) = OmpixConstruct(OX_DCTASK, (yyvsp[-5].xdir), 
             FuncCallStmt(strcmp((yyvsp[-4].name), "main") ? (yyvsp[-4].name) : MAIN_NEWNAME, (yyvsp[-2].expr)));
      (yyval.xcon)->l = (yyvsp[-5].xdir)->l;
    }
#line 13160 "compiler/parser.c"
    break;

  case 1131: /* ox_task_directive: PRAGMA_OMPIX OMP_TASK ox_task_clause_optseq '\n'  */
#line 5922 "../compiler/parser.y"
    {
      (yyval.xdir) = OmpixDirective(OX_DCTASK, (yyvsp[-1].xcla));
    }
#line 13168 "compiler/parser.c"
    break;

  case 1132: /* ox_task_clause_optseq: %empty  */
#line 5929 "../compiler/parser.y"
    {
      (yyval.xcla) = NULL;
    }
#line 13176 "compiler/parser.c"
    break;

  case 1133: /* ox_task_clause_optseq: ox_task_clause_optseq ox_task_clause  */
#line 5933 "../compiler/parser.y"
    {
      (yyval.xcla) = OmpixClauseList((yyvsp[-1].xcla), (yyvsp[0].xcla));
    }
#line 13184 "compiler/parser.c"
    break;

  case 1134: /* ox_task_clause_optseq: ox_task_clause_optseq ',' ox_task_clause  */
#line 5937 "../compiler/parser.y"
    {
      (yyval.xcla) = OmpixClauseList((yyvsp[-2].xcla), (yyvsp[0].xcla));
    }
#line 13192 "compiler/parser.c"
    break;

  case 1135: /* ox_task_clause: OMPIX_ATNODE '(' '*' ')'  */
#line 5944 "../compiler/parser.y"
    {
      (yyval.xcla) = OmpixPlainClause(OX_OCATALL);
    }
#line 13200 "compiler/parser.c"
    break;

  case 1136: /* ox_task_clause: OMPIX_ATNODE '(' assignment_expression ')'  */
#line 5948 "../compiler/parser.y"
    {
      (yyval.xcla) = OmpixAtnodeClause((yyvsp[-1].expr));
    }
#line 13208 "compiler/parser.c"
    break;

  case 1137: /* ox_task_clause: OMPIX_ATNODE '(' OMPIX_HERE ')'  */
#line 5952 "../compiler/parser.y"
    {
      (yyval.xcla) = OmpixPlainClause(OX_OCLOCAL);
    }
#line 13216 "compiler/parser.c"
    break;

  case 1138: /* ox_task_clause: OMPIX_ATNODE '(' OMPIX_REMOTE ')'  */
#line 5956 "../compiler/parser.y"
    {
      (yyval.xcla) = OmpixPlainClause(OX_OCREMOTE);
    }
#line 13224 "compiler/parser.c"
    break;

  case 1139: /* ox_task_clause: OMPIX_ATWORKER '(' assignment_expression ')'  */
#line 5960 "../compiler/parser.y"
    {
      (yyval.xcla) = OmpixAtworkerClause((yyvsp[-1].expr));
    }
#line 13232 "compiler/parser.c"
    break;

  case 1140: /* ox_task_clause: OMPIX_TIED  */
#line 5964 "../compiler/parser.y"
    {
      (yyval.xcla) = OmpixPlainClause(OX_OCTIED);
    }
#line 13240 "compiler/parser.c"
    break;

  case 1141: /* ox_task_clause: OMP_UNTIED  */
#line 5968 "../compiler/parser.y"
    {
      (yyval.xcla) = OmpixPlainClause(OX_OCUNTIED);
    }
#line 13248 "compiler/parser.c"
    break;

  case 1142: /* ox_task_clause: OMPIX_DETACHED  */
#line 5972 "../compiler/parser.y"
    {
      (yyval.xcla) = OmpixPlainClause(OX_OCDETACHED);
    }
#line 13256 "compiler/parser.c"
    break;

  case 1143: /* ox_task_clause: OMP_HINT '(' expression ')'  */
#line 5976 "../compiler/parser.y"
    {
      (yyval.xcla) = OmpixHintsClause((yyvsp[-1].expr));
    }
#line 13264 "compiler/parser.c"
    break;

  case 1144: /* ox_task_clause: IF '(' expression ')'  */
#line 5980 "../compiler/parser.y"
    {
      (yyval.xcla) = OmpixIfClause((yyvsp[-1].expr));
    }
#line 13272 "compiler/parser.c"
    break;

  case 1145: /* ox_procextern_construct: ox_procextern_directive  */
#line 5988 "../compiler/parser.y"
    {
      (yyval.xcon) = OmpixConstruct(OX_DCPROCEXT, (yyvsp[0].xdir), NULL);
    }
#line 13280 "compiler/parser.c"
    break;

  case 1146: /* $@68: %empty  */
#line 5995 "../compiler/parser.y"
    { sc_pause_ompix(); }
#line 13286 "compiler/parser.c"
    break;

  case 1147: /* $@69: %empty  */
#line 5995 "../compiler/parser.y"
                                                       { sc_start_ompix(); }
#line 13292 "compiler/parser.c"
    break;

  case 1148: /* ox_procextern_directive: PRAGMA_OMPIX OMPIX_PROCEXTERN $@68 '(' extern_variable_list ')' $@69 '\n'  */
#line 5996 "../compiler/parser.y"
    {
      (yyval.xdir) = OmpixDirective(OX_DCPROCEXT, NULL);
      (yyval.xdir)->varlist = (yyvsp[-3].decl);
    }
#line 13301 "compiler/parser.c"
    break;

  case 1149: /* extern_variable_list: IDENTIFIER  */
#line 6004 "../compiler/parser.y"
    {
      stentry e = symtab_get(stab, Symbol((yyvsp[0].name)), IDNAME);
      
      if (symtab_get(stab, Symbol((yyvsp[0].name)), IDNAME) == NULL)
        parse_error(-1, "unknown identifier `%s'.\n", (yyvsp[0].name));
      if (e->scopelevel != 0)
        parse_error(-1, "procshared directive should only be used for global "
                        "variables (%s).\n", (yyvsp[0].name));
      if (speclist_getspec(e->spec, STCLASSSPEC, SPEC_extern) == NULL)
        parse_warning("variable `%s' is not declared as extern; ignoring\n", (yyvsp[0].name));
      (yyval.decl) = IdentifierDecl( Symbol((yyvsp[0].name)) );
    }
#line 13318 "compiler/parser.c"
    break;

  case 1150: /* extern_variable_list: extern_variable_list ',' IDENTIFIER  */
#line 6017 "../compiler/parser.y"
    {
      stentry e = symtab_get(stab, Symbol((yyvsp[0].name)), IDNAME);
      
      if (symtab_get(stab, Symbol((yyvsp[0].name)), IDNAME) == NULL)
        parse_error(-1, "unknown identifier `%s'.\n", (yyvsp[0].name));
      if (e->scopelevel != 0)
        parse_error(-1, "procshared directive should only be used for global "
                        "variables (%s).\n", (yyvsp[0].name));
      if (speclist_getspec(e->spec, STCLASSSPEC, SPEC_extern) == NULL)
        parse_warning("variable `%s' is not declared as extern; ignoring\n", (yyvsp[0].name));
      (yyval.decl) = IdList((yyvsp[-2].decl), IdentifierDecl( Symbol((yyvsp[0].name)) ));
    }
#line 13335 "compiler/parser.c"
    break;

  case 1151: /* ox_tag_construct: ox_tag_directive openmp_construct  */
#line 6033 "../compiler/parser.y"
    {
      (yyval.xcon) = OmpixConstruct(OX_DCTAG, (yyvsp[-1].xdir), OmpStmt((yyvsp[0].ocon)));
    }
#line 13343 "compiler/parser.c"
    break;

  case 1152: /* ox_tag_construct: ox_tag_directive ompix_construct  */
#line 6037 "../compiler/parser.y"
    {
      (yyval.xcon) = OmpixConstruct(OX_DCTAG, (yyvsp[-1].xdir), OmpixStmt((yyvsp[0].xcon)));
    }
#line 13351 "compiler/parser.c"
    break;

  case 1153: /* ox_tag_directive: PRAGMA_OMPIX ox_tag_clause '\n'  */
#line 6044 "../compiler/parser.y"
    {
      (yyval.xdir) = OmpixDirective(OX_DCTAG, (yyvsp[-1].xcla));
    }
#line 13359 "compiler/parser.c"
    break;

  case 1154: /* ox_tag_clause: OMPIX_TAG '(' string_literal ')'  */
#line 6051 "../compiler/parser.y"
    {
      (yyval.xcla) = OmpixClause(OX_OCTAG, NULL, String((yyvsp[-1].string)));
    }
#line 13367 "compiler/parser.c"
    break;

  case 1155: /* $@70: %empty  */
#line 6054 "../compiler/parser.y"
                                 { sc_pause_ompix(); }
#line 13373 "compiler/parser.c"
    break;

  case 1156: /* ox_tag_clause: OMPIX_TAG '(' string_literal $@70 ',' expression ')'  */
#line 6055 "../compiler/parser.y"
    {
      sc_start_ompix();
      (yyval.xcla) = OmpixClause(OX_OCTAG, NULL, CommaList(String((yyvsp[-4].string)), (yyvsp[-1].expr)));
    }
#line 13382 "compiler/parser.c"
    break;

  case 1157: /* tag_clause: OMPIX_TAG '(' string_literal ')'  */
#line 6063 "../compiler/parser.y"
    {
      (yyval.ocla) = TagClause(String((yyvsp[-1].string)));
    }
#line 13390 "compiler/parser.c"
    break;

  case 1158: /* $@71: %empty  */
#line 6066 "../compiler/parser.y"
                                 { sc_pause_openmp(); }
#line 13396 "compiler/parser.c"
    break;

  case 1159: /* tag_clause: OMPIX_TAG '(' string_literal $@71 ',' expression ')'  */
#line 6067 "../compiler/parser.y"
    {
      sc_start_openmp();
      (yyval.ocla) = TagClause(CommaList(String((yyvsp[-4].string)), (yyvsp[-1].expr)));
    }
#line 13405 "compiler/parser.c"
    break;


#line 13409 "compiler/parser.c"

      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", YY_CAST (yysymbol_kind_t, yyr1[yyn]), &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;

  *++yyvsp = yyval;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */
  {
    const int yylhs = yyr1[yyn] - YYNTOKENS;
    const int yyi = yypgoto[yylhs] + *yyssp;
    yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyssp
               ? yytable[yyi]
               : yydefgoto[yylhs]);
  }

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYSYMBOL_YYEMPTY : YYTRANSLATE (yychar);
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
      yyerror (YY_("syntax error"));
    }

  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == YYEOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:
  /* Pacify compilers when the user code never invokes YYERROR and the
     label yyerrorlab therefore never appears in user code.  */
  if (0)
    YYERROR;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  /* Pop stack until we find a state that shifts the error token.  */
  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYSYMBOL_YYerror;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYSYMBOL_YYerror)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;


      yydestruct ("Error: popping",
                  YY_ACCESSING_SYMBOL (yystate), yyvsp);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", YY_ACCESSING_SYMBOL (yyn), yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;


/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;


#if !defined yyoverflow
/*-------------------------------------------------.
| yyexhaustedlab -- memory exhaustion comes here.  |
`-------------------------------------------------*/
yyexhaustedlab:
  yyerror (YY_("memory exhausted"));
  yyresult = 2;
  goto yyreturn;
#endif


/*-------------------------------------------------------.
| yyreturn -- parsing is finished, clean up and return.  |
`-------------------------------------------------------*/
yyreturn:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  YY_ACCESSING_SYMBOL (+*yyssp), yyvsp);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif

  return yyresult;
}

#line 6073 "../compiler/parser.y"



/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                                                               *
 *     CODE                                                      *
 *                                                               *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */


void yyerror(const char *s)
{
	fprintf(stderr, "(file %s, line %d, column %d):\n\t%s\n",
	                sc_original_file(), sc_original_line(), sc_column(), s);
}


/* Utility function 
 */
char *strdupcat(char *first, char *second, int freethem)
{
	char *res;
	
	if (first == NULL && second == NULL)
		return NULL;
	if (first == NULL) 
		return (freethem) ? second : strdup(second);
	if (second == NULL) 
		return (freethem) ? first : strdup(first);
	if ((res = malloc(strlen(first)+strlen(second)+1)) == NULL)
		parse_error(1, "strdupcat ran out of memory\n");
	sprintf(res, "%s%s", first, second);
	if (freethem)
	{
		free(first);
		free(second);
	}
	return res;
}


/* This checks if e is a (parenthesized) identifier and it is known or not 
 */
void check_for_unknown_identifier(astexpr e)
{
	/* Unwrap parentheses */
	for (; e && e->type == UOP && e->opid == UOP_paren; e = e->left)
		;
	if (e && e->type == IDENT && checkDecls)
		check_uknown_var(e->u.sym->name);
}


/* Check whether the identifier is known or not
 */
void check_uknown_var(char *name)
{
	symbol s = Symbol(name);
	if (symtab_get(stab, s, IDNAME) == NULL &&
			symtab_get(stab, s, LABELNAME) == NULL &&
			symtab_get(stab, s, FUNCNAME) == NULL)
		parse_error(-1, "unknown identifier `%s'.\n", name);
}


/* See the "declaration" rule: if the last element of the list
 * is a user typename, we remove it, and we return it as an
 * identifier declarator.
 * The list should have 3 elements (typedef xxx type).
 */
astdecl fix_known_typename(astspec s)
{
	astspec prev;
	astdecl d;

	if (s->type != SPECLIST || s->u.next->type != SPECLIST) return (NULL);

	for (; s->u.next->type == SPECLIST; prev = s, s = s->u.next)
		;   /* goto last list node */
	if (s->u.next->type != USERTYPE)         /* nope */
		return (NULL);

	prev->u.next = s->body;

	d = Declarator(NULL, IdentifierDecl(s->u.next->name));
	if (checkDecls)
		symtab_put(stab, s->u.next->name, TYPENAME);
	free(s);
	return (d);
}


void check_for_main_and_declare(astspec s, astdecl d)
{
	astdecl n = decl_getidentifier(d);

	assert(d->type == DECLARATOR);
	assert(d->decl->type == DFUNC);

	if (strcmp(n->u.id->name, "main") == 0)
	{
		n->u.id = Symbol(MAIN_NEWNAME);         /* Catch main()'s definition */
		hasMainfunc = 1;

		/* Now check for return type and # parameters */
		/* It d != NULL then its parameters is either (id or idlist) or
		* (paramtype or parmatypelist). If it is a list, assume the
		* standard 2 params, otherwise, we guess the single argument
		* must be the type "void" which means no params.
		* In any case, we always force main have (argc, argv[]).
		*/
		if (d->decl->u.params == NULL || d->decl->u.params->type != DLIST)
			d->decl->u.params =
					ParamList(
						ParamDecl(
							Declspec(SPEC_int),
							Declarator( NULL, IdentifierDecl( Symbol("_argc_ignored") ) )
						),
						ParamDecl(
							Declspec(SPEC_char),
							Declarator(Speclist_right( Pointer(), Pointer() ),
												IdentifierDecl( Symbol("_argv_ignored") ))
						)
					);

		mainfuncRettype = 0; /* int */
		if (s != NULL)
		{
			for (; s->type == SPECLIST && s->subtype == SPEC_Rlist; s = s->u.next)
				if (s->body->type == SPEC && s->body->subtype == SPEC_void)
				{
					s = s->body;
					break;
				};
			if (s->type == SPEC && s->subtype == SPEC_void)
				mainfuncRettype = 1; /* void */
		}
	}
	if (symtab_get(stab, n->u.id, FUNCNAME) == NULL)/* From earlier declaration */
		symtab_put(stab, n->u.id, FUNCNAME);
}


/* For each variable/typename in the given declaration, add pointers in the
 * symbol table entries back to the declaration nodes.
 */
void add_declaration_links(astspec s, astdecl d)
{
	astdecl ini = NULL;

	if (d->type == DLIST && d->subtype == DECL_decllist)
	{
		add_declaration_links(s, d->u.next);
		d = d->decl;
	}
	if (d->type == DINIT) d = (ini = d)->decl;   /* Skip the initializer */
	assert(d->type == DECLARATOR);
	if (d->decl != NULL && d->decl->type != ABSDECLARATOR)
	{
		symbol  t = decl_getidentifier_symbol(d->decl);
		stentry e = isTypedef ?
		            symtab_get(stab,t,TYPENAME) :
		            symtab_get(stab,t,(decl_getkind(d)==DFUNC) ? FUNCNAME : IDNAME);
		e->spec  = s;
		e->decl  = d;
		e->idecl = ini;
	}
}


void  check_schedule(ompclsubt_e sched, intvec_t mods)
{
	if (mods == NULL) return;
	if (intvec_contains(mods, OCM_nonmonotonic) && 
	    sched != OC_dynamic && sched != OC_guided)
		parse_error(1, "nonmonotonic modifier is only allowed in dynamic or "
		                 "guided schedules\n");
}


static void countredids(int *elem, bool isfirst, bool islast, void *arg)
{
	if (isfirst) *((int *) arg) = 0;
	if (IsReductionidModifier(*elem))
		(*((int *) arg))++;
}

static void countdirnamemods(int *elem, bool isfirst, bool islast, void *arg)
{
	if (isfirst) *((int *) arg) = 0;
	if (IsDirnameModifier(*elem))
		(*((int *) arg))++;
}

static void findredid(int *elem, bool isfirst, bool islast, void *arg)
{
	if (IsReductionidModifier(*elem))
		(*((int *) arg)) = *elem;
}

/* Check if correct modifiers were given to a data reduction clause.
 * It returs the reduction operation id.
 */
int check_data_reduction_modifiers(intvec_t v)
{
	int n = 0;
	intvec_iterate(v, countredids, &n);
	if (!v || n != 1)
		parse_error(1, "reduction operator missing from reduction clause.\n");
	intvec_iterate(v, countdirnamemods, &n);
	if (n > 1)
		parse_error(1, "multiple directive name modifiers in reduction clause.\n");
	/* FIXME: we need to check many other things, too like # OCM_default, etc */
	intvec_iterate(v, findredid, &n);
	return UnpackModifier(n);
}


static void countmaptypes(int *elem, bool isfirst, bool islast, void *arg)
{
	if (isfirst) *((int *) arg) = 0;
	if (IsMaptypeModifier(*elem))
		(*((int *) arg))++;
}

static void findmaptype(int *elem, bool isfirst, bool islast, void *arg)
{
	if (IsMaptypeModifier(*elem))
		(*((int *) arg)) = *elem;
}

/* Check if correct modifiers were given to a map clause.
 * It returs the map type.
 */
int check_map_clause_modifiers(intvec_t v)
{
	int n = 0;
	intvec_iterate(v, countdirnamemods, &n);
	if (n > 1)
		parse_error(1, "multiple directive name modifiers in map clause.\n");
	n = 0;
	intvec_iterate(v, countmaptypes, &n);
	switch (n)
	{
		case 0:  return OC_tofrom;     /* default */
		case 1:  intvec_iterate(v, findmaptype, &n);
		         return UnpackModifier(n);
		default: parse_error(1, "multiple map types met in map clause.\n");
	}
	return 0;
}


int mk_dirname_modifier(char *dirname)
{
	if (strcmp(dirname, "parallel") == 0) return DirnameModifier(DCPARALLEL);
	if (strcmp(dirname, "for") == 0) return DirnameModifier(DCFOR);
	if (strcmp(dirname, "sections") == 0) return DirnameModifier(DCSECTIONS);
	if (strcmp(dirname, "single") == 0) return DirnameModifier(DCSINGLE);
	if (strcmp(dirname, "master") == 0) return DirnameModifier(DCMASTER);
	if (strcmp(dirname, "critical") == 0) return DirnameModifier(DCCRITICAL);
	if (strcmp(dirname, "atomic") == 0) return DirnameModifier(DCATOMIC);
	if (strcmp(dirname, "ordered") == 0) return DirnameModifier(DCORDERED);
	if (strcmp(dirname, "barrier") == 0) return DirnameModifier(DCBARRIER);
	if (strcmp(dirname, "flush") == 0) return DirnameModifier(DCFLUSH);
	if (strcmp(dirname, "threadprivate") == 0) return DirnameModifier(DCTHREADPRIVATE);
	if (strcmp(dirname, "task") == 0) return DirnameModifier(DCTASK);
	if (strcmp(dirname, "taskwait") == 0) return DirnameModifier(DCTASKWAIT);
	if (strcmp(dirname, "taskyield") == 0) return DirnameModifier(DCTASKYIELD);
	if (strcmp(dirname, "simd") == 0) return DirnameModifier(DCSIMD);
	if (strcmp(dirname, "distribute") == 0) return DirnameModifier(DCDISTRIBUTE);
	if (strcmp(dirname, "target") == 0) return DirnameModifier(DCTARGET);
	if (strcmp(dirname, "target_data") == 0) return DirnameModifier(DCTARGETDATA);
	if (strcmp(dirname, "target_update") == 0) return DirnameModifier(DCTARGETUPDATE);
	if (strcmp(dirname, "declare_target") == 0) return DirnameModifier(DCDECLARETARGET);
	if (strcmp(dirname, "cancel") == 0) return DirnameModifier(DCCANCEL);
	if (strcmp(dirname, "cancellation_point") == 0) return DirnameModifier(DCCANCELLATIONPOINT);
	if (strcmp(dirname, "taskgroup") == 0) return DirnameModifier(DCTASKGROUP);
	if (strcmp(dirname, "teams") == 0) return DirnameModifier(DCTEAMS);
	if (strcmp(dirname, "target_enter_data") == 0) return DirnameModifier(DCTARGETENTERDATA);
	if (strcmp(dirname, "target_exit_data") == 0) return DirnameModifier(DCTARGETEXITDATA);
	if (strcmp(dirname, "requires") == 0) return DirnameModifier(DCREQUIRES);
	if (strcmp(dirname, "masked") == 0) return DirnameModifier(DCMASKED);
	if (strcmp(dirname, "error") == 0) return DirnameModifier(DCERROR);
	return OCM_none;
}


void parse_error(int exitvalue, char *format, ...)
{
	va_list ap;

	va_start(ap, format);
	fprintf(stderr, "(%s, line %d)\n\t", sc_original_file(), sc_original_line());
	vfprintf(stderr, format, ap);
	va_end(ap);
	if (strcmp(sc_original_file(), "injected_code") == 0)
		fprintf(stderr, "\n>>>>>>>\n%s\n>>>>>>>\n", parsingstring);
	_exit(exitvalue);
}


void parse_warning(char *format, ...)
{
	va_list ap;

	va_start(ap, format);
	fprintf(stderr, "[warning] ");
	vfprintf(stderr, format, ap);
	va_end(ap);
}


aststmt parse_file(char *fname, int *error)
{
	*error = 0;
	if ( (yyin = fopen(fname, "r")) == NULL )
		return (NULL);
	sc_set_filename(fname);      /* Inform the scanner */
	*error = yyparse();
	fclose(yyin);                /* No longer needed */
	return (pastree);
}


#define PARSE_STRING_SIZE 16384


astexpr parse_expression_string(char *format, ...)
{
	static char s[PARSE_STRING_SIZE];
	int    savecD;

	va_list ap;
	va_start(ap, format);
	vsnprintf(s, PARSE_STRING_SIZE-1, format, ap);
	va_end(ap);
	parsingstring = s;
	sc_scan_string(s);
	sc_set_start_token(START_SYMBOL_EXPRESSION);

	savecD = checkDecls;
	checkDecls = 0;         /* Don't check identifiers & don't declare them */
	yyparse();
	checkDecls = savecD;    /* Reset it */
	return ( pastree_expr );
}


aststmt parse_blocklist_string(char *format, ...)
{
	static char s[PARSE_STRING_SIZE];
	int    savecD;

	va_list ap;
	va_start(ap, format);
	vsnprintf(s, PARSE_STRING_SIZE-1, format, ap);
	va_end(ap);
	parsingstring = s;
	sc_scan_string(s);
	sc_set_start_token(START_SYMBOL_BLOCKLIST);

	savecD = checkDecls;
	checkDecls = 0;         /* Don't check identifiers & don't declare them */
	yyparse();
	checkDecls = savecD;    /* Reset it */
	return ( pastree_stmt );
}


aststmt parse_and_declare_blocklist_string(char *format, ...)
{
	static char s[PARSE_STRING_SIZE];
	int    savecD;

	va_list ap;
	va_start(ap, format);
	vsnprintf(s, PARSE_STRING_SIZE-1, format, ap);
	va_end(ap);
	parsingstring = s;
	sc_scan_string(s);
	sc_set_start_token(START_SYMBOL_BLOCKLIST);

	savecD = checkDecls;
	checkDecls = 1;         /* Do check identifiers & do declare them */
	yyparse();
	checkDecls = savecD;    /* Reset it */
	return ( pastree_stmt );
}


aststmt parse_transunit_string(char *format, ...)
{
	static char s[PARSE_STRING_SIZE];
	int    savecD;

	va_list ap;
	va_start(ap, format);
	vsnprintf(s, PARSE_STRING_SIZE-1, format, ap);
	va_end(ap);
	parsingstring = s;
	sc_scan_string(s);
	sc_set_start_token(START_SYMBOL_TRANSUNIT);

	savecD = checkDecls;
	checkDecls = 0;         /* Don't check identifiers & don't declare them */
	yyparse();
	checkDecls = savecD;    /* Reset it */
	return ( pastree_stmt );
}
