/*
  OMPi OpenMP Compiler
  == Copyright since 2001 the OMPi Team
  == Dept. of Computer Science & Engineering, University of Ioannina

  This file is part of OMPi.

  OMPi is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  OMPi is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with OMPi; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* x_utilcons.c -- transform utility and informational constructs */

#include <string.h>
#include "ast_free.h"
#include "ast_assorted.h"
#include "x_utilcons.h"
#include "x_clauses.h"
#include "ast_xform.h"
#include "ompi.h"


void xform_error(aststmt *t)
{
	aststmt parent = (*t)->parent, v;
	ompclause c;
	ompclsubt_e time = OC_compilation, action = OC_fatal;  /* the defaults */
	
	v = ompdir_commented((*t)->u.omp->directive);

	if ((c = xc_ompcon_get_clause((*t)->u.omp, OCAT)))
		time = c->subtype;
	if ((c = xc_ompcon_get_clause((*t)->u.omp, OCSEVERITY)))
		action = c->subtype;
	c = xc_ompcon_get_clause((*t)->u.omp, OCMESSAGE);
	
	if (time == OC_compilation)
	{ 
		if (action == OC_fatal)
			exit_error(1, "[compilation aborted]: %.*s\n", 
			              c ? strlen(c->s->name)-2 : 20,  /* avoid the quotes */
			              c ? c->s->name+1 : "error directive met.");
		else
			warning("[warning]: %.*s\n", 
			        c ? strlen(c->s->name)-2 : 20,  /* avoid the quotes */
			        c ? c->s->name+1 : "error directive met.");
	}
	else
	{
		if (action == OC_fatal && xformingTarget) /* TODO: support in devices?? */
		{
			if (xformingForHOST)   /* Avoid re-printing it for all code targets */
				warning("(%s, line %d) warning:\n\tFatal #error is only supported in "
				        "the host currently; ignoring.\n",
				        (*t)->u.omp->directive->file->name, 
				        (*t)->u.omp->directive->l);
		}
		else
			v = BlockList(
			      v, 
			      FuncCallStmt("_ort_handle_error", 
			        Comma2(numConstant(action == OC_fatal), 
			               c ? String(c->s->name) : numConstant(0)
			                  //  CastedExpr(
			                  //    Casttypename(
			                  //      Declspec(SPEC_char), 
			                  //      AbstractDeclarator(Declspec(SPEC_star), NULL)
			                  //    ),
			                  //    ZeroExpr()
			                  //  )
			              )
			      )
			    );
	}
	ast_free(*t);
	*t = v; /* We are done */
	(*t)->parent = parent;
}
