/*
  OMPi OpenMP Compiler
  == Copyright since 2001 the OMPi Team
  == Dept. of Computer Science & Engineering, University of Ioannina

  This file is part of OMPi.

  OMPi is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  OMPi is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with OMPi; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* x_requires.h -- Handle OpenMP #requires directive */

#ifndef __X_REQUIRES_H__
#define __X_REQUIRES_H__

#include "ast.h"

#define _required(x) __req_##x
#define _requires_flag(x) bool _required(x)
extern  _requires_flag(OCREVERSEOFFLOAD);
extern  _requires_flag(OCUNIFIEDADDRESS);
extern  _requires_flag(OCUNIFIEDSHAREDMEMORY);
extern  _requires_flag(OCDYNAMICALLOCATORS);
extern  _requires_flag(OCATOMICDEFAULTMEMORDER);
extern ompclsubt_e __req_memorder_value;

extern unsigned int num_requirements;
extern bool _ext_required(char *name);
extern void stringify_reqs(str s, bool quoted);

extern void xform_requires(aststmt *t);

#endif /* __X_REQUIRES_H__ */
