/*
  OMPi OpenMP Compiler
  == Copyright since 2001 the OMPi Team
  == Dept. of Computer Science & Engineering, University of Ioannina

  This file is part of OMPi.

  OMPi is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  OMPi is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with OMPi; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* x_parallel.h -- too big a transformation to be part off ast_xfrom! */

#ifndef __X_PARALLEL_H__
#define __X_PARALLEL_H__

#include "ast.h"
#include "ast_vars.h"

#define NUMTHREADS_RUNTIME   -1
#define NUMTHREADS_UNDEFINED 0
#define NUMTHREADS_SINGLE    1

extern aststmt xp_handle_copyin(set(vars) s, char *structVariable);
extern vartype_t xp_implicitDefaultAuto(setelem(vars) s, void *arg);
extern vartype_t xp_implicitDefault(setelem(vars) s, void *arg);
extern int xp_procbind(ompcon t);

/* Transforms the given statement, which is supposed to be
 * an OpenMP parallel construct
 */
extern void xform_parallel(aststmt *t);
extern void xform_parforsimd(aststmt *t);


#endif
