/*
  OMPi OpenMP Compiler
  == Copyright since 2001 the OMPi Team
  == Dept. of Computer Science & Engineering, University of Ioannina

  This file is part of OMPi.

  OMPi is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  OMPi is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with OMPi; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* x_distribute.h -- transform distribute constructs */

#ifndef __X_DISTRIBUTE_H__
#define __X_DISTRIBUTE_H__

#include "ast.h"
#include "x_for.h"

extern void xform_distribute(aststmt *t);
extern void xform_distsimd(aststmt *t);
extern void xform_distparfor(aststmt *t);
extern void xform_distparforsimd(aststmt *t);

/* This is xform_distribute() but with a custom function for the main part 
 * of the loop; used by code targets other than the host.
 */
extern aststmt dist_mainpart(fordata_t *loopinfo, aststmt origbody);
extern void _do_distribute(aststmt *t, aststmt (*fmainpart)(fordata_t*, aststmt));

#endif
