/*
  OMPi OpenMP Compiler
  == Copyright since 2001 the OMPi Team
  == Dept. of Computer Science & Engineering, University of Ioannina

  This file is part of OMPi.

  OMPi is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  OMPi is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with OMPi; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* x_clauserules.h -- clause rules */

#ifndef __X_CLAUSERULES_H__
#define __X_CLAUSERULES_H__

#include "ast.h"

extern void      clr_init_rules(void);

extern int       clr_multiplicity(ompdirt_e dirtype, ompclt_e cltype);
extern bool      clr_allowed(ompdirt_e dirtype, ompclt_e cltype);
extern bool      clr_allowed_mod(ompdirt_e dir, ompclt_e cla, ompclmod_e mo);
extern ompclt_e  clr_clause_id(char *str);
extern ompdirt_e clr_dir_id(char *str);

extern void      clr_print_all_dirs(void);
extern void      clr_print_all_clauses(void);
extern void      clr_print_dir_clauses(ompdirt_e dirtype);
extern void      clr_print_clause_dirs(ompclt_e cltype);

#endif
