/*
  OMPi OpenMP Compiler
  == Copyright since 2001 the OMPi Team
  == Dept. of Computer Science & Engineering, University of Ioannina

  This file is part of OMPi.

  OMPi is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  OMPi is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with OMPi; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* x_teams_vk.c -- transform Vulkan teams constructs */

#include <stdio.h>
#include "autoscope.h"
#include "ompi.h"
#include "outline.h"
#include "x_clauses.h"
#include "x_cars.h"
#include "x_distribute.h"
#include "x_target_vk.h"
#include "x_teams_vk.h"
#include "x_teams.h"
#include "x_combine.h"


/* Treat it like a target region with multiple workgroups, for now */
void xform_targetteams_vulkan(aststmt *t)
{
	xform_target_vulkan(t);
}


void xform_targetteamsdistparfor_vulkan(aststmt *t)
{
	ccc_try_splitting(t);
	xform_targetteams_vulkan(t);
}
