/*
  OMPi OpenMP Compiler
  == Copyright since 2001 the OMPi Team
  == Dept. of Computer Science & Engineering, University of Ioannina

  This file is part of OMPi.

  OMPi is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  OMPi is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with OMPi; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* x_target_vk.h -- transform Vulkan target constructs */

#ifndef __X_TARGET_VK_H__
#define __X_TARGET_VK_H__

#include "ast.h"
#include "x_cars.h"

#define BINDING_TARGET   0
#define BINDING_DECLTARG 1

struct vk_bindingstate_ {
	int binding_num;
	int from;
};

typedef struct vk_bindingstate_ vk_bindingstate_t;

extern bool inIfMaster;

/* Transformation functions */
extern void xform_targetparallel_vulkan(aststmt *t);
extern void xform_targparfor_vulkan(aststmt *t);
extern void xform_target_vulkan(aststmt *t);
extern aststmt produce_shader_buffer_decl(symbol s, void *state);

#endif
