/*
  OMPi OpenMP Compiler
  == Copyright since 2001 the OMPi Team
  == Dept. of Computer Science & Engineering, University of Ioannina

  This file is part of OMPi.

  OMPi is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  OMPi is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with OMPi; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* x_parallel_vk.c -- transform Vulkan parallel constructs */

#include <string.h>
#include <assert.h>
#include "ast_xform.h"
#include "ast_copy.h"
#include "x_parallel.h"
#include "x_parallel_vk.h"
#include "x_target.h"
#include "x_clauses.h"
#include "omp.h"
#include "ompi.h"
#include "outline.h"
#include "ast_show.h"
#include "autoscope.h"
#include "builder.h"


void xform_parallel_vulkan(aststmt *t)
{
	stackelem(ompdirs) targetelem;
	int savescope = closest_parallel_scope;
	int savecpl = cur_parallel_line;
	int savectgl = cur_taskgroup_line;
	aststmt d;

	cur_parallel_line = (*t)->l;
	cur_taskgroup_line = 0;

	closest_parallel_scope = stab->scopelevel;

	if ((targetelem = find_target_parent()))
		targetelem->data->nparallel++;

	xform_ompcon_body((*t)->u.omp);

	/* For now, just get rid of the OMP directive */
	d = (*t);
	(*t) = (*t)->u.omp->body;
	(*t)->parent = d->parent;

	closest_parallel_scope = savescope;
	cur_parallel_line = savecpl;
	cur_taskgroup_line = savectgl;
}
