/*
  OMPi OpenMP Compiler
  == Copyright since 2001 the OMPi Team
  == Dept. of Computer Science & Engineering, University of Ioannina

  This file is part of OMPi.

  OMPi is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  OMPi is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with OMPi; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* x_teams_cu.c -- transform CUDA target teams constructs */

#include <stdio.h>
#include "autoscope.h"
#include "ompi.h"
#include "outline.h"
#include "x_clauses.h"
#include "x_cars.h"
#include "x_distribute.h"
#include "x_target.h"
#include "x_target_cu.h"
#include "x_parallel.h"
#include "x_parallel_cu.h"

#include "x_teams.h"
#include "ast_copy.h"
#include "ast_xform.h"
#include "ast_print.h"
#include "x_combine.h"


void xform_targetteams_cuda(aststmt *t)
{
	targstats_t *ts = analyzeKernels 
		? cars_analyze_target((*t)->u.omp->body)
		: NULL;

	/* This is called just to set the clause vars */
	xc_ompcon_search_offload_params((*(t))->u.omp);

	/* (1) Apply the appropriate scheme, transform the body &
	 * the directive, no need to find offload parameters.
	 */
	if (((*t)->u.omp->type == DCTARGETTEAMS)
		&& !search_nested_construct((*t)->u.omp, DCPARALLEL) 
		&& !search_nested_construct((*t)->u.omp, DCDISTRIBUTE)
		&& !search_nested_construct((*t)->u.omp, DCDISTPARFOR))
	{
		#if PARALLEL_SCHEME == SCHEME_MASTERWORKER
		masterworker_stmt(&((*t)->u.omp->body));
		XFORM_CURR_DIRECTIVE->ismasterworker = 1;
		#else
		ifmaster_stmt_cuda(&((*t)->u.omp->body), false);
		#endif
	}
	else
	{
		prepend_cuda_prologue(t);
		append_cuda_epilogue(t);
	}
		
	xform_ompcon_body((*t)->u.omp);
	omp_target_cuda(t, ts);
}

void xform_targetteamsdist_cuda(aststmt *t)
{
	ccc_try_splitting(t);
	xform_targetteams_cuda(t);
}


void xform_targetteamsdistparfor_cuda(aststmt *t)
{
	ccc_try_splitting(t);
	// xform_ompcon_body((*t)->u.omp);
	xform_targetteams_cuda(t);
}
