/*
  OMPi OpenMP Compiler
  == Copyright since 2001 the OMPi Team
  == Dept. of Computer Science & Engineering, University of Ioannina

  This file is part of OMPi.

  OMPi is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  OMPi is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with OMPi; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* ast_types.h */

#ifndef __AST_TYPES_H__
#define __AST_TYPES_H__

#include "ast.h"
#include "ast_vars.h"
#include "dg.h"
#include "callgraph.h"

extern void ast_xt_barebones_substitute(astspec *spec, astdecl *decl);
extern void ast_xt_barebones_decl(astdecl d);
extern void ast_xt_suedecl_xform(aststmt *d);
extern void ast_xt_declaration_xform(aststmt *t);
extern void ast_xt_free_retired();
extern int  ast_xt_decl_depends_on_sue(astdecl decl);
extern int  ast_xt_spec_depends_on_sue(astspec spec);
extern int  ast_xt_symbol_depends_on_sue(symbol s);
#define ast_xt_has_sue(s,d) (ast_xt_spec_depends_on_sue(s) || ast_xt_decl_depends_on_sue(d))
extern void ast_xt_dlist_array2pointer(aststmt d);
extern void ast_xt_decl_array2pointer(astdecl d);

extern astdecl ast_xt_concrete_to_abstract_declarator(astdecl orig);
extern astdecl ast_xt_abstract_to_concrete_declarator(astdecl orig, astdecl bd);

extern aststmt multi2single_stmt(astspec spec, astdecl decl);

/* SUE dependency graph */
extern dg_t     *suedg_graph_from_globals();
extern void      suedg_add_from_ast(dg_t *g, aststmt t, set(cgfun) cf);
extern set(vars) suedg_get_used_global_sues(dg_t *g);
extern aststmt   suedg_declare_used_globals(dg_t *g);

#endif
