/*
  OMPi OpenMP Compiler
  == Copyright since 2001 the OMPi Team
  == Dept. of Computer Science & Engineering, University of Ioannina

  This file is part of OMPi.

  OMPi is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  OMPi is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with OMPi; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* ast_traverse.h -- generic traversal of the AST using callbacks @ each node */

#ifndef __AST_TRAVERSE_H__
#define __AST_TRAVERSE_H__

#include "ast.h"

#define CALLBACKFUNCTYPEDEF(TYPENAME,ASTNODETYPE) \
  typedef void (*TYPENAME)(ASTNODETYPE, void *starg, int vistime)

CALLBACKFUNCTYPEDEF(stmtcbf_t,aststmt);
typedef struct {
	stmtcbf_t break_c;
	stmtcbf_t continue_c;
	stmtcbf_t return_c;
	stmtcbf_t goto_c;
	stmtcbf_t for_c;
	stmtcbf_t while_c;
	stmtcbf_t do_c;
	stmtcbf_t switch_c;
	stmtcbf_t if_c;
	stmtcbf_t label_c;
	stmtcbf_t case_c;
	stmtcbf_t default_c;
	stmtcbf_t expression_c;
	stmtcbf_t compound_c;
	stmtcbf_t declaration_c;
	stmtcbf_t funcdef_c;
	stmtcbf_t stmtlist_c;
	stmtcbf_t verbatim_c;
	stmtcbf_t asmstmt_c;
} stmtcbs_t;

CALLBACKFUNCTYPEDEF(exprcbf_t,astexpr);
typedef struct {
	exprcbf_t ident_c;
	exprcbf_t constval_c;
	exprcbf_t string_c;
	exprcbf_t funccall_c;
	exprcbf_t arrayidx_c;
	exprcbf_t dotfield_c;
	exprcbf_t ptrfield_c;
	exprcbf_t bracedinit_c;
	exprcbf_t castexpr_c;
	exprcbf_t condexpr_c;
	exprcbf_t uop_c;
	exprcbf_t bop_c;
	exprcbf_t preop_c;
	exprcbf_t postop_c;
	exprcbf_t ass_c;
	exprcbf_t designated_c;
	exprcbf_t idxdes_c;
	exprcbf_t dotdes_c;
	exprcbf_t list_c;
} exprcbs_t;

CALLBACKFUNCTYPEDEF(speccbf_t,astspec);
typedef struct {
	speccbf_t spec_c;
	speccbf_t usertype_c;
	speccbf_t specenum_c;
	speccbf_t specstruct_c;
	speccbf_t specunion_c;
	speccbf_t enumerator_c;
	speccbf_t speclist_c;
} speccbs_t;

CALLBACKFUNCTYPEDEF(declcbf_t,astdecl);
typedef struct {
	declcbf_t dident_c;
	declcbf_t dparen_c;
	declcbf_t darray_c;
	declcbf_t dfunc_c;
	declcbf_t dinit_c;
	declcbf_t declarator_c;
	declcbf_t absdeclarator_c;
	declcbf_t dparam_c;
	declcbf_t dellipsis_c;
	declcbf_t dbit_c;
	declcbf_t dstructfield_c;
	declcbf_t dcasttype_c;
	declcbf_t dlist_c;
} declcbs_t;

CALLBACKFUNCTYPEDEF(oclacbf_t,ompclause);
typedef struct {
	oclacbf_t ompclexpr_c;
	oclacbf_t ompclvars_c;
	oclacbf_t ompclplain_c;
	oclacbf_t ompcllist_c;
	/* prune_* fields disallow recursing when visiting the corresponding nodes */
	int  prune_ompclexpr_c;
	int  prune_ompclvars_c;
} ompclcbs_t;

CALLBACKFUNCTYPEDEF(odircbf_t,ompdir);
CALLBACKFUNCTYPEDEF(oconcbf_t,ompcon);
typedef struct {
	odircbf_t ompdircrit_c;
	odircbf_t ompdirflush_c;
	odircbf_t ompdirthrpriv_c;
	odircbf_t ompdirrest_c;
	oconcbf_t ompconall_c;
} ompdccbs_t;

CALLBACKFUNCTYPEDEF(xclacbf_t,oxclause);
CALLBACKFUNCTYPEDEF(xdircbf_t,oxdir);
CALLBACKFUNCTYPEDEF(xconcbf_t,oxcon);
typedef struct {
	xclacbf_t oxclvars_c;
	xclacbf_t oxclexpr_c;
	xclacbf_t oxclrest_c;
	xclacbf_t oxcllist_c;
	xdircbf_t oxdirall_c;
	xconcbf_t oxconall_c;
} oxcbs_t;


#define PREVISIT  1  /* Also used for simple visit; this is the default. */
#define POSTVISIT 2
#define PREPOSTVISIT (PREVISIT | POSTVISIT)
#define MIDVISIT  4  /* Only used in ASS_OP, DECLARATION */

#define LRORDER   1  /* Left-then-right part of assignments (default) */
#define RLORDER   2  /* Right-then-left */

typedef struct {
	int        when;        /* PRE/POST/MID visit */
	int        lrorder;     /* LR/RL: order of visit the 2 sides of assignments */

	int        doexpr;      /* Set to false to avoid visiting such nodes */
	int        dospec;
	int        dodecl;
	int        doomp;       /* Even if false, construct body is always visited */
	int        doox;        /* Even if false, construct body is always visited */
	
	void      *starg;       /* State (argument) passed to callback functions */
	int        guided;      /* If true, callback functions are responsible for
	                           the traversal of their children; in this case
	                           their argument is the whole option structure,
	                           not just starg */

	stmtcbs_t  stmtc;
	exprcbs_t  exprc;
	speccbs_t  specc;
	declcbs_t  declc;
	ompclcbs_t ompclausec;
	ompdccbs_t ompdcc;
	oxcbs_t    oxc;
} travopts_t;

/* While setting manualy every field of the structs may be fulfilling,
 * it is not the easiest (or shortest) thing to do. The following create
 * a batch-filled struct; fields can then be differentiated seperately.
 */
extern void travopts_init_noop(travopts_t *trop);       /* Everything NULL */
extern void travopts_init_batch(travopts_t *trop, 
                                stmtcbf_t stmtcb, 
                                exprcbf_t exprcb,
                                speccbf_t speccb, 
                                declcbf_t declcb,
                                oclacbf_t ompclasecb, 
                                odircbf_t ompdircb,
                                oconcbf_t ompconcb, 
                                xclacbf_t oxclausecb,
                                xdircbf_t oxdircb, 
                                xconcbf_t oxconcb);

extern void ast_stmt_traverse(aststmt tree,        travopts_t *trop);
extern void ast_expr_traverse(astexpr tree,        travopts_t *trop);
extern void ast_spec_traverse(astspec tree,        travopts_t *trop);
extern void ast_decl_traverse(astdecl tree,        travopts_t *trop);
extern void ast_ompclause_traverse(ompclause tree, travopts_t *trop);
extern void ast_ompdir_traverse(ompdir tree,       travopts_t *trop);
extern void ast_ompcon_traverse(ompcon tree,       travopts_t *trop);
extern void ast_oxclause_traverse(oxclause tree,   travopts_t *trop);
extern void ast_oxdir_traverse(oxdir tree,         travopts_t *trop);
extern void ast_oxcon_traverse(oxcon tree,         travopts_t *trop);

#endif
