/*
  OMPi OpenMP Compiler
  == Copyright since 2001 the OMPi Team
  == Dept. of Computer Science & Engineering, University of Ioannina

  This file is part of OMPi.

  OMPi is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  OMPi is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with OMPi; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* ast_assorted.h - Assorted functions and utilities related to the AST */
 
#ifndef __AST_ASSORTED_H__
#define __AST_ASSORTED_H__

#include "ast.h"

/* Get the declaration of a struct/union field from its name */
extern astdecl get_sufield(symbol s, symbol f);

/* This simply prints the directive into a string and encloses it
 * in comments, adding also the source line number.
 * It returns a verbatim node with the comment.
 */
extern aststmt ompdir_commented(ompdir d);

extern aststmt linepragma(int line, symbol file);

/* Compare ASTs */
extern bool same_expr(astexpr e, astexpr f), 
            same_decl(astdecl d, astdecl e),
            same_spec(astspec s, astspec t),
            same_xlist(ompxli x, ompxli y);

extern int bop2assop(int bop), assop2bop(int assop);

#endif /* __AST_ASSORTED_H__ */
