/*
  OMPi OpenMP Compiler
  == Copyright since 2001 the OMPi Team
  == Dept. of Computer Science & Engineering, University of Ioannina

  This file is part of OMPi.

  OMPi is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  OMPi is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with OMPi; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#ifndef __ROFF_CONFIG_H__
#define __ROFF_CONFIG_H__

#ifdef REMOTE_OFFLOADING_SETUP_MODE
	#define OMPI_REMOTE_OFFLOADING
#else
	#include "stddefs.h"
#endif

#ifdef OMPI_REMOTE_OFFLOADING

#include "str.h"


#define IS_CPU_MODULE(x) (strcmp(x, "cpu") == 0)

#define ROFFCONF_CONF_FILE "/.ompi_remote_devices"
#define ROFFCONF_MAXMODS 256
#define ROFFCONF_MAXNAME 64
#define ROFFCONF_MAX_INL_DECL 16

#define DONT_INCLUDE_CPU_MOD 0
#define INCLUDE_CPU_MOD 1

#define DONT_IGNORE_DISABLED_MODULES false
#define IGNORE_DISABLED_MODULES true

typedef struct roff_config_status_ roff_config_status_t;
typedef struct roff_config_module_ roff_config_module_t;
typedef struct roff_config_node_   roff_config_node_t;
typedef struct roff_config_        roff_config_t;

typedef struct walk_
{
	const char *buffer;
	char *p;
} walk_t;

#define MODULE(m) { MODULE_ ## m, #m }
#define LASTMODULE { MODULE_last_, NULL }

// Currently not used, could be useful in the long run.
typedef enum module_enum_
{
	MODULE_cpu       = 1 << 0,
	MODULE_cuda      = 1 << 1,
	MODULE_opencl    = 1 << 2,
	MODULE_vulkan    = 1 << 3,
	MODULE_proc2     = 1 << 4,
	MODULE_proc2l    = 1 << 5,
/* new-module.sh:roffmodenum */
	MODULE_last_     = -1
} module_enum_t;

typedef struct modules_
{
	module_enum_t modid;
	char *modname;
} modules_t;

extern modules_t allmodules[];

struct roff_config_module_
{
	char *name;
	roff_config_node_t *node;
	int num_devices;
	bool is_disabled;
};

struct roff_config_node_
{
	int id;
	char *name;
	unsigned int port;
	int total_num_devices;
	int num_modules;
	int num_modnames;
	int has_cpu_module;
	int first_remote_devid;
	roff_config_module_t modules[ROFFCONF_MAXMODS];
	char *module_names[ROFFCONF_MAXMODS];
};

struct roff_config_status_
{
	enum
	{
		roff_config_status_success,
		roff_config_status_fail,
		roff_config_status_duplicate
	} return_code;
	int id;
};

struct roff_config_
{
	str modstr;
	char **uniquemodnames;
	int initialized;
	int finalized;
	int nuniquemodules;
	int has_cpu_module;
	roff_config_node_t *nodes;
	unsigned int num_devices;
	unsigned int num_modules;
	unsigned int num_enabled_devices;
	unsigned int num_enabled_modules;
	unsigned int num_nodes;
	unsigned int node_capacity;
};

extern roff_config_t roff_config;

extern void roff_config_initialize(bool ignore_disabled_modules, bool is_userprog_portable);
extern void roff_config_finalize(void);
extern void roff_config_iterate(void (*handle)(roff_config_module_t *, void *), void *info);
extern char *roff_config_get_node_modulestr(char *hostname);
extern roff_config_node_t *roff_config_get_node_from_hostname(char *hostname);
extern char *roff_config_encode(char *snapshot_name);
extern void roff_config_initialize_from_hex(char *roff_config_hex,
                                            unsigned long size,
                                            bool ignore_disabled_modules,
											bool is_userprog_portable);
extern char *roff_config_get_node_names(void);
extern void roff_config_print_ssh_hosts(void);
extern bool roff_config_should_print_ssh_hosts(void);
#endif /* OMPI_REMOTE_OFFLOADING */
#endif /* __ROFF_CONFIG_H__ */
