/* Prototypes of functions used by the compiler in the generated code */
void _ort_execute_serial(void *(*func)(void *),void *shared);
void _ort_execute_parallel(void *(*func)(void *),void *shared,int num_threads,
	int iscombined,int procbind_type);
void _ort_execute_teams(void *(*func)(void *),void *shared,int min_teams,
	int max_teams,int thr_limit);

void *_ort_get_thrpriv(void **key,int size,void *origvar);
void _ort_sglvar_allocate(void **dataptr,int size,void *initer);
void _ort_fence();
void _ort_initreqs_add(void (*initfunc)(void));
void *_ort_memalloc(int size);
void _ort_memfree(void *ptr);
void _ort_required(void);
void _ort_modules_required(void);
#ifdef OMPI_REMOTE_OFFLOADING
void _ort_set_ompi_remote_devices(char *ompi_remote_devices_snapshot, 
                                  unsigned long ompi_remote_devices_snapshot_size);
#endif
void _ort_set_moduledir(char *moduledir, int portable);

/*
 * From ort.c
 */
void _ort_register_thrfunc(void *(*thrfunc)(void *));
void _ort_register_taskfunc(void *(*taskfunc)(void *));
void _ort_handle_error(int fatal, char *usermsg);

/*
 * From tasks.c
 */

void _ort_new_task(void *(*func)(void *arg),void *arg,
                  int now, int final, int untied, int priority,
                  void **deparray, int noutdeps, int nindeps, int ninoutdeps);
void _ort_taskwait(int waitall);
int  _ort_task_throttling(void);
void *_ort_task_immediate_start(int final);
void _ort_task_immediate_end(void *tn);
void _ort_entering_taskgroup(void);
void _ort_leaving_taskgroup(void);

void _ort_taskscope_start(int num, void *datarr);
void _ort_task_reduce(void *origvar, void *localvar);
void _ort_taskscope_end();

/*
 * From pools.c
 */

void *_ort_taskenv_alloc(int size,void *(*task_func)(void *));
void _ort_taskenv_free(void *ptr,void *(*task_func)(void *));

/* Atomic,critical,reduction,copyprivate and barrier */
void _ort_atomic_begin();
void _ort_atomic_end();
void _ort_critical_begin(void **cl);
void _ort_critical_end(void **cl);
void _ort_broadcast_private(int num,...);
void _ort_copy_private(int num,...);

/*
 * From barrier.c
 */

int _ort_barrier_me(int reason);

/*
 * From cancel.c
 */

int _ort_enable_cancel(int type);
int _ort_check_cancel(int type);

/*
 * From worksharing.c
 */

/* Workshare-related functions */
int  _ort_mysingle(int hasnowait);
void _ort_leaving_single();
void _ort_entering_sections(int hasnowait,int numberofsections);
void _ort_leaving_sections();
int  _ort_get_section();
int  _ort_get_section_alt(int lastsec, int totalsecs);
void _ort_entering_for(int nowait,int hasordered);
void _ort_entering_doacross(int nowait, int nestdepth, int collapsenum,
                            int schedtype, int chsize, long params[][3]);
int  _ort_leaving_for();
void _ort_for_curriter(unsigned long iter);
void _ort_ordered_begin();
void _ort_ordered_end();
void _ort_doacross_post(long params[][3], long *idx);
void _ort_doacross_wait(long params[][3], int ndeps, long *deps);

/* For schedules support (loopsched.c) */
typedef int (*chunky_t)(unsigned long niters, unsigned long chunksize,
                        int monotonic, unsigned long *fiter, unsigned long *liter,
                        void *extra);

void _ort_get_runtime_schedule_stuff(chunky_t *func,unsigned long *chunksize);
void _ort_get_auto_schedule_stuff(chunky_t *func,unsigned long *chunksize);
void _ort_loop_initializations(unsigned long niters, unsigned long *chunksize, void** sched_data_loc, int isruntime);
int _ort_get_guided_chunk(unsigned long niters, unsigned long chunksize,
               int monotonic, unsigned long *fiter, unsigned long *liter,
               void *ignored);
int _ort_get_dynamic_chunk(unsigned long niters, unsigned long chunksize,
               int monotonic, unsigned long *fiter, unsigned long *liter,
               void *ignored);
int _ort_get_runtimestatic_chunk(unsigned long niters, unsigned long chunksize,
               int monotonic, unsigned long *fiter, unsigned long *liter,
               void *chunkid);
int _ort_get_static_default_chunk(unsigned long niters,
                                 unsigned long *from, unsigned long *to);
int _ort_get_distribute_chunk(unsigned long niters, unsigned long *fiter, unsigned long *liter);

void _ort_push_tag(char* tag, int has_number, int number);
void _ort_pop_tag();
void _ort_read_tag_sched();
void _ort_read_tag_num_threads();

/*
 * From reduction.c
 */

void _ort_reduction_begin();
void _ort_reduction_end();
void _ort_reduction_old_begin(void **cl);
void _ort_reduction_old_end(void **cl);

void _ort_reduce_add(int, void *, void *, int);
void _ort_reduce_subtract(int, void *, void *, int);
void _ort_reduce_multiply(int, void *, void *, int);
void _ort_reduce_and(int, void *, void *, int);
void _ort_reduce_or(int, void *, void *, int);
void _ort_reduce_max(int, void *, void *, int);
void _ort_reduce_min(int, void *, void *, int);
void _ort_reduce_bitand(int, void *, void *, int);
void _ort_reduce_bitor(int, void *, void *, int);
void _ort_reduce_bitxor(int, void *, void *, int);

extern void (*_ort_add_combiners[13])(void*,void*,int), 
            (*_ort_subtract_combiners[13])(void*,void*,int), 
            (*_ort_multiply_combiners[13])(void*,void*,int), 
            (*_ort_and_combiners[13])(void*,void*,int), 
            (*_ort_or_combiners[13])(void*,void*,int), 
            (*_ort_max_combiners[13])(void*,void*,int), 
            (*_ort_min_combiners[13])(void*,void*,int), 
            (*_ort_bitand_combiners[13])(void*,void*,int), 
            (*_ort_bitor_combiners[13])(void*,void*,int), 
            (*_ort_bitxor_combiners[13])(void*,void*,int);
            
/*
 * From target.c
 */

#pragma omp declare target
char *_dev_med2dev_addr(void *medaddr,unsigned long size);
#pragma omp end declare target
int _ort_check_reoffload(int *devid);

void _ort_decltarg_register(void *var,unsigned long size,const void *init,
	int bylink);
void *_ort_decltarg_host2med_addr(void *var,int ompdevid);

void *_ort_devdata_alloc(unsigned long size,int ompdevid);
void _ort_devdata_free(void *data,int ompdevid);
void *_ort_decldata_alloc(unsigned long size,int ompdevid);
void _ort_decldata_free(void *data,int ompdevid);

void *_ort_start_target_data(int tdvars,int ompdevid);
void _ort_end_target_data(void *de);

void _ort_map_tdvar(void *var,unsigned long size,void *varlb,int isptr,int init,
	int map_type);
void _ort_unmap_tdvar(void *var, int update);
void _ort_map_var_dev(void *var,unsigned long size,void *varlb,int isptr,
	int ompdevid, int init);
void _ort_unmap_var_dev(void *var, int ompdevid, int update, int delete);

void _ort_read_var_dev(void *var,unsigned long size,void *varlb,int ompdevid);
void _ort_write_var_dev(void *var,unsigned long size,void *varlb,int ompdevid);
void *_ort_unmappedcopy_dev(void *buf, unsigned long size, int ompdevid);
void _ort_unmappedfree_dev(void *umed, int ompdevid);
void *_ort_host2med_addr(void *var, int ompdevid);
int _ort_offload_kernel(void *(*host_func)(void *),void *vars,void *declvars,
	int min_teams, int max_teams, int num_threads, 
	int thread_limit, unsigned long long teamdims, unsigned long long thrdims,
	char *kernel_filename_prefix, int ompdevid, int *num_args, void **args);


/*
 * From rt_common.h
 */
void _ort_kernfunc_register(char *name, void *(*kernel_function)(void *));
void _ort_bundle_binfile(int kid, char *mod, const unsigned char *data, const unsigned int size, 
                         char *filename, char *progfname, char *cars);
void _ort_set_bundling_type(int bundling_type);
void _ort_set_requirements(unsigned int num_requirements, ...);