/*
  OMPi OpenMP Compiler
  == Copyright since 2001 the OMPi Team
  == Dept. of Computer Science & Engineering, University of Ioannina

  This file is part of OMPi.

  OMPi is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  OMPi is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with OMPi; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* dg.h - A barebones, generic directed graph implementation for dependencies */

#ifndef __DG_H__
#define __DG_H__

#include <set.h>

SET_TYPE_DEFINE(ptr2int, void *, int, 53)  /* for the node set */
typedef struct dgnode_s dgnode_t;
struct dgnode_s {     /* a node and its edges */
		int      nsucc;
		dgnode_t **succ;
		void     *val;
		int      ignore;  /* basically padding... */
	};

typedef struct {
		dgnode_t *G;            /* Nodes & edges */
		set(ptr2int) nodeset;   /* The nodes as a set; the key is dgnode_t* */
	} dg_t;


/* Nodes & edges */
extern dg_t     *dg_new();
extern dgnode_t *dg_alloc_node(void *val);
extern void      dg_add_node(dg_t *graph, dgnode_t *n);
extern void      dg_add_edge(dgnode_t *from, dgnode_t *to);

/*  Search & traversal */
#define DG_TRAV_PREORDER  1
#define DG_TRAV_POSTORDER 2

typedef struct { 
		void (*nodefunc)(dgnode_t *node);
		void (*edgefunc)(dgnode_t *from, dgnode_t *to);
		bool (*valcmp)(void *val1, void *val2);
		int  visorder;
	} dgvisopts_t;
extern dgvisopts_t dgvisopts;

extern void      dg_traverse(dg_t *graph);
extern void      dg_traverse_fromnode(dgnode_t *n);
extern void      dg_traverse_continue(dgnode_t *n);
extern dgnode_t *dg_search(dg_t *graph, void *val);
extern dgnode_t *dg_search_fromnode(dg_t *graph, void *val);
extern dgnode_t *dg_search_continue(dgnode_t *n, void *val);

/* Visualization (gv/dot format output to stderr) */
extern void dg_visualize(dg_t *graph, char *(*labelfunc)(void *));
extern void dg_visualize_fromnode(dgnode_t *n, char *(*labelfunc)(void *));

#endif /* __DG_H__ */
