/*
  OMPi OpenMP Compiler
  == Copyright since 2001, the OMPi Team
  == Dept. of Computer Science & Engineering, University of Ioannina

  This file is part of OMPi.

  OMPi is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  OMPi is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with OMPi; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* MODULES.H
 * Module support for ompiconf
 */

#ifndef __MODULES_H__
#define __MODULES_H__

#include "stddefs.h"

extern int    oc_nmodules;
extern char **oc_modulenames;

extern void ompiconf_modules_employ(char *modstr);   /* Find requested modules/devices */
extern void ompiconf_modules_show_info(int verbose); /* Show module/device info        */
extern int  ompiconf_modules_query(char *modstr);    /* Top-level function for checkiing modules. */

#ifdef OMPI_REMOTE_OFFLOADING
	extern void ompiconf_remote_modules_show_info(int devoffset, int verbose); /* Show remote module/device info */
	extern void ompiconf_remote_modules_employ(void);                          /* Find requested remote modules/devices */
	extern void ompiconf_remote_modules_finalize(void);
	extern int  ompiconf_get_num_mpiprocs(void);
	extern char *ompiconf_get_node_names(void);
	extern void ompiconf_create_mpirun_script(void);
#endif

#endif /* __MODULES_H__ */
