/*
  OMPi OpenMP Compiler
  == Copyright since 2001 the OMPi Team
  == Dept. of Computer Science & Engineering, University of Ioannina

  This file is part of OMPi.

  OMPi is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  OMPi is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with OMPi; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#include <stdbool.h>
#include "globals.h"
#include "queue.h"

#define TASK_POOL_SIZE 256
#define TASK_QUEUE_SIZE 256

typedef struct ort_task_icvs_s
{
	int         dynamic;
	int         nested;
	// omp_sched_t rtschedule;     /* For runtime schedules */
	int         rtchunk;        /* ditto */
	int         nthreads;       /* default # threads for a team */
	int         threadlimit;
	// omp_proc_bind_t proc_bind;
} ort_task_icvs_t;            /* per task */

typedef struct Node
{
	void           *(*func)(void *);    /* Task function */
	void           *funcarg;            /* Task function argument */
	struct Node    *parent;             /* Task's parent id */
	int             isfinal;            /* OpenMP 3.1 */

	int             lock;               /* Lock queue for atomic access */

	volatile int    num_children;       /* Number of task's descendants*/
	volatile int    status;             /* 0: Uninitialized, 1: free, 2: occupied */
	ort_task_icvs_t icvs;
} ort_task_node_t;


typedef struct ort_taskenv_
{
	void *(*task_func)(void *);
	void *mem;
	size_t size;
	int occupied;
} ort_taskenv_t;


#define MAX_TASKENVS 16
typedef struct cuda_tasking_
{
	ort_taskenv_t    taskenvs[MAX_TASKENVS];
	size_t           num_taskenvs;

	/* Task pool */
	ort_task_node_t  tpool[TASK_QUEUE_SIZE];
	
	/* Pointers to tasks in the pool */
	// ort_task_node_t *tasks[TASK_QUEUE_SIZE];
	bq_t         tasks; 
	
	/* Number of pending tasks per thread */
	volatile int    *pending_tasks[1024];
	ort_task_node_t *current_task[32]; /* one per warp */
	
	int    top;
	int    bottom;
	int    lock;
	int    enqlock;
	int    tpool_size;
	int    queue_size;
	bool   initialized;
} cuda_tasking_t;

extern __SHAREDQLFR cuda_tasking_t tasking;

extern __DEVQLFR void   tasking_init();
                  
extern __DEVQLFR bool _dev_is_executing_task();
                  