/*
  OMPi OpenMP Compiler
  == Copyright since 2001 the OMPi Team
  == Dept. of Computer Science & Engineering, University of Ioannina

  This file is part of OMPi.

  OMPi is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  OMPi is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with OMPi; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#include "globals.h"
#include "locks.h"

#ifndef __PARALLEL_H__
#define __PARALLEL_H__

#define SCHEME_IFMASTER     0
#define SCHEME_MASTERWORKER 1

#define MEMTYPE_GLOBAL 0
#define MEMTYPE_SHARED 1

/*
 * Parallel configuration 
 */

/* Available values: SCHEME_IFMASTER, SCHEME_MASTERWORKER */
#define PARALLEL_SCHEME SCHEME_MASTERWORKER

/* Available values: MEMTYPE_GLOBAL, MEMTYPE_SHARED */
#define PARALLEL_MEMTYPE MEMTYPE_SHARED 

typedef struct ort_parallel_
{
	int activelevel;
	int empty;
	int execthr;
	void *(*func)(void*);
	void *shvars;
} ort_parallel_t;

#if PARALLEL_MEMTYPE == MEMTYPE_SHARED
	#define __INTASKPARALLEL \
		((_dev_is_executing_task()) && (warpblocks[__WARPID].activelevel > 0))
	#define __WARPBLOCK warpblocks[__WARPID]
	#define __PARBLOCK parblock
	#define __MYPARBLOCK (__INTASKPARALLEL ? &(__WARPBLOCK) : &(__PARBLOCK))
	#define __CHECKPARBLOCK(p)
	extern __SHAREDQLFR ort_parallel_t parblock;
	extern __SHAREDQLFR ort_parallel_t warpblocks[16];
#else
	#define MAX_PARALLEL_BLOCKS 512
	#define __WARPBLOCK warpblocks[omp_get_team_num()][__WARPID]
	#define __PARBLOCK parblocks[omp_get_team_num()]
	#define __INTASKPARALLEL \
		((_dev_is_executing_task()) \
			&& (__WARPBLOCK.activelevel > 0))

	#define __WARPORPARBLOCK \
		(__INTASKPARALLEL ? &(__WARPBLOCK) : &(__PARBLOCK))
	#define __MYPARBLOCK \
		((omp_get_team_num() < MAX_PARALLEL_BLOCKS) \
		? __WARPORPARBLOCK \
		: NULL)
	#define __CHECKPARBLOCK(p) \
		if (p == NULL) \
		{ \
			printf("error: could not retrieve parallel control block."); \
			return; \
		}
	extern __DEVQLFR ort_parallel_t parblocks[MAX_PARALLEL_BLOCKS];
	extern __DEVQLFR ort_parallel_t warpblocks[32][16];
#endif

extern __DEVQLFR int  dev_get_parallel_active_threads(void);
extern __DEVQLFR void _dev_worker_loop(int thrid);

#endif
