/*
  OMPi OpenMP Compiler
  == Copyright since 2001 the OMPi Team
  == Dept. of Computer Science & Engineering, University of Ioannina

  This file is part of OMPi.

  OMPi is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  OMPi is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with OMPi; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* x_teams_ocl.c -- transform OpenCL target teams constructs */

#include <stdio.h>
#include "autoscope.h"
#include "ompi.h"
#include "outline.h"
#include "x_clauses.h"
#include "x_cars.h"
#include "x_distribute.h"
#include "x_target.h"
#include "x_target_ocl.h"
#include "x_parallel.h"
#include "x_parallel_ocl.h"
#include "x_teams.h"
#include "ast_copy.h"
#include "ast_xform.h"
#include "ast_print.h"
#include "x_combine.h"

static autoshattr_t as;

void xform_targetteams_opencl(aststmt *t)
{
	targstats_t *ts = analyzeKernels 
		? cars_analyze_target((*t)->u.omp->body)
		: NULL;

    /* 
	 * The opencl transformation is simpler. Just apply the appropriate 
     * scheme, transform the body & the directive, no need to find offload 
	 * parameters.
	 */
    if (((*t)->u.omp->type == DCTARGETTEAMS)
		&& !search_nested_construct((*t)->u.omp, DCPARALLEL) 
		&& !search_nested_construct((*t)->u.omp, DCDISTRIBUTE)
		&& !search_nested_construct((*t)->u.omp, DCDISTPARFOR))
	{
		#if PARALLEL_SCHEME == SCHEME_MASTERWORKER
		masterworker_stmt(&((*t)->u.omp->body));
		#else
		ifmaster_stmt(&((*t)->u.omp->body), false);
		#endif
		
	}
	else
		XFORM_CURR_DIRECTIVE->iscombpar = 1;

	xform_ompcon_body((*t)->u.omp);
	xform_target_foropencl(t, ts);
}


void xform_targetteamsdistparfor_opencl(aststmt *t)
{
	ccc_try_splitting(t);
	// xform_ompcon_body((*t)->u.omp);
	xform_targetteams_opencl(t);
}