/*
  OMPi OpenMP Compiler
  == Copyright since 2001 the OMPi Team
  == Dept. of Computer Science & Engineering, University of Ioannina

  This file is part of OMPi.

  OMPi is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  OMPi is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with OMPi; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* remotedev/workers.h 
 * 
 * All worker (remote; with rank != 0) MPI processes execute
 * these functions. Their purpose is to respond to the
 * primary node's requests. Note that the primary and the worker nodes do
 * **NOT** run in a shared memory environment. Communication is
 * achieved with MPI.
 */


#ifndef __REMOTEDEV_WORKERS_H__
#define __REMOTEDEV_WORKERS_H__

#include "stddefs.h"

#ifdef OMPI_REMOTE_OFFLOADING

typedef unsigned long long rdev_datatype_t;

typedef struct
{
	int tag;
	rdev_datatype_t *content;
} command_t;

extern void rdev_worker_init(void);

/**
 * Make sure we use our implementation of _dev_med2dev_addr function.
 * Should be called once during startup.
 */
extern void override__dev_med2dev_addr(void);

/**
 * Make sure we use our implementation of _dev_med2dev_addr function.
 * Should be called once during startup.
 */
extern void override_omp_is_initial_device(void);

#endif  /* OMPI_REMOTE_OFFLOADING */
#endif  /* __REMOTEDEV_WORKERS_H__ */
