/*
  OMPi OpenMP Compiler
  == Copyright since 2001 the OMPi Team
  == Dept. of Computer Science & Engineering, University of Ioannina

  This file is part of OMPi.

  OMPi is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  OMPi is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with OMPi; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* x_teams.c */

#include <stdio.h>
#include "autoscope.h"
#include "ompi.h"
#include "outline.h"
#include "x_clauses.h"
#include "x_cars.h"
#include "x_distribute.h"
#include "x_target.h"
#include "x_parallel.h"
#include "x_teams.h"
#include "ast_copy.h"
#include "ast_xform.h"
#include "ast_print.h"
#include "x_combine.h"

static autoshattr_t as;

vartype_t xtm_implicitDefaultAuto(setelem(vars) s)
{
	if (set_get(as.autoShared, s->key))
		return DCT_BYREF;
	else
		if (set_get(as.autoPrivate, s->key))
			return DCT_PRIVATE;
		else
			if (set_get(as.autoFirstPrivate, s->key))
				return DCT_BYVALUE;
	/*else if (isInSet( as.autoReduction, s->key))
	clausetype = OCREDUCTION;
	return DCT_REDUCTION*/

	return DCT_BYREF;
}


vartype_t xtm_implicitDefault(setelem(vars) s)
{
	if (s->value.clause == OCAUTO)
		return xtm_implicitDefaultAuto(s);
	return DCT_BYREF;
}


/* Produces an expression that calls the outlined function */
static astexpr xtm_callsite_xtraargs;
astexpr xtm_callsite_expr(symbol func, astexpr funcargs)
{
	/* Add the extra parameters */
	funcargs = funcargs ? CommaList(funcargs, xtm_callsite_xtraargs) : 
	                      xtm_callsite_xtraargs;
	return FunctionCall(
		       IdentName("_ort_start_teams"),
		       CommaList(Identifier(func), funcargs)
		     );
}


/* OpenMP v5.0, p. 329:
 * distribute, distribute simd, distribute parallel worksharing-loop, 
 * distribute parallel worksharing-loop SIMD, loop, parallel regions, 
 * including any parallel regions arising from combined constructs,
 * omp_get_num_teams() regions, and omp_get_team_num() regions are the only 
 * OpenMP regions that may be strictly nested inside the teams region.
 */
void xform_teams(aststmt *t)
{
	static int teamfuncid = 0;

	astexpr    numteamsmax = NULL, numteamsmin = NULL, thrlimitexpr = NULL;
	ompclause  c;
	static outline_opts_t oo =
	{
		/* structbased             */  true,               
		/* functionName            */  "",                 
		/* functionCall  (func)    */  xtm_callsite_expr,  
		/* byvalue_type            */  BYVAL_byname,       
		/* byref_type              */  BYREF_pointer,      
		/* byref_copyptr (2 funcs) */  NULL, NULL,         
		/* global_byref_in_struct  */  false,              
		/* structName              */  "__shvt__",         
		/* structVariable          */  "_shvars",          
		/* structInitializer       */  NULL,               
		/* implicitDefault (func)  */  xtm_implicitDefault,
		/* deviceexpr              */  NULL,               
		/* addComment              */  true,               
		/* thestmt                 */  NULL,
		/* userType                */  NULL                  
	};

#if 0
	ompclause  def = xc_ompcon_get_clause((*t)->u.omp, OCDEFAULT);
	if (enableAutoscope) /* Agelos */
	{
		assert(autoscope_parreg_get_results((*t)->l) != NULL);
		as = *autoscope_parreg_get_results((*t)->l);
		if (def && def->subtype == OC_auto)
			oo.implicitDefault = xp_implicitDefaultAuto;
	}
#endif

	/* (1) Check for num_teams and thead_limit clauses and keep a copy
	 */
	if ((c = xc_ompcon_get_unique_clause((*t)->u.omp, OCNUMTEAMS)) != NULL)
	{
		if (c->u.x2.expr1)
			numteamsmin = ast_expr_copy(c->u.x2.expr1);
		numteamsmax = ast_expr_copy(c->u.x2.expr2);
	}
	if ((c = xc_ompcon_get_unique_clause((*t)->u.omp, OCTHREADLIMIT)) != NULL)
		thrlimitexpr = ast_expr_copy(c->u.expr);

	xform_ompcon_body((*t)->u.omp);
	/* (2) Call outline_OpenMP
	 */
	sprintf(oo.functionName, "_teamthrFunc%d_", teamfuncid++);
	xtm_callsite_xtraargs = Comma3(  // <minteams>, <maxteams>, <theadlimit>
	                          numteamsmin ? numteamsmin : numConstant(-1),
	                          numteamsmax ? numteamsmax : numConstant(-1),
	                          thrlimitexpr ? thrlimitexpr : numConstant(-1)
	                        );
	oo.thestmt = *t;
	outline_OpenMP(t, oo);
}

void xform_targetteams(aststmt *t)
{
	astexpr targetparams, optthreads;
	targstats_t *ts = analyzeKernels 
		? cars_analyze_target((*t)->u.omp->body)
		: NULL;

	if (ts != NULL)
		ts->mtr[CARS_nteams]++;

	/* (1) Get the other offload parameters */
	targetparams = xc_ompcon_search_offload_params((*t)->u.omp);
	optthreads = targetparams->right->left;

	/* (2) Split to target + teams, if possible */
	if (ccc_try_splitting(t))
		xform_ompcon_body((*t)->u.omp);

	/* (3) Optimal number of threads could not be found previously, 
	 * so count the total # of parallel regions and decide */
	if (!optthreads)
		optthreads = (XFORM_CURR_DIRECTIVE->nparallel > 0) ? 
			numConstant(DEVICETHREADS_FIXED) : ZeroExpr();

	/* (4) Finally insert optthreads into the offload params */
	targetparams->right->left = optthreads;

	xform_ompcon_body((*t)->u.omp);
	xform_target_generic(t, ts, targetparams);
}


/* (Non-Target)-Teams combinations 
 */
void xform_teamsdist(aststmt *t)
{
	fprintf(stderr, "#pragma omp teams distribute: unsupported; "
	                "please wait a bit...\n");
}


void xform_teamsdistsimd(aststmt *t)
{
	fprintf(stderr, "#pragma omp teams distribute simd: unsupported; "
	                "please wait a bit...\n");
}


void xform_teamsdistparfor(aststmt *t)
{
	// old code
	// ccc_try_splitting(t);
	// xform_ompcon_body((*t)->u.omp);
	// xform_teams(t);
	dist_combined = 1;
	xform_teams(t);
}


void xform_targetteamsdistparfor(aststmt *t)
{
	dist_combined = 1;
	xform_targetteams(t);
}


void xform_teamsdistparforsimd(aststmt *t)
{
	fprintf(stderr, "#pragma omp teams distribute parallel for simd: "
	                "unsupported; please wait a bit...\n");
}


/* Target-Teams combinations 
 */


void xform_targetteamsdistsimd(aststmt *t)
{
	fprintf(stderr, "#pragma omp target teams distribute simd: unsupported; "
	                "please wait a bit...\n");
}


void xform_targetteamsdistparforsimd(aststmt *t)
{
	fprintf(stderr, "#pragma omp target teams distribute parallel for simd:"
	                "unsupported; please wait a bit...\n");
}
