/*
  OMPi OpenMP Compiler
  == Copyright since 2001 the OMPi Team
  == Dept. of Computer Science & Engineering, University of Ioannina

  This file is part of OMPi.

  OMPi is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  OMPi is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with OMPi; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#include "x_atomic.h"
#include "ast_xform.h"
#include "ast_free.h"
#include "ast_copy.h"
#include "ast.h"
#include "ompi.h"
#include "ast_assorted.h"
#include "ast_arith.h"


void xform_atomic(aststmt *t)
{
	aststmt s, parent, v;
	astexpr ex;
	bool    stlist;   /* See comment above */

	/* First transform the body */
	ast_stmt_xform(&((*t)->u.omp->body));

	s = (*t)->u.omp->body;
	parent = (*t)->parent;
	ex = s->u.expr;

	if ((s->type != EXPRESSION) ||
		(ex->type != POSTOP && ex->type != PREOP && ex->type != ASS))
		exit_error(1, "(%s, line %d) openmp error:\n\t"
				   "non-compliant ATOMIC expression.\n",
				   (*t)->u.omp->directive->file->name, (*t)->u.omp->directive->l);

	v = ompdir_commented((*t)->u.omp->directive); /* Put directive in comments */
	stlist = ((*t)->parent->type == STATEMENTLIST ||
			  (*t)->parent->type == COMPOUND);

	(*t)->u.omp->body = NULL;     /* Make it NULL so as to free t easily */
	ast_free(*t);                 /* Get rid of the OmpStmt */

	if (!symbol_exists("_atomic_lock"))    /* Check for the lock */
		bld_globalvar_add(Declaration(Declspec(SPEC_void), /* Dont use omp_lock_t */
								 InitDecl(
								   Declarator(
									 Pointer(),
									 IdentifierDecl(Symbol("_atomic_lock"))
								   ),
								   NullExpr()
								 )));

	if (ex->type == ASS &&
		(ex->right->type != IDENT && !xar_expr_is_constant(ex->right)))
	{
		aststmt tmp;

		tmp = Declaration(
				(ex->left->type != IDENT ?
				 Declspec(SPEC_long) :
				 ast_spec_copy_nosc(
				   symtab_get(stab, ex->left->u.sym, IDNAME)->spec)
				),
				InitDecl(
				  Declarator(NULL, IdentifierDecl(Symbol("__tmp"))),
				  ex->right
				)
			  );
		ex->right = IdentName("__tmp");

		*t = Compound(
			Block6(
				v, tmp,
				Call0_stmt("_ort_atomic_begin"), 
				s,
				Call0_stmt("_ort_atomic_end"),
				linepragma(s->l + 1 - (!stlist), s->file)
			)
		);
	}
	else
	{

		*t = Block5(
				v, 
				Call0_stmt("_ort_atomic_begin"),
				s, 
				Call0_stmt("_ort_atomic_end"),
				linepragma(s->l + 1 - (!stlist), s->file)
			);
		if (!stlist)
			*t = Compound(*t);
	}
	ast_stmt_parent(parent, *t);
}


void xform_atomic_cuda(aststmt *t)
{
	aststmt s, parent, v;
	astexpr ex;
	bool    stlist;   /* See comment above */

	/* First transform the body */
	ast_stmt_xform(&((*t)->u.omp->body));

	s = (*t)->u.omp->body;
	parent = (*t)->parent;
	ex = s->u.expr;

	if ((s->type != EXPRESSION) ||
		(ex->type != POSTOP && ex->type != PREOP && ex->type != ASS))
		exit_error(1, "(%s, line %d) openmp error:\n\t"
				   "non-compliant ATOMIC expression.\n",
				   (*t)->u.omp->directive->file->name, (*t)->u.omp->directive->l);

	v = ompdir_commented((*t)->u.omp->directive); /* Put directive in comments */
	stlist = ((*t)->parent->type == STATEMENTLIST ||
			  (*t)->parent->type == COMPOUND);

	(*t)->u.omp->body = NULL;     /* Make it NULL so as to free t easily */
	ast_free(*t);                 /* Get rid of the OmpStmt */

	if (ex->type == ASS &&
		(ex->right->type != IDENT && !xar_expr_is_constant(ex->right)))
	{
		aststmt tmp;

		tmp = Declaration(
				(ex->left->type != IDENT ?
				 Declspec(SPEC_long) :
				 ast_spec_copy_nosc(
				   symtab_get(stab, ex->left->u.sym, IDNAME)->spec)
				),
				InitDecl(
				  Declarator(NULL, IdentifierDecl(Symbol("__tmp"))),
				  ex->right
				)
			  );
		ex->right = IdentName("__tmp");
		if (in_target())
			*t = Block5(
					v, tmp,
					Declaration(
						Declspec(SPEC_int), 
						InitDecl(
							Declarator(Declspec(SPEC_star), 
							IdentifierDecl(Symbol("_sh_atomic_lock"))
						), 
						FunctionCall(IdentName("_cuda_dev_get_atomic_lock"), NULL))
					),
					Block5(
						Call0_stmt("_ort_atomic_begin"),
						Expression(
							FunctionCall(IdentName("_cuda_dev_set_lock"), 
							UnaryOperator(UOP_addr, IdentName("_sh_atomic_lock")))
						),
						s,
						Expression(
							FunctionCall(IdentName("_cuda_dev_unset_lock"), 
							UnaryOperator(UOP_addr, IdentName("_sh_atomic_lock")))
						),
						Call0_stmt("_ort_atomic_end")
					),
					linepragma(s->l + 1 - (!stlist), s->file)
				);

	}
	else
	{
		if (in_target())
			*t = Block4(
					v,
					Declaration(
						Declspec(SPEC_int), 
						InitDecl(
							Declarator(
								Declspec(SPEC_star), 
								IdentifierDecl(Symbol("_sh_atomic_lock"))
							), 
							FunctionCall(IdentName("_cuda_dev_get_atomic_lock"), NULL)
						)
					), 
					Block5(
						Call0_stmt("_ort_atomic_begin"),
						
						Expression(
							FunctionCall(IdentName("_cuda_dev_set_lock"), 
							UnaryOperator(UOP_addr, IdentName("_sh_atomic_lock")))
						),
						s,
						Expression(
							FunctionCall(IdentName("_cuda_dev_unset_lock"), 
							UnaryOperator(UOP_addr, IdentName("_sh_atomic_lock")))
						),
						Call0_stmt("_ort_atomic_end")
					),
					linepragma(s->l + 1 - (!stlist), s->file)
				);
		if (!stlist)
			*t = Compound(*t);
	}
	ast_stmt_parent(parent, *t);
}
