/*
  OMPi OpenMP Compiler
  == Copyright since 2001 the OMPi Team
  == Dept. of Computer Science & Engineering, University of Ioannina

  This file is part of OMPi.

  OMPi is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  OMPi is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with OMPi; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* x_target_cu.h -- transform CUDA target constructs */

#ifndef __X_TARGET_CU_H__
#define __X_TARGET_CU_H__

#include "ast.h"
#include "x_cars.h"

/* Helper functions */
extern void prepend_cuda_prologue(aststmt *t);
extern void optimize_numthreads(astexpr *targetparams);

/* Transformation functions */
extern void xform_targetparallel_cuda(aststmt *t);
extern void xform_targparfor_cuda(aststmt *t);
extern void xform_target_cuda(aststmt *t);
extern void xform_target_forcuda(aststmt *t, targstats_t *ts, astexpr params);
#endif
