/*
  OMPi OpenMP Compiler
  == Copyright since 2001 the OMPi Team
  == Dept. of Computer Science & Engineering, University of Ioannina

  This file is part of OMPi.

  OMPi is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  OMPi is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with OMPi; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#include <stdlib.h>
#include <pthread.h>
#include <cuda.h>
#include "context.h"
#include "cudautils.h"

/* context.c -- init/destroy thread-specific CUDA contexts */

/**
 * Tests if a thread-specific CUDA context is set. If not,
 * it initializes and sets a new one.
 */
void cuda_ctx_test_init(cuda_dev_t *cuda_gpu)
{
	CUcontext *context = 
  		(CUcontext*) pthread_getspecific(cuda_gpu->ctx_key);

	if (context == NULL)
	{
		context = (CUcontext*) malloc(sizeof(CUcontext));
		cuda_do(cuCtxCreate(context, 0, cuda_gpu->device));
		pthread_setspecific(cuda_gpu->ctx_key, context);
	}
}

/**
 * Tests if a thread-specific CUDA context is set. If so,
 * it destroys and frees it.
 */
void cuda_ctx_test_destroy(cuda_dev_t *cuda_gpu)
{
	CUcontext *context = 
		(CUcontext*) pthread_getspecific(cuda_gpu->ctx_key);

	if (context != NULL)
	{
		cuda_do(cuCtxDestroy(*(context)));
		free(context);
	}
}

CUcontext* cuda_ctx_get(cuda_dev_t *cuda_gpu)
{
	CUcontext *context 
		= (CUcontext*) pthread_getspecific(cuda_gpu->ctx_key);

	if (context == NULL)
	{
		fprintf(stderr, "[cuda] context is not initialized; exiting.\n");
		exit(1);
	}

	return context;
}
