/*
  OMPi OpenMP Compiler
  == Copyright since 2001 the OMPi Team
  == Dept. of Computer Science & Engineering, University of Ioannina

  This file is part of OMPi.

  OMPi is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  OMPi is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with OMPi; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#ifndef __LOCKS_H__
#define __LOCKS_H__

#include <stdbool.h>
#include "globals.h"

#if defined(CUDA)
#define CUDA_SET_LOCK(cl) \
	    { int __cuda_spin = 1;           \
	    __syncthreads();                 \
	    while (__cuda_spin) {            \
	    if (atomicCAS(&(cl), 0, 1) == 0) {

#define CUDA_UNSET_LOCK(cl) \
	    atomicExch(&(cl), 0); \
	    __cuda_spin = 0; \
	    } } __syncthreads(); }
	    
#define CUDA_SET_LOCK_PARTSYNC(cl,nb,nthr)    \
	    { int __cuda_spin = 1, __nthr = nthr; \
	    bar_slot_e __nbar = nb;               \
	    dev_barrier_wait(__nbar,__nthr);      \
	    while (__cuda_spin) {                 \
	    if (atomicCAS(&(cl), 0, 1) == 0) {

#define CUDA_UNSET_LOCK_PARTSYNC(cl) \
	    atomicExch(&(cl), 0); \
	    __cuda_spin = 0; \
	    } } dev_barrier_wait(__nbar,__nthr); }
#else
#define CUDA_SET_LOCK(cl)
#define CUDA_UNSET_LOCK(cl)
#define CUDA_SET_LOCK_PARTSYNC(cl,nb,nthr)
#define CUDA_UNSET_LOCK_PARTSYNC(cl)
#endif

#define CUDA_LOCK_INITIALIZER { 0, false, true }
typedef void *omp_lock_t;

typedef struct cudalock_
{
	int mutex;
	bool in_area;
	bool mutex_init;
	int nbar;
	int nthr;
} cudalock_t;

extern __SHAREDQLFR cudalock_t critical_lock;
extern __SHAREDQLFR cudalock_t atomic_lock;

extern __DEVQLFR void omp_init_lock(omp_lock_t *lock);
extern __DEVQLFR void omp_set_lock(omp_lock_t *lock);
extern __DEVQLFR void omp_unset_lock(omp_lock_t *lock);
extern __DEVQLFR int omp_test_lock(omp_lock_t *lock);
extern __DEVQLFR void omp_destroy_lock(omp_lock_t *lock);

extern __DEVQLFR void dev_lock(int *lock);
extern __DEVQLFR void dev_unlock(int *lock);

#endif
