/*
  OMPi OpenMP Compiler
  == Copyright since 2001 the OMPi Team
  == Dept. of Computer Science & Engineering, University of Ioannina

  This file is part of OMPi.

  OMPi is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  OMPi is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with OMPi; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#ifndef __GLOBALS_H__
#define __GLOBALS_H__


#if defined(CUDA)
#define __HOSTDEVQLFR __host__ __device__
#define __DEVQLFR __device__
#define __CONSTQLFR __constant__
#define __SHAREDQLFR __shared__
#define __DEVKERN extern "C" __device__
#define __MANAGEDQLFR __managed__
#define __LOCALQLFR __local__
#else
#define __HOSTDEVQLFR
#define __DEVQLFR
#define __CONSTQLFR
#define __DEVKERN
#define __SHAREDQLFR
#define __MANAGEDQLFR
#define __LOCALQLFR
#endif

#define TIMES2(c) c, c
#define TIMES3(c) c, c, c

typedef struct
{
	int max_teams;
	int max_threads;
	int thread_limit;
	int nprocs;
} cuda_thrinfo_t;

#endif
