/*
  OMPi OpenMP Compiler
  == Copyright since 2001 the OMPi Team
  == Dept. of Computer Science & Engineering, University of Ioannina

  This file is part of OMPi.

  OMPi is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  OMPi is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with OMPi; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* devpart.c
 * This is the device-side part of the module.
 * It is to be linked with every kernel.
 */

// #define DEBUG

#include "globals.h"
#include <stdio.h>
#include <stdarg.h>
#include <math.h>

__CONSTQLFR cuda_thrinfo_t thrinfo;


__DEVQLFR 
int omp_get_max_active_levels(void)
{
	return 1;
}

__DEVQLFR 
int omp_get_thread_num(void)
{
	return 0;
}

__DEVQLFR
int omp_get_num_threads(void)
{
	return 1;
}

__DEVQLFR
void omp_set_num_threads(int num_threads)
{
	return;
}

__DEVQLFR 
int omp_is_initial_device(void)
{
	return 0;
}

__DEVQLFR 
int omp_get_num_teams(void) 
{
	return 1;
}

__DEVQLFR 
int omp_get_team_num(void)
{
	return 0;
}

__DEVQLFR 
int omp_get_max_threads(void) 
{
	return 1;
}

__DEVQLFR 
int omp_get_max_teams(void) 
{
	return 1;
}

__DEVQLFR 
int omp_get_thread_limit(void)
{
	return 0;
}

__DEVQLFR 
int omp_get_level(void)
{
	return 1;
}

__DEVQLFR 
int omp_get_active_level(void)
{
	return 1;
}

__DEVQLFR
int omp_get_num_procs(void)
{
	return thrinfo.nprocs;
}

__DEVQLFR
int omp_get_dynamic(void)
{
	return 0;
}

__DEVQLFR
int omp_get_nested(void)
{
	return 0;
}

__DEVQLFR 
void *_ort_dev_gaddr(void *medaddr) 
{
	return medaddr;
}

/* This converts a usable mediary address to an actual device address.
 * The size argument should be useless but is given as a possible help; if uaddr 
 * refers to a known, mapped object, then it represents its size in bytes in
 * the device memory. Otherwise, it is simply 0.
 * This is called in all kernels.
 */
__DEVQLFR 
char *_dev_med2dev_addr(void *uaddr, unsigned long size)
{
	return (char*) uaddr;
}

#if defined(DEBUG)
#undef DEBUG
#endif
