/*
  OMPi OpenMP Compiler
  == Copyright since 2001 the OMPi Team
  == Dept. of Computer Science & Engineering, University of Ioannina

  This file is part of OMPi.

  OMPi is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  OMPi is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with OMPi; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* x_target.h */

#ifndef __X_TARGET_H__
#define __X_TARGET_H__

#include "ast.h"
#include "stddefs.h"
#include "x_cars.h"
#include "callgraph.h"
#include "builder.h"
#include "x_kernels.h"
#include "ast_vars.h"

/* Values of the ->isindevenv stentry field (when non-FALSE).
 * They represent the reason the symbol is in the device environments
 */
#define due2DECLTARG 1  /* symbol appeared in a declare target didrective */
#define due2TARGDATA 2  /* symbol appeared in a target data directive */

/* The variable name holding the current device ("__ompi_devID") */
extern char *currdevvarName;

extern void targtree_reset_all();
extern void calc_kernel_team_dimensions(astexpr expr);
extern void calc_kernel_thread_dimensions(astexpr expr);


#define TARGTREE_ADD_RETFUNC(t, f) t = BlockList(t, f);
#define TARGTREE_INIT(t) t = verbit("");

#define DEVICETHREADS_RUNTIME -1
#define DEVICETHREADS_SINGLE  0
#define DEVICETHREADS_FIXED   128

#define SCHEME_IFMASTER     0
#define SCHEME_MASTERWORKER 1
#define PARALLEL_SCHEME SCHEME_MASTERWORKER

#define MASTERWORKER_MYID "_mw_myid"
#define MASTERWORKER_NTHR "_mw_nthr"

#define WRAPPER_ARG_NAME "__devdata"
#define DEVENV_STRUCT_NAME "_dev_data"

#define HOSTDEV_ID  0 /* We should probably move these into common */
#define AUTODEV_ID -1 /* (along with the ones from ort.h)          */
#define SYMEND     "SYMBOLS_END"

#define TARGET_PROLOGUE(tree) \
	targstats_t *ts = NULL;\
	if (analyzeKernels)\
		ts = cars_analyze_target((*(tree))->u.omp->body);\
	xform_ompcon_body((*(tree))->u.omp);
	
extern bool targetTask;
extern astexpr thrdims_list;
extern astexpr teamdims_list;

extern aststmt argarray_declstmt;
extern aststmt numargs_declstmt;

extern vartype_t xtarget_implicitDefault(setelem(vars) s);
extern void prepare_gpu_wrapper(astexpr commalist, set(vars) *usedvars, 
       aststmt rep_struct, char *structType, set(vars) devptrs, target_list_t t);
extern bool targettask(aststmt *t, aststmt devicestm,
                ompclause deps, bool nowait, set(vars) usedvars[]);
extern void create_devdata_env(aststmt *t, ompcon construct,
         set(vars) *usedvars, set(vars) implink, astexpr devexpr);
extern aststmt gpuize_struct(aststmt s, int numfips);

extern aststmt create_offloaddims_stmt(void);

//int __ompi_devID = [(<deviceexpr>)|(<ifexpr>) ? (<deviceexpr>) : 0];
extern aststmt device_statement(astexpr ifexpr, astexpr deviceexpr);

extern void    get_and_check_device_ptrs(ompcon t, set(vars) s);
extern aststmt get_denv_var_decl(bool createNew);
extern symbol  targstruct_offsetname(symbol var);
extern void    masterworker_stmt(aststmt *t);
extern void    ifmaster_stmt(aststmt *t, bool infunc);
extern astexpr find_optimal_nthr(ompcon t);

extern void xform_target_default(aststmt *t);
extern void xform_targetdata(aststmt *t);
extern void xform_targetupdate(aststmt *t);
extern void xform_targetenterdata(aststmt *t);
extern void xform_targetexitdata(aststmt *t);
extern void xform_targetparallel(aststmt *t);
extern void xform_targparfor_default(aststmt *t);

extern void xform_target_generic(aststmt *t, targstats_t *ts, astexpr params);

#endif
