/*
  OMPi OpenMP Compiler
  == Copyright since 2001 the OMPi Team
  == Dept. of Computer Science & Engineering, University of Ioannina

  This file is part of OMPi.

  OMPi is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  OMPi is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with OMPi; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* x_for.h */

#ifndef __X_FOR_H__
#define __X_FOR_H__

#include "ast.h"
#include "x_loops.h"

/* Variable ids that are used in for-loop code generation */
typedef enum schedvartype_ {
	LOOP_PREFIX = 0,  /* a prefix for all the following */
	LOOP_ITER,        /* iteration index; e.g. "iter_" */
	LOOP_NITERS,      /* total # iterations; e.g. "niters_" */
	LOOP_FITER,       /* first iteration; e.g. "fiter_" */
	LOOP_LITER        /* last iteration; e.g. "liter_" */
} schedvartype_e;

/* All info gathered from an OpenMP loop nest */
typedef struct {
          int haslast;         /* true if it has lastprivate vars */
          int ordplain;        /* true if it has a plain ordered clause */
          int collapsenum;      
          int doacrossnum;     
          int schedtype;
          int modifier;
          astexpr schedchunk;  /* the expression of the schedule chunksize */
          forparts_t *forps;   /* all loops in the nest analyzed */
          symbol *itersym;     /* iteration symbol for each loop in the nest */

          /* Parameterization */

          /* Returns the name given a schedvartype_e variable id */
          char *(*varname)(schedvartype_e); 
          /* The function that manipulates the main part of the loop */
          aststmt (*mainpart_func)(); 
          /* Just for #distribute */
          int combined;
        } fordata_t;

/* The transformed code for OpenMP loop */
typedef struct {
          aststmt decls;        /* Declarations of all needed variables */
          aststmt inits;        /* Initializer for fip/red arrays */
          aststmt prologue;     /* Any statements preceeding the main part */
          aststmt mainpart;     /* Schedule-dependent */
          aststmt epilogue;     /* Any statement after the main part */
        } foresult_t;

/* Utilities to be used by x_distribute, x_taskloop, etc. */
extern char *for_varnames(schedvartype_e svt);
extern aststmt for_iterdecls(fordata_t *loopinfo);
extern void for_schedule_static(fordata_t *loopinfo, foresult_t *code);
extern void for_schedule_static_chunksize(fordata_t *loopinfo,foresult_t *code);
extern void for_schedule_runtime_or_auto(fordata_t *loopinfo, foresult_t *code);
extern void for_schedule_dynamic_or_guided(fordata_t *loopifo,foresult_t *code);

extern void xform_for(aststmt *t);
extern void xform_forsimd(aststmt *t);

#endif
