/*
  OMPi OpenMP Compiler
  == Copyright since 2001 the OMPi Team
  == Dept. of Computer Science & Engineering, University of Ioannina

  This file is part of OMPi.

  OMPi is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  OMPi is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with OMPi; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* ast_xformrules.h  */

#include "ast.h"
#include "set.h"
#include "x_kernels.h"

#ifndef __AST_XFORMRULES_H__
#define __AST_XFORMRULES_H__

#define XFRMOD(s) XFR_MODID_ ## s

#define X_ACTION_NONE 0
#define X_ACTION_SPLIT 1
#define X_ACTION_COMBINE 2
#define X_ACTION_COMBSPLIT 3

/* Types and macros
 */
 
typedef struct xfr_vars_
{
	aststmt *tree, targtree;
	aststmt newglobals;
	target_list_t Targets;
	int targetnum;
} *xfr_vars_t;

typedef struct xfr_rule_
{
	ompdirt_e dirtype;
	void (*xform_func)(aststmt *t);
	int combsplittype;
} xfr_rule_t;

typedef struct xfr_mod_
{
	char *modulename;
	xfr_rule_t **rules;
	xfr_vars_t vars;
	int id;
} xfr_mod_t;

enum xfr_moduleid_ {
	XFRMOD(unknown) = -1,
	XFRMOD(_) = 0, XFRMOD(cuda), XFRMOD(opencl),
	/* new-module.sh:moduleids */
	XFRMOD(_last)
};
typedef enum xfr_moduleid_ xfr_moduleid_e;

extern xfr_mod_t all_xformrules[];

typedef struct 
{
	struct {
    	bool initialized;
		void (*xform_func)(aststmt *t);
    	int combsplittype;
	} rules[DCLASTDIR];
	xfr_vars_t vars;
	int origindex;
} xfr_modrules_t;

SET_TYPE_DEFINE(xformrules, int, xfr_modrules_t *, 389)
extern set(xformrules) ast_xfrules;
#define DEFAULTDEVICE           "_"

extern xfr_moduleid_e ast_xfr_modulename_toid(char *modulename);
extern char *ast_xfr_moduleid_toname(xfr_moduleid_e id);

extern void ast_xfr_init_rules(void);
extern void ast_xfr_call_xformfunc(xfr_moduleid_e modid, aststmt *t);
extern void ast_xfr_gen_tree_copies(aststmt *t);
extern void ast_xfr_free_tree_copies(void);
extern setelem(xformrules) ast_xfr_get_defaultrules(void);
extern bool ast_xfr_type_issupported(ompdirt_e type);
#endif
