/*
  OMPi OpenMP Compiler
  == Copyright since 2001 the OMPi Team
  == Dept. of Computer Science & Engineering, University of Ioannina

  This file is part of OMPi.

  OMPi is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  OMPi is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with OMPi; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* remotedev/workercmds.h 
 * 
 * All worker (remote; with rank != 0) MPI processes execute
 * these functions. Their purpose is to respond to the
 * primary node's requests. Note that the primary and the worker nodes do
 * **NOT** run in a shared memory environment. Communication is
 * achieved with MPI.
 */


#ifndef __REMOTEDEV_WORKERCMDS_H__
#define __REMOTEDEV_WORKERCMDS_H__

#include "stddefs.h"

#ifdef OMPI_REMOTE_OFFLOADING

#include "rdev_prive.h"
#include "rdev.h"
#include "workers.h"

#define __DEVICE(device_id) &(ort->ort_devices[device_id])
#define DEVICE_ALLOC(d,size,map,haddr) \
	d->module->dev_alloc(d->device_info,size,map,haddr)
#define DEVICE_INIT_ALLOC_GLOBAL(d,initfrom,size,glid,haddr) \
	d->module->dev_init_alloc_global(d->device_info,initfrom,size,glid,haddr)
#define DEVICE_FREE(d,da,unmap) \
	d->module->dev_free(d->device_info,da,unmap)
#define DEVICE_FREE_GLOBAL(d,da,glid) \
	d->module->dev_free_global(d->device_info,da,glid)
#define DEVICE_WRITE(d,ha,hoff,da,doff,s) \
	d->module->todev(d->device_info,ha,hoff,da,doff,s)
#define DEVICE_READ(d,ha,hoff,da,doff,s) \
	d->module->fromdev(d->device_info,ha,hoff,da,doff,s)
#define DEVICE_OFFLOAD(d,hf,devdata,decldata,kfname,nt,nthr,thrl,td,thrd,nargs,args) \
	d->module->offload(d->device_info,hf,devdata,decldata,kfname,\
	                                  nt,nthr,thrl,td,thrd,nargs,args)
#define DEVICE_I2UMEDADDR(d,i) \
	d->module->imed2umed_addr(d->device_info, i)
#define DEVICE_U2IMEDADDR(d,u) \
	d->module->umed2imed_addr(d->device_info, u)
	
#define NO_HOSTADDR NULL
#define DEFINE_WORKER_COMMANDS(c1,c2,c3,c4,c5,c6,c7,c8,c9,c10,c11) \
	static void c1(int, rdev_datatype_t*), c2(int, rdev_datatype_t*), c3(int, rdev_datatype_t*), c4(int, rdev_datatype_t*), \
	            c5(int, rdev_datatype_t*), c6(int, rdev_datatype_t*),  c7(int, rdev_datatype_t*), c8(int, rdev_datatype_t*), \
	            c9(int, rdev_datatype_t*), c10(int, rdev_datatype_t*), c11(int, rdev_datatype_t*);\
	void (*worker_commands[])() = {\
		c1, c2, c3, c4, c5, c6, c7, c8, c9, c10, c11\
	};

	
/* Commands the device can understand */
#define CMD(x) MPI_CMD_ ## x
typedef enum workercmd_ {
	CMD(INIT) = 0,  
	CMD(SHUTDOWN) = 1, 
	CMD(FROMDEV),         
	CMD(TODEV), 
	CMD(DEVALLOC),       
	CMD(DEVINIT_ALLOC_GLOBAL), 
	CMD(DEVFREE),    
	CMD(DEVFREE_GLOBAL), 
	CMD(OFFLOAD),
	CMD(I2UMEDADDR),     
	CMD(U2IMEDADDR),
	CMD(LAST)
} workercmd_e;

extern void (*worker_commands[])();

#endif  /* OMPI_REMOTE_OFFLOADING */
#endif  /* __REMOTEDEV_WORKERCMDS_H__ */
