/*
  OMPi OpenMP Compiler
  == Copyright since 2001 the OMPi Team
  == Dept. of Computer Science & Engineering, University of Ioannina

  This file is part of OMPi.

  OMPi is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  OMPi is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with OMPi; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* remotedev/rdev.h -- remote offloading runtime interface
 */

#ifndef __REMOTEDEV_H__
#define __REMOTEDEV_H__

#include "stddefs.h"

#ifdef OMPI_REMOTE_OFFLOADING

#include <stdlib.h>
#include "ort.h"
#include "../../rt_common.h"

#define COMM_MAX_NUM_ARGS 6

enum noderoletype
{
	ROLE_PRIMARY = 0, 
	ROLE_WORKER = 1
};

extern enum noderoletype node_role;

extern int    rdev_man_get_my_id(void);
extern void   rdev_man_prepare_node(int *argc, char ***argv);
extern void   rdev_worker_loop(void);
extern char **rdev_worker_get_modules(int *nModules);

/* Interface between the primary node and a worker node */
extern void  *rdev_initialize(int device_id, ort_icvs_t *ort_env, int *argc, char ***argv);
extern void   rdev_finalize(void *device_info);
extern void   rdev_offload(void *device_info, void *(*host_func)(void *), void *dev_data,
                           void *decl_data, char *kernel_filename_prefix, int num_teams,
                           int num_threads, int thread_limit, 
                           unsigned long long teamdims, unsigned long long thrdims, 
                           int *num_args, void **args);
extern void  *rdev_alloc(void *device_info, size_t size, int map_memory, void *hostaddr);
extern void  *rdev_init_alloc_global(void *device_info, void *initfrom, size_t size, int global_id,
                                     void *hostaddr);
extern void   rdev_free(void *device_info, void *iaddr, int unmap_memory);
extern void   rdev_free_global(void *device_info, void *iaddr, int global_id);
extern void   rdev_todev(void *device_info, void *hostaddr, size_t hostoffset,
                         void *imedaddr, size_t devoffset, size_t size);
extern void   rdev_fromdev(void *device_info, void *hostaddr, size_t hostoffset,
                           void *imedaddr, size_t devoffset, size_t size);
extern void  *rdev_imed2umed_addr(void *device_info, void *imedaddr);
extern void  *rdev_umed2imed_addr(void *device_info, void *umedaddr);

#endif /* OMPI_REMOTE_OFFLOADING */
#endif /* __REMOTEDEV_H__ */
