/*
  OMPi OpenMP Compiler
  == Copyright since 2001 the OMPi Team
  == Dept. of Computer Science & Engineering, University of Ioannina

  This file is part of OMPi.

  OMPi is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  OMPi is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with OMPi; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#ifndef __WORKSHARING_H__
#define __WORKSHARING_H__

#include "globals.h"
#include "locks.h"

#define SINGLE_LIGHT     0
#define SINGLE_GENERIC   1
#define SINGLE_IMPLEMENTATION SINGLE_LIGHT

#define WS_EMPTYREGION 1
#define WS_INITED 1
#define WS_NONELEFT 0
#define WS_NOSECTIONS 0
#define _OMP_SINGLE   0
#define _OMP_SECTIONS 1
#define _OMP_FOR      2
#define WS_INITIALIZER \
	    { TIMES3(CUDA_LOCK_INITIALIZER), \
	    WS_EMPTYREGION, WS_NONELEFT, WS_INITED, WS_NOSECTIONS, 0 };


typedef struct __attribute__((aligned(8)))
{
	cudalock_t   wslock; /* Lock for the region */
	cudalock_t   leavelock; /* Lock for leaving a region */
	cudalock_t   forlooplock; /* Lock for chunks */

	volatile int empty;  /* True if no thread entered yet */
	volatile int left;   /* # threads that have left the region */
    volatile int nowait; 
    bool         insingle;
	bool         inited; /* 1 if the region was initialized */

	int sectionsleft; /* Remaining # sections to be given away */
	volatile int forloopiter;  /* The next iteration to be scheduled */
} ort_workshare_t;

extern __SHAREDQLFR ort_workshare_t workshare;

extern __DEVQLFR int ws_enter_workshare_region(int wstype, int nowait, int hasordered,
	                          int nsections);
extern __DEVQLFR int ws_leave_workshare_region(int wstype);

#endif
