/*
  OMPi OpenMP Compiler
  == Copyright since 2001 the OMPi Team
  == Dept. of Computer Science & Engineering, University of Ioannina

  This file is part of OMPi.

  OMPi is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  OMPi is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with OMPi; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#include <stdbool.h>

#ifndef __QUEUE_H__
#define __QUEUE_H__

typedef struct bq_item_
{
	void *data;
} bq_item_t;

typedef struct bq_
{
	bq_item_t *buffer;
	unsigned int *tickets;
	unsigned int head, tail;
	unsigned int count;
	unsigned int max_threads;
	unsigned int max_size;
} bq_t;

extern __DEVQLFR void bq_init(bq_t *queue, unsigned int max_size, unsigned int max_threads);
extern __DEVQLFR bool bq_enqueue(bq_t *queue, void *item, unsigned int size);
extern __DEVQLFR bq_item_t *bq_dequeue(bq_t *queue);


#endif
