/*
  OMPi OpenMP Compiler
  == Copyright since 2001 the OMPi Team
  == Dept. of Computer Science & Engineering, University of Ioannina

  This file is part of OMPi.

  OMPi is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  OMPi is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with OMPi; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#include <stdio.h>
#include "parallel.h"
#include "barrier.h"
#include "globals.h"

static __DEVQLFR
int numtowarpsize(int n)
{
	return (int) ceilf(((float) n) / warpSize) * warpSize;
}

__DEVQLFR
void dev_barrier_wait(bar_slot_e bar_slot, int nthr)
{
	thread_cb_t *cb = __MYCB;
	if (!cb) return;
	if ((nthr == 1) || (cb->in_nested_parallel)) return;
	
	/* Clamp `bar_slot' */
	bar_slot = (bar_slot > BARRIER_SLOT_15) ? BARRIER_SLOT_15 
		: ((bar_slot < BARRIER_SLOT_DEFAULT) ? BARRIER_SLOT_DEFAULT : bar_slot);

	asm volatile("bar.sync %0, %1;" : : "r"(bar_slot), 
		"r"(numtowarpsize(nthr)) : "memory");
}

__DEVQLFR 
int _ort_barrier_me(void) 
{
	dev_barrier_wait(BARRIER_SLOT_1, dev_get_parallel_active_threads());
	return 0;
}
