/*
  OMPi OpenMP Compiler
  == Copyright since 2001 the OMPi Team
  == Dept. of Computer Science & Engineering, University of Ioannina

  This file is part of OMPi.

  OMPi is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  OMPi is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with OMPi; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* x_task.h -- too big a transformation to be part off ast_xfrom */

#ifndef __X_TASK_H__
#define __X_TASK_H__

#include "ast.h"
#include "outline.h"
#include "ompi.h"

#define DEPARRAY "_deps"

extern vartype_t xt_implicitDefault(setelem(vars) s);
extern aststmt xt_assemble_deps(ompcon t, int *nin, int *nout, int *ninout);
extern aststmt gencode_noopt(astexpr ifexpr, astexpr finalexpr, bool mergeable,
                      bool hasdeps, aststmt body, outcome_t *op);
extern aststmt gencode_fast(astexpr ifexpr, astexpr finalexpr, bool mergeable,
                      bool hasdeps, aststmt body, outcome_t *op);

extern void xform_task(aststmt *t);
extern void xform_taskgroup(aststmt *t);

#endif
