/*
  OMPi OpenMP Compiler
  == Copyright since 2001 the OMPi Team
  == Dept. of Computer Science & Engineering, University of Ioannina

  This file is part of OMPi.

  OMPi is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  OMPi is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with OMPi; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#ifndef __RDEV_CONFIG_H__
#define __RDEV_CONFIG_H__

#ifdef SETUP_MODE
	#define OMPI_REMOTE_OFFLOADING
#else
	#include "stddefs.h"
#endif

#ifdef OMPI_REMOTE_OFFLOADING

#include "str.h"

#ifdef PORTABLE_BUILD
	#ifdef PATH_MAX
		#define CONFIG_PATH_SIZE PATH_MAX
	#else
		#define CONFIG_PATH_SIZE 4096
	#endif
#endif

#define IS_CPU_MODULE(x) (strncmp(x, "cpu", 3) == 0)

#define RDEVCONF_CONF_FILE "/.ompi_remote_devices"
#define RDEVCONF_MAXMODS 256
#define RDEVCONF_MAXNAME 64
#define RDEVCONF_MAX_INL_DECL 16

#define DONT_INCLUDE_CPU_MOD 0
#define INCLUDE_CPU_MOD 1

#define DONT_IGNORE_DISABLED_MODULES false
#define IGNORE_DISABLED_MODULES true

typedef struct rdev_config_status_ rdev_config_status_t;
typedef struct rdev_config_module_ rdev_config_module_t;
typedef struct rdev_config_node_   rdev_config_node_t;
typedef struct rdev_config_        rdev_config_t;

typedef struct walk_
{
	const char *buffer;
	char *p;
} walk_t;

#define MODULE(m) { MODULE_ ## m, #m }
#define LASTMODULE { -1, NULL }

// Currently not used, could be useful in the long run.
typedef enum module_enum_
{
	MODULE_cpu       = 1 << 0,
	MODULE_cuda      = 1 << 1,
	MODULE_opencl    = 1 << 2,
	MODULE_proc2     = 1 << 3,
	MODULE_proc2l    = 1 << 4,
	MODULE_epiphany3 = 1 << 5,
	MODULE_epiphany4 = 1 << 6,
} module_enum_t;

typedef struct modules_
{
	module_enum_t modid;
	char *modname;
} modules_t;

extern modules_t allmodules[];

struct rdev_config_module_
{
	char *name;
	rdev_config_node_t *node;
	int num_devices;
	bool is_disabled;
};

struct rdev_config_node_
{
	int id;
	char *name;
	int total_num_devices;
	int num_modules;
	int num_modnames;
	int has_cpu_module;
	int first_remote_devid;
	rdev_config_module_t modules[RDEVCONF_MAXMODS];
	char *module_names[RDEVCONF_MAXMODS];
};

struct rdev_config_status_
{
	enum
	{
		rdev_config_status_success,
		rdev_config_status_fail,
		rdev_config_status_duplicate
	} return_code;
	int id;
};

struct rdev_config_
{
	str modstr;
	char **uniquemodnames;
	int initialized;
	int finalized;
	int nuniquemodules;
	rdev_config_node_t *nodes;
	unsigned int num_devices;
	unsigned int num_modules;
	unsigned int num_enabled_devices;
	unsigned int num_enabled_modules;
	unsigned int num_nodes;
	unsigned int node_capacity;
};

extern rdev_config_t rdev_config;

extern void rdev_config_initialize(bool ignore_disabled_modules);
extern void rdev_config_finalize(void);
extern void rdev_config_iterate(void (*handle)(rdev_config_module_t *, void *), void *info);
extern char *rdev_config_get_node_modulestr(char *hostname);
extern rdev_config_node_t *rdev_config_get_node_from_hostname(char *hostname);
extern char *rdev_config_encode(char *snapshot_name);
extern void rdev_config_initialize_from_hex(unsigned char *rdev_config_hex,
                                            unsigned long size,
                                            bool ignore_disabled_modules);
extern char *rdev_config_get_node_names(void);

#endif /* OMPI_REMOTE_OFFLOADING */
#endif /* __RDEV_CONFIG_H__ */
